/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.function.AbstractBodyNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JavaScriptRealmBoundaryRootNode;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import java.util.Map;

@NodeInfo(cost=NodeCost.NONE, language="JavaScript", description="The root node of all functions in JavaScript.")
public class FunctionRootNode
extends JavaScriptRealmBoundaryRootNode
implements FrameDescriptorProvider,
JSFunctionData.CallTargetInitializer {
    @Node.Child
    private JavaScriptNode body;
    private final JSFunctionData functionData;
    private String internalFunctionName;

    protected FunctionRootNode(AbstractBodyNode body, FrameDescriptor frameDescriptor, JSFunctionData functionData, SourceSection sourceSection, String internalFunctionName) {
        super(functionData.getContext().getLanguage(), sourceSection, frameDescriptor);
        this.body = body;
        if (!this.body.hasSourceSection()) {
            this.body.setSourceSection(sourceSection);
        }
        this.functionData = functionData;
        this.internalFunctionName = internalFunctionName;
    }

    public static FunctionRootNode create(AbstractBodyNode body, FrameDescriptor frameDescriptor, JSFunctionData functionData, SourceSection sourceSection, String internalFunctionName) {
        FunctionRootNode rootNode = new FunctionRootNode(body, frameDescriptor, functionData, sourceSection, internalFunctionName);
        if (functionData.getContext().getContextOptions().isTestCloneUninitialized()) {
            assert (JSNodeUtil.hasExactlyOneRootBodyTag(body)) : "Function does not have exactly one RootBodyTag";
            return (FunctionRootNode)rootNode.cloneUninitialized();
        }
        return rootNode;
    }

    public JSFunctionData getFunctionData() {
        return this.functionData;
    }

    @Override
    public boolean isCloningAllowed() {
        return true;
    }

    @Override
    protected boolean isCloneUninitializedSupported() {
        return true;
    }

    @Override
    protected JavaScriptRootNode cloneUninitialized() {
        return new FunctionRootNode((AbstractBodyNode)JavaScriptNode.cloneUninitialized(this.body, null), this.getFrameDescriptor(), this.functionData, this.getSourceSection(), this.internalFunctionName);
    }

    public boolean isInlineImmediately() {
        return this.functionData.isBuiltin();
    }

    public boolean isSplitImmediately() {
        return false;
    }

    @Override
    public String getName() {
        if (this.functionData.isBuiltin() || this.functionData.getName().isEmpty() && this.internalFunctionName != null) {
            assert (this.internalFunctionName != null);
            return this.internalFunctionName;
        }
        return this.functionData.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public JavaScriptNode getBody() {
        return this.body;
    }

    @Override
    protected JSContext getContext() {
        return this.functionData.getContext();
    }

    @Override
    protected Object executeInRealm(VirtualFrame frame) {
        return this.body.execute(frame);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Map<String, Object> getDebugProperties() {
        Map<String, Object> map = super.getDebugProperties();
        map.put("name", "function " + this.getName() + "(" + this.getParamCount() + "/" + this.getFrameDescriptor().getSize() + ")");
        return map;
    }

    public int getParamCount() {
        return this.functionData.getLength();
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public void initializeRoot(JSFunctionData fd) {
        if (this.getCallTarget() != null) {
            return;
        }
        fd.setRootTarget(Truffle.getRuntime().createCallTarget(this));
    }

    @Override
    public void initializeCallTarget(JSFunctionData fd, JSFunctionData.Target target, CallTarget rootTarget) {
        FunctionRootNode.initializeFunctionDataCallTarget(fd, target, rootTarget, this);
    }

    private static void initializeFunctionDataCallTarget(JSFunctionData functionData, JSFunctionData.Target target, CallTarget rootTarget, FunctionRootNode functionRoot) {
        NodeFactory factory = NodeFactory.getDefaultInstance();
        if (target == JSFunctionData.Target.Call) {
            CallTarget functionCallTarget = functionData.requiresNew() ? Truffle.getRuntime().createCallTarget(factory.createConstructorRequiresNewRoot(functionData, functionRoot.getSourceSection())) : (functionData.needsNewTarget() ? Truffle.getRuntime().createCallTarget(factory.createNewTargetCall(functionData.getContext(), rootTarget)) : rootTarget);
            functionData.setCallTarget(functionCallTarget);
        } else if (target == JSFunctionData.Target.Construct) {
            CallTarget constructCallTarget;
            if (functionData.isGenerator()) {
                constructCallTarget = functionData.getContext().getGeneratorNotConstructibleCallTarget();
            } else if (functionData.isAsync()) {
                constructCallTarget = functionData.getContext().getNotConstructibleCallTarget();
            } else {
                constructCallTarget = Truffle.getRuntime().createCallTarget(factory.createConstructorRootNode(functionData, rootTarget, false));
                if (functionData.needsNewTarget()) {
                    constructCallTarget = Truffle.getRuntime().createCallTarget(factory.createNewTargetConstruct(functionData.getContext(), constructCallTarget));
                }
            }
            functionData.setConstructTarget(constructCallTarget);
        } else if (target == JSFunctionData.Target.ConstructNewTarget) {
            CallTarget newTargetCallTarget = functionData.needsNewTarget() ? rootTarget : Truffle.getRuntime().createCallTarget(factory.createDropNewTarget(functionData.getContext(), rootTarget));
            RootCallTarget constructNewTargetCallTarget = Truffle.getRuntime().createCallTarget(factory.createConstructorRootNode(functionData, newTargetCallTarget, true));
            functionData.setConstructNewTarget(constructNewTargetCallTarget);
        }
    }
}

