/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class InitFunctionNode
extends JavaScriptBaseNode {
    private final JSFunctionData functionData;
    private final JSContext context;
    @Node.Child
    private DynamicObjectLibrary setPrototypeNode;
    @Node.Child
    private DynamicObjectLibrary setLengthNode;
    @Node.Child
    private DynamicObjectLibrary setNameNode;
    @Node.Child
    private DynamicObjectLibrary setArgumentsNode;
    @Node.Child
    private DynamicObjectLibrary setCallerNode;
    private final int prototypeFlags;
    private final int lengthFlags;
    private final int nameFlags;
    private final int argumentsCallerFlags;
    private final boolean strictProperties;

    protected InitFunctionNode(JSFunctionData functionData, JSContext context, boolean strictProperties, boolean isConstructor, boolean isBound, boolean isGenerator, boolean prototypeNotWritable) {
        boolean hasPrototype;
        this.functionData = functionData;
        this.context = context;
        this.strictProperties = strictProperties;
        boolean bl = hasPrototype = isConstructor && !isBound || isGenerator;
        if (hasPrototype) {
            int prototypeAttributes = prototypeNotWritable ? JSAttributes.notConfigurableNotEnumerableNotWritable() : JSAttributes.notConfigurableNotEnumerableWritable();
            this.prototypeFlags = prototypeAttributes | 0x10;
            this.setPrototypeNode = JSObjectUtil.createDispatched("prototype");
        } else {
            this.prototypeFlags = 0;
        }
        int lengthAttributes = context.getEcmaScriptVersion() < 6 ? JSAttributes.notConfigurableNotEnumerableNotWritable() : JSAttributes.configurableNotEnumerableNotWritable();
        this.lengthFlags = lengthAttributes | 0x10;
        this.setLengthNode = JSObjectUtil.createDispatched("length");
        int nameAttributes = JSAttributes.configurableNotEnumerableNotWritable();
        this.nameFlags = nameAttributes | 0x10;
        this.setNameNode = JSObjectUtil.createDispatched("name");
        boolean argumentsCaller = false;
        int argumentsCallerAttributes = 0;
        if (context.getEcmaScriptVersion() >= 6) {
            if (!strictProperties) {
                argumentsCaller = true;
                argumentsCallerAttributes = JSAttributes.notConfigurableNotEnumerableNotWritable();
            }
        } else if (strictProperties) {
            argumentsCaller = true;
            argumentsCallerAttributes = JSAttributes.notConfigurableNotEnumerable() | 8;
        }
        if (argumentsCaller) {
            this.setArgumentsNode = JSObjectUtil.createDispatched("arguments");
            this.setCallerNode = JSObjectUtil.createDispatched("caller");
        }
        this.argumentsCallerFlags = argumentsCallerAttributes;
    }

    protected InitFunctionNode(JSFunctionData functionData) {
        this(functionData, functionData.getContext(), functionData.hasStrictFunctionProperties(), functionData.isConstructor(), functionData.isBound(), functionData.isGenerator(), functionData.isPrototypeNotWritable());
        assert (!functionData.isBuiltin());
    }

    public static InitFunctionNode create(JSContext context, boolean strictProperties, boolean isConstructor, boolean isBound, boolean isGenerator, boolean prototypeNotWritable) {
        return new InitFunctionNode(null, context, strictProperties, isConstructor, isBound, isGenerator, prototypeNotWritable);
    }

    public static InitFunctionNode create(JSFunctionData functionData) {
        return new InitFunctionNode(functionData);
    }

    public final DynamicObject execute(DynamicObject function) {
        return this.execute(function, this.functionData.getLength(), this.functionData.getName());
    }

    public final DynamicObject execute(DynamicObject function, JSFunctionData functionData) {
        return this.execute(function, functionData.getLength(), functionData.getName());
    }

    public final DynamicObject execute(DynamicObject function, int length, String name) {
        this.setLengthNode.putConstant(function, "length", JSFunction.LENGTH_PROXY, this.lengthFlags);
        assert (JSFunction.getFunctionData(function).isBound() || length == (Integer)JSFunction.LENGTH_PROXY.get(function));
        this.setNameNode.putConstant(function, "name", JSFunction.NAME_PROXY, this.nameFlags);
        assert (JSFunction.getFunctionData(function).isBound() || name.equals(JSFunction.NAME_PROXY.get(function)));
        if (this.setPrototypeNode != null) {
            this.setPrototypeNode.putConstant(function, "prototype", JSFunction.PROTOTYPE_PROXY, this.prototypeFlags);
        }
        if (this.context.getEcmaScriptVersion() >= 6) {
            if (!this.strictProperties) {
                if (this.context.isOptionV8CompatibilityMode()) {
                    this.setArgumentsNode.putConstant(function, "arguments", this.context.getArgumentsPropertyProxy(), this.argumentsCallerFlags | 0x10);
                    this.setCallerNode.putConstant(function, "caller", this.context.getCallerPropertyProxy(), this.argumentsCallerFlags | 0x10);
                } else {
                    this.setArgumentsNode.putConstant(function, "arguments", Undefined.instance, this.argumentsCallerFlags);
                    this.setCallerNode.putConstant(function, "caller", Undefined.instance, this.argumentsCallerFlags);
                }
            }
        } else if (this.strictProperties) {
            Accessor throwerAccessor = JSFunction.getRealm(function).getThrowerAccessor();
            this.setArgumentsNode.putWithFlags(function, "arguments", throwerAccessor, this.argumentsCallerFlags);
            this.setCallerNode.putWithFlags(function, "caller", throwerAccessor, this.argumentsCallerFlags);
        }
        return function;
    }
}

