/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;

@GenerateUncached
public abstract class KeyInfoNode
extends JavaScriptBaseNode {
    public static final int READABLE = 1;
    public static final int MODIFIABLE = 2;
    public static final int INSERTABLE = 4;
    public static final int INVOCABLE = 8;
    public static final int REMOVABLE = 16;
    public static final int READ_SIDE_EFFECTS = 32;
    public static final int WRITE_SIDE_EFFECTS = 64;
    public static final int WRITABLE = 6;

    KeyInfoNode() {
    }

    public abstract boolean execute(DynamicObject var1, String var2, int var3);

    @Specialization(guards={"!isJSProxy(target)", "property != null"}, limit="2")
    static boolean cachedOwnProperty(DynamicObject target, String key, int query, @CachedLibrary(value="target") DynamicObjectLibrary objectLibrary, @Bind(value="objectLibrary.getProperty(target, key)") Property property, @Cached IsCallableNode isCallable) {
        if (JSProperty.isAccessor(property)) {
            Accessor accessor = (Accessor)objectLibrary.getOrDefault(target, key, null);
            if ((query & 1) != 0 && accessor.hasGetter()) {
                return true;
            }
            if ((query & 2) != 0 && accessor.hasSetter()) {
                return true;
            }
            if ((query & 0x20) != 0 && accessor.hasGetter()) {
                return true;
            }
            if ((query & 0x40) != 0 && accessor.hasSetter()) {
                return true;
            }
            return (query & 0x10) != 0 && JSProperty.isConfigurable(property);
        }
        assert (JSProperty.isData(property));
        if ((query & 1) != 0) {
            return true;
        }
        if ((query & 2) != 0 && JSProperty.isWritable(property)) {
            return true;
        }
        if ((query & 8) != 0 && isCallable.executeBoolean(objectLibrary.getOrDefault(target, key, Undefined.instance))) {
            return true;
        }
        return (query & 0x10) != 0 && JSProperty.isConfigurable(property);
    }

    @Specialization(replaces={"cachedOwnProperty"})
    static boolean member(DynamicObject target, String key, int query, @Cached GetPrototypeNode getPrototype, @Cached IsCallableNode isCallable, @Cached IsExtensibleNode isExtensible) {
        boolean writeSideEffects;
        PropertyDescriptor desc = null;
        boolean isProxy = false;
        DynamicObject proto = target;
        while (proto != Null.instance) {
            desc = JSObject.getOwnProperty(proto, key);
            if (JSProxy.isJSProxy(proto)) {
                isProxy = true;
                break;
            }
            if (desc != null) break;
            proto = getPrototype.executeJSObject(proto);
        }
        if (desc == null) {
            return (query & 4) != 0 && isExtensible.executeBoolean(target);
        }
        boolean hasGet = desc.hasGet() && desc.getGet() != Undefined.instance;
        boolean hasSet = desc.hasSet() && desc.getSet() != Undefined.instance;
        boolean readable = hasGet || !hasSet;
        boolean writable = hasSet || !hasGet && desc.getIfHasWritable(true);
        boolean readSideEffects = isProxy || hasGet;
        boolean bl = writeSideEffects = isProxy || hasSet;
        if ((query & 1) != 0 && readable) {
            return true;
        }
        if ((query & 2) != 0 && writable) {
            return true;
        }
        if ((query & 0x20) != 0 && readSideEffects) {
            return true;
        }
        if ((query & 0x40) != 0 && writeSideEffects) {
            return true;
        }
        if ((query & 8) != 0 && desc.isDataDescriptor() && isCallable.executeBoolean(desc.getValue())) {
            return true;
        }
        return (query & 0x10) != 0 && desc.getConfigurable();
    }
}

