/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.IsIdenticalStringNode;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsIdenticalStringNode.class)
public final class IsIdenticalStringNodeGen
extends IsIdenticalStringNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyString_flatten_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyString_len_;

    private IsIdenticalStringNodeGen(String string, JavaScriptNode operand, boolean leftConstant) {
        super(string, operand, leftConstant);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && operandNodeValue instanceof JSLazyString) {
            JSLazyString operandNodeValue_ = (JSLazyString)operandNodeValue;
            return this.doLazyString(operandNodeValue_, this.lazyString_flatten_, this.lazyString_len_);
        }
        if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, operandNodeValue)) {
            String operandNodeValue_ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, operandNodeValue);
            return this.doString(operandNodeValue_);
        }
        if ((state_0 & 4) != 0 && IsIdenticalStringNodeGen.fallbackGuard_(operandNodeValue)) {
            return this.doOther(operandNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 1) != 0 && operandNodeValue_ instanceof JSLazyString) {
            JSLazyString operandNodeValue__ = (JSLazyString)operandNodeValue_;
            return this.doLazyString(operandNodeValue__, this.lazyString_flatten_, this.lazyString_len_);
        }
        if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, operandNodeValue_)) {
            String operandNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, operandNodeValue_);
            return this.doString(operandNodeValue__);
        }
        if ((state_0 & 4) != 0 && IsIdenticalStringNodeGen.fallbackGuard_(operandNodeValue_)) {
            return this.doOther(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 1) != 0 && operandNodeValue_ instanceof JSLazyString) {
            JSLazyString operandNodeValue__ = (JSLazyString)operandNodeValue_;
            return this.doLazyString(operandNodeValue__, this.lazyString_flatten_, this.lazyString_len_);
        }
        if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, operandNodeValue_)) {
            String operandNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, operandNodeValue_);
            return this.doString(operandNodeValue__);
        }
        if ((state_0 & 4) != 0 && IsIdenticalStringNodeGen.fallbackGuard_(operandNodeValue_)) {
            return this.doOther(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (operandNodeValue instanceof JSLazyString) {
                JSLazyString operandNodeValue_ = (JSLazyString)operandNodeValue;
                this.lazyString_flatten_ = ConditionProfile.createBinaryProfile();
                this.lazyString_len_ = ConditionProfile.createBinaryProfile();
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doLazyString(operandNodeValue_, this.lazyString_flatten_, this.lazyString_len_);
                return bl;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(operandNodeValue);
            if (stringCast0 != 0) {
                String operandNodeValue_ = JSTypesGen.asImplicitString(stringCast0, operandNodeValue);
                state_0 |= stringCast0 << 3;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doString(operandNodeValue_);
                return bl;
            }
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doOther(operandNodeValue);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s2 = new Object[3];
        s2[0] = "doLazyString";
        if ((state_0 & 1) != 0) {
            s2[1] = (byte)1;
            ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.lazyString_flatten_, this.lazyString_len_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "doString";
        s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s2;
        s2 = new Object[3];
        s2[0] = "doOther";
        s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s2;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(Object operandNodeValue) {
        return !JSTypesGen.isImplicitString(operandNodeValue);
    }

    public static IsIdenticalStringNode create(String string, JavaScriptNode operand, boolean leftConstant) {
        return new IsIdenticalStringNodeGen(string, operand, leftConstant);
    }
}

