/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.parser.BinarySnapshotProvider;
import com.oracle.truffle.js.parser.DirectEvalContext;
import com.oracle.truffle.js.parser.GraalJSParserHelper;
import com.oracle.truffle.js.parser.JSParser;
import com.oracle.truffle.js.parser.JavaScriptTranslator;
import com.oracle.truffle.js.parser.SnapshotProvider;
import com.oracle.truffle.js.parser.date.DateParser;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Supplier;

public final class GraalJSEvaluator
implements JSParser {
    private static final HiddenKey STORE_MODULE_KEY = new HiddenKey("store-module-key");

    @Override
    public Object evaluate(JSRealm realm, Node lastNode, Source source) {
        DynamicObject thisObj = realm.getGlobalObject();
        return GraalJSEvaluator.doEvaluate(realm, lastNode, thisObj, JSFrameUtil.NULL_MATERIALIZED_FRAME, source, false, null);
    }

    @Override
    public ScriptNode parseFunction(JSContext context, String parameterList, String body, boolean generatorFunction, boolean asyncFunction, String sourceName) {
        String wrappedBody = '\n' + body + '\n';
        try {
            GraalJSParserHelper.checkFunctionSyntax(context, context.getParserOptions(), parameterList, wrappedBody, generatorFunction, asyncFunction, sourceName);
        }
        catch (ParserException e) {
            e.setLineNumber(e.getLineNumber() - 1);
            throw GraalJSEvaluator.parserToJSError(null, e, context);
        }
        StringBuilder code = new StringBuilder();
        if (asyncFunction) {
            code.append("(async function");
        } else {
            code.append("(function");
        }
        if (generatorFunction) {
            code.append("*");
        }
        if (context.getEcmaScriptVersion() >= 6) {
            code.append(" anonymous");
        }
        if (context.isOptionNashornCompatibilityMode()) {
            code.append(' ');
        }
        code.append('(');
        code.append(parameterList);
        code.append('\n');
        code.append(") {");
        code.append(wrappedBody);
        code.append("})");
        Source source = Source.newBuilder("js", code.toString(), sourceName).build();
        return GraalJSEvaluator.parseEval(context, null, source, false, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public Object evaluate(JSRealm realm, Node lastNode, Source source, MaterializedFrame frame, Object thisObj, Object evalEnv) {
        assert (frame != null);
        DirectEvalContext directEval = (DirectEvalContext)evalEnv;
        return GraalJSEvaluator.doEvaluate(realm, lastNode, thisObj, frame, source, directEval.env.isStrictMode(), directEval);
    }

    private static JavaScriptNode parseInlineScript(final JSContext context, Source source, Environment env, boolean isStrict) {
        ScriptNode script = JavaScriptTranslator.translateInlineScript(NodeFactory.getInstance(context), context, env, source, isStrict);
        final RootCallTarget callTarget = script.getCallTarget();
        final JSFunctionData functionData = script.getFunctionData();
        return new JavaScriptNode(){
            @Node.Child
            DirectCallNode callNode;
            {
                this.callNode = DirectCallNode.create(callTarget);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                DynamicObject closure = JSFunction.create(context.getRealm(), functionData, frame.materialize());
                return this.callNode.call(JSArguments.createZeroArg(JSFrameUtil.getThisObj(frame), closure));
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    private static Object doEvaluate(JSRealm realm, Node lastNode, Object thisObj, MaterializedFrame materializedFrame, Source source, boolean isStrict, DirectEvalContext directEval) {
        JSContext context = realm.getContext();
        ScriptNode scriptNode = GraalJSEvaluator.parseEval(context, lastNode, source, isStrict, directEval);
        return GraalJSEvaluator.runParsed(scriptNode, realm, thisObj, materializedFrame);
    }

    private static Object runParsed(ScriptNode scriptNode, JSRealm realm, Object thisObj, MaterializedFrame materializedFrame) {
        DynamicObject functionObj = JSFunction.create(realm, scriptNode.getFunctionData(), materializedFrame);
        return scriptNode.run(JSArguments.createZeroArg(thisObj, functionObj));
    }

    private static ScriptNode parseEval(JSContext context, Node lastNode, Source source, boolean isStrict, DirectEvalContext directEval) {
        context.checkEvalAllowed();
        NodeFactory nodeFactory = NodeFactory.getInstance(context);
        try {
            return JavaScriptTranslator.translateEvalScript(nodeFactory, context, source, isStrict, directEval);
        }
        catch (ParserException e) {
            throw GraalJSEvaluator.parserToJSError(lastNode, e, context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException parserToJSError(Node lastNode, ParserException e, JSContext context) {
        String message = e.getMessage().replace("\r\n", "\n");
        if (e.getErrorType() == JSErrorType.ReferenceError) {
            return Errors.createReferenceError(message, e, lastNode);
        }
        assert (e.getErrorType() == JSErrorType.SyntaxError);
        if (context.isOptionNashornCompatibilityMode() && lastNode instanceof EvalNode) {
            SourceSection sourceSection = lastNode.getSourceSection();
            String name = sourceSection.getSource().getName();
            int lineNumber = sourceSection.getStartLine();
            int columnNumber = sourceSection.getStartColumn() - 1;
            message = name + '#' + lineNumber + ':' + columnNumber + message;
        }
        return Errors.createSyntaxError(message, e, lastNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ScriptNode evalCompile(JSContext context, String sourceCode, String name) {
        try {
            context.checkEvalAllowed();
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder("js", sourceCode, name).build(), false, "", "");
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, String prolog, String epilog, String[] argumentNames) {
        String mimeType = source.getMimeType();
        if ("application/javascript+module".equals(mimeType) || mimeType == null && source.getName().endsWith(".mjs")) {
            return this.fakeScriptForModule(context, source);
        }
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, source, context.getParserOptions().isStrict(), prolog, epilog, argumentNames);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    private ScriptNode fakeScriptForModule(final JSContext context, final Source source) {
        JavaScriptRootNode rootNode = new JavaScriptRootNode(context.getLanguage(), JSBuiltin.createSourceSection(), null){
            @Node.Child
            private PerformPromiseThenNode performPromiseThenNode;
            {
                super(x0, x1, x2);
                this.performPromiseThenNode = PerformPromiseThenNode.create(context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSRealm realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject(frame));
                return this.evalModule(realm);
            }

            @CompilerDirectives.TruffleBoundary
            private Object evalModule(JSRealm realm) {
                JSModuleRecord moduleRecord = realm.getModuleLoader().loadModule(source);
                GraalJSEvaluator.this.moduleInstantiation(realm, moduleRecord);
                Object promise = GraalJSEvaluator.this.moduleEvaluation(realm, moduleRecord);
                if (context.isOptionTopLevelAwait() && JSPromise.isJSPromise(promise)) {
                    DynamicObject onRejected = GraalJSEvaluator.createTopLevelAwaitReject(context);
                    DynamicObject onAccepted = GraalJSEvaluator.createTopLevelAwaitResolve(context);
                    this.performPromiseThenNode.execute((DynamicObject)promise, onAccepted, onRejected, null);
                }
                return promise;
            }
        };
        JSFunctionData functionData = JSFunctionData.createCallOnly(context, Truffle.getRuntime().createCallTarget(rootNode), 0, "");
        return ScriptNode.fromFunctionData(context, functionData);
    }

    private static DynamicObject createTopLevelAwaitReject(JSContext context) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.TopLevelAwaitReject, c -> GraalJSEvaluator.createTopLevelAwaitRejectImpl(c));
        return JSFunction.create(context.getRealm(), functionData);
    }

    private static JSFunctionData createTopLevelAwaitRejectImpl(JSContext context) {
        class TopLevelAwaitRejectedRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);

            TopLevelAwaitRejectedRootNode() {
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object error = this.argumentNode.execute(frame);
                throw JSRuntime.getException(error);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new TopLevelAwaitRejectedRootNode());
        return JSFunctionData.createCallOnly(context, callTarget, 1, "");
    }

    private static DynamicObject createTopLevelAwaitResolve(JSContext context) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.TopLevelAwaitResolve, c -> GraalJSEvaluator.createTopLevelAwaitResolveImpl(c));
        return JSFunction.create(context.getRealm(), functionData);
    }

    private static JSFunctionData createTopLevelAwaitResolveImpl(JSContext context) {
        class TopLevelAwaitFulfilledRootNode
        extends JavaScriptRootNode {
            TopLevelAwaitFulfilledRootNode() {
            }

            @Override
            public Object execute(VirtualFrame frame) {
                return Undefined.instance;
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new TopLevelAwaitFulfilledRootNode());
        return JSFunctionData.createCallOnly(context, callTarget, 1, "");
    }

    @Override
    public ScriptNode parseScript(JSContext context, String sourceCode) {
        try {
            return JavaScriptTranslator.translateScript(NodeFactory.getInstance(context), context, Source.newBuilder("js", sourceCode, "<unknown>").build(), false, "", "");
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage());
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Integer[] parseDate(JSRealm realm, String date) {
        DateParser dateParser = new DateParser(realm, date);
        return dateParser.parse() ? dateParser.getDateFields() : null;
    }

    @Override
    public String parseToJSON(JSContext context, String code, String name, boolean includeLoc) {
        return GraalJSParserHelper.parseToJSON(code, name, includeLoc, context.getParserOptions());
    }

    @Override
    public Object getDefaultNodeFactory() {
        return NodeFactory.getDefaultInstance();
    }

    public static Supplier<ScriptNode> internalParseForTiming(JSContext context, Source source) {
        FunctionNode ast = GraalJSParserHelper.parseScript(context, source, new JSParserOptions());
        return () -> JavaScriptTranslator.translateFunction(NodeFactory.getInstance(context), context, null, source, 0, false, ast);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord parseModule(JSContext context, Source source, JSModuleLoader moduleLoader) {
        try {
            return JavaScriptTranslator.translateModule(NodeFactory.getInstance(context), context, source, moduleLoader);
        }
        catch (ParserException e) {
            throw Errors.createSyntaxError(e.getMessage(), e, null);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSModuleRecord hostResolveImportedModule(JSContext context, ScriptOrModule referrer, String specifier) {
        JSModuleLoader moduleLoader = referrer instanceof JSModuleRecord ? ((JSModuleRecord)referrer).getModuleLoader() : context.getRealm().getModuleLoader();
        return moduleLoader.resolveImportedModule(referrer, specifier);
    }

    private static JSModuleRecord hostResolveImportedModule(JSModuleRecord referencingModule, String specifier) {
        return referencingModule.getModuleLoader().resolveImportedModule(referencingModule, specifier);
    }

    Collection<String> getExportedNames(JSModuleRecord moduleRecord) {
        return this.getExportedNames(moduleRecord, new HashSet<JSModuleRecord>());
    }

    private Collection<String> getExportedNames(JSModuleRecord moduleRecord, Set<JSModuleRecord> exportStarSet) {
        if (exportStarSet.contains(moduleRecord)) {
            return Collections.emptySortedSet();
        }
        exportStarSet.add(moduleRecord);
        HashSet<String> exportedNames = new HashSet<String>();
        Module module = (Module)moduleRecord.getModule();
        for (Module.ExportEntry exportEntry : module.getLocalExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            exportedNames.add(exportEntry.getExportName());
        }
        for (Module.ExportEntry exportEntry : module.getStarExportEntries()) {
            JSModuleRecord requestedModule = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, exportEntry.getModuleRequest());
            Collection<String> starNames = this.getExportedNames(requestedModule, exportStarSet);
            for (String starName : starNames) {
                if (starName.equals("default") || exportedNames.contains(starName)) continue;
                exportedNames.add(starName);
            }
        }
        return exportedNames;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ExportResolution resolveExport(JSModuleRecord referencingModule, String exportName) {
        return this.resolveExport(referencingModule, exportName, new HashSet<Pair<JSModuleRecord, String>>());
    }

    private ExportResolution resolveExport(JSModuleRecord referencingModule, String exportName, Set<Pair<JSModuleRecord, String>> resolveSet) {
        Pair<JSModuleRecord, String> resolved = new Pair<JSModuleRecord, String>(referencingModule, exportName);
        if (resolveSet.contains(resolved)) {
            return ExportResolution.notFound();
        }
        resolveSet.add(resolved);
        Module module = (Module)referencingModule.getModule();
        for (Module.ExportEntry exportEntry : module.getLocalExportEntries()) {
            if (!exportEntry.getExportName().equals(exportName)) continue;
            return ExportResolution.resolved(referencingModule, exportEntry.getLocalName());
        }
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            if (!exportEntry.getExportName().equals(exportName)) continue;
            JSModuleRecord importedModule = GraalJSEvaluator.hostResolveImportedModule(referencingModule, exportEntry.getModuleRequest());
            if (exportEntry.getImportName().equals("*")) {
                return ExportResolution.resolved(importedModule, "*namespace*");
            }
            return this.resolveExport(importedModule, exportEntry.getImportName(), resolveSet);
        }
        if (exportName.equals("default")) {
            return ExportResolution.notFound();
        }
        ExportResolution starResolution = ExportResolution.notFound();
        for (Module.ExportEntry exportEntry : module.getStarExportEntries()) {
            JSModuleRecord importedModule = GraalJSEvaluator.hostResolveImportedModule(referencingModule, exportEntry.getModuleRequest());
            ExportResolution resolution = this.resolveExport(importedModule, exportName, resolveSet);
            if (resolution.isAmbiguous()) {
                return resolution;
            }
            if (resolution.isNull()) continue;
            if (starResolution.isNull()) {
                starResolution = resolution;
                continue;
            }
            if (resolution.equals(starResolution)) continue;
            return ExportResolution.ambiguous();
        }
        return starResolution;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getModuleNamespace(JSModuleRecord moduleRecord) {
        if (moduleRecord.getNamespace() != null) {
            return moduleRecord.getNamespace();
        }
        assert (moduleRecord.getStatus() != JSModuleRecord.Status.Unlinked);
        Collection<String> exportedNames = this.getExportedNames(moduleRecord);
        ArrayList<Pair<String, ExportResolution>> unambiguousNames = new ArrayList<Pair<String, ExportResolution>>();
        for (String exportedName : exportedNames) {
            ExportResolution resolution = this.resolveExport(moduleRecord, exportedName);
            if (resolution.isNull()) {
                throw Errors.createSyntaxError("Could not resolve export");
            }
            if (resolution.isAmbiguous()) continue;
            unambiguousNames.add(new Pair<String, ExportResolution>(exportedName, resolution));
        }
        LinkedHashMap<String, ExportResolution> sortedNames = new LinkedHashMap<String, ExportResolution>();
        unambiguousNames.stream().sorted(Comparator.comparing(Pair::getFirst)).forEachOrdered(p -> {
            ExportResolution cfr_ignored_0 = (ExportResolution)sortedNames.put((String)p.getFirst(), (ExportResolution)p.getSecond());
        });
        DynamicObject namespace = JSModuleNamespace.create(moduleRecord.getContext(), moduleRecord, sortedNames);
        moduleRecord.setNamespace(namespace);
        return namespace;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void moduleInstantiation(JSRealm realm, JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() != JSModuleRecord.Status.Linking && moduleRecord.getStatus() != JSModuleRecord.Status.Evaluating);
        ArrayDeque<JSModuleRecord> stack = new ArrayDeque<JSModuleRecord>(4);
        try {
            this.innerModuleInstantiation(realm, moduleRecord, stack, 0);
        }
        catch (GraalJSException e) {
            for (JSModuleRecord m3 : stack) {
                assert (m3.getStatus() == JSModuleRecord.Status.Linking);
                m3.setUninstantiated();
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Unlinked);
            throw e;
        }
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Linked || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated);
        assert (stack.isEmpty());
    }

    private int innerModuleInstantiation(JSRealm realm, JSModuleRecord moduleRecord, Deque<JSModuleRecord> stack, int index0) {
        int index;
        block8: {
            JSModuleRecord requiredModule;
            index = index0;
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Linking || moduleRecord.getStatus() == JSModuleRecord.Status.Linked || moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated) {
                return index;
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Unlinked);
            moduleRecord.setStatus(JSModuleRecord.Status.Linking);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            ++index;
            stack.push(moduleRecord);
            Module module = (Module)moduleRecord.getModule();
            for (String requestedModule : module.getRequestedModules()) {
                JSModuleRecord requiredModule2 = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, requestedModule);
                index = this.innerModuleInstantiation(realm, requiredModule2, stack, index);
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Linking || requiredModule2.getStatus() == JSModuleRecord.Status.Linked || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Linking == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() != JSModuleRecord.Status.Linking) continue;
                moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
            }
            this.moduleInitializeEnvironment(realm, moduleRecord);
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block8;
            do {
                requiredModule = stack.pop();
                requiredModule.setStatus(JSModuleRecord.Status.Linked);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    private void moduleInitializeEnvironment(JSRealm realm, JSModuleRecord moduleRecord) {
        assert (moduleRecord.getStatus() == JSModuleRecord.Status.Linking);
        Module module = (Module)moduleRecord.getModule();
        for (Module.ExportEntry exportEntry : module.getIndirectExportEntries()) {
            ExportResolution resolution = this.resolveExport(moduleRecord, exportEntry.getExportName());
            if (!resolution.isNull() && !resolution.isAmbiguous()) continue;
            throw Errors.createSyntaxError("Could not resolve indirect export entry");
        }
        GraalJSEvaluator.moduleExecution(realm, moduleRecord, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object moduleEvaluation(JSRealm realm, JSModuleRecord moduleRecord) {
        JSModuleRecord module = moduleRecord;
        ArrayDeque<JSModuleRecord> stack = new ArrayDeque<JSModuleRecord>(4);
        if (realm.getContext().isOptionTopLevelAwait()) {
            assert (module.getStatus() == JSModuleRecord.Status.Linked || module.getStatus() == JSModuleRecord.Status.Evaluated);
            if (module.getStatus() == JSModuleRecord.Status.Evaluated) {
                module = GraalJSEvaluator.getAsyncCycleRoot(module);
            }
            if (module.getTopLevelCapability() != null) {
                return module.getTopLevelCapability().getPromise();
            }
            PromiseCapabilityRecord capability = NewPromiseCapabilityNode.createDefault(realm);
            module.setTopLevelCapability(capability);
            try {
                this.innerModuleEvaluation(realm, module, stack, 0);
                assert (module.getStatus() == JSModuleRecord.Status.Evaluated);
                assert (module.getEvaluationError() == null);
                if (!module.isAsyncEvaluating()) {
                    JSFunction.call(JSArguments.create(Undefined.instance, capability.getResolve(), Undefined.instance));
                }
                assert (stack.isEmpty());
            }
            catch (Throwable e) {
                if (TryCatchNode.shouldCatch(e)) {
                    for (JSModuleRecord m3 : stack) {
                        assert (m3.getStatus() == JSModuleRecord.Status.Evaluating);
                        m3.setStatus(JSModuleRecord.Status.Evaluated);
                        m3.setEvaluationError(e);
                    }
                    assert (module.getStatus() == JSModuleRecord.Status.Evaluated && module.getEvaluationError() == e);
                    throw e;
                }
                throw e;
            }
            return capability.getPromise();
        }
        try {
            this.innerModuleEvaluation(realm, module, stack, 0);
        }
        catch (Throwable e) {
            if (TryCatchNode.shouldCatch(e)) {
                for (JSModuleRecord m4 : stack) {
                    assert (m4.getStatus() == JSModuleRecord.Status.Evaluating);
                    m4.setStatus(JSModuleRecord.Status.Evaluated);
                    m4.setEvaluationError(e);
                }
                assert (module.getStatus() == JSModuleRecord.Status.Evaluated && module.getEvaluationError() == e);
            }
            throw e;
        }
        assert (module.getStatus() == JSModuleRecord.Status.Evaluated && module.getEvaluationError() == null);
        assert (stack.isEmpty());
        Object result = module.getExecutionResult();
        return result == null ? Undefined.instance : result;
    }

    @CompilerDirectives.TruffleBoundary
    private static JSModuleRecord getAsyncCycleRoot(JSModuleRecord moduleRecord) {
        JSModuleRecord module = moduleRecord;
        assert (module.getStatus() == JSModuleRecord.Status.Evaluated);
        if (module.getAsyncParentModules().size() == 0) {
            return module;
        }
        while (module.getDFSIndex() > module.getDFSAncestorIndex()) {
            assert (module.getAsyncParentModules().size() != 0);
            JSModuleRecord nextCycleModule = module.getAsyncParentModules().remove(0);
            assert (nextCycleModule.getDFSAncestorIndex() <= module.getDFSAncestorIndex());
            module = nextCycleModule;
        }
        assert (module.getDFSIndex() == module.getDFSAncestorIndex());
        return module;
    }

    @CompilerDirectives.TruffleBoundary
    private int innerModuleEvaluation(JSRealm realm, JSModuleRecord moduleRecord, Deque<JSModuleRecord> stack, int index0) {
        int index;
        block18: {
            JSModuleRecord requiredModule;
            index = index0;
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluated) {
                if (moduleRecord.getEvaluationError() == null) {
                    return index;
                }
                throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
            }
            if (moduleRecord.getStatus() == JSModuleRecord.Status.Evaluating) {
                return index;
            }
            assert (moduleRecord.getStatus() == JSModuleRecord.Status.Linked);
            moduleRecord.setStatus(JSModuleRecord.Status.Evaluating);
            moduleRecord.setDFSIndex(index);
            moduleRecord.setDFSAncestorIndex(index);
            moduleRecord.setPendingAsyncDependencies(0);
            moduleRecord.initAsyncParentModules();
            ++index;
            stack.push(moduleRecord);
            Module module = (Module)moduleRecord.getModule();
            for (String requestedModule : module.getRequestedModules()) {
                JSModuleRecord requiredModule2 = GraalJSEvaluator.hostResolveImportedModule(moduleRecord, requestedModule);
                index = this.innerModuleEvaluation(realm, requiredModule2, stack, index);
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating || requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated) : requiredModule2.getStatus();
                assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating == stack.contains(requiredModule2));
                if (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluating) {
                    moduleRecord.setDFSAncestorIndex(Math.min(moduleRecord.getDFSAncestorIndex(), requiredModule2.getDFSAncestorIndex()));
                } else {
                    requiredModule2 = GraalJSEvaluator.getAsyncCycleRoot(requiredModule2);
                    assert (requiredModule2.getStatus() == JSModuleRecord.Status.Evaluated);
                    if (requiredModule2.getEvaluationError() != null) {
                        throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
                    }
                }
                if (!requiredModule2.isAsyncEvaluating()) continue;
                moduleRecord.incPendingAsyncDependencies();
                requiredModule2.appendAsyncParentModules(moduleRecord);
            }
            if (moduleRecord.getPendingAsyncDependencies() > 0) {
                moduleRecord.setAsyncEvaluating(true);
            } else if (moduleRecord.isTopLevelAsync()) {
                GraalJSEvaluator.moduleAsyncExecution(realm, moduleRecord);
            } else {
                Object result = GraalJSEvaluator.moduleExecution(realm, moduleRecord, null);
                moduleRecord.setExecutionResult(result);
            }
            assert (GraalJSEvaluator.occursExactlyOnce(moduleRecord, stack));
            assert (moduleRecord.getDFSAncestorIndex() <= moduleRecord.getDFSIndex());
            if (moduleRecord.getDFSAncestorIndex() != moduleRecord.getDFSIndex()) break block18;
            do {
                requiredModule = stack.pop();
                requiredModule.setStatus(JSModuleRecord.Status.Evaluated);
            } while (!requiredModule.equals(moduleRecord));
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    private static void moduleAsyncExecution(JSRealm realm, JSModuleRecord module) {
        assert (module.getStatus() == JSModuleRecord.Status.Evaluating || module.getStatus() == JSModuleRecord.Status.Evaluated);
        assert (module.isTopLevelAsync());
        module.setAsyncEvaluating(true);
        PromiseCapabilityRecord capability = NewPromiseCapabilityNode.createDefault(realm);
        DynamicObject onFulfilled = GraalJSEvaluator.createCallAsyncModuleFulfilled(realm.getContext(), module);
        DynamicObject onRejected = GraalJSEvaluator.createCallAsyncModuleRejected(realm.getContext(), module);
        Object then = JSObject.get(capability.getPromise(), (Object)"then");
        JSFunction.call(JSArguments.create(capability.getPromise(), then, onFulfilled, onRejected));
        GraalJSEvaluator.moduleExecution(realm, module, capability);
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createCallAsyncModuleFulfilled(JSContext context, JSModuleRecord module) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncModuleExecutionFulfilled, c -> GraalJSEvaluator.createCallAsyncModuleFulfilledImpl(c));
        DynamicObject function = JSFunction.create(context.getRealm(), functionData);
        JSObjectUtil.putHiddenProperty(function, STORE_MODULE_KEY, module);
        return function;
    }

    private static JSFunctionData createCallAsyncModuleFulfilledImpl(JSContext context) {
        class AsyncModuleFulfilledRoot
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private PropertyGetNode getModule = PropertyGetNode.createGetHidden(GraalJSEvaluator.access$200(), this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncModuleFulfilledRoot(JSContext jSContext) {
                this.val$context = jSContext;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object dynamicImportResolutionResult = this.argumentNode.execute(frame);
                Object module = this.getModule.getValue(JSArguments.getFunctionObject(frame.getArguments()));
                return GraalJSEvaluator.asyncModuleExecutionFulfilled(this.val$context.getRealm(), (JSModuleRecord)module, dynamicImportResolutionResult);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new AsyncModuleFulfilledRoot(context));
        return JSFunctionData.createCallOnly(context, callTarget, 1, "");
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createCallAsyncModuleRejected(JSContext context, JSModuleRecord module) {
        JSFunctionData functionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncModuleExecutionRejected, c -> GraalJSEvaluator.createCallAsyncModuleRejectedImpl(c));
        DynamicObject function = JSFunction.create(context.getRealm(), functionData);
        JSObjectUtil.putHiddenProperty(function, STORE_MODULE_KEY, module);
        return function;
    }

    private static JSFunctionData createCallAsyncModuleRejectedImpl(JSContext context) {
        class AsyncModuleExecutionRejectedRoot
        extends JavaScriptRootNode {
            @Node.Child
            private PropertyGetNode getModule;
            @Node.Child
            private PropertyGetNode getRejectionError;
            final /* synthetic */ JSContext val$context;

            AsyncModuleExecutionRejectedRoot(JSContext jSContext) {
                this.val$context = jSContext;
                this.getModule = PropertyGetNode.createGetHidden(STORE_MODULE_KEY, this.val$context);
                this.getRejectionError = PropertyGetNode.createGetHidden(JSPromise.PROMISE_RESULT, this.val$context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSModuleRecord module = (JSModuleRecord)this.getModule.getValue(JSArguments.getFunctionObject(frame.getArguments()));
                Object resolvedPromise = module.getExecutionContinuation();
                assert (JSPromise.isJSPromise(resolvedPromise));
                assert (JSPromise.isRejected((DynamicObject)resolvedPromise));
                Object reaction = this.getRejectionError.getValue(resolvedPromise);
                return GraalJSEvaluator.asyncModuleExecutionRejected(this.val$context.getRealm(), module, reaction);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new AsyncModuleExecutionRejectedRoot(context));
        return JSFunctionData.createCallOnly(context, callTarget, 1, "");
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asyncModuleExecutionFulfilled(JSRealm realm, JSModuleRecord module, Object dynamicImportResolutionResult) {
        assert (module.getStatus() == JSModuleRecord.Status.Evaluated);
        if (!module.isAsyncEvaluating()) {
            assert (module.getEvaluationError() != null);
            return Undefined.instance;
        }
        assert (module.getEvaluationError() == null);
        module.setAsyncEvaluating(false);
        for (JSModuleRecord m3 : module.getAsyncParentModules()) {
            if (module.getDFSIndex() != module.getDFSAncestorIndex()) assert (m3.getDFSAncestorIndex() <= module.getDFSAncestorIndex());
            m3.decPendingAsyncDependencies();
            if (m3.getPendingAsyncDependencies() != 0 || m3.getEvaluationError() != null) continue;
            assert (m3.isAsyncEvaluating());
            JSModuleRecord cycleRoot = GraalJSEvaluator.getAsyncCycleRoot(m3);
            if (cycleRoot.getEvaluationError() != null) {
                return Undefined.instance;
            }
            if (m3.isTopLevelAsync()) {
                GraalJSEvaluator.moduleAsyncExecution(realm, m3);
                continue;
            }
            try {
                GraalJSEvaluator.moduleExecution(realm, m3, null);
                GraalJSEvaluator.asyncModuleExecutionFulfilled(realm, m3, dynamicImportResolutionResult);
            }
            catch (Exception e) {
                GraalJSEvaluator.asyncModuleExecutionRejected(realm, m3, e);
            }
        }
        if (module.getTopLevelCapability() != null) {
            assert (module.getDFSIndex() == module.getDFSAncestorIndex());
            JSFunction.call(JSArguments.create(Undefined.instance, module.getTopLevelCapability().getResolve(), dynamicImportResolutionResult));
        }
        return Undefined.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asyncModuleExecutionRejected(JSRealm realm, JSModuleRecord module, Object error) {
        assert (error != null) : "Cannot reject a module creation with null error";
        assert (module.getStatus() == JSModuleRecord.Status.Evaluated);
        if (!module.isAsyncEvaluating()) {
            assert (module.getEvaluationError() != null);
            return Undefined.instance;
        }
        assert (module.getEvaluationError() == null);
        module.setEvaluationError(JSRuntime.getException(error));
        module.setAsyncEvaluating(false);
        for (JSModuleRecord m3 : module.getAsyncParentModules()) {
            if (module.getDFSIndex() != module.getDFSAncestorIndex()) assert (m3.getDFSAncestorIndex() == module.getDFSAncestorIndex());
            GraalJSEvaluator.asyncModuleExecutionRejected(realm, m3, error);
        }
        if (module.getTopLevelCapability() != null) {
            assert (module.getDFSIndex() == module.getDFSAncestorIndex());
            JSFunction.call((DynamicObject)module.getTopLevelCapability().getReject(), Undefined.instance, new Object[]{error});
        }
        return Undefined.instance;
    }

    private static Object moduleExecution(JSRealm realm, JSModuleRecord moduleRecord, PromiseCapabilityRecord capability) {
        if (!moduleRecord.isTopLevelAsync()) {
            assert (capability == null);
            return JSFunction.call(JSArguments.create(Undefined.instance, JSFunction.create(realm, moduleRecord.getFunctionData()), moduleRecord));
        }
        Object asyncFunctionResultPromise = JSFunction.call(JSArguments.create(Undefined.instance, JSFunction.create(realm, moduleRecord.getFunctionData()), moduleRecord, capability));
        moduleRecord.setExecutionContinuation(asyncFunctionResultPromise);
        return asyncFunctionResultPromise;
    }

    private static boolean occursExactlyOnce(JSModuleRecord moduleRecord, Collection<JSModuleRecord> stack) {
        return stack.stream().filter(moduleRecord::equals).count() == 1L;
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, ByteBuffer binary) {
        return ScriptNode.fromFunctionRoot(context, (FunctionRootNode)new BinarySnapshotProvider(binary).apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public ScriptNode parseScript(JSContext context, Source source, SnapshotProvider snapshotProvider) {
        return ScriptNode.fromFunctionRoot(context, (FunctionRootNode)snapshotProvider.apply(NodeFactory.getInstance(context), context, source));
    }

    @Override
    public JavaScriptNode parseInlineScript(JSContext context, Source source, MaterializedFrame lexicalContextFrame, boolean isStrict) {
        Environment env = GraalJSEvaluator.assembleDebugEnvironment(context, lexicalContextFrame);
        return GraalJSEvaluator.parseInlineScript(context, source, env, isStrict);
    }

    private static Environment assembleDebugEnvironment(JSContext context, MaterializedFrame lexicalContextFrame) {
        DebugEnvironment env = null;
        ArrayList<FrameDescriptor> frameDescriptors = new ArrayList<FrameDescriptor>();
        Frame frame = lexicalContextFrame;
        while (frame != null && frame != JSFrameUtil.NULL_MATERIALIZED_FRAME) {
            FrameSlot parentSlot;
            assert (GraalJSEvaluator.isJSArgumentsArray(frame.getArguments()));
            while ((parentSlot = frame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)) != null) {
                frameDescriptors.add(frame.getFrameDescriptor());
                frame = (Frame)FrameUtil.getObjectSafe(frame, parentSlot);
            }
            frameDescriptors.add(frame.getFrameDescriptor());
            frame = JSArguments.getEnclosingFrame(frame.getArguments());
        }
        for (int i = frameDescriptors.size() - 1; i >= 0; --i) {
            env = new DebugEnvironment(env, NodeFactory.getInstance(context), context, (FrameDescriptor)frameDescriptors.get(i));
        }
        return env;
    }

    private static boolean isJSArgumentsArray(Object[] arguments) {
        return arguments != null && arguments.length >= 2 && JSFunction.isJSFunction(JSArguments.getFunctionObject(arguments));
    }

    @Override
    public Expression parseExpression(JSContext context, String sourceString) {
        return GraalJSParserHelper.parseExpression(context, Source.newBuilder("js", sourceString, "<unknown>").build(), context.getParserOptions());
    }
}

