/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.doubleconv.DoubleConversion;
import com.oracle.truffle.js.runtime.external.DToA;
import com.oracle.truffle.js.runtime.interop.InteropFunction;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Nullish;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public final class JSRuntime {
    private static final long NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
    private static final long POSITIVE_INFINITY_DOUBLE_BITS = Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
    public static final String INFINITY_STRING = "Infinity";
    public static final String NEGATIVE_INFINITY_STRING = "-Infinity";
    public static final String POSITIVE_INFINITY_STRING = "+Infinity";
    public static final String NAN_STRING = "NaN";
    public static final double TWO32 = 4.294967296E9;
    public static final char LINE_SEPARATOR = '\n';
    public static final long INVALID_ARRAY_INDEX = -1L;
    public static final long MAX_ARRAY_LENGTH = 0xFFFFFFFFL;
    public static final int MAX_UINT32_DIGITS = 10;
    public static final double MAX_SAFE_INTEGER = Math.pow(2.0, 53.0) - 1.0;
    public static final double MIN_SAFE_INTEGER = -MAX_SAFE_INTEGER;
    public static final long MAX_SAFE_INTEGER_LONG = (long)MAX_SAFE_INTEGER;
    public static final long MIN_SAFE_INTEGER_LONG = (long)MIN_SAFE_INTEGER;
    public static final long INVALID_INTEGER_INDEX = -1L;
    public static final int MAX_INTEGER_INDEX_DIGITS = 16;
    public static final int MAX_SAFE_INTEGER_DIGITS = 16;
    public static final int MAX_SAFE_INTEGER_IN_FLOAT = 0x1000000;
    public static final int MIN_SAFE_INTEGER_IN_FLOAT = -16777216;
    public static final long MAX_BIG_INT_EXPONENT = Integer.MAX_VALUE;
    public static final long INVALID_SAFE_INTEGER = Long.MIN_VALUE;
    public static final String TO_STRING = "toString";
    public static final String VALUE_OF = "valueOf";
    public static final String VALUE = "value";
    public static final String DONE = "done";
    public static final String NEXT = "next";
    public static final String HINT_STRING = "string";
    public static final String HINT_NUMBER = "number";
    public static final String HINT_DEFAULT = "default";
    public static final String PRIMITIVE_VALUE = "PrimitiveValue";
    public static final HiddenKey ITERATED_OBJECT_ID = new HiddenKey("IteratedObject");
    public static final HiddenKey ITERATOR_NEXT_INDEX = new HiddenKey("IteratorNextIndex");
    public static final HiddenKey ENUMERATE_ITERATOR_ID = new HiddenKey("EnumerateIterator");
    public static final HiddenKey FOR_IN_ITERATOR_ID = new HiddenKey("ForInIterator");
    public static final HiddenKey FINALIZATION_GROUP_CLEANUP_ITERATOR_ID = new HiddenKey("CleanupIterator");
    public static final int ITERATION_KIND_KEY = 1;
    public static final int ITERATION_KIND_VALUE = 2;
    public static final int ITERATION_KIND_KEY_PLUS_VALUE = 3;
    public static final int TO_STRING_MAX_DEPTH = 3;

    private JSRuntime() {
    }

    public static boolean doubleIsRepresentableAsInt(double d) {
        return JSRuntime.doubleIsRepresentableAsInt(d, false);
    }

    public static boolean doubleIsRepresentableAsInt(double d, boolean ignoreNegativeZero) {
        long longValue = (long)d;
        return JSRuntime.doubleIsRepresentableAsLong(d) && JSRuntime.longIsRepresentableAsInt(longValue) && (ignoreNegativeZero || !JSRuntime.isNegativeZero(d));
    }

    public static boolean doubleIsRepresentableAsUnsignedInt(double d, boolean ignoreNegativeZero) {
        long longValue = (long)d;
        return JSRuntime.doubleIsRepresentableAsLong(d) && JSRuntime.longIsRepresentableAsInt(longValue) && (ignoreNegativeZero || !JSRuntime.isNegativeZero(d));
    }

    public static boolean isNegativeZero(double d) {
        return Double.doubleToRawLongBits(d) == NEGATIVE_ZERO_DOUBLE_BITS;
    }

    public static boolean isPositiveInfinity(double d) {
        return Double.doubleToRawLongBits(d) == POSITIVE_INFINITY_DOUBLE_BITS;
    }

    public static Number doubleToNarrowestNumber(double d) {
        if (JSRuntime.doubleIsRepresentableAsInt(d)) {
            return (int)d;
        }
        return d;
    }

    public static boolean longIsRepresentableAsInt(long value) {
        return value == (long)((int)value);
    }

    public static boolean isRepresentableAsUnsignedInt(long value) {
        return (value & 0xFFFFFFFFL) == value;
    }

    public static boolean doubleIsRepresentableAsLong(double d) {
        return d == (double)((long)d);
    }

    public static Object positiveLongToIntOrDouble(long value) {
        if (value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        return (double)value;
    }

    public static Number longToIntOrDouble(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        return (double)value;
    }

    public static boolean isNaN(Object value) {
        if (!(value instanceof Double)) {
            return false;
        }
        double d = (Double)value;
        return Double.isNaN(d);
    }

    @CompilerDirectives.TruffleBoundary
    public static String typeof(Object value) {
        if (value == Null.instance) {
            return "object";
        }
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (JSRuntime.isString(value)) {
            return HINT_STRING;
        }
        if (JSRuntime.isNumber(value)) {
            return HINT_NUMBER;
        }
        if (JSRuntime.isBigInt(value)) {
            return "bigint";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Symbol) {
            return "symbol";
        }
        if (JSDynamicObject.isJSDynamicObject(value)) {
            DynamicObject object = (DynamicObject)value;
            if (JSProxy.isJSProxy(object)) {
                Object target = JSProxy.getTarget(object);
                if (target == Null.instance) {
                    return JSRuntime.isRevokedCallableProxy(object) ? "function" : "object";
                }
                return JSRuntime.typeof(target);
            }
            if (JSFunction.isJSFunction(object)) {
                return "function";
            }
            return "object";
        }
        if (value instanceof TruffleObject) {
            assert (!(value instanceof Symbol));
            TruffleObject object = (TruffleObject)value;
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (interop.isBoolean(object)) {
                return "boolean";
            }
            if (interop.isString(object)) {
                return HINT_STRING;
            }
            if (interop.isNumber(object)) {
                return HINT_NUMBER;
            }
            if (interop.isExecutable(object) || interop.isInstantiable(object)) {
                return "function";
            }
            return "object";
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("typeof: don't know " + value.getClass().getSimpleName());
    }

    public static boolean isObject(Object vo) {
        assert (vo instanceof JSObject == JSRuntime.hasJSDynamicType(vo));
        return vo instanceof JSObject;
    }

    private static boolean hasJSDynamicType(Object vo) {
        if (JSDynamicObject.isJSDynamicObject(vo)) {
            Object type = ((JSDynamicObject)vo).getShape().getDynamicType();
            return type instanceof JSClass && type != Null.NULL_CLASS;
        }
        return false;
    }

    public static boolean isNullOrUndefined(Object value) {
        return value instanceof Nullish;
    }

    public static boolean isNullish(Object value) {
        return value == Null.instance || value == Undefined.instance || InteropLibrary.getUncached(value).isNull(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitive(Object value) {
        return JSRuntime.toPrimitive(value, HINT_DEFAULT);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitive(Object value, String hint) {
        if (value == Null.instance || value == Undefined.instance) {
            return value;
        }
        if (value instanceof TruffleObject) {
            if (JSDynamicObject.isJSDynamicObject(value)) {
                return JSObject.toPrimitive((DynamicObject)value, hint);
            }
            if (JSRuntime.isForeignObject(value)) {
                TruffleObject tObj = (TruffleObject)value;
                return JSRuntime.toPrimitiveFromForeign(tObj, hint);
            }
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPrimitiveFromForeign(Object tObj, String hint) {
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(tObj);
        if (interop.isNull(tObj)) {
            return Null.instance;
        }
        TruffleLanguage.Env env = JavaScriptLanguage.getCurrentEnv();
        if (env.isHostObject(tObj)) {
            Object javaObject = env.asHostObject(tObj);
            if (javaObject == null) {
                return Null.instance;
            }
            if (JSGuards.isJavaPrimitiveNumber(javaObject)) {
                return JSRuntime.importValue(javaObject);
            }
            if (JavaScriptLanguage.getCurrentJSRealm().getContext().isOptionNashornCompatibilityMode() && javaObject instanceof Number) {
                return ((Number)javaObject).doubleValue();
            }
            return JSRuntime.toJSNull(javaObject.toString());
        }
        if (interop.isBoolean(tObj) || interop.isString(tObj) || interop.isNumber(tObj)) {
            return JSInteropUtil.toPrimitiveOrDefault(tObj, Null.instance, interop, null);
        }
        return JSRuntime.foreignOrdinaryToPrimitive(tObj, hint);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object foreignOrdinaryToPrimitive(Object obj, String hint) {
        String[] methodNames;
        JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(obj);
        if (hint.equals(HINT_STRING)) {
            methodNames = new String[]{TO_STRING, VALUE_OF};
        } else {
            assert (HINT_NUMBER.equals(hint));
            methodNames = new String[]{VALUE_OF, TO_STRING};
        }
        DynamicObject proto = interop.hasArrayElements(obj) ? realm.getArrayPrototype() : (interop.isExecutable(obj) ? realm.getFunctionPrototype() : (interop.isInstant(obj) ? realm.getDatePrototype() : realm.getObjectPrototype()));
        for (String name : methodNames) {
            Object result;
            Object method;
            if (interop.hasMembers(obj) && interop.isMemberInvocable(obj, name)) {
                Object result2;
                try {
                    result2 = JSRuntime.importValue(interop.invokeMember(obj, name, new Object[0]));
                }
                catch (InteropException e) {
                    result2 = null;
                }
                if (result2 != null && !JSRuntime.isObject(result2)) {
                    return result2;
                }
            }
            if (!JSRuntime.isCallable(method = JSObject.getMethod(proto, name)) || JSRuntime.isObject(result = JSRuntime.call(method, obj, new Object[0]))) continue;
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean toBoolean(Object value) {
        if (value == Boolean.TRUE) {
            return true;
        }
        if (value == Boolean.FALSE || value == Undefined.instance || value == Null.instance) {
            return false;
        }
        if (JSRuntime.isNumber(value)) {
            return JSRuntime.toBoolean((Number)value);
        }
        if (value instanceof String) {
            return ((String)value).length() != 0;
        }
        if (JSRuntime.isLazyString(value)) {
            return value.toString().length() != 0;
        }
        if (value instanceof BigInt) {
            return ((BigInt)value).compareTo(BigInt.ZERO) != 0;
        }
        if (JSRuntime.isForeignObject(value)) {
            InteropLibrary interop = InteropLibrary.getFactory().getUncached(value);
            if (interop.isNull(value)) {
                return false;
            }
            if (interop.isBoolean(value) || interop.isString(value) || interop.isNumber(value)) {
                return JSRuntime.toBoolean(JSInteropUtil.toPrimitiveOrDefault(value, Null.instance, interop, null));
            }
            return true;
        }
        return true;
    }

    public static boolean toBoolean(Number number) {
        double val = JSRuntime.doubleValue(number);
        if (val == 0.0 || Double.isNaN(val)) {
            return false;
        }
        return Boolean.TRUE;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number toNumber(Object value) {
        Object primitive = JSRuntime.isObject(value) ? JSObject.toPrimitive((DynamicObject)value, HINT_NUMBER) : (JSRuntime.isForeignObject(value) ? JSRuntime.toPrimitiveFromForeign(value, HINT_NUMBER) : value);
        return JSRuntime.toNumberFromPrimitive(primitive);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toNumeric(Object value) {
        Object primitive;
        Object object = primitive = JSRuntime.isObject(value) ? JSObject.toPrimitive((DynamicObject)value, HINT_NUMBER) : value;
        if (primitive instanceof BigInt) {
            return primitive;
        }
        return JSRuntime.toNumberFromPrimitive(primitive);
    }

    @CompilerDirectives.TruffleBoundary
    public static Number toNumberFromPrimitive(Object value) {
        if (CompilerDirectives.injectBranchProbability(0.75, JSRuntime.isNumber(value))) {
            return (Number)value;
        }
        if (value == Undefined.instance) {
            return Double.NaN;
        }
        if (value == Null.instance) {
            return 0;
        }
        if (value instanceof Boolean) {
            return JSRuntime.booleanToNumber((Boolean)value);
        }
        if (value instanceof String) {
            return JSRuntime.stringToNumber((String)value);
        }
        if (JSRuntime.isLazyString(value)) {
            return JSRuntime.stringToNumber(value.toString());
        }
        if (value instanceof Symbol) {
            throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value");
        }
        if (value instanceof BigInt) {
            throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value");
        }
        if (value instanceof Number) {
            assert (JSRuntime.isJavaPrimitive(value)) : value.getClass().getName();
            return (Number)value;
        }
        assert (false) : "should never reach here, type " + value.getClass().getName() + " not handled.";
        throw Errors.createTypeErrorCannotConvertToNumber(JSRuntime.safeToString(value));
    }

    public static int booleanToNumber(boolean value) {
        return value ? 1 : 0;
    }

    public static boolean isNumber(Object value) {
        return value instanceof Integer || value instanceof Double || value instanceof Long || value instanceof SafeInteger;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt toBigInt(Object value) {
        Object primitive = JSRuntime.toPrimitive(value, HINT_NUMBER);
        if (primitive instanceof String) {
            try {
                return BigInt.valueOf((String)primitive);
            }
            catch (NumberFormatException e) {
                throw Errors.createErrorCanNotConvertToBigInt(JSErrorType.SyntaxError, primitive);
            }
        }
        if (primitive instanceof BigInt) {
            return (BigInt)primitive;
        }
        if (primitive instanceof Boolean) {
            return (Boolean)primitive != false ? BigInt.ONE : BigInt.ZERO;
        }
        throw Errors.createErrorCanNotConvertToBigInt(JSErrorType.TypeError, primitive);
    }

    public static boolean isBigInt(Object value) {
        return value instanceof BigInt;
    }

    public static boolean isJavaNumber(Object value) {
        return value instanceof Number;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number stringToNumber(String string) {
        String strCamel = JSRuntime.trimJSWhiteSpace(string);
        if (strCamel.length() == 0) {
            return 0;
        }
        char firstChar = strCamel.charAt(0);
        if (strCamel.length() >= INFINITY_STRING.length() && strCamel.length() <= INFINITY_STRING.length() + 1 && strCamel.endsWith(INFINITY_STRING)) {
            return JSRuntime.identifyInfinity(strCamel, firstChar);
        }
        if (!JSRuntime.isAsciiDigit(firstChar) && firstChar != '-' && firstChar != '.' && firstChar != '+') {
            return Double.NaN;
        }
        return JSRuntime.stringToNumberParse(strCamel);
    }

    private static Number stringToNumberParse(String str) {
        assert (str.length() > 0);
        boolean hex = str.startsWith("0x") || str.startsWith("0X");
        int eIndex = JSRuntime.firstExpIndexInString(str);
        boolean sci = !hex && 0 <= eIndex && eIndex < str.length() - 1;
        try {
            if (!sci && str.length() <= 18 && str.indexOf(46) == -1) {
                if (hex) {
                    return Long.valueOf(str.substring(2), 16);
                }
                return JSRuntime.stringToNumberLong(str);
            }
            return JSRuntime.parseDoubleOrNaN(str);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static Number stringToNumberLong(String strLower) throws NumberFormatException {
        assert (strLower.length() > 0);
        long num = Long.parseLong(strLower);
        if (JSRuntime.longIsRepresentableAsInt(num)) {
            if (num == 0L && strLower.charAt(0) == '-') {
                return -0.0;
            }
            return (int)num;
        }
        return (double)num;
    }

    @CompilerDirectives.TruffleBoundary
    public static double parseDoubleOrNaN(String input) {
        if (input.isEmpty() || input.charAt(input.length() - 1) > '9') {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int firstExpIndexInString(String str) {
        int firstIdx = str.indexOf(101, 0);
        if (firstIdx >= 0) {
            return firstIdx;
        }
        return str.indexOf(69, 0);
    }

    public static double identifyInfinity(String str, char firstChar) {
        int infinityLength;
        int len = str.length();
        if (len == (infinityLength = INFINITY_STRING.length())) {
            return Double.POSITIVE_INFINITY;
        }
        if (len == infinityLength + 1) {
            if (firstChar == '+') {
                return Double.POSITIVE_INFINITY;
            }
            if (firstChar == '-') {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return Double.NaN;
    }

    public static long toInteger(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toInteger(number);
    }

    public static long toInteger(Number number) {
        return JSRuntime.longValue(number);
    }

    public static long toLength(Object value) {
        long l = JSRuntime.toInteger(value);
        return JSRuntime.toLength(l);
    }

    public static double toLength(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d > MAX_SAFE_INTEGER) {
            return MAX_SAFE_INTEGER;
        }
        return d;
    }

    public static long toLength(long l) {
        if (l <= 0L) {
            return 0L;
        }
        if (l > MAX_SAFE_INTEGER_LONG) {
            return MAX_SAFE_INTEGER_LONG;
        }
        return l;
    }

    public static int toLength(int value) {
        if (value <= 0) {
            return 0;
        }
        return value;
    }

    public static int toUInt8(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toUInt8(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static int toUInt8(Number number) {
        Double d;
        if (number instanceof Double && JSRuntime.isPositiveInfinity(d = (Double)number)) {
            return 0;
        }
        return JSRuntime.toUInt8(number.longValue());
    }

    public static int toUInt8(long number) {
        return (int)(number & 0xFFL);
    }

    public static int toInt8(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toInt8(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static int toInt8(Number number) {
        Double d;
        if (number instanceof Double && JSRuntime.isPositiveInfinity(d = (Double)number)) {
            return 0;
        }
        return JSRuntime.toInt8(number.longValue());
    }

    @CompilerDirectives.TruffleBoundary
    public static int toInt8(long number) {
        int res = (int)Math.floorMod(number, 256L);
        if (res >= 128) {
            res -= 256;
        }
        return res;
    }

    public static int toUInt16(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toUInt16(number);
    }

    public static int toUInt16(Number number) {
        Double d;
        if (number instanceof Double && JSRuntime.isPositiveInfinity(d = (Double)number)) {
            return 0;
        }
        return JSRuntime.toUInt16(JSRuntime.longValue(number));
    }

    public static int toUInt16(long number) {
        return (int)(number & 0xFFFFL);
    }

    public static int toInt16(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toInt16(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static int toInt16(Number number) {
        Double d;
        if (number instanceof Double && JSRuntime.isPositiveInfinity(d = (Double)number)) {
            return 0;
        }
        return JSRuntime.toInt16(number.longValue());
    }

    @CompilerDirectives.TruffleBoundary
    public static int toInt16(long number) {
        int res = (int)Math.floorMod(number, 65536L);
        if (res >= 32768) {
            res -= 65536;
        }
        return res;
    }

    public static long toUInt32(Object value) {
        return JSRuntime.toUInt32(JSRuntime.toNumber(value));
    }

    public static long toUInt32(Number number) {
        if (number instanceof Double) {
            return JSRuntime.toUInt32((Double)number);
        }
        return JSRuntime.toUInt32(JSRuntime.longValue(number));
    }

    public static long toUInt32(long value) {
        return value & 0xFFFFFFFFL;
    }

    public static long toUInt32(double value) {
        return JSRuntime.toUInt32NoTruncate(JSRuntime.truncateDouble(value));
    }

    public static long toUInt32NoTruncate(double value) {
        assert (!Double.isFinite(value) || value % 1.0 == 0.0);
        double d = JSRuntime.doubleModuloTwo32(value);
        return JSRuntime.toUInt32((long)d);
    }

    public static double truncateDouble(double value) {
        return Math.signum(value) * JSRuntime.mathFloor(Math.abs(value));
    }

    public static double truncateDouble2(double thing) {
        return thing < 0.0 ? JSRuntime.mathCeil(thing) : JSRuntime.mathFloor(thing);
    }

    public static int toInt32(Object value) {
        Number number = JSRuntime.toNumber(value);
        return JSRuntime.toInt32(number);
    }

    public static int toInt32(Number number) {
        if (number instanceof Double) {
            return JSRuntime.toInt32((Double)number);
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number instanceof Long) {
            return (int)((Long)number).longValue();
        }
        return JSRuntime.toInt32Intl(number);
    }

    @CompilerDirectives.TruffleBoundary
    private static int toInt32Intl(Number number) {
        return JSRuntime.toInt32(number.doubleValue());
    }

    public static int toInt32(double value) {
        return JSRuntime.toInt32NoTruncate(JSRuntime.truncateDouble(value));
    }

    public static int toInt32NoTruncate(double value) {
        assert (!Double.isFinite(value) || value % 1.0 == 0.0);
        return (int)JSRuntime.doubleModuloTwo32(value);
    }

    private static double doubleModuloTwo32(double value) {
        return value - JSRuntime.mathFloor(value / 4.294967296E9) * 4.294967296E9;
    }

    public static double toDouble(Object value) {
        return JSRuntime.doubleValue(JSRuntime.toNumber(value));
    }

    public static double toDouble(Number value) {
        return JSRuntime.doubleValue(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(Object value) {
        if (CompilerDirectives.injectBranchProbability(0.75, value instanceof String)) {
            return (String)value;
        }
        if (JSRuntime.isLazyString(value)) {
            return value.toString();
        }
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value == Null.instance) {
            return "null";
        }
        if (value instanceof Boolean) {
            return JSRuntime.booleanToString((Boolean)value);
        }
        if (JSRuntime.isNumber(value)) {
            return JSRuntime.numberToString((Number)value);
        }
        if (value instanceof Symbol) {
            throw Errors.createTypeErrorCannotConvertToString("a Symbol value");
        }
        if (value instanceof BigInt) {
            return value.toString();
        }
        if (JSDynamicObject.isJSDynamicObject(value)) {
            return JSRuntime.toString(JSObject.toPrimitive((DynamicObject)value, HINT_STRING));
        }
        if (value instanceof TruffleObject) {
            assert (!JSRuntime.isJSNative(value));
            return JSRuntime.toString(JSRuntime.toPrimitiveFromForeign(value, HINT_STRING));
        }
        throw JSRuntime.toStringTypeError(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String safeToString(Object value) {
        return JSRuntime.toDisplayStringImpl(value, 3, null, false, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toDisplayString(Object value, boolean allowSideEffects) {
        return JSRuntime.toDisplayStringImpl(value, 3, null, false, allowSideEffects);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toDisplayString(Object value, int currentDepth, Object parent, boolean allowSideEffects) {
        return JSRuntime.toDisplayStringImpl(value, currentDepth - 1, parent, true, allowSideEffects);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toDisplayString(Object value, int currentDepth, Object parent, boolean quoteString, boolean allowSideEffects) {
        return JSRuntime.toDisplayStringImpl(value, currentDepth - 1, parent, quoteString, allowSideEffects);
    }

    private static String toDisplayStringImpl(Object value, int depth, Object parent, boolean quoteString, boolean allowSideEffects) {
        CompilerAsserts.neverPartOfCompilation();
        if (value == parent) {
            return "(this)";
        }
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value == Null.instance) {
            return "null";
        }
        if (value instanceof Boolean) {
            return JSRuntime.booleanToString((Boolean)value);
        }
        if (JSRuntime.isString(value)) {
            String string = value.toString();
            return quoteString ? JSRuntime.quote(string) : string;
        }
        if (JSDynamicObject.isJSDynamicObject(value)) {
            return JSObject.toDisplayString((DynamicObject)value, depth, allowSideEffects);
        }
        if (value instanceof Symbol) {
            return value.toString();
        }
        if (value instanceof BigInt) {
            return value.toString() + 'n';
        }
        if (JSRuntime.isNumber(value)) {
            Number number = (Number)value;
            if (JSRuntime.isNegativeZero(number.doubleValue())) {
                return "-0";
            }
            return JSRuntime.numberToString(number);
        }
        if (value instanceof InteropFunction) {
            return JSRuntime.toDisplayStringImpl(((InteropFunction)value).getFunction(), depth, parent, quoteString, allowSideEffects);
        }
        if (value instanceof TruffleObject) {
            assert (!JSRuntime.isJSNative(value)) : value;
            return JSRuntime.foreignToString(value, depth, allowSideEffects);
        }
        return String.valueOf(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String objectToConsoleString(DynamicObject obj, String name, int depth, boolean allowSideEffects) {
        return JSRuntime.objectToConsoleString(obj, name, depth, null, null, allowSideEffects);
    }

    @CompilerDirectives.TruffleBoundary
    public static String objectToConsoleString(DynamicObject obj, String name, int depth, String[] internalKeys, Object[] internalValues, boolean allowSideEffects) {
        assert (JSDynamicObject.isJSDynamicObject(obj) && !JSFunction.isJSFunction(obj) && !JSProxy.isJSProxy(obj));
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name);
        }
        boolean isArrayLike = false;
        boolean isArray = false;
        long length = -1L;
        if (JSArray.isJSArray(obj)) {
            isArrayLike = true;
            isArray = true;
            length = JSArray.arrayGetLength(obj);
        } else if (JSArrayBufferView.isJSArrayBufferView(obj)) {
            isArrayLike = true;
            length = JSArrayBufferView.typedArrayGetLength(obj);
        } else if (JSString.isJSString(obj)) {
            length = JSString.getStringLength(obj);
        }
        boolean isStringObj = JSString.isJSString(obj);
        long prevArrayIndex = -1L;
        if (isArrayLike) {
            if (length > 0L) {
                boolean topLevel;
                boolean bl = topLevel = depth == 3;
                if (depth <= 0 || !topLevel && length > 20L) {
                    if (name == null) {
                        sb.append("Array");
                    }
                    sb.append('(').append(length).append(')');
                    return sb.toString();
                }
                if (topLevel && length >= 2L) {
                    sb.append('(').append(length).append(')');
                }
            }
        } else if (depth <= 0) {
            sb.append("{...}");
            return sb.toString();
        }
        sb.append(isArrayLike ? (char)'[' : '{');
        int propertyCount = 0;
        for (Object key : JSObject.ownPropertyKeys(obj)) {
            PropertyDescriptor desc = JSObject.getOwnProperty(obj, key);
            if ((isArrayLike || isStringObj) && key.equals("length") || isStringObj && JSRuntime.isArrayIndex(key) && JSRuntime.parseArrayIndexRaw(key.toString()) < length) continue;
            if (propertyCount > 0) {
                sb.append(", ");
                if (propertyCount >= 20) {
                    sb.append("...");
                    break;
                }
            }
            if (isArray) {
                if (JSRuntime.isArrayIndex(key)) {
                    long index = JSRuntime.parseArrayIndexRaw(key.toString());
                    if (index < length && JSRuntime.fillEmptyArrayElements(sb, index, prevArrayIndex, false)) {
                        sb.append(", ");
                        if (++propertyCount >= 20) {
                            sb.append("...");
                            break;
                        }
                    }
                    prevArrayIndex = index;
                } else {
                    if (JSRuntime.fillEmptyArrayElements(sb, length, prevArrayIndex, false)) {
                        sb.append(", ");
                        if (++propertyCount >= 20) {
                            sb.append("...");
                            break;
                        }
                    }
                    prevArrayIndex = Math.max(prevArrayIndex, length);
                }
            }
            if (!isArrayLike || !JSRuntime.isArrayIndex(key)) {
                sb.append(key);
                sb.append(": ");
            }
            String valueStr = null;
            if (desc.isDataDescriptor()) {
                Object value = desc.getValue();
                valueStr = JSRuntime.toDisplayString(value, depth, obj, allowSideEffects);
            } else {
                valueStr = desc.isAccessorDescriptor() ? "accessor" : "empty";
            }
            sb.append(valueStr);
            ++propertyCount;
        }
        if (isArray && propertyCount < 20 && JSRuntime.fillEmptyArrayElements(sb, length, prevArrayIndex, propertyCount > 0)) {
            ++propertyCount;
        }
        if (internalKeys != null) {
            assert (internalValues != null && internalKeys.length == internalValues.length);
            for (int i = 0; i < internalKeys.length; ++i) {
                if (propertyCount > 0) {
                    sb.append(", ");
                }
                sb.append("[[").append(internalKeys[i]).append("]]: ").append(JSRuntime.toDisplayString(internalValues[i], depth, obj, allowSideEffects));
                ++propertyCount;
            }
        }
        sb.append(isArrayLike ? (char)']' : '}');
        return sb.toString();
    }

    private static String foreignToString(Object value, int depth, boolean allowSideEffects) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            InteropLibrary interop = InteropLibrary.getFactory().getUncached(value);
            if (interop.isNull(value)) {
                return "null";
            }
            if (interop.hasArrayElements(value)) {
                return JSRuntime.foreignArrayToString(value, depth, allowSideEffects);
            }
            if (interop.isString(value)) {
                return interop.asString(value);
            }
            if (interop.isBoolean(value)) {
                return JSRuntime.booleanToString(interop.asBoolean(value));
            }
            if (interop.isNumber(value)) {
                Object unboxed = "Number";
                if (interop.fitsInInt(value)) {
                    unboxed = interop.asInt(value);
                } else if (interop.fitsInLong(value)) {
                    unboxed = interop.asLong(value);
                } else if (interop.fitsInDouble(value)) {
                    unboxed = interop.asDouble(value);
                }
                return JSRuntime.toDisplayString(unboxed, 0, null, allowSideEffects);
            }
            TruffleLanguage.Env env = JavaScriptLanguage.getCurrentEnv();
            if (env.isHostObject(value)) {
                Object hostObject = env.asHostObject(value);
                Class clazz = hostObject.getClass();
                if (clazz == Class.class) {
                    clazz = (Class)hostObject;
                    return "JavaClass[" + clazz.getTypeName() + "]";
                }
                return "JavaObject[" + clazz.getTypeName() + "]";
            }
            if (interop.isMetaObject(value)) {
                return InteropLibrary.getFactory().getUncached().asString(interop.getMetaQualifiedName(value));
            }
            if (interop.hasMembers(value) && !interop.isExecutable(value) && !interop.isInstantiable(value)) {
                return JSRuntime.foreignObjectToString(value, depth, allowSideEffects);
            }
            return InteropLibrary.getFactory().getUncached().asString(interop.toDisplayString(value, allowSideEffects));
        }
        catch (InteropException e) {
            return "Object";
        }
    }

    private static String foreignArrayToString(Object truffleObject, int depth, boolean allowSideEffects) throws InteropException {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(truffleObject);
        assert (interop.hasArrayElements(truffleObject));
        long size = interop.getArraySize(truffleObject);
        if (size == 0L) {
            return "[]";
        }
        if (depth <= 0) {
            return "Array(" + size + ")";
        }
        boolean topLevel = depth == 3;
        StringBuilder sb = new StringBuilder();
        if (topLevel && size >= 2L) {
            sb.append('(').append(size).append(')');
        }
        sb.append('[');
        for (long i = 0L; i < size; ++i) {
            if (i > 0L) {
                sb.append(", ");
                if (i >= 20L) {
                    sb.append("...");
                    break;
                }
            }
            Object value = interop.readArrayElement(truffleObject, i);
            sb.append(JSRuntime.toDisplayString(value, depth, truffleObject, allowSideEffects));
        }
        sb.append(']');
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String javaArrayToString(Object array) {
        return JSRuntime.javaArrayToString(array, 3, true);
    }

    private static String javaArrayToString(Object javaArray, int depth, boolean allowSideEffects) {
        CompilerAsserts.neverPartOfCompilation();
        if (javaArray == null) {
            return "null";
        }
        if (depth <= 0) {
            return "[...]";
        }
        int size = Array.getLength(javaArray) - 1;
        if (size == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            Object arrayValue;
            if (JSGuards.isJavaArray(arrayValue = Array.get(javaArray, i))) {
                b.append(JSRuntime.javaArrayToString(arrayValue, depth - 1, allowSideEffects));
            } else {
                b.append(JSRuntime.toDisplayString(arrayValue, depth, javaArray, allowSideEffects));
            }
            if (i == size) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String foreignObjectToString(Object truffleObject, int depth, boolean allowSideEffects) throws InteropException {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary objInterop = InteropLibrary.getFactory().getUncached(truffleObject);
        assert (objInterop.hasMembers(truffleObject));
        if (allowSideEffects && objInterop.isMemberInvocable(truffleObject, TO_STRING)) {
            return objInterop.invokeMember(truffleObject, TO_STRING, new Object[0]).toString();
        }
        Object keys = objInterop.getMembers(truffleObject);
        InteropLibrary keysInterop = InteropLibrary.getFactory().getUncached(keys);
        long keyCount = keysInterop.getArraySize(keys);
        if (keyCount == 0L) {
            return "{}";
        }
        if (depth <= 0) {
            return "{...}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (long i = 0L; i < keyCount; ++i) {
            if (i > 0L) {
                sb.append(", ");
                if (i >= 20L) {
                    sb.append("...");
                    break;
                }
            }
            Object key = keysInterop.readArrayElement(keys, i);
            assert (InteropLibrary.getFactory().getUncached().isString(key));
            String stringKey = key instanceof String ? (String)key : InteropLibrary.getFactory().getUncached().asString(key);
            Object value = objInterop.readMember(truffleObject, stringKey);
            sb.append(stringKey);
            sb.append(": ");
            sb.append(JSRuntime.toDisplayString(value, depth, truffleObject, allowSideEffects));
        }
        sb.append('}');
        return sb.toString();
    }

    private static boolean fillEmptyArrayElements(StringBuilder sb, long index, long prevArrayIndex, boolean prependComma) {
        if (prevArrayIndex < index - 1L) {
            long count;
            if (prependComma) {
                sb.append(", ");
            }
            if ((count = index - prevArrayIndex - 1L) == 1L) {
                sb.append("empty");
            } else {
                sb.append("empty \u00d7 ");
                sb.append(count);
            }
            return true;
        }
        return false;
    }

    public static String collectionToConsoleString(DynamicObject obj, String name, JSHashMap map, int depth, boolean allowSideEffects) {
        assert (JSMap.isJSMap(obj) || JSSet.isJSSet(obj));
        assert (name != null);
        int size = map.size();
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('(').append(size).append(')');
        if (size > 0 && depth > 0) {
            sb.append('{');
            boolean isMap = JSMap.isJSMap(obj);
            boolean isFirst = true;
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object key = cursor.getKey();
                if (key == null) continue;
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(JSRuntime.toDisplayString(key, depth, obj, allowSideEffects));
                if (isMap) {
                    sb.append(" => ");
                    sb.append(JSRuntime.toDisplayString(cursor.getValue(), depth, obj, allowSideEffects));
                }
                isFirst = false;
            }
            sb.append('}');
        }
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static JSException toStringTypeError(Object value) {
        String what = value == null ? "null" : (JSDynamicObject.isJSDynamicObject(value) ? JSObject.defaultToString((DynamicObject)value) : value.getClass().getName());
        throw Errors.createTypeErrorCannotConvertToString(what);
    }

    public static String booleanToString(boolean value) {
        return value ? "true" : "false";
    }

    public static String toString(DynamicObject value) {
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value == Null.instance) {
            return "null";
        }
        return JSRuntime.toString(JSObject.toPrimitive(value, HINT_STRING));
    }

    public static String numberToString(Number number) {
        if (number instanceof Integer) {
            return Boundaries.stringValueOf((Integer)number);
        }
        if (number instanceof SafeInteger) {
            return JSRuntime.doubleToString(((SafeInteger)number).doubleValue());
        }
        if (number instanceof Double) {
            return JSRuntime.doubleToString((Double)number);
        }
        if (number instanceof Long) {
            return Boundaries.stringValueOf(number.longValue());
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("unknown number value: " + number.toString() + " " + number.getClass().getSimpleName());
    }

    public static int length(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).length();
        }
        if (cs instanceof JSLazyString) {
            return ((JSLazyString)cs).length();
        }
        return JSRuntime.lengthIntl(cs);
    }

    public static int length(CharSequence cs, ConditionProfile stringProfile, ConditionProfile lazyStringProfile) {
        if (stringProfile.profile(cs instanceof String)) {
            return ((String)cs).length();
        }
        if (lazyStringProfile.profile(cs instanceof JSLazyString)) {
            return ((JSLazyString)cs).length();
        }
        return JSRuntime.lengthIntl(cs);
    }

    @CompilerDirectives.TruffleBoundary
    private static int lengthIntl(CharSequence cs) {
        return cs.length();
    }

    public static char charAt(CharSequence cs, int index) {
        if (cs instanceof String) {
            return ((String)cs).charAt(index);
        }
        if (cs instanceof JSLazyString) {
            return ((JSLazyString)cs).charAt(index);
        }
        return JSRuntime.charAtIntl(cs, index);
    }

    @CompilerDirectives.TruffleBoundary
    private static char charAtIntl(CharSequence cs, int index) {
        return cs.charAt(index);
    }

    public static String javaToString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof JSLazyString) {
            return ((JSLazyString)obj).toString();
        }
        return Boundaries.javaToString(obj);
    }

    public static boolean propertyKeyEquals(Object a, Object b) {
        assert (JSRuntime.isPropertyKey(a));
        if (a instanceof String) {
            if (b instanceof String) {
                return ((String)a).equals(b);
            }
            if (b instanceof JSLazyString) {
                return ((String)a).equals(((JSLazyString)b).toString());
            }
            return false;
        }
        if (a instanceof Symbol) {
            return ((Symbol)a).equals(b);
        }
        throw Errors.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public static String doubleToString(double d, int radix) {
        assert (radix >= 2 && radix <= 36);
        if (Double.isNaN(d)) {
            return NAN_STRING;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return INFINITY_STRING;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_STRING;
        }
        if (d == 0.0) {
            return "0";
        }
        return JSRuntime.formatDtoA(d, radix);
    }

    public static String doubleToString(double d) {
        if (Double.isNaN(d)) {
            return NAN_STRING;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return INFINITY_STRING;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_STRING;
        }
        if (d == 0.0) {
            return "0";
        }
        if (JSRuntime.doubleIsRepresentableAsInt(d)) {
            return Boundaries.stringValueOf((int)d);
        }
        return JSRuntime.formatDtoA(d);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoA(double value) {
        return DoubleConversion.toShortest(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoAPrecision(double value, int precision) {
        return DoubleConversion.toPrecision(value, precision);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoAExponential(double d, int digits) {
        return DoubleConversion.toExponential(d, digits);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoAExponential(double d) {
        return DoubleConversion.toExponential(d, -1);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoAFixed(double value, int digits) {
        return DoubleConversion.toFixed(value, digits);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatDtoA(double d, int radix) {
        return DToA.jsDtobasestr(radix, d);
    }

    public static TruffleObject toObject(JSContext ctx, Object value) {
        JSRuntime.requireObjectCoercible(value, ctx);
        if (CompilerDirectives.injectBranchProbability(0.75, JSDynamicObject.isJSDynamicObject(value))) {
            return (DynamicObject)value;
        }
        Object unboxedValue = value;
        if (JSRuntime.isForeignObject(value)) {
            InteropLibrary interop = InteropLibrary.getUncached(value);
            assert (!interop.isNull(value));
            unboxedValue = JSInteropUtil.toPrimitiveOrDefault(value, null, interop, null);
            if (unboxedValue == null) {
                return (TruffleObject)value;
            }
        }
        return JSRuntime.toObjectFromPrimitive(ctx, unboxedValue, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleObject toObjectFromPrimitive(JSContext ctx, Object value, boolean useJavaWrapper) {
        if (value instanceof Boolean) {
            return JSBoolean.create(ctx, (Boolean)value);
        }
        if (value instanceof String) {
            return JSString.create(ctx, (String)value);
        }
        if (value instanceof JSLazyString) {
            return JSString.create(ctx, (JSLazyString)value);
        }
        if (value instanceof BigInt) {
            return JSBigInt.create(ctx, (BigInt)value);
        }
        if (JSRuntime.isNumber(value)) {
            return JSNumber.create(ctx, (Number)value);
        }
        if (value instanceof Symbol) {
            return JSSymbol.create(ctx, (Symbol)value);
        }
        assert (!JSRuntime.isJSNative(value) && JSRuntime.isJavaPrimitive(value)) : value;
        if (useJavaWrapper) {
            return (TruffleObject)ctx.getRealm().getEnv().asBoxedGuestValue(value);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isSameValue(Object x, Object y) {
        if (x == Undefined.instance && y == Undefined.instance) {
            return true;
        }
        if (x == Null.instance && y == Null.instance) {
            return true;
        }
        if (x instanceof Integer && y instanceof Integer) {
            return ((Integer)x).intValue() == ((Integer)y).intValue();
        }
        if (JSRuntime.isNumber(x) && JSRuntime.isNumber(y)) {
            double yd;
            double xd = JSRuntime.doubleValue((Number)x);
            return Double.compare(xd, yd = JSRuntime.doubleValue((Number)y)) == 0;
        }
        if (JSRuntime.isString(x) && JSRuntime.isString(y)) {
            return x.toString().equals(y.toString());
        }
        if (x instanceof Boolean && y instanceof Boolean) {
            return ((Boolean)x).booleanValue() == ((Boolean)y).booleanValue();
        }
        if (JSRuntime.isBigInt(x) && JSRuntime.isBigInt(y)) {
            return ((BigInt)x).compareTo((BigInt)y) == 0;
        }
        return x == y;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == Undefined.instance || a == Null.instance) {
            return JSRuntime.isNullish(b);
        }
        if (b == Undefined.instance || b == Null.instance) {
            return JSRuntime.isNullish(a);
        }
        if (a instanceof Boolean && b instanceof Boolean) {
            return a.equals(b);
        }
        if (JSRuntime.isString(a) && JSRuntime.isString(b)) {
            return a.toString().equals(b.toString());
        }
        if (JSRuntime.isJavaNumber(a) && JSRuntime.isJavaNumber(b)) {
            double db;
            double da = JSRuntime.doubleValue((Number)a);
            return da == (db = JSRuntime.doubleValue((Number)b));
        }
        if (JSDynamicObject.isJSDynamicObject(a) && JSDynamicObject.isJSDynamicObject(b)) {
            return a == b;
        }
        if (JSRuntime.isJavaNumber(a) && JSRuntime.isString(b)) {
            return JSRuntime.equal(a, JSRuntime.stringToNumber(b.toString()));
        }
        if (JSRuntime.isString(a) && JSRuntime.isJavaNumber(b)) {
            return JSRuntime.equal(JSRuntime.stringToNumber(a.toString()), b);
        }
        if (JSRuntime.isBigInt(a) && JSRuntime.isBigInt(b)) {
            return a.equals(b);
        }
        if (JSRuntime.isBigInt(a) && JSRuntime.isString(b)) {
            return a.equals(JSRuntime.stringToBigInt(b.toString()));
        }
        if (JSRuntime.isString(a) && JSRuntime.isBigInt(b)) {
            return b.equals(JSRuntime.stringToBigInt(a.toString()));
        }
        if (JSRuntime.isJavaNumber(a) && JSRuntime.isBigInt(b)) {
            return JSRuntime.equalBigIntAndNumber((BigInt)b, (Number)a);
        }
        if (JSRuntime.isBigInt(a) && JSRuntime.isJavaNumber(b)) {
            return JSRuntime.equalBigIntAndNumber((BigInt)a, (Number)b);
        }
        if (a instanceof Boolean) {
            return JSRuntime.equal(JSRuntime.booleanToNumber((Boolean)a), b);
        }
        if (b instanceof Boolean) {
            return JSRuntime.equal(a, JSRuntime.booleanToNumber((Boolean)b));
        }
        if (JSRuntime.isObject(a)) {
            assert (b != Undefined.instance && b != Null.instance);
            return JSRuntime.equal(JSObject.toPrimitive((DynamicObject)a), b);
        }
        if (JSRuntime.isObject(b)) {
            assert (b != Undefined.instance && b != Null.instance);
            return JSRuntime.equal(a, JSObject.toPrimitive((DynamicObject)b));
        }
        if (JSRuntime.isForeignObject(a) || JSRuntime.isForeignObject(b)) {
            return JSRuntime.equalInterop(a, b);
        }
        return false;
    }

    public static boolean isForeignObject(Object value) {
        return value instanceof TruffleObject && JSRuntime.isForeignObject((TruffleObject)value);
    }

    public static boolean isForeignObject(TruffleObject value) {
        return !JSDynamicObject.isJSDynamicObject(value) && !(value instanceof Symbol) && !(value instanceof JSLazyString) && !(value instanceof SafeInteger) && !(value instanceof BigInt);
    }

    private static boolean equalInterop(Object a, Object b) {
        Object primRight;
        Object primLeft;
        assert (a != null && b != null);
        Object defaultValue = null;
        if (JSRuntime.isForeignObject(a)) {
            primLeft = JSInteropUtil.toPrimitiveOrDefault(a, defaultValue, InteropLibrary.getUncached(a), null);
        } else {
            Object object = primLeft = JSRuntime.isNullOrUndefined(a) ? Null.instance : a;
        }
        if (JSRuntime.isForeignObject(b)) {
            primRight = JSInteropUtil.toPrimitiveOrDefault(b, defaultValue, InteropLibrary.getUncached(b), null);
        } else {
            Object object = primRight = JSRuntime.isNullOrUndefined(b) ? Null.instance : b;
        }
        if (primLeft == Null.instance || primRight == Null.instance) {
            return primLeft == primRight;
        }
        if (primLeft == defaultValue || primRight == defaultValue) {
            if (primLeft == defaultValue && primRight == defaultValue) {
                return Boundaries.equals(a, b);
            }
            return false;
        }
        assert (!JSRuntime.isForeignObject(primLeft) && !JSRuntime.isForeignObject(primRight));
        return JSRuntime.equal(primLeft, primRight);
    }

    private static boolean equalBigIntAndNumber(BigInt a, Number b) {
        if (b instanceof Double || b instanceof Float) {
            double numberVal = JSRuntime.doubleValue(b);
            return !Double.isNaN(numberVal) && a.compareValueTo(numberVal) == 0;
        }
        return a.compareValueTo(JSRuntime.longValue(b)) == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean identical(Object a, Object b) {
        InteropLibrary bInterop;
        if (a == b) {
            if (a instanceof Double) {
                return !Double.isNaN((Double)a);
            }
            return true;
        }
        if (a == Undefined.instance || b == Undefined.instance) {
            return false;
        }
        if (a == Null.instance) {
            assert (b != Undefined.instance);
            return InteropLibrary.getUncached(b).isNull(b);
        }
        if (b == Null.instance) {
            assert (a != Undefined.instance);
            return InteropLibrary.getUncached(a).isNull(a);
        }
        if (JSRuntime.isBigInt(a) && JSRuntime.isBigInt(b)) {
            return a.equals(b);
        }
        if (JSRuntime.isJavaNumber(a) && JSRuntime.isJavaNumber(b)) {
            if (a instanceof Integer && b instanceof Integer) {
                return ((Integer)a).intValue() == ((Integer)b).intValue();
            }
            return JSRuntime.doubleValue((Number)a) == JSRuntime.doubleValue((Number)b);
        }
        if (a instanceof Boolean && b instanceof Boolean) {
            return a.equals(b);
        }
        if (JSRuntime.isString(a) && JSRuntime.isString(b)) {
            return a.toString().equals(b.toString());
        }
        if (JSRuntime.isObject(a) || JSRuntime.isObject(b)) {
            return false;
        }
        InteropLibrary aInterop = InteropLibrary.getUncached(a);
        return aInterop.isIdentical(a, b, bInterop = InteropLibrary.getUncached(b)) || aInterop.isNull(a) && bInterop.isNull(b);
    }

    public static <T> T requireObjectCoercible(T argument, JSContext context) {
        if (argument == Undefined.instance || argument == Null.instance || JSRuntime.isForeignObject(argument) && InteropLibrary.getUncached(argument).isNull(argument)) {
            throw Errors.createTypeErrorNotObjectCoercible(argument, null, context);
        }
        return argument;
    }

    @CompilerDirectives.TruffleBoundary
    public static PropertyDescriptor toPropertyDescriptor(Object property) {
        boolean hasSet;
        boolean hasGet;
        boolean hasWritable;
        boolean hasValue;
        if (!JSRuntime.isObject(property)) {
            throw Errors.createTypeErrorNotAnObject(property);
        }
        DynamicObject obj = (DynamicObject)property;
        PropertyDescriptor desc = PropertyDescriptor.createEmpty();
        if (JSObject.hasProperty(obj, "enumerable")) {
            desc.setEnumerable(JSRuntime.toBoolean(JSObject.get(obj, (Object)"enumerable")));
        }
        if (JSObject.hasProperty(obj, "configurable")) {
            desc.setConfigurable(JSRuntime.toBoolean(JSObject.get(obj, (Object)"configurable")));
        }
        if (hasValue = JSObject.hasProperty(obj, VALUE)) {
            desc.setValue(JSObject.get(obj, (Object)VALUE));
        }
        if (hasWritable = JSObject.hasProperty(obj, "writable")) {
            desc.setWritable(JSRuntime.toBoolean(JSObject.get(obj, (Object)"writable")));
        }
        if (hasGet = JSObject.hasProperty(obj, "get")) {
            Object getter = JSObject.get(obj, (Object)"get");
            if (!JSRuntime.isCallable(getter) && getter != Undefined.instance) {
                throw Errors.createTypeError("Getter must be a function");
            }
            desc.setGet((DynamicObject)getter);
        }
        if (hasSet = JSObject.hasProperty(obj, "set")) {
            Object setter = JSObject.get(obj, (Object)"set");
            if (!JSRuntime.isCallable(setter) && setter != Undefined.instance) {
                throw Errors.createTypeError("Setter must be a function");
            }
            desc.setSet((DynamicObject)setter);
        }
        if ((hasGet || hasSet) && (hasValue || hasWritable)) {
            throw Errors.createTypeError("Invalid property. A property cannot both have accessors and be writable or have a value");
        }
        return desc;
    }

    public static int valueInRadix10(char c) {
        if (JSRuntime.isAsciiDigit(c)) {
            return c - 48;
        }
        return -1;
    }

    public static int valueInRadix(char c, int radix) {
        int val = JSRuntime.valueInRadixIntl(c);
        return val < radix ? val : -1;
    }

    private static int valueInRadixIntl(char c) {
        if (JSRuntime.isAsciiDigit(c)) {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'Z') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static int valueInHex(char c) {
        if (JSRuntime.isAsciiDigit(c)) {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static boolean isHex(char c) {
        return JSRuntime.isAsciiDigit(c) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseArrayIndexRaw(String string) {
        int pos;
        long value = 0L;
        int len = string.length();
        if (len > 1 && string.charAt(pos) == '0') {
            return -1L;
        }
        for (pos = 0; pos < len; ++pos) {
            char c = string.charAt(pos);
            if (!JSRuntime.isAsciiDigit(c)) {
                return -1L;
            }
            value *= 10L;
            value += (long)(c - 48);
        }
        return value;
    }

    public static String trimJSWhiteSpace(String string) {
        return JSRuntime.trimJSWhiteSpace(string, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static String trimJSWhiteSpace(String string, boolean useLineTerminators) {
        int firstIdx = JSRuntime.firstNonWhitespaceIndex(string, useLineTerminators);
        int lastIdx = JSRuntime.lastNonWhitespaceIndex(string, useLineTerminators);
        if (firstIdx == 0) {
            if (lastIdx + 1 == string.length()) {
                return string;
            }
        } else if (firstIdx > lastIdx) {
            return "";
        }
        return string.substring(firstIdx, lastIdx + 1);
    }

    public static int firstNonWhitespaceIndex(String string, boolean useLineTerminators) {
        int idx;
        for (idx = 0; idx < string.length() && (JSRuntime.isWhiteSpace(string.charAt(idx)) || useLineTerminators && JSRuntime.isLineTerminator(string.charAt(idx))); ++idx) {
        }
        return idx;
    }

    public static int lastNonWhitespaceIndex(String string, boolean useLineTerminators) {
        int idx;
        for (idx = string.length() - 1; idx >= 0 && (JSRuntime.isWhiteSpace(string.charAt(idx)) || useLineTerminators && JSRuntime.isLineTerminator(string.charAt(idx))); --idx) {
        }
        return idx;
    }

    public static boolean isWhiteSpace(char cp) {
        if (JSRuntime.isAsciiDigit(cp)) {
            return false;
        }
        return '\t' <= cp && cp <= '\r' || '\u2000' <= cp && cp <= '\u200a' || cp == ' ' || cp == '\u00a0' || cp == '\u1680' || cp == '\u2028' || cp == '\u2029' || cp == '\u202f' || cp == '\u205f' || cp == '\u3000' || cp == '\ufeff';
    }

    private static boolean isLineTerminator(char codePoint) {
        switch (codePoint) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidArrayLength(long longValue) {
        return 0L <= longValue && longValue <= 0xFFFFFFFFL;
    }

    public static boolean isValidArrayLength(double doubleValue) {
        long longValue = (long)doubleValue;
        return doubleValue == (double)longValue && JSRuntime.isValidArrayLength(longValue);
    }

    public static boolean isValidArrayLength(int intValue) {
        return intValue >= 0;
    }

    public static boolean isIntegerIndex(long longValue) {
        return 0L <= longValue && longValue <= MAX_SAFE_INTEGER_LONG;
    }

    public static boolean isArrayIndex(int intValue) {
        return intValue >= 0;
    }

    public static boolean isArrayIndex(long longValue) {
        return 0L <= longValue && longValue < 0xFFFFFFFFL;
    }

    public static boolean isArrayIndex(double doubleValue) {
        long longValue = (long)doubleValue;
        return (double)longValue == doubleValue && JSRuntime.isArrayIndex(longValue);
    }

    public static boolean isArrayIndex(String property) {
        long idx = JSRuntime.propertyNameToArrayIndex(property);
        return JSRuntime.isArrayIndex(idx);
    }

    public static boolean isArrayIndex(Object property) {
        if (property instanceof Integer) {
            return JSRuntime.isArrayIndex((Integer)property);
        }
        if (property instanceof Long) {
            return JSRuntime.isArrayIndex((Long)property);
        }
        if (property instanceof Double) {
            return JSRuntime.isArrayIndex((Double)property);
        }
        if (JSRuntime.isString(property)) {
            long idx = JSRuntime.propertyNameToArrayIndex(JSRuntime.toStringIsString(property));
            return JSRuntime.isArrayIndex(idx);
        }
        return false;
    }

    public static long castArrayIndex(double doubleValue) {
        assert (JSRuntime.isArrayIndex(doubleValue));
        return (long)doubleValue & 0xFFFFFFFFL;
    }

    public static long castArrayIndex(long longValue) {
        assert (JSRuntime.isArrayIndex(longValue));
        return longValue;
    }

    public static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    @CompilerDirectives.TruffleBoundary
    public static long propertyNameToArrayIndex(String propertyName) {
        if (propertyName != null && JSRuntime.arrayIndexLengthInRange(propertyName) && JSRuntime.isAsciiDigit(propertyName.charAt(0))) {
            return JSRuntime.parseArrayIndexRaw(propertyName);
        }
        return -1L;
    }

    public static boolean arrayIndexLengthInRange(String index) {
        int len = index.length();
        return 0 < len && len <= 10;
    }

    public static long propertyKeyToArrayIndex(Object propertyKey) {
        return propertyKey instanceof String ? JSRuntime.propertyNameToArrayIndex((String)propertyKey) : -1L;
    }

    @CompilerDirectives.TruffleBoundary
    public static long propertyNameToIntegerIndex(String propertyName) {
        if (propertyName != null && propertyName.length() > 0 && propertyName.length() <= 16 && JSRuntime.isAsciiDigit(propertyName.charAt(0))) {
            return JSRuntime.parseArrayIndexRaw(propertyName);
        }
        return -1L;
    }

    public static long propertyKeyToIntegerIndex(Object propertyKey) {
        return propertyKey instanceof String ? JSRuntime.propertyNameToIntegerIndex((String)propertyKey) : -1L;
    }

    public static boolean isJSNative(Object value) {
        return JSDynamicObject.isJSDynamicObject(value) || JSRuntime.isJSPrimitive(value);
    }

    public static boolean isJSPrimitive(Object value) {
        return JSRuntime.isNumber(value) || value instanceof BigInt || value instanceof Boolean || JSRuntime.isString(value) || value == Undefined.instance || value == Null.instance || value instanceof Symbol;
    }

    public static boolean isString(Object value) {
        return value instanceof String || JSRuntime.isLazyString(value);
    }

    public static String toStringIsString(Object value) {
        assert (JSRuntime.isString(value));
        if (value instanceof String) {
            return (String)value;
        }
        assert (JSRuntime.isLazyString(value));
        return ((JSLazyString)value).toString();
    }

    public static boolean isLazyString(Object value) {
        return value instanceof JSLazyString;
    }

    public static boolean isStringClass(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz) || JSLazyString.class.isAssignableFrom(clazz);
    }

    public static Object nullToUndefined(Object value) {
        return value == null ? Undefined.instance : value;
    }

    public static Object undefinedToNull(Object value) {
        return value == Undefined.instance ? null : value;
    }

    public static Object toJSNull(Object value) {
        return value == null ? Null.instance : value;
    }

    public static Object toJavaNull(Object value) {
        return value == Null.instance ? null : value;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object jsObjectToJavaObject(Object obj) {
        if (JSRuntime.isLazyString(obj)) {
            return obj.toString();
        }
        return JSRuntime.toJavaNull(JSRuntime.undefinedToNull(obj));
    }

    public static boolean isPropertyKey(Object key) {
        return key instanceof String || key instanceof Symbol;
    }

    public static Object boxIndex(long longIndex, ConditionProfile indexInIntRangeConditionProfile) {
        if (indexInIntRangeConditionProfile.profile(longIndex <= Integer.MAX_VALUE)) {
            return (int)longIndex;
        }
        return (double)longIndex;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt stringToBigInt(String s2) {
        try {
            return BigInt.valueOf(s2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int intValue(Number number) {
        if (number instanceof Integer) {
            return (Integer)number;
        }
        if (number instanceof Double) {
            return ((Double)number).intValue();
        }
        return JSRuntime.intValueVirtual(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static int intValueVirtual(Number number) {
        return number.intValue();
    }

    public static double doubleValue(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        if (number instanceof Integer) {
            return ((Integer)number).doubleValue();
        }
        return JSRuntime.doubleValueVirtual(number);
    }

    public static double doubleValue(Number number, BranchProfile profile) {
        if (number instanceof Double) {
            return (Double)number;
        }
        if (number instanceof Integer) {
            return ((Integer)number).doubleValue();
        }
        profile.enter();
        return JSRuntime.doubleValueVirtual(number);
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValueVirtual(Number number) {
        return number.doubleValue();
    }

    public static float floatValue(Number n) {
        if (n instanceof Double) {
            return ((Double)n).floatValue();
        }
        if (n instanceof Integer) {
            return ((Integer)n).floatValue();
        }
        return JSRuntime.floatValueVirtual(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static float floatValueVirtual(Number n) {
        return n.floatValue();
    }

    public static long longValue(Number n) {
        if (n instanceof Integer) {
            return ((Integer)n).longValue();
        }
        if (n instanceof Double) {
            return ((Double)n).longValue();
        }
        if (n instanceof SafeInteger) {
            return ((SafeInteger)n).longValue();
        }
        return JSRuntime.longValueVirtual(n);
    }

    @CompilerDirectives.TruffleBoundary
    private static long longValueVirtual(Number n) {
        return n.longValue();
    }

    public static long toLong(Number value) {
        return JSRuntime.longValue(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String stringConcat(String first, String second) {
        StringBuilder stringBuilder = new StringBuilder(first.length() + second.length());
        stringBuilder.append(first).append(second);
        return stringBuilder.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject fromPropertyDescriptor(PropertyDescriptor desc, JSContext context) {
        if (desc == null) {
            return Undefined.instance;
        }
        DynamicObject obj = JSOrdinary.create(context);
        if (desc.hasValue()) {
            JSObject.set(obj, VALUE, desc.getValue());
        }
        if (desc.hasWritable()) {
            JSObject.set(obj, "writable", (Object)desc.getWritable());
        }
        if (desc.hasGet()) {
            JSObject.set(obj, "get", desc.getGet());
        }
        if (desc.hasSet()) {
            JSObject.set(obj, "set", desc.getSet());
        }
        if (desc.hasEnumerable()) {
            JSObject.set(obj, "enumerable", (Object)desc.getEnumerable());
        }
        if (desc.hasConfigurable()) {
            JSObject.set(obj, "configurable", (Object)desc.getConfigurable());
        }
        return obj;
    }

    public static Object getArgOrUndefined(Object[] args, int i) {
        return args.length > i ? args[i] : Undefined.instance;
    }

    public static Object getArg(Object[] args, int i, Object defaultValue) {
        return args.length > i ? args[i] : defaultValue;
    }

    public static long getOffset(long start, long length, ConditionProfile profile) {
        if (profile.profile(start < 0L)) {
            return Math.max(start + length, 0L);
        }
        return Math.min(start, length);
    }

    public static int getOffset(int start, int length, ConditionProfile profile) {
        if (profile.profile(start < 0)) {
            return Math.max(start + length, 0);
        }
        return Math.min(start, length);
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseSafeInteger(String s2) {
        return JSRuntime.parseSafeInteger(s2, 0, s2.length(), 10);
    }

    @CompilerDirectives.TruffleBoundary
    public static long parseSafeInteger(String s2, int beginIndex, int endIndex, int radix) {
        return JSRuntime.parseLong(s2, beginIndex, endIndex, radix, radix == 10, MAX_SAFE_INTEGER_LONG);
    }

    private static long parseLong(String s2, int beginIndex, int endIndex, int radix, boolean parseSign, long limit) {
        assert (beginIndex >= 0 && beginIndex <= endIndex && endIndex <= s2.length());
        assert (radix >= 2 && radix <= 36);
        assert (limit <= Long.MAX_VALUE / (long)radix - (long)radix);
        boolean negative = false;
        int i = beginIndex;
        if (i >= endIndex) {
            return Long.MIN_VALUE;
        }
        if (parseSign) {
            char firstChar = s2.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                } else if (firstChar != '+') {
                    return Long.MIN_VALUE;
                }
                ++i;
            }
            if (i >= endIndex) {
                return Long.MIN_VALUE;
            }
        }
        long result = 0L;
        while (i < endIndex) {
            char c = s2.charAt(i);
            int digit = JSRuntime.valueInRadix(c, radix);
            if (digit < 0) {
                return Long.MIN_VALUE;
            }
            result *= (long)radix;
            if ((result += (long)digit) > limit) {
                return Long.MIN_VALUE;
            }
            ++i;
        }
        assert (result >= 0L);
        if (negative && result == 0L) {
            return Long.MIN_VALUE;
        }
        return negative ? -result : result;
    }

    @CompilerDirectives.TruffleBoundary
    public static Number parseRawFitsLong(String string, int radix, int startPos, int endPos, boolean negate) {
        long signedValue;
        assert (startPos < endPos);
        long value = 0L;
        for (int pos = startPos; pos < endPos; ++pos) {
            char c = string.charAt(pos);
            int cval = JSRuntime.valueInRadix(c, radix);
            if (cval < 0) {
                if (pos != startPos) break;
                return Double.NaN;
            }
            value *= (long)radix;
            value += (long)cval;
        }
        if (value == 0L && negate && string.charAt(startPos) == '0') {
            return -0.0;
        }
        assert (value >= 0L);
        long l = signedValue = negate ? -value : value;
        if (value <= Integer.MAX_VALUE) {
            return (int)signedValue;
        }
        return (double)signedValue;
    }

    @CompilerDirectives.TruffleBoundary
    public static double parseRawDontFitLong(String string, int radix, int startPos, int endPos, boolean negate) {
        assert (startPos < endPos);
        double value = 0.0;
        for (int pos = startPos; pos < endPos; ++pos) {
            char c = string.charAt(pos);
            int cval = JSRuntime.valueInRadix(c, radix);
            if (cval < 0) {
                if (pos != startPos) break;
                return Double.NaN;
            }
            value *= (double)radix;
            value += (double)cval;
        }
        assert (value >= 0.0);
        return negate ? -value : value;
    }

    public static boolean createDataProperty(DynamicObject o, Object p, Object v) {
        assert (JSRuntime.isObject(o));
        assert (JSRuntime.isPropertyKey(p));
        return JSObject.defineOwnProperty(o, p, PropertyDescriptor.createDataDefault(v));
    }

    public static boolean createDataProperty(DynamicObject o, Object p, Object v, boolean doThrow) {
        assert (JSRuntime.isObject(o));
        assert (JSRuntime.isPropertyKey(p));
        boolean success = JSObject.defineOwnProperty(o, p, PropertyDescriptor.createDataDefault(v), doThrow);
        assert (!doThrow || success) : "should have thrown";
        return success;
    }

    public static boolean createDataPropertyOrThrow(DynamicObject o, Object p, Object v) {
        return JSRuntime.createDataProperty(o, p, v, true);
    }

    public static void definePropertyOrThrow(DynamicObject o, Object key, PropertyDescriptor desc) {
        assert (JSRuntime.isObject(o));
        assert (JSRuntime.isPropertyKey(key));
        boolean success = JSObject.getJSClass(o).defineOwnProperty(o, key, desc, true);
        assert (success);
    }

    public static boolean isPrototypeOf(DynamicObject object, DynamicObject prototype) {
        DynamicObject prototypeChainObject = object;
        do {
            if ((prototypeChainObject = JSObject.getPrototype(prototypeChainObject)) != prototype) continue;
            return true;
        } while (prototypeChainObject != Null.instance);
        return false;
    }

    public static DynamicObject createArrayFromList(JSContext context, List<? extends Object> list) {
        return JSArray.createConstant(context, Boundaries.listToArray(list));
    }

    public static boolean isCallable(Object value) {
        if (JSFunction.isJSFunction(value)) {
            return true;
        }
        if (JSProxy.isJSProxy(value)) {
            return JSRuntime.isCallableProxy((DynamicObject)value);
        }
        if (value instanceof TruffleObject) {
            return JSRuntime.isCallableForeign(value);
        }
        return false;
    }

    public static boolean isCallableIsJSObject(DynamicObject value) {
        assert (JSDynamicObject.isJSDynamicObject(value));
        if (JSFunction.isJSFunction(value)) {
            return true;
        }
        if (JSProxy.isJSProxy(value)) {
            return JSRuntime.isCallableProxy(value);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isCallableForeign(Object value) {
        if (JSRuntime.isForeignObject(value)) {
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            return interop.isExecutable(value) || interop.isInstantiable(value);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isCallableProxy(DynamicObject proxy) {
        assert (JSProxy.isJSProxy(proxy));
        Object target = JSProxy.getTarget(proxy);
        return target == Null.instance ? JSRuntime.isRevokedCallableProxy(proxy) : JSRuntime.isCallable(target);
    }

    public static boolean isRevokedCallableProxy(DynamicObject revokedProxy) {
        assert (JSProxy.isJSProxy(revokedProxy) && JSProxy.isRevoked(revokedProxy));
        return Boolean.TRUE == JSDynamicObject.getOrDefault(revokedProxy, JSProxy.REVOKED_CALLABLE, Boolean.FALSE);
    }

    public static boolean isArray(Object obj) {
        if (JSArray.isJSArray(obj)) {
            return true;
        }
        if (JSProxy.isJSProxy(obj)) {
            return JSRuntime.isProxyAnArray((DynamicObject)obj);
        }
        if (JSRuntime.isForeignObject(obj)) {
            return InteropLibrary.getFactory().getUncached().hasArrayElements(obj);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isProxyAnArray(DynamicObject proxy) {
        assert (JSProxy.isJSProxy(proxy));
        if (JSProxy.isRevoked(proxy)) {
            throw Errors.createTypeErrorProxyRevoked();
        }
        return JSRuntime.isArrayProxyRecurse(proxy);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isArrayProxyRecurse(DynamicObject proxy) {
        return JSRuntime.isArray(JSProxy.getTarget(proxy));
    }

    @CompilerDirectives.TruffleBoundary
    public static Object toPropertyKey(Object arg) {
        if (arg instanceof String) {
            return arg;
        }
        Object key = JSRuntime.toPrimitive(arg);
        if (key instanceof Symbol) {
            return key;
        }
        if (JSRuntime.isString(key)) {
            return key.toString();
        }
        return JSRuntime.toString(key);
    }

    public static Object call(Object fnObj, Object holder, Object[] arguments) {
        if (JSFunction.isJSFunction(fnObj)) {
            return JSFunction.call((DynamicObject)fnObj, holder, arguments);
        }
        if (JSProxy.isJSProxy(fnObj)) {
            return JSProxy.call((DynamicObject)fnObj, holder, arguments);
        }
        if (JSRuntime.isForeignObject(fnObj)) {
            return JSInteropUtil.call(fnObj, arguments);
        }
        throw Errors.createTypeErrorNotAFunction(fnObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(Object fnObj, Object holder, Object[] arguments, Node encapsulatingNode) {
        EncapsulatingNodeReference encapsulating = null;
        Node prev = null;
        if (encapsulatingNode != null) {
            encapsulating = EncapsulatingNodeReference.getCurrent();
            prev = encapsulating.set(encapsulatingNode);
        }
        try {
            Object object = JSRuntime.call(fnObj, holder, arguments);
            return object;
        }
        finally {
            if (encapsulatingNode != null) {
                encapsulating.set(prev);
            }
        }
    }

    public static Object construct(Object fnObj, Object[] arguments) {
        if (JSFunction.isJSFunction(fnObj)) {
            return JSFunction.construct((DynamicObject)fnObj, arguments);
        }
        if (JSProxy.isJSProxy(fnObj)) {
            return JSProxy.construct((DynamicObject)fnObj, arguments);
        }
        if (JSRuntime.isForeignObject(fnObj)) {
            return JSInteropUtil.construct(fnObj, arguments);
        }
        throw Errors.createTypeErrorNotAFunction(fnObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object canonicalNumericIndexString(String s2) {
        if (s2.isEmpty() || !JSRuntime.isNumericIndexStart(s2.charAt(0))) {
            return Undefined.instance;
        }
        if ("-0".equals(s2)) {
            return -0.0;
        }
        Number n = JSRuntime.stringToNumber(s2);
        if (!JSRuntime.numberToString(n).equals(s2)) {
            return Undefined.instance;
        }
        return n;
    }

    private static boolean isNumericIndexStart(char c) {
        return JSRuntime.isAsciiDigit(c) || c == '-' || c == 'I' || c == 'N';
    }

    public static boolean isInteger(Object obj) {
        if (!JSRuntime.isNumber(obj)) {
            return false;
        }
        double d = JSRuntime.doubleValue((Number)obj);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return false;
        }
        return Math.floor(Math.abs(d)) == Math.abs(d);
    }

    @CompilerDirectives.TruffleBoundary
    public static double mathFloor(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (JSRuntime.isNegativeZero(d)) {
            return -0.0;
        }
        if (JSRuntime.isSafeInteger(d)) {
            long i = (long)d;
            return d < (double)i ? (double)(i - 1L) : (double)i;
        }
        return Math.floor(d);
    }

    @CompilerDirectives.TruffleBoundary
    public static double mathCeil(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (JSRuntime.isNegativeZero(d)) {
            return -0.0;
        }
        if (JSRuntime.isSafeInteger(d)) {
            long result;
            long i = (long)d;
            long l = result = d > (double)i ? i + 1L : i;
            if (result == 0L && d < 0.0) {
                return -0.0;
            }
            return result;
        }
        return Math.ceil(d);
    }

    @CompilerDirectives.TruffleBoundary
    public static double mathRint(double d) {
        return Math.rint(d);
    }

    public static int comparePropertyKeys(Object key1, Object key2) {
        assert (JSRuntime.isPropertyKey(key1) && JSRuntime.isPropertyKey(key2));
        boolean isString1 = key1 instanceof String;
        boolean isString2 = key2 instanceof String;
        if (isString1 && isString2) {
            String str1 = (String)key1;
            String str2 = (String)key2;
            long index1 = JSRuntime.propertyNameToArrayIndex(str1);
            long index2 = JSRuntime.propertyNameToArrayIndex(str2);
            boolean isIndex1 = JSRuntime.isArrayIndex(index1);
            boolean isIndex2 = JSRuntime.isArrayIndex(index2);
            if (isIndex1 && isIndex2) {
                return Long.compare(index1, index2);
            }
            if (isIndex1) {
                return -1;
            }
            if (isIndex2) {
                return 1;
            }
            return 0;
        }
        if (isString1) {
            return -1;
        }
        if (isString2) {
            return 1;
        }
        return 0;
    }

    public static String getConstructorName(DynamicObject receiver) {
        Object constructor;
        DynamicObject prototype;
        Object toStringTag = JSRuntime.getDataProperty(receiver, Symbol.SYMBOL_TO_STRING_TAG);
        if (JSRuntime.isString(toStringTag)) {
            return JSRuntime.javaToString(toStringTag);
        }
        if (!JSRuntime.isProxy(receiver) && (prototype = JSObject.getPrototype(receiver)) != Null.instance && JSFunction.isJSFunction(constructor = JSRuntime.getDataProperty(prototype, "constructor"))) {
            return JSFunction.getName((DynamicObject)constructor);
        }
        return JSObject.getClassName(receiver);
    }

    public static Object getDataProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject current = thisObj;
        while (current != Null.instance && current != null && !JSRuntime.isProxy(current)) {
            PropertyDescriptor desc = JSObject.getOwnProperty(current, key);
            if (desc != null) {
                if (!desc.isDataDescriptor()) break;
                return desc.getValue();
            }
            current = JSObject.getPrototype(current);
        }
        return null;
    }

    private static boolean isProxy(DynamicObject receiver) {
        return JSProxy.isJSProxy(receiver) || JSAdapter.isJSAdapter(receiver);
    }

    public static boolean isJSRootNode(RootNode rootNode) {
        return rootNode instanceof JavaScriptRootNode;
    }

    public static boolean isJSFunctionRootNode(RootNode rootNode) {
        return rootNode instanceof JavaScriptRootNode && ((JavaScriptRootNode)rootNode).isFunction();
    }

    public static boolean isSafeInteger(double value) {
        return value >= MIN_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
    }

    public static boolean isSafeInteger(long value) {
        return value >= MIN_SAFE_INTEGER_LONG && value <= MAX_SAFE_INTEGER_LONG;
    }

    public static JSRealm getFunctionRealm(Object obj, JSContext context) {
        JSRealm currentRealm = context.getRealm();
        return JSRuntime.getFunctionRealm(obj, currentRealm);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSRealm getFunctionRealm(Object obj, JSRealm currentRealm) {
        if (JSDynamicObject.isJSDynamicObject(obj)) {
            DynamicObject dynObj = (DynamicObject)obj;
            if (JSFunction.isJSFunction(dynObj)) {
                if (JSFunction.isBoundFunction(dynObj)) {
                    return JSRuntime.getFunctionRealm((Object)JSFunction.getBoundTargetFunction(dynObj), currentRealm);
                }
                return JSFunction.getRealm(dynObj);
            }
            if (JSProxy.isJSProxy(dynObj)) {
                if (JSProxy.getHandler(dynObj) == Null.instance) {
                    throw Errors.createTypeErrorProxyRevoked();
                }
                return JSRuntime.getFunctionRealm(JSProxy.getTarget(dynObj), currentRealm);
            }
        }
        return currentRealm;
    }

    public static boolean isConstructor(Object constrObj) {
        if (JSFunction.isConstructor(constrObj)) {
            return true;
        }
        if (JSProxy.isJSProxy(constrObj)) {
            return JSRuntime.isConstructorProxy((DynamicObject)constrObj);
        }
        if (constrObj instanceof TruffleObject) {
            return JSRuntime.isConstructorForeign(constrObj);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isConstructorForeign(Object value) {
        if (JSRuntime.isForeignObject(value)) {
            return InteropLibrary.getFactory().getUncached().isInstantiable(value);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isConstructorProxy(DynamicObject constrObj) {
        assert (JSProxy.isJSProxy(constrObj));
        return JSRuntime.isConstructor(JSProxy.getTarget(constrObj));
    }

    public static boolean isGenerator(Object genObj) {
        if (JSFunction.isJSFunction(genObj) && JSFunction.isGenerator((DynamicObject)genObj)) {
            return true;
        }
        if (JSProxy.isJSProxy(genObj)) {
            return JSRuntime.isGeneratorProxy((DynamicObject)genObj);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isGeneratorProxy(DynamicObject genObj) {
        assert (JSProxy.isJSProxy(genObj));
        return JSRuntime.isGenerator(JSProxy.getTarget(genObj));
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> createListFromArrayLikeAllowSymbolString(Object obj) {
        if (!JSRuntime.isObject(obj)) {
            throw Errors.createTypeErrorNotAnObject(obj);
        }
        DynamicObject jsObj = (DynamicObject)obj;
        long len = JSRuntime.toLength(JSObject.get(jsObj, (Object)"length"));
        if (len > Integer.MAX_VALUE) {
            throw Errors.createRangeError("range exceeded");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (long index = 0L; index < len; ++index) {
            Object next = JSObject.get(jsObj, index);
            if (JSRuntime.isLazyString(next)) {
                next = next.toString();
            }
            if (!(next instanceof String) && !(next instanceof Symbol)) {
                throw Errors.createTypeError("Symbol or String expected");
            }
            Boundaries.listAdd(list, next);
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    public static String quote(String value) {
        char ch;
        int pos;
        for (pos = 0; pos < value.length() && (ch = value.charAt(pos)) >= ' ' && ch != '\\' && ch != '\"'; ++pos) {
        }
        StringBuilder builder = new StringBuilder(value.length() + 2);
        builder.append('\"');
        builder.append(value, 0, pos);
        for (int i = pos; i < value.length(); ++i) {
            char ch2 = value.charAt(i);
            if (ch2 < ' ') {
                if (ch2 == '\b') {
                    builder.append("\\b");
                    continue;
                }
                if (ch2 == '\f') {
                    builder.append("\\f");
                    continue;
                }
                if (ch2 == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (ch2 == '\r') {
                    builder.append("\\r");
                    continue;
                }
                if (ch2 == '\t') {
                    builder.append("\\t");
                    continue;
                }
                builder.append("\\u00");
                builder.append(Character.forDigit((ch2 & 0xF0) >> 4, 16));
                builder.append(Character.forDigit(ch2 & 0xF, 16));
                continue;
            }
            if (ch2 == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (ch2 == '\"') {
                builder.append("\\\"");
                continue;
            }
            builder.append(ch2);
        }
        builder.append('\"');
        return builder.toString();
    }

    public static DynamicObject expectJSObject(Object to, BranchProfile errorBranch) {
        if (!JSDynamicObject.isJSDynamicObject(to)) {
            errorBranch.enter();
            throw Errors.createTypeErrorJSObjectExpected();
        }
        return (DynamicObject)to;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object exportValue(Object value) {
        if (JSRuntime.isLazyString(value)) {
            return value.toString();
        }
        if (value instanceof SafeInteger) {
            return ((SafeInteger)value).doubleValue();
        }
        if (value instanceof TruffleObject) {
            return value;
        }
        if (JSRuntime.isJSPrimitive(value)) {
            return value;
        }
        TruffleLanguage.Env env = JavaScriptLanguage.getCurrentEnv();
        return env.asGuestValue(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object[] exportValueArray(Object[] arr) {
        Object[] newArr = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            newArr[i] = JSRuntime.exportValue(arr[i]);
        }
        return newArr;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object importValue(Object value) {
        if (value == null) {
            return Null.instance;
        }
        if (value instanceof Integer || value instanceof Double || value instanceof String || value instanceof Boolean || value instanceof TruffleObject) {
            return value;
        }
        if (value instanceof Character) {
            return String.valueOf(value);
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            if (JSRuntime.longIsRepresentableAsInt(longValue)) {
                return (int)longValue;
            }
            return longValue;
        }
        if (value instanceof Byte || value instanceof Short) {
            return ((Number)value).intValue();
        }
        if (value instanceof Float) {
            return ((Number)value).doubleValue();
        }
        throw Errors.createTypeErrorUnsupportedInteropType(value);
    }

    public static boolean intIsRepresentableAsFloat(int value) {
        return -16777216 <= value && value <= 0x1000000;
    }

    public static boolean isJavaPrimitive(Object value) {
        return value != null && value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character;
    }

    public static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static boolean isTypedArrayBigIntFactory(TypedArrayFactory factory) {
        return factory == TypedArrayFactory.BigInt64Array || factory == TypedArrayFactory.BigUint64Array;
    }

    public static GraalJSException getException(Object errorObject) {
        if (JSError.isJSError(errorObject)) {
            return JSError.getException((DynamicObject)errorObject);
        }
        return UserScriptException.create(errorObject);
    }
}

