/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.util.List;

public class LazyArray
extends AbstractConstantArray {
    private static final LazyArray LAZY_ARRAY = new LazyArray(0, LazyArray.createCache());

    protected LazyArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static LazyArray createLazyArray() {
        return LAZY_ARRAY;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new LazyArray(newIntegrityLevel, this.cache);
    }

    private static List<?> arrayGetLazyList(DynamicObject object) {
        return (List)JSAbstractArray.arrayGetArray(object);
    }

    @Override
    public Object getElementInBounds(DynamicObject object, int index) {
        return Boundaries.listGet(LazyArray.arrayGetLazyList(object), index);
    }

    public Object getElementInBounds(DynamicObject object, int index, ListGetNode listGetNode) {
        return listGetNode.execute(JSAbstractArray.arrayGetArray(object), index);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index) {
        return index >= 0L && index < (long)this.lengthInt(object);
    }

    @Override
    public int lengthInt(DynamicObject object) {
        return (int)JSAbstractArray.arrayGetLength(object);
    }

    @Override
    public AbstractWritableArray createWriteableObject(DynamicObject object, long index, Object value, ScriptArray.ProfileHolder profile) {
        int len = this.lengthInt(object);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getElementInBounds(object, i);
        }
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, array.length, array.length, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray createWriteableDouble(DynamicObject object, long index, double value, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, profile);
    }

    @Override
    public AbstractWritableArray createWriteableInt(DynamicObject object, long index, int value, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, profile);
    }

    @Override
    public AbstractWritableArray createWriteableJSObject(DynamicObject object, long index, JSDynamicObject value, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, profile);
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict) {
        return this.createWriteableObject(object, index, null, ScriptArray.ProfileHolder.empty()).deleteElementImpl(object, index, strict);
    }

    @Override
    public ScriptArray setLengthImpl(DynamicObject object, long len, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, len - 1L, null, ScriptArray.ProfileHolder.empty()).setLengthImpl(object, len, profile);
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.createWriteableObject(object, start, null, ScriptArray.ProfileHolder.empty()).removeRangeImpl(object, start, end);
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.createWriteableObject(object, offset, null, ScriptArray.ProfileHolder.empty()).addRangeImpl(object, offset, size);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        int len = this.lengthInt(object);
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getElementInBounds(object, i);
        }
        return array;
    }

    @Override
    public Object cloneArray(DynamicObject object) {
        return LazyArray.arrayGetLazyList(object);
    }
}

