/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.DateFunctionBuiltins;
import com.oracle.truffle.js.builtins.DatePrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSDateObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class JSDate
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "Date";
    public static final String PROTOTYPE_NAME = "Date.prototype";
    private static DateTimeFormatter jsDateFormat;
    private static DateTimeFormatter jsDateFormatBeforeYear0;
    private static DateTimeFormatter jsDateFormatAfterYear9999;
    private static DateTimeFormatter jsDateFormatISO;
    private static DateTimeFormatter jsShortDateFormat;
    private static DateTimeFormatter jsShortDateLocalFormat;
    private static DateTimeFormatter jsShortTimeFormat;
    private static DateTimeFormatter jsShortTimeLocalFormat;
    private static DateTimeFormatter jsDateToStringFormat;
    public static final JSDate INSTANCE;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MS_PER_SECOND = 1000;
    public static final int MS_PER_MINUTE = 60000;
    private static final int MS_PER_HOUR = 3600000;
    public static final int MS_PER_DAY = 86400000;
    public static final double MAX_DATE = 8.64E15;
    private static final int DAYS_IN_4_YEARS = 1461;
    private static final int DAYS_IN_100_YEARS = 36524;
    private static final int DAYS_IN_400_YEARS = 146097;
    private static final int DAYS_FROM_1970_TO_2000 = 10957;
    private static final int YEAR_SHIFT = 280000;
    private static final int DAY_SHIFT = 102267900;
    public static final String INVALID_DATE_STRING = "Invalid Date";

    private JSDate() {
    }

    public static void setTimeMillisField(DynamicObject obj, double timeMillis) {
        assert (JSDate.isJSDate(obj));
        ((JSDateObject)obj).setTimeMillis(timeMillis);
    }

    public static double getTimeMillisField(DynamicObject obj) {
        assert (JSDate.isJSDate(obj));
        return ((JSDateObject)obj).getTimeMillis();
    }

    public static boolean isJSDate(Object obj) {
        return obj instanceof JSDateObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        DynamicObject datePrototype;
        JSContext ctx = realm.getContext();
        if (ctx.getEcmaScriptVersion() < 6) {
            Shape protoShape = JSShape.createPrototypeShape(realm.getContext(), INSTANCE, realm.getObjectPrototype());
            datePrototype = JSDateObject.create(protoShape, Double.NaN);
            JSObjectUtil.setOrVerifyPrototype(ctx, datePrototype, realm.getObjectPrototype());
        } else {
            datePrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        }
        JSObjectUtil.putConstructorProperty(ctx, datePrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, datePrototype, DatePrototypeBuiltins.BUILTINS);
        if (ctx.isOptionAnnexB()) {
            Object utcStringFunction = JSDynamicObject.getOrNull(datePrototype, "toUTCString");
            JSObjectUtil.putDataProperty(ctx, datePrototype, "toGMTString", utcStringFunction, JSAttributes.getDefaultNotEnumerable());
        }
        return datePrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, DateFunctionBuiltins.BUILTINS);
    }

    @CompilerDirectives.TruffleBoundary
    public static double executeConstructor(double[] argsEvaluated, boolean inputIsUTC, JSContext context) {
        double month;
        double year = argsEvaluated.length > 0 ? argsEvaluated[0] : Double.NaN;
        double d = month = argsEvaluated.length > 1 ? argsEvaluated[1] : 0.0;
        if (Double.isNaN(year) || Double.isInfinite(year) || Double.isNaN(month) || Double.isInfinite(month)) {
            return Double.NaN;
        }
        double day = JSDate.getArgOrDefault(argsEvaluated, 2, 1);
        double hour = JSDate.getArgOrDefault(argsEvaluated, 3, 0);
        double minute = JSDate.getArgOrDefault(argsEvaluated, 4, 0);
        double second = JSDate.getArgOrDefault(argsEvaluated, 5, 0);
        double ms = JSDate.getArgOrDefault(argsEvaluated, 6, 0);
        return JSDate.makeDate(JSDate.toFullYear(year), month, day, hour, minute, second, ms, inputIsUTC ? Integer.valueOf(0) : null, context);
    }

    private static double getArgOrDefault(double[] argsEvaluated, int index, int def) {
        if (argsEvaluated.length > index) {
            return argsEvaluated[index];
        }
        return def;
    }

    private static double day(double t) {
        return JSDate.floor(t / 8.64E7);
    }

    private static double timeWithinDay(double t) {
        return JSDate.secureNegativeModulo(t, 8.64E7);
    }

    public static int dayFromYear(int y) {
        return 365 * (y - 1970) + Math.floorDiv(y - 1969, 4) - Math.floorDiv(y - 1901, 100) + Math.floorDiv(y - 1601, 400);
    }

    @CompilerDirectives.TruffleBoundary
    public static int yearFromTime(long t) {
        long daysAfter1970 = Math.floorDiv(t, 86400000L);
        assert (JSRuntime.longIsRepresentableAsInt(daysAfter1970));
        return JSDate.yearFromDays((int)daysAfter1970);
    }

    public static int yearFromDays(int daysAfter1970) {
        int daysAfter2000 = daysAfter1970 - 10957;
        int days = daysAfter2000 + 102267900;
        assert (days > 0);
        int year = 400 * (days / 146097);
        int remainingDays = days % 146097;
        year += 100 * (--remainingDays / 36524);
        remainingDays %= 36524;
        year += 4 * (++remainingDays / 1461);
        remainingDays %= 1461;
        return (year += --remainingDays / 365) - 280000 + 2000;
    }

    private static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static int monthFromTime(double dt) {
        assert (JSRuntime.doubleIsRepresentableAsLong(dt));
        long t = (long)dt;
        int year = JSDate.yearFromTime(t);
        boolean leapYear = JSDate.isLeapYear(year);
        int day = JSDate.dayWithinYear(t, year);
        return JSDate.monthFromTimeIntl(leapYear, day);
    }

    private static int monthFromTimeIntl(boolean leapYear, int day) {
        assert (0 <= day && day < 365 + (leapYear ? 1 : 0)) : "should not reach here";
        if (day < 31) {
            return 0;
        }
        if (!leapYear) {
            if (day < 59) {
                return 1;
            }
            if (day < 90) {
                return 2;
            }
            if (day < 120) {
                return 3;
            }
            if (day < 151) {
                return 4;
            }
            if (day < 181) {
                return 5;
            }
            if (day < 212) {
                return 6;
            }
            if (day < 243) {
                return 7;
            }
            if (day < 273) {
                return 8;
            }
            if (day < 304) {
                return 9;
            }
            if (day < 334) {
                return 10;
            }
            return 11;
        }
        if (day < 60) {
            return 1;
        }
        if (day < 91) {
            return 2;
        }
        if (day < 121) {
            return 3;
        }
        if (day < 152) {
            return 4;
        }
        if (day < 182) {
            return 5;
        }
        if (day < 213) {
            return 6;
        }
        if (day < 244) {
            return 7;
        }
        if (day < 274) {
            return 8;
        }
        if (day < 305) {
            return 9;
        }
        if (day < 335) {
            return 10;
        }
        return 11;
    }

    private static int dayWithinYear(long t, int year) {
        return (int)Math.floorDiv(t, 86400000L) - JSDate.dayFromYear(year);
    }

    @CompilerDirectives.TruffleBoundary
    public static int dateFromTime(double dt) {
        assert (JSRuntime.doubleIsRepresentableAsLong(dt));
        long t = (long)dt;
        int year = JSDate.yearFromTime(t);
        int day = JSDate.dayWithinYear(t, year);
        return JSDate.dateFromDayInYear(year, day);
    }

    public static int dateFromDayInYear(int year, int day) {
        if (day < 31) {
            return day + 1;
        }
        boolean leapYear = JSDate.isLeapYear(year);
        int dayMinusLeap = day - (leapYear ? 1 : 0);
        switch (JSDate.monthFromTimeIntl(leapYear, day)) {
            case 1: {
                return day - 30;
            }
            case 2: {
                return dayMinusLeap - 58;
            }
            case 3: {
                return dayMinusLeap - 89;
            }
            case 4: {
                return dayMinusLeap - 119;
            }
            case 5: {
                return dayMinusLeap - 150;
            }
            case 6: {
                return dayMinusLeap - 180;
            }
            case 7: {
                return dayMinusLeap - 211;
            }
            case 8: {
                return dayMinusLeap - 242;
            }
            case 9: {
                return dayMinusLeap - 272;
            }
            case 10: {
                return dayMinusLeap - 303;
            }
            case 11: {
                return dayMinusLeap - 333;
            }
        }
        assert (false) : "should not reach here";
        return -1;
    }

    public static double weekDay(double t) {
        int result = ((int)JSDate.day(t) + 4) % 7;
        return result >= 0 ? (double)result : (double)(result + 7);
    }

    public static double localTime(double t, JSContext context) {
        return t + (double)JSDate.localTZA(t, true, context);
    }

    private static double utc(double t, JSContext context) {
        return t - (double)JSDate.localTZA(t, false, context);
    }

    public static long localTZA(double t, boolean isUTC, JSContext context) {
        return JSDate.localTZA(t, isUTC, context.getRealm().getLocalTimeZoneId());
    }

    @CompilerDirectives.TruffleBoundary
    public static long localTZA(double t, boolean isUTC, ZoneId zoneId) {
        ZoneOffset zoneOffset;
        if (isUTC) {
            zoneOffset = zoneId.getRules().getOffset(Instant.ofEpochMilli((long)t));
        } else {
            if (!(Math.abs(t) < 8.6400000864E15)) {
                return 0L;
            }
            LocalDateTime localDateTime = LocalDateTime.of(JSDate.yearFromTime((long)t), 1 + JSDate.monthFromTime(t), JSDate.dateFromTime(t), JSDate.hourFromTime(t), JSDate.minFromTime(t), JSDate.secFromTime(t), JSDate.msFromTime(t));
            zoneOffset = zoneId.getRules().getOffset(localDateTime);
        }
        return (long)zoneOffset.getTotalSeconds() * 1000L;
    }

    @CompilerDirectives.TruffleBoundary
    public static int hourFromTime(double t) {
        return (int)JSDate.secureNegativeModulo(JSDate.floor(t / 3600000.0), 24.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int minFromTime(double t) {
        return (int)JSDate.secureNegativeModulo(JSDate.floor(t / 60000.0), 60.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int secFromTime(double t) {
        return (int)JSDate.secureNegativeModulo(JSDate.floor(t / 1000.0), 60.0);
    }

    @CompilerDirectives.TruffleBoundary
    public static int msFromTime(double t) {
        return (int)JSDate.secureNegativeModulo(t, 1000.0);
    }

    private static double secureNegativeModulo(double value, double modulo) {
        double result = value % modulo;
        if (result >= 0.0) {
            return result;
        }
        return result + modulo;
    }

    @CompilerDirectives.TruffleBoundary
    private static double makeTime(double hour, double min2, double sec, double ms) {
        if (!(JSDate.isFinite(hour) && JSDate.isFinite(min2) && JSDate.isFinite(sec) && JSDate.isFinite(ms))) {
            return Double.NaN;
        }
        long h2 = JSDate.doubleToLong(hour);
        long m3 = JSDate.doubleToLong(min2);
        long s2 = JSDate.doubleToLong(sec);
        long milli = JSDate.doubleToLong(ms);
        return (double)(h2 * 3600000L + m3 * 60000L + s2 * 1000L) + (double)milli;
    }

    @CompilerDirectives.TruffleBoundary
    private static double makeDay(double year, double month, double date) {
        if (!(JSDate.isFinite(year) && JSDate.isFinite(month) && JSDate.isFinite(date))) {
            return Double.NaN;
        }
        double y = JSDate.doubleToLong(year);
        double m3 = JSDate.doubleToLong(month);
        double dt = JSDate.doubleToLong(date);
        double ym = y + JSDate.floor(m3 / 12.0);
        int mn = (int)(m3 % 12.0);
        if (mn < 0) {
            mn += 12;
        }
        if (ym < -9.99999999E8 || ym > 9.99999999E8) {
            return Double.NaN;
        }
        double t = LocalDate.of((int)ym, mn + 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        return JSDate.day(t) + dt - 1.0;
    }

    private static long doubleToLong(double value) {
        assert (!Double.isNaN(value));
        return (long)value;
    }

    @CompilerDirectives.TruffleBoundary
    private static double makeDate(double day, double time) {
        if (!JSDate.isFinite(day) || !JSDate.isFinite(time)) {
            return Double.NaN;
        }
        return day * 8.64E7 + time;
    }

    @CompilerDirectives.TruffleBoundary
    public static double makeDate(double y, double m3, double d, double h2, double min2, double sec, double ms, Integer timezone, JSContext context) {
        double day = JSDate.makeDay(y, m3, d);
        double time = JSDate.makeTime(h2, min2, sec, ms);
        double date = JSDate.makeDate(day, time);
        date = timezone == null ? JSDate.utc(date, context) : (date -= (double)(timezone * 60000));
        return JSDate.timeClip(date);
    }

    public static double timeClip(double time) {
        if (Double.isInfinite(time) || Double.isNaN(time) || Math.abs(time) > 8.64E15) {
            return Double.NaN;
        }
        return Double.valueOf(time).longValue();
    }

    private static boolean isFinite(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    private static double floor(double d) {
        return JSRuntime.mathFloor(d);
    }

    public static DynamicObject create(JSContext context, double timeMillis) {
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getDateFactory();
        DynamicObject obj = JSDateObject.create(factory.getShape(realm), timeMillis);
        factory.initProto(obj, realm);
        assert (JSDate.isJSDate(obj));
        return context.trackAllocation(obj);
    }

    public static double setTime(DynamicObject thisDate, double time) {
        double v = JSDate.timeClip(time);
        JSDate.setTimeMillisField(thisDate, v);
        return v;
    }

    public static double setMilliseconds(DynamicObject thisDate, double ms, boolean isUTC, JSContext context) {
        double t = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, context);
        double time = JSDate.makeTime(JSDate.hourFromTime(t), JSDate.minFromTime(t), JSDate.secFromTime(t), ms);
        double u = JSDate.timeClip(JSDate.utc(JSDate.makeDate(JSDate.day(t), time), isUTC, context));
        JSDate.setTimeMillisField(thisDate, u);
        return u;
    }

    public static double setSeconds(DynamicObject thisDate, double s2, double ms, boolean msSpecified, boolean isUTC, JSContext context) {
        double t = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, context);
        double milli = msSpecified ? ms : (double)JSDate.msFromTime(t);
        double date = JSDate.makeDate(JSDate.day(t), JSDate.makeTime(JSDate.hourFromTime(t), JSDate.minFromTime(t), s2, milli));
        double u = JSDate.timeClip(JSDate.utc(date, isUTC, context));
        JSDate.setTimeMillisField(thisDate, u);
        return u;
    }

    public static double setMinutes(DynamicObject thisDate, double m3, double s2, boolean sSpecified, double ms, boolean msSpecified, boolean isUTC, JSContext context) {
        double t = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, context);
        double milli = msSpecified ? ms : (double)JSDate.msFromTime(t);
        double sec = sSpecified ? s2 : (double)JSDate.secFromTime(t);
        double date = JSDate.makeDate(JSDate.day(t), JSDate.makeTime(JSDate.hourFromTime(t), m3, sec, milli));
        double u = JSDate.timeClip(JSDate.utc(date, isUTC, context));
        JSDate.setTimeMillisField(thisDate, u);
        return u;
    }

    public static double setHours(DynamicObject thisDate, double h2, double m3, boolean mSpecified, double s2, boolean sSpecified, double ms, boolean msSpecified, boolean isUTC, JSContext context) {
        double t = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, context);
        double milli = msSpecified ? ms : (double)JSDate.msFromTime(t);
        double sec = sSpecified ? s2 : (double)JSDate.secFromTime(t);
        double min2 = mSpecified ? m3 : (double)JSDate.minFromTime(t);
        double date = JSDate.makeDate(JSDate.day(t), JSDate.makeTime(h2, min2, sec, milli));
        double u = JSDate.timeClip(JSDate.utc(date, isUTC, context));
        JSDate.setTimeMillisField(thisDate, u);
        return u;
    }

    public static double setDate(DynamicObject thisDate, double date, boolean isUTC, JSContext context) {
        double u;
        double t = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, context);
        if (Double.isNaN(t)) {
            u = Double.NaN;
        } else {
            double newDate = JSDate.makeDate(JSDate.makeDay(JSDate.yearFromTime((long)t), JSDate.monthFromTime(t), date), JSDate.timeWithinDay(t));
            u = JSDate.timeClip(JSDate.utc(newDate, isUTC, context));
        }
        JSDate.setTimeMillisField(thisDate, u);
        return u;
    }

    public static double setMonth(DynamicObject thisDate, double month, double date, boolean dateSpecified, boolean isUTC, JSContext context) {
        double newDate;
        double t = JSDate.localTime(JSDate.getTimeMillisField(thisDate), isUTC, context);
        if (Double.isNaN(t)) {
            newDate = Double.NaN;
        } else {
            double dt = dateSpecified ? date : (double)JSDate.dateFromTime(t);
            newDate = JSDate.timeClip(JSDate.utc(JSDate.makeDate(JSDate.makeDay(JSDate.yearFromTime((long)t), month, dt), JSDate.timeWithinDay(t)), isUTC, context));
        }
        JSDate.setTimeMillisField(thisDate, newDate);
        return newDate;
    }

    public static double setFullYear(DynamicObject thisDate, double year, double month, boolean monthSpecified, double date, boolean dateSpecified, boolean isUTC, JSContext context) {
        double timeFieldValue = JSDate.getTimeMillisField(thisDate);
        double t = Double.isNaN(timeFieldValue) ? 0.0 : JSDate.localTime(timeFieldValue, isUTC, context);
        double dt = dateSpecified ? date : (double)JSDate.dateFromTime(t);
        double m3 = monthSpecified ? month : (double)JSDate.monthFromTime(t);
        double newDate = JSDate.makeDate(JSDate.makeDay(year, m3, dt), JSDate.timeWithinDay(t));
        double u = JSDate.timeClip(JSDate.utc(newDate, isUTC, context));
        JSDate.setTimeMillisField(thisDate, u);
        return u;
    }

    public static double setYear(DynamicObject thisDate, double year, JSContext context) {
        double t = JSDate.getTimeMillisField(thisDate);
        double d = t = Double.isNaN(t) ? 0.0 : JSDate.localTime(t, context);
        if (Double.isNaN(year)) {
            JSDate.setTimeMillisField(thisDate, Double.NaN);
            return Double.NaN;
        }
        double fullYear = JSDate.toFullYear(year);
        double r5 = JSDate.makeDay(fullYear, JSDate.monthFromTime(t), JSDate.dateFromTime(t));
        double r6 = JSDate.timeClip(JSDate.utc(JSDate.makeDate(r5, JSDate.timeWithinDay(t)), context));
        JSDate.setTimeMillisField(thisDate, r6);
        return r6;
    }

    private static double toFullYear(double year) {
        if (-1.0 < year && year < 100.0) {
            return 1900 + (int)year;
        }
        return year;
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatLocal(DateTimeFormatter format, double time, JSRealm realm) {
        return Instant.ofEpochMilli((long)time).atZone(realm.getLocalTimeZoneId()).format(format);
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatUTC(DateTimeFormatter format, double time) {
        return Instant.ofEpochMilli((long)time).atZone(ZoneOffset.UTC).format(format);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(double time, JSRealm realm) {
        if (Double.isNaN(time)) {
            return INVALID_DATE_STRING;
        }
        return JSDate.formatLocal(JSDate.getDateToStringFormat(), time, realm);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toISOStringIntl(double time) {
        return JSDate.formatUTC(JSDate.getJSDateFormat(time), time);
    }

    public static boolean isTimeValid(double time) {
        return !Double.isNaN(time) && !Double.isInfinite(time);
    }

    private static double localTime(double time, boolean isUTC, JSContext context) {
        return isUTC ? time : JSDate.localTime(time, context);
    }

    private static double utc(double time, boolean isUTC, JSContext context) {
        return isUTC ? time : JSDate.utc(time, context);
    }

    public static boolean isValidDate(DynamicObject date) {
        return JSDate.isJSDate(date) && !Double.isNaN(JSDate.getTimeMillisField(date));
    }

    @CompilerDirectives.TruffleBoundary
    public static Instant asInstant(DynamicObject date) {
        assert (JSDate.isValidDate(date));
        return Instant.ofEpochMilli((long)JSDate.getTimeMillisField(date));
    }

    @CompilerDirectives.TruffleBoundary
    public static LocalDate asLocalDate(DynamicObject date, JSRealm realm) {
        return LocalDate.from(JSDate.asInstant(date).atZone(realm.getLocalTimeZoneId()));
    }

    @CompilerDirectives.TruffleBoundary
    public static LocalTime asLocalTime(DynamicObject date, JSRealm realm) {
        return LocalTime.from(JSDate.asInstant(date).atZone(realm.getLocalTimeZoneId()));
    }

    public static double getDateValueFromInstant(Object receiver, InteropLibrary interop) {
        Instant instant;
        try {
            instant = interop.asInstant(receiver);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(receiver, e, "asInstant", null);
        }
        try {
            return instant.toEpochMilli();
        }
        catch (ArithmeticException e) {
            return Double.NaN;
        }
    }

    public static DateTimeFormatter getJSDateFormat(double time) {
        long milliseconds = (long)time;
        if (milliseconds < -62167219200000L) {
            if (jsDateFormatBeforeYear0 == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                jsDateFormatBeforeYear0 = DateTimeFormatter.ofPattern("uuuuuu-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            }
            return jsDateFormatBeforeYear0;
        }
        if (milliseconds >= 253402300800000L) {
            if (jsDateFormatAfterYear9999 == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                jsDateFormatAfterYear9999 = DateTimeFormatter.ofPattern("+uuuuuu-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            }
            return jsDateFormatAfterYear9999;
        }
        if (jsDateFormat == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsDateFormat = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        }
        return jsDateFormat;
    }

    public static DateTimeFormatter getJSDateUTCFormat() {
        if (jsDateFormatISO == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsDateFormatISO = DateTimeFormatter.ofPattern("EEE, dd MMM uuuu HH:mm:ss 'GMT'", Locale.US);
        }
        return jsDateFormatISO;
    }

    public static DateTimeFormatter getJSShortDateFormat() {
        if (jsShortDateFormat == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsShortDateFormat = DateTimeFormatter.ofPattern("EEE MMM dd uuuu", Locale.US);
        }
        return jsShortDateFormat;
    }

    public static DateTimeFormatter getJSShortDateLocalFormat() {
        if (jsShortDateLocalFormat == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsShortDateLocalFormat = DateTimeFormatter.ofPattern("uuuu-MM-dd", Locale.US);
        }
        return jsShortDateLocalFormat;
    }

    public static DateTimeFormatter getJSShortTimeFormat() {
        if (jsShortTimeFormat == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsShortTimeFormat = DateTimeFormatter.ofPattern("HH:mm:ss 'GMT'Z (z)", Locale.US);
        }
        return jsShortTimeFormat;
    }

    public static DateTimeFormatter getJSShortTimeLocalFormat() {
        if (jsShortTimeLocalFormat == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsShortTimeLocalFormat = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.US);
        }
        return jsShortTimeLocalFormat;
    }

    public static DateTimeFormatter getDateToStringFormat() {
        if (jsDateToStringFormat == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            jsDateToStringFormat = DateTimeFormatter.ofPattern("EEE MMM dd uuuu HH:mm:ss 'GMT'Z (z)", Locale.US);
        }
        return jsDateToStringFormat;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects, JSContext context) {
        double time = JSDate.getTimeMillisField(obj);
        String formattedDate = JSDate.isTimeValid(time) ? JSDate.toISOStringIntl(time) : INVALID_DATE_STRING;
        if (context.isOptionNashornCompatibilityMode()) {
            return "[Date " + formattedDate + "]";
        }
        return formattedDate;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDatePrototype();
    }

    static {
        INSTANCE = new JSDate();
    }
}

