/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@ExportLibrary(value=InteropLibrary.class)
public final class JSDateObject
extends JSNonProxyObject {
    private double value;

    protected JSDateObject(Shape shape, double value) {
        super(shape);
        this.value = value;
    }

    public double getTimeMillis() {
        return this.value;
    }

    public void setTimeMillis(double value) {
        this.value = value;
    }

    public static DynamicObject create(Shape shape, double value) {
        return new JSDateObject(shape, value);
    }

    @Override
    public String getClassName() {
        return "Date";
    }

    @Override
    public String getBuiltinToStringTag() {
        return this.getClassName();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isDate"), @ExportMessage(name="isTime"), @ExportMessage(name="isTimeZone")})
    protected boolean isDate() {
        return JSDate.isValidDate(this);
    }

    @ExportMessage
    public Instant asInstant() throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asInstant(this);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public LocalDate asDate(@CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asLocalDate(this, contextRef.get());
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public LocalTime asTime(@CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asLocalTime(this, contextRef.get());
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public ZoneId asTimeZone(@CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) throws UnsupportedMessageException {
        if (this.isDate()) {
            return contextRef.get().getLocalTimeZoneId();
        }
        throw UnsupportedMessageException.create();
    }
}

