/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostAdapterFactory;
import com.oracle.truffle.polyglot.HostClassCache;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

final class HostClassDesc {
    private final Class<?> type;
    private final HostClassCache cache;
    private volatile Members members;
    private volatile JNIMembers jniMembers;
    private volatile MethodsBySignature methodsBySignature;
    private volatile HostAdapterFactory.AdapterResult adapter;
    private final boolean allowsImplementation;
    private final boolean allowedTargetType;

    @CompilerDirectives.TruffleBoundary
    static HostClassDesc forClass(PolyglotEngineImpl impl, Class<?> clazz) {
        return impl.getHostClassCache().forClass(clazz);
    }

    HostClassDesc(HostClassCache cache, Class<?> type) {
        this.type = type;
        this.cache = cache;
        this.allowsImplementation = HostInteropReflect.isExtensibleType(type) && cache.allowsImplementation(type);
        this.allowedTargetType = this.allowsImplementation && HostInteropReflect.isAbstractType(type) && HostClassDesc.hasDefaultConstructor(type);
    }

    public boolean isAllowsImplementation() {
        return this.allowsImplementation;
    }

    public boolean isAllowedTargetType() {
        return this.allowedTargetType;
    }

    public Class<?> getType() {
        return this.type;
    }

    private static boolean hasDefaultConstructor(Class<?> type) {
        assert (!type.isPrimitive());
        if (type.isInterface()) {
            return true;
        }
        for (Constructor<?> ctor : type.getConstructors()) {
            if (ctor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    static boolean isObjectMethodOverride(Method m3) {
        return m3.getParameterCount() == 0 && (m3.getName().equals("hashCode") || m3.getName().equals("toString")) || m3.getParameterCount() == 1 && m3.getName().equals("equals") && m3.getParameterTypes()[0] == Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Members getMembers() {
        Members m3 = this.members;
        if (m3 == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m3 = this.members;
                if (m3 == null) {
                    this.members = m3 = new Members(this.cache, this.type);
                }
            }
        }
        return m3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIMembers getJNIMembers() {
        JNIMembers m3 = this.jniMembers;
        if (m3 == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m3 = this.jniMembers;
                if (m3 == null) {
                    this.jniMembers = m3 = new JNIMembers(this.getMembers());
                }
            }
        }
        return m3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodsBySignature getMethodsBySignature() {
        MethodsBySignature m3 = this.methodsBySignature;
        if (m3 == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m3 = this.methodsBySignature;
                if (m3 == null) {
                    this.methodsBySignature = m3 = new MethodsBySignature(this.getMembers());
                }
            }
        }
        return m3;
    }

    public HostMethodDesc lookupMethod(String name) {
        return this.getMembers().methods.get(name);
    }

    public HostMethodDesc lookupStaticMethod(String name) {
        return this.getMembers().staticMethods.get(name);
    }

    public HostMethodDesc lookupMethod(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticMethod(name) : this.lookupMethod(name);
    }

    public HostMethodDesc lookupMethodBySignature(String nameAndSignature, boolean onlyStatic) {
        MethodsBySignature m3 = this.getMethodsBySignature();
        return onlyStatic ? m3.staticMethods.get(nameAndSignature) : m3.methods.get(nameAndSignature);
    }

    public HostMethodDesc lookupMethodByJNIName(String jniName, boolean onlyStatic) {
        JNIMembers m3 = this.getJNIMembers();
        return onlyStatic ? m3.staticMethods.get(jniName) : m3.methods.get(jniName);
    }

    public Collection<String> getMethodNames(boolean onlyStatic, boolean includeInternal) {
        Map<String, HostMethodDesc> methods;
        Map<String, HostMethodDesc> map = methods = onlyStatic ? this.getMembers().staticMethods : this.getMembers().methods;
        if (includeInternal || onlyStatic) {
            return Collections.unmodifiableCollection(methods.keySet());
        }
        ArrayList<String> methodNames = new ArrayList<String>(methods.size());
        for (Map.Entry<String, HostMethodDesc> entry : methods.entrySet()) {
            if (entry.getValue().isInternal()) continue;
            methodNames.add(entry.getKey());
        }
        return methodNames;
    }

    public HostMethodDesc lookupConstructor() {
        return this.getMembers().constructor;
    }

    public HostFieldDesc lookupField(String name) {
        return this.getMembers().fields.get(name);
    }

    public HostFieldDesc lookupStaticField(String name) {
        return this.getMembers().staticFields.get(name);
    }

    public HostFieldDesc lookupField(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticField(name) : this.lookupField(name);
    }

    public Collection<String> getFieldNames(boolean onlyStatic) {
        return Collections.unmodifiableCollection((onlyStatic ? this.getMembers().staticFields : this.getMembers().fields).keySet());
    }

    public HostMethodDesc getFunctionalMethod() {
        return this.getMembers().functionalMethod;
    }

    public HostAdapterFactory.AdapterResult getAdapter(HostLanguage.HostContext hostContext) {
        HostAdapterFactory.AdapterResult result = this.adapter;
        if (result == null) {
            result = this.getOrSetAdapter(hostContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostAdapterFactory.AdapterResult getOrSetAdapter(HostLanguage.HostContext hostContext) {
        CompilerAsserts.neverPartOfCompilation();
        HostClassDesc hostClassDesc = this;
        synchronized (hostClassDesc) {
            HostAdapterFactory.AdapterResult result = this.adapter;
            if (result == null) {
                this.adapter = result = HostAdapterFactory.makeAdapterClassFor(this.cache, this.type, hostContext.getClassloader());
            }
            return result;
        }
    }

    public String toString() {
        return "JavaClass[" + this.type.getCanonicalName() + "]";
    }

    private static final class MethodsBySignature {
        final UnmodifiableEconomicMap<String, HostMethodDesc> methods;
        final UnmodifiableEconomicMap<String, HostMethodDesc> staticMethods;

        MethodsBySignature(Members members) {
            this.methods = MethodsBySignature.collectMethodsBySignature(members.methods);
            this.staticMethods = MethodsBySignature.collectMethodsBySignature(members.staticMethods);
        }

        private static UnmodifiableEconomicMap<String, HostMethodDesc> collectMethodsBySignature(Map<String, HostMethodDesc> methods) {
            EconomicMap<String, HostMethodDesc> methodMap = EconomicMap.create();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc.SingleMethod m3 : method.getOverloads()) {
                    assert (m3.isMethod());
                    methodMap.put(HostInteropReflect.toNameAndSignature((Method)m3.getReflectionMethod()), m3);
                }
            }
            return methodMap;
        }
    }

    private static final class JNIMembers {
        final UnmodifiableEconomicMap<String, HostMethodDesc> methods;
        final UnmodifiableEconomicMap<String, HostMethodDesc> staticMethods;

        JNIMembers(Members members) {
            this.methods = JNIMembers.collectJNINamedMethods(members.methods);
            this.staticMethods = JNIMembers.collectJNINamedMethods(members.staticMethods);
        }

        private static UnmodifiableEconomicMap<String, HostMethodDesc> collectJNINamedMethods(Map<String, HostMethodDesc> methods) {
            EconomicMap<String, HostMethodDesc> jniMethods = EconomicMap.create();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc.SingleMethod m3 : method.getOverloads()) {
                    assert (m3.isMethod());
                    jniMethods.put(HostInteropReflect.jniName((Method)m3.getReflectionMethod()), m3);
                }
            }
            return jniMethods;
        }
    }

    private static class Members {
        final Map<String, HostMethodDesc> methods;
        final Map<String, HostMethodDesc> staticMethods;
        final HostMethodDesc constructor;
        final Map<String, HostFieldDesc> fields;
        final Map<String, HostFieldDesc> staticFields;
        final HostMethodDesc functionalMethod;
        private static final BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc> MERGE = new BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc>(){

            @Override
            public HostMethodDesc apply(HostMethodDesc m1, HostMethodDesc m22) {
                return Members.merge(m1, m22);
            }
        };

        Members(HostClassCache hostAccess, Class<?> type) {
            String functionalInterfaceMethodName;
            LinkedHashMap<String, HostMethodDesc> methodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostMethodDesc> staticMethodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostFieldDesc> fieldMap = new LinkedHashMap<String, HostFieldDesc>();
            LinkedHashMap<String, HostFieldDesc> staticFieldMap = new LinkedHashMap<String, HostFieldDesc>();
            HostMethodDesc functionalInterfaceMethod = null;
            Members.collectPublicMethods(hostAccess, type, methodMap, staticMethodMap);
            Members.collectPublicFields(hostAccess, type, fieldMap, staticFieldMap);
            HostMethodDesc ctor = Members.collectPublicConstructors(hostAccess, type);
            if (!Modifier.isInterface(type.getModifiers()) && !Modifier.isAbstract(type.getModifiers()) && (functionalInterfaceMethodName = Members.findFunctionalInterfaceMethodName(type)) != null) {
                functionalInterfaceMethod = (HostMethodDesc)methodMap.get(functionalInterfaceMethodName);
            }
            this.methods = methodMap;
            this.staticMethods = staticMethodMap;
            this.constructor = ctor;
            this.fields = fieldMap;
            this.staticFields = staticFieldMap;
            this.functionalMethod = functionalInterfaceMethod;
        }

        private static boolean isClassAccessible(Class<?> declaringClass, HostClassCache hostAccess) {
            return Modifier.isPublic(declaringClass.getModifiers()) && EngineAccessor.JDKSERVICES.verifyModuleVisibility(hostAccess.getUnnamedModule(), declaringClass);
        }

        private static HostMethodDesc collectPublicConstructors(HostClassCache hostAccess, Class<?> type) {
            HostMethodDesc.SingleMethod ctor = null;
            if (Members.isClassAccessible(type, hostAccess)) {
                for (Constructor<?> c : type.getConstructors()) {
                    if (!hostAccess.allowsAccess(c)) continue;
                    HostMethodDesc.SingleMethod overload = HostMethodDesc.SingleMethod.unreflect(c);
                    ctor = ctor == null ? overload : Members.merge(ctor, overload);
                }
            }
            return ctor;
        }

        private static void collectPublicMethods(HostClassCache hostAccess, Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            Members.collectPublicMethods(hostAccess, type, methodMap, staticMethodMap, new HashSet<Object>(), type);
        }

        private static void collectPublicMethods(HostClassCache hostAccess, Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap, Set<Object> visited, Class<?> startType) {
            boolean isPublicType = Members.isClassAccessible(type, hostAccess) && !Proxy.isProxyClass(type);
            boolean allMethodsPublic = true;
            ArrayList<GenericDeclaration> bridgeMethods = null;
            if (isPublicType) {
                for (GenericDeclaration genericDeclaration : type.getMethods()) {
                    Class<?> declaringClass = ((Method)genericDeclaration).getDeclaringClass();
                    if (Modifier.isStatic(((Method)genericDeclaration).getModifiers()) && declaringClass != startType && Modifier.isInterface(declaringClass.getModifiers())) continue;
                    if (!Members.isClassAccessible(declaringClass, hostAccess)) {
                        allMethodsPublic = false;
                        continue;
                    }
                    if (((Method)genericDeclaration).isBridge()) {
                        allMethodsPublic = false;
                        if (bridgeMethods == null) {
                            bridgeMethods = new ArrayList<GenericDeclaration>();
                        }
                        bridgeMethods.add(genericDeclaration);
                        continue;
                    }
                    if (!visited.add(Members.methodInfo((Method)genericDeclaration))) continue;
                    Members.putMethod(hostAccess, (Method)genericDeclaration, methodMap, staticMethodMap);
                }
            }
            if (!isPublicType || !allMethodsPublic) {
                if (type.getSuperclass() != null) {
                    Members.collectPublicMethods(hostAccess, type.getSuperclass(), methodMap, staticMethodMap, visited, startType);
                }
                for (Class<?> clazz : type.getInterfaces()) {
                    if (!visited.add(clazz)) continue;
                    Members.collectPublicMethods(hostAccess, clazz, methodMap, staticMethodMap, visited, startType);
                }
            }
            if (bridgeMethods != null && !bridgeMethods.isEmpty()) {
                for (Method method : bridgeMethods) {
                    if (!visited.add(Members.methodInfo(method))) continue;
                    Members.putMethod(hostAccess, method, methodMap, staticMethodMap);
                }
            }
        }

        private static Object methodInfo(Method m3) {
            class MethodInfo {
                private final boolean isStatic;
                private final String name;
                private final Class<?>[] parameterTypes;
                final /* synthetic */ Method val$m;

                MethodInfo(Method method) {
                    this.val$m = method;
                    this.isStatic = Modifier.isStatic(this.val$m.getModifiers());
                    this.name = this.val$m.getName();
                    this.parameterTypes = this.val$m.getParameterTypes();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof MethodInfo) {
                        MethodInfo other = (MethodInfo)obj;
                        return this.isStatic == other.isStatic && this.name.equals(other.name) && Arrays.equals(this.parameterTypes, other.parameterTypes);
                    }
                    return false;
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.isStatic ? 1 : 0);
                    result = 31 * result + this.name.hashCode();
                    result = 31 * result + Arrays.hashCode(this.parameterTypes);
                    return result;
                }
            }
            return new MethodInfo(m3);
        }

        private static void putMethod(HostClassCache hostAccess, Method m3, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            if (!hostAccess.allowsAccess(m3)) {
                return;
            }
            HostMethodDesc.SingleMethod method = HostMethodDesc.SingleMethod.unreflect(m3);
            Map<String, HostMethodDesc> map = Modifier.isStatic(m3.getModifiers()) ? staticMethodMap : methodMap;
            map.merge(m3.getName(), method, MERGE);
        }

        static HostMethodDesc merge(HostMethodDesc existing, HostMethodDesc other) {
            assert (other instanceof HostMethodDesc.SingleMethod);
            if (existing instanceof HostMethodDesc.SingleMethod) {
                return new HostMethodDesc.OverloadedMethod(new HostMethodDesc.SingleMethod[]{(HostMethodDesc.SingleMethod)existing, (HostMethodDesc.SingleMethod)other});
            }
            HostMethodDesc.SingleMethod[] oldOverloads = ((HostMethodDesc.OverloadedMethod)existing).getOverloads();
            HostMethodDesc.SingleMethod[] newOverloads = Arrays.copyOf(oldOverloads, oldOverloads.length + 1);
            newOverloads[oldOverloads.length] = (HostMethodDesc.SingleMethod)other;
            return new HostMethodDesc.OverloadedMethod(newOverloads);
        }

        private static void collectPublicFields(HostClassCache hostAccess, Class<?> type, Map<String, HostFieldDesc> fieldMap, Map<String, HostFieldDesc> staticFieldMap) {
            if (Members.isClassAccessible(type, hostAccess)) {
                boolean inheritedPublicInstanceFields = false;
                boolean inheritedPublicInaccessibleFields = false;
                for (Field f : type.getFields()) {
                    if (!Modifier.isStatic(f.getModifiers())) {
                        if (f.getDeclaringClass() == type) {
                            assert (!fieldMap.containsKey(f.getName()));
                            if (!hostAccess.allowsAccess(f)) continue;
                            fieldMap.put(f.getName(), HostFieldDesc.unreflect(f));
                            continue;
                        }
                        if (Members.isClassAccessible(f.getDeclaringClass(), hostAccess)) {
                            inheritedPublicInstanceFields = true;
                            continue;
                        }
                        inheritedPublicInaccessibleFields = true;
                        continue;
                    }
                    if (f.getDeclaringClass() != type || !hostAccess.allowsAccess(f)) continue;
                    staticFieldMap.put(f.getName(), HostFieldDesc.unreflect(f));
                }
                if (inheritedPublicInstanceFields) {
                    Members.collectPublicInstanceFields(hostAccess, type, fieldMap, inheritedPublicInaccessibleFields);
                }
            } else if (!Modifier.isInterface(type.getModifiers())) {
                Members.collectPublicInstanceFields(hostAccess, type, fieldMap, true);
            }
        }

        private static void collectPublicInstanceFields(HostClassCache hostAccess, Class<?> type, Map<String, HostFieldDesc> fieldMap, boolean mayHaveInaccessibleFields) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (Class<?> superclass = type; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                boolean inheritedPublicInstanceFields = false;
                for (Field f : superclass.getFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    if (f.getDeclaringClass() != superclass) {
                        if (!Modifier.isPublic(f.getDeclaringClass().getModifiers())) continue;
                        inheritedPublicInstanceFields = true;
                        continue;
                    }
                    if (mayHaveInaccessibleFields && !fieldNames.add(f.getName())) continue;
                    if (Members.isClassAccessible(f.getDeclaringClass(), hostAccess)) {
                        if (!hostAccess.allowsAccess(f)) continue;
                        fieldMap.putIfAbsent(f.getName(), HostFieldDesc.unreflect(f));
                        continue;
                    }
                    assert (mayHaveInaccessibleFields);
                }
                if (!inheritedPublicInstanceFields) break;
            }
        }

        private static String findFunctionalInterfaceMethodName(Class<?> clazz) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!Modifier.isPublic(iface.getModifiers()) || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
                for (Method m3 : iface.getMethods()) {
                    if (!Modifier.isAbstract(m3.getModifiers()) || HostClassDesc.isObjectMethodOverride(m3)) continue;
                    return m3.getName();
                }
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return Members.findFunctionalInterfaceMethodName(superclass);
            }
            return null;
        }
    }
}

