/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class LegacyScopesBridge {
    private static final InteropLibrary INTEROP = InteropLibrary.getUncached();

    private LegacyScopesBridge() {
    }

    static Iterable<Scope> findLibraryLocalScopesToLegacy(Node node, Frame frame) {
        Object scopeObject;
        NodeLibrary nodeLibrary = NodeLibrary.getUncached(node);
        if (!nodeLibrary.hasScope(node, frame)) {
            return Collections.emptyList();
        }
        try {
            scopeObject = nodeLibrary.getScope(node, frame, true);
        }
        catch (UnsupportedMessageException ex) {
            return Collections.emptyList();
        }
        String receiverName = LegacyScopesBridge.getReceiverName(nodeLibrary, node, frame);
        SourceSection rootSection = node.getRootNode().getSourceSection();
        ArrayList<Scope> scopes = new ArrayList<Scope>(5);
        while (scopeObject != null) {
            String name;
            Object variables;
            Object variablesWithReceiver;
            InteropLibrary scopeInterop = InteropLibrary.getUncached(scopeObject);
            Object scopeParent = null;
            if (scopeInterop.hasScopeParent(scopeObject)) {
                try {
                    scopeParent = scopeInterop.getScopeParent(scopeObject);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere(ex);
                }
            }
            if (scopeParent != null) {
                variablesWithReceiver = new SubtractedVariables(scopeObject, scopeParent, null);
                variables = receiverName != null ? new SubtractedVariables(scopeObject, scopeParent, receiverName) : variablesWithReceiver;
            } else {
                variablesWithReceiver = scopeObject;
                variables = receiverName != null ? new NoReceiverVariables(scopeObject, receiverName) : scopeObject;
            }
            try {
                name = InteropLibrary.getUncached().asString(scopeInterop.toDisplayString(scopeObject));
            }
            catch (UnsupportedMessageException ex) {
                assert (false) : String.format("Scope %s does not support toDisplayString()", scopeObject);
                name = "local";
            }
            Scope.Builder scopeBuilder = Scope.newBuilder(name, variables);
            SourceSection sourceLocation = null;
            if (scopeInterop.hasSourceLocation(scopeObject)) {
                try {
                    sourceLocation = scopeInterop.getSourceLocation(scopeObject);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere(ex);
                }
            }
            if (sourceLocation != null) {
                if (sourceLocation.equals(rootSection)) {
                    LegacyScopesBridge.buildFunctionScope(node, frame, nodeLibrary, scopeBuilder, variablesWithReceiver);
                } else {
                    for (Node scopeNode = node; scopeNode != null; scopeNode = scopeNode.getParent()) {
                        if (!(scopeNode instanceof InstrumentableNode) || !sourceLocation.equals(scopeNode.getSourceSection())) continue;
                        scopeBuilder.node(scopeNode);
                        break;
                    }
                }
            }
            scopes.add(scopeBuilder.build());
            scopeObject = scopeParent;
        }
        return scopes;
    }

    private static String getReceiverName(NodeLibrary nodeLibrary, Node node, Frame frame) {
        if (nodeLibrary.hasReceiverMember(node, frame)) {
            try {
                return INTEROP.asString(nodeLibrary.getReceiverMember(node, frame));
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
        return null;
    }

    private static void buildFunctionScope(Node node, Frame frame, NodeLibrary nodeLibrary, Scope.Builder scopeBuilder, Object variablesWithReceiver) {
        scopeBuilder.node(node.getRootNode());
        Object arguments = LegacyScopesBridge.getArguments(node, frame);
        if (arguments != null) {
            scopeBuilder.arguments(arguments);
        }
        if (nodeLibrary.hasReceiverMember(node, frame)) {
            try {
                String receiverName = InteropLibrary.getUncached().asString(nodeLibrary.getReceiverMember(node, frame));
                Object receiverValue = null;
                if (InteropLibrary.getUncached().isMemberReadable(variablesWithReceiver, receiverName)) {
                    receiverValue = InteropLibrary.getUncached().readMember(variablesWithReceiver, receiverName);
                }
                scopeBuilder.receiver(receiverName, receiverValue);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
        if (nodeLibrary.hasRootInstance(node, frame)) {
            try {
                Object rootInstance = nodeLibrary.getRootInstance(node, frame);
                if (rootInstance != null) {
                    scopeBuilder.rootInstance(rootInstance);
                }
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere(ex);
            }
        }
    }

    static Iterable<Scope> topScopesToLegacy(Object scopeObjectOriginal) {
        ArrayList<Scope> scopes = new ArrayList<Scope>(3);
        Object scopeObject = scopeObjectOriginal;
        while (scopeObject != null) {
            String name;
            InteropLibrary scopeInterop = InteropLibrary.getUncached(scopeObject);
            Object scopeParent = null;
            if (scopeInterop.hasScopeParent(scopeObject)) {
                try {
                    scopeParent = scopeInterop.getScopeParent(scopeObject);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere(ex);
                }
            }
            Object variables = scopeParent != null ? new SubtractedVariables(scopeObject, scopeParent, null) : scopeObject;
            try {
                name = InteropLibrary.getUncached().asString(scopeInterop.toDisplayString(scopeObject));
            }
            catch (UnsupportedMessageException ex) {
                name = "global";
            }
            Scope.Builder scopeBuilder = Scope.newBuilder(name, variables);
            scopes.add(scopeBuilder.build());
            scopeObject = scopeParent;
        }
        return scopes;
    }

    private static Object getArguments(Node node, Frame frame) {
        Node n;
        for (n = node; !(n == null || n instanceof InstrumentableNode && ((InstrumentableNode)((Object)n)).hasTag(StandardTags.RootTag.class)); n = n.getParent()) {
        }
        if (n == null || !NodeLibrary.getUncached().hasScope(n, frame)) {
            return null;
        }
        try {
            Object argScope = NodeLibrary.getUncached().getScope(n, frame, true);
            String receiverName = LegacyScopesBridge.getReceiverName(NodeLibrary.getUncached(), n, frame);
            if (InteropLibrary.getUncached().hasScopeParent(argScope)) {
                argScope = new SubtractedVariables(argScope, InteropLibrary.getUncached().getScopeParent(argScope), receiverName);
            } else if (receiverName != null) {
                argScope = new NoReceiverVariables(argScope, receiverName);
            }
            return argScope;
        }
        catch (UnsupportedMessageException e) {
            return null;
        }
    }

    static boolean legacyScopesHasScope(NodeInterface node, Iterator<Scope> legacyScopes) {
        assert (legacyScopes.hasNext());
        if (node instanceof InstrumentableNode && ((InstrumentableNode)node).hasTag(StandardTags.RootTag.class)) {
            while (legacyScopes.hasNext()) {
                Scope scope = legacyScopes.next();
                if (scope.getNode() != null && !(scope.getNode() instanceof RootNode)) continue;
                return scope.getArguments() != null;
            }
        }
        return true;
    }

    static Object legacyScopes2ScopeObject(NodeInterface node, Iterator<Scope> legacyScopes, Class<? extends TruffleLanguage<?>> language) {
        if (!legacyScopes.hasNext()) {
            return new EmptyObject(language);
        }
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Scope> scopesList = new ArrayList<Scope>(5);
        if (node instanceof InstrumentableNode && ((InstrumentableNode)node).hasTag(StandardTags.RootTag.class)) {
            while (legacyScopes.hasNext()) {
                Scope scope = legacyScopes.next();
                scopesList.add(scope);
                if (scope.getNode() != null && !(scope.getNode() instanceof RootNode)) continue;
                Object argumentsObj = scope.getArguments();
                if (argumentsObj == null) {
                    return null;
                }
                return new MergedScopes(new Scope[]{scope}, new Object[]{argumentsObj}, language);
            }
        } else {
            while (legacyScopes.hasNext()) {
                scopesList.add(legacyScopes.next());
            }
        }
        Scope[] scopes = scopesList.toArray(new Scope[scopesList.size()]);
        Object[] variables = new Object[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            variables[i] = scopes[i].getVariables();
        }
        return new MergedScopes(scopes, variables, language);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MergedVarNames
    implements TruffleObject {
        private final Object[] keys;
        private final long[] size;
        private final String receiverName;

        private MergedVarNames(Object[] keys, String receiverName) throws UnsupportedMessageException {
            this.keys = keys;
            this.receiverName = receiverName;
            this.size = new long[keys.length];
            long s2 = 0L;
            InteropLibrary interop = InteropLibrary.getUncached();
            for (int i = 0; i < keys.length; ++i) {
                s2 += interop.getArraySize(keys[i]);
                if (i != 0 || receiverName != null) {
                    // empty if block
                }
                this.size[i] = ++s2;
            }
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.size[this.size.length - 1];
        }

        @ExportMessage
        boolean isArrayElementReadable(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop) {
            if (index >= 0L) {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (index >= this.size[i]) continue;
                    if (this.receiverName != null && i == 0 && index == this.size[0] - 1L) {
                        return true;
                    }
                    long start = i == 0 ? 0L : this.size[i - 1];
                    return interop.isArrayElementReadable(this.keys[i], index - start);
                }
            }
            return false;
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
            if (index >= 0L) {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (index >= this.size[i]) continue;
                    if (this.receiverName != null && i == 0 && index == this.size[0] - 1L) {
                        return this.receiverName;
                    }
                    long start = i == 0 ? 0L : this.size[i - 1];
                    return interop.readArrayElement(this.keys[i], index - start);
                }
            }
            throw InvalidArrayIndexException.create(index);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MergedScopes
    implements TruffleObject {
        static final int LIMIT = 5;
        private final Scope[] scopes;
        private final Object[] variables;
        private final int scopeIndex;
        private final String receiverName;
        private final Class<? extends TruffleLanguage<?>> language;
        private volatile SourceSection cachedSourceLocation;
        private volatile boolean hasCachedSourceLocation = false;

        MergedScopes(Scope[] scopes, Object[] variables, Class<? extends TruffleLanguage<?>> language) {
            this(scopes, variables, 0, language);
        }

        private MergedScopes(Scope[] scopes, Object[] variables, int scopeIndex, Class<? extends TruffleLanguage<?>> language) {
            this.scopes = scopes;
            this.variables = variables;
            this.scopeIndex = scopeIndex;
            String aReceiverName = null;
            if (scopeIndex == 0) {
                for (int i = 0; i < scopes.length; ++i) {
                    if (scopes[i].getReceiverName() == null) continue;
                    aReceiverName = scopes[i].getReceiverName();
                    break;
                }
            }
            this.receiverName = aReceiverName;
            this.language = language;
        }

        private Object getReceiverValue() {
            for (int i = this.scopeIndex; i < this.scopes.length; ++i) {
                if (this.scopes[i].getReceiverName() == null) continue;
                return this.scopes[i].getReceiver();
            }
            return null;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return this.language;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        Object toDisplayString(boolean allowSideEffects) {
            return this.scopes[this.scopeIndex].getName();
        }

        @ExportMessage
        boolean hasSourceLocation() {
            Node node = this.scopes[this.scopeIndex].getNode();
            if (node == null) {
                return false;
            }
            CompilerDirectives.transferToInterpreter();
            return this.getSourceSection(node) != null;
        }

        @ExportMessage
        SourceSection getSourceLocation() throws UnsupportedMessageException {
            Node node = this.scopes[this.scopeIndex].getNode();
            if (node != null) {
                CompilerDirectives.transferToInterpreter();
                SourceSection section = this.getSourceSection(node);
                if (section != null) {
                    return section;
                }
                throw UnsupportedMessageException.create();
            }
            throw UnsupportedMessageException.create();
        }

        private SourceSection getSourceSection(Node node) {
            assert (CompilerDirectives.inInterpreter());
            if (this.hasCachedSourceLocation) {
                return this.cachedSourceLocation;
            }
            SourceSection section = null;
            if (node instanceof RootNode && node.getSourceSection() == null) {
                final SourceSection[] rootSection = new SourceSection[]{null};
                node.accept(new NodeVisitor(){

                    @Override
                    public boolean visit(Node n) {
                        InstrumentableNode inode;
                        if (n instanceof InstrumentableNode && (inode = (InstrumentableNode)((Object)n)).isInstrumentable() && inode.hasTag(StandardTags.RootTag.class)) {
                            rootSection[0] = n.getSourceSection();
                            return false;
                        }
                        return true;
                    }
                });
                section = rootSection[0];
            } else {
                section = node.getSourceSection();
            }
            this.cachedSourceLocation = section;
            this.hasCachedSourceLocation = true;
            return section;
        }

        @ExportMessage
        boolean hasScopeParent() {
            return this.scopeIndex < this.scopes.length - 1;
        }

        @ExportMessage
        Object getScopeParent() throws UnsupportedMessageException {
            if (this.scopeIndex < this.scopes.length - 1) {
                return new MergedScopes(this.scopes, this.variables, this.scopeIndex + 1, this.language);
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        boolean hasMembers(@Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object vars = this.variables[i];
                if (!interop.hasMembers(vars)) continue;
                return true;
            }
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop) throws UnsupportedMessageException {
            int length = this.scopes.length;
            Object[] keys = new Object[length - this.scopeIndex];
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                keys[i - this.scopeIndex] = interop.getMembers(scope);
            }
            return new MergedVarNames(keys, this.receiverName);
        }

        @ExportMessage
        boolean isMemberReadable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            if (member.equals(this.receiverName)) {
                return this.getReceiverValue() != null;
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (!interop.isMemberReadable(scope, member)) continue;
                return true;
            }
            return false;
        }

        @ExportMessage
        Object readMember(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) throws UnknownIdentifierException, UnsupportedMessageException {
            if (member.equals(this.receiverName)) {
                return this.getReceiverValue();
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (!interop.isMemberReadable(scope, member)) continue;
                return interop.readMember(scope, member);
            }
            throw UnknownIdentifierException.create(member);
        }

        @ExportMessage
        boolean isMemberModifiable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            if (member.equals(this.receiverName)) {
                return false;
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (!interop.isMemberModifiable(scope, member)) continue;
                return true;
            }
            return false;
        }

        @ExportMessage
        boolean isMemberInsertable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            if (member.equals(this.receiverName)) {
                return false;
            }
            int length = lengthProfile.profile(this.scopes.length);
            boolean wasInsertable = false;
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (interop.isMemberExisting(scope, member)) {
                    return false;
                }
                if (!interop.isMemberInsertable(scope, member)) continue;
                wasInsertable = true;
            }
            return wasInsertable;
        }

        @ExportMessage
        boolean hasMemberReadSideEffects(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            if (member.equals(this.receiverName)) {
                return false;
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (!interop.isMemberReadable(scope, member)) continue;
                return interop.hasMemberReadSideEffects(scope, member);
            }
            return false;
        }

        @ExportMessage
        boolean hasMemberWriteSideEffects(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            if (member.equals(this.receiverName)) {
                return false;
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (!interop.isMemberWritable(scope, member)) continue;
                return interop.hasMemberWriteSideEffects(scope, member);
            }
            return false;
        }

        @ExportMessage
        void writeMember(String member, Object value, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) throws UnknownIdentifierException, UnsupportedMessageException, UnsupportedTypeException {
            if (member.equals(this.receiverName)) {
                throw UnsupportedMessageException.create();
            }
            int length = lengthProfile.profile(this.scopes.length);
            Object firstInsertableScope = null;
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (interop.isMemberExisting(scope, member)) {
                    if (interop.isMemberModifiable(scope, member)) {
                        interop.writeMember(scope, member, value);
                        return;
                    }
                    throw UnsupportedMessageException.create();
                }
                if (!interop.isMemberInsertable(scope, member) || firstInsertableScope != null) continue;
                firstInsertableScope = scope;
            }
            if (firstInsertableScope != null) {
                interop.writeMember(firstInsertableScope, member, value);
                return;
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        boolean isMemberRemovable(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) {
            if (member.equals(this.receiverName)) {
                return false;
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = this.scopeIndex; i < length; ++i) {
                Object scope = this.variables[i];
                if (interop.isMemberRemovable(scope, member)) {
                    return true;
                }
                if (!interop.isMemberExisting(scope, member)) continue;
                return false;
            }
            return false;
        }

        @ExportMessage
        void removeMember(String member, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached(value="createIdentityProfile()") IntValueProfile lengthProfile) throws UnsupportedMessageException, UnknownIdentifierException {
            if (member.equals(this.receiverName)) {
                throw UnsupportedMessageException.create();
            }
            int length = lengthProfile.profile(this.scopes.length);
            for (int i = 0; i < length; ++i) {
                Object scope = this.variables[i];
                if (interop.isMemberRemovable(scope, member)) {
                    interop.removeMember(scope, member);
                    return;
                }
                if (interop.isMemberExisting(scope, member)) break;
            }
            throw UnsupportedMessageException.create();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class SubtractedKeys
    implements TruffleObject {
        private final Object allKeys;
        private final long allSize;
        private final long removedSize;
        private final long size;

        SubtractedKeys(Object allKeys, Object removedKeys, String receiverNameOrig) throws UnsupportedMessageException {
            this.allKeys = allKeys;
            this.allSize = INTEROP.getArraySize(allKeys);
            this.removedSize = INTEROP.getArraySize(removedKeys);
            String receiverName = receiverNameOrig;
            if (receiverName != null) {
                long receiverIndex = this.allSize - this.removedSize - 1L;
                if (receiverIndex < 0L) {
                    receiverName = null;
                } else {
                    try {
                        if (!receiverName.equals(InteropLibrary.getUncached().readArrayElement(allKeys, receiverIndex))) {
                            receiverName = null;
                        }
                    }
                    catch (InteropException e) {
                        CompilerDirectives.shouldNotReachHere(e);
                    }
                }
            }
            this.size = this.allSize - this.removedSize - (long)(receiverName != null ? 1 : 0);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.size;
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="1") InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
            if (0L <= index && index < this.getArraySize()) {
                return interop.readArrayElement(this.allKeys, index);
            }
            throw InvalidArrayIndexException.create(index);
        }

        @ExportMessage
        boolean isArrayElementReadable(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="1") InteropLibrary interop) {
            if (0L <= index && index < this.getArraySize()) {
                return interop.isArrayElementReadable(this.allKeys, index);
            }
            return false;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static class SubtractedVariables
    implements TruffleObject {
        private final Object allVariables;
        private final InteropLibrary allLibrary;
        private final Object removedVariables;
        private final InteropLibrary removedLibrary;
        private final String receiverName;

        SubtractedVariables(Object allVariables, Object removedVariables, String receiverName) {
            this.allVariables = allVariables;
            this.allLibrary = InteropLibrary.getUncached(allVariables);
            this.removedVariables = removedVariables;
            this.removedLibrary = InteropLibrary.getUncached(removedVariables);
            this.receiverName = receiverName;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMembers() {
            return this.allLibrary.hasMembers(this.allVariables) && this.removedLibrary.hasMembers(this.removedVariables);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
            return new SubtractedKeys(this.allLibrary.getMembers(this.allVariables, includeInternal), this.removedLibrary.getMembers(this.removedVariables, includeInternal), this.receiverName);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean isMemberReadable(String member) {
            if (this.receiverName != null && this.receiverName.equals(member)) {
                return false;
            }
            if (!this.allLibrary.isMemberReadable(this.allVariables, member)) {
                return false;
            }
            if (!this.removedLibrary.isMemberReadable(this.removedVariables, member)) {
                return true;
            }
            return this.isAmongMembers(member);
        }

        private boolean isAmongMembers(String member) {
            try {
                Object members = this.getMembers(true);
                InteropLibrary membersLibrary = InteropLibrary.getUncached(members);
                long n = membersLibrary.getArraySize(members);
                for (long i = 0L; i < n; ++i) {
                    String m3 = InteropLibrary.getUncached().asString(membersLibrary.readArrayElement(members, i));
                    if (!member.equals(m3)) continue;
                    return true;
                }
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final Object readMember(String member) throws UnknownIdentifierException, UnsupportedMessageException {
            if (this.isMemberReadable(member)) {
                return this.allLibrary.readMember(this.allVariables, member);
            }
            throw UnknownIdentifierException.create(member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean isMemberModifiable(String member) {
            if (this.receiverName != null && this.receiverName.equals(member)) {
                return false;
            }
            if (!this.allLibrary.isMemberModifiable(this.allVariables, member)) {
                return false;
            }
            if (!this.removedLibrary.isMemberModifiable(this.removedVariables, member)) {
                return true;
            }
            return this.isAmongMembers(member);
        }

        @ExportMessage
        final boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final void writeMember(String member, Object value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
            if (!this.isMemberModifiable(member)) {
                throw UnknownIdentifierException.create(member);
            }
            this.allLibrary.writeMember(this.allVariables, member, value);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMemberReadSideEffects(String member) {
            return this.isMemberReadable(member) && this.allLibrary.hasMemberReadSideEffects(this.allVariables, member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMemberWriteSideEffects(String member) {
            return this.isMemberModifiable(member) && this.allLibrary.hasMemberWriteSideEffects(this.allVariables, member);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class SubtractedReceiver
    implements TruffleObject {
        private final Object allKeys;
        private final long allSize;

        SubtractedReceiver(Object allKeys) throws UnsupportedMessageException {
            this.allKeys = allKeys;
            this.allSize = INTEROP.getArraySize(allKeys);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.allSize - 1L;
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="1") InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
            if (0L <= index && index < this.getArraySize()) {
                return interop.readArrayElement(this.allKeys, index);
            }
            throw InvalidArrayIndexException.create(index);
        }

        @ExportMessage
        boolean isArrayElementReadable(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="1") InteropLibrary interop) {
            if (0L <= index && index < this.getArraySize()) {
                return interop.isArrayElementReadable(this.allKeys, index);
            }
            return false;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static class NoReceiverVariables
    implements TruffleObject {
        private final Object allVariables;
        private final InteropLibrary allLibrary;
        private final String receiverName;

        NoReceiverVariables(Object allVariables, String receiverName) {
            this.allVariables = allVariables;
            this.allLibrary = InteropLibrary.getUncached(allVariables);
            assert (receiverName != null);
            this.receiverName = receiverName;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMembers() {
            return this.allLibrary.hasMembers(this.allVariables);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
            return new SubtractedReceiver(this.allLibrary.getMembers(this.allVariables, includeInternal));
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean isMemberReadable(String member) {
            if (this.receiverName.equals(member)) {
                return false;
            }
            return this.allLibrary.isMemberReadable(this.allVariables, member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final Object readMember(String member) throws UnknownIdentifierException, UnsupportedMessageException {
            if (this.isMemberReadable(member)) {
                return this.allLibrary.readMember(this.allVariables, member);
            }
            throw UnknownIdentifierException.create(member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean isMemberModifiable(String member) {
            if (this.receiverName.equals(member)) {
                return false;
            }
            return this.allLibrary.isMemberModifiable(this.allVariables, member);
        }

        @ExportMessage
        final boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final void writeMember(String member, Object value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
            if (!this.isMemberModifiable(member)) {
                throw UnknownIdentifierException.create(member);
            }
            this.allLibrary.writeMember(this.allVariables, member, value);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMemberReadSideEffects(String member) {
            return this.isMemberReadable(member) && this.allLibrary.hasMemberReadSideEffects(this.allVariables, member);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean hasMemberWriteSideEffects(String member) {
            return this.isMemberModifiable(member) && this.allLibrary.hasMemberWriteSideEffects(this.allVariables, member);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static class EmptyKeys
    implements TruffleObject {
        EmptyKeys() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 0L;
        }

        @ExportMessage
        final boolean isArrayElementReadable(long index) {
            return false;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            throw InvalidArrayIndexException.create(index);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static class EmptyObject
    implements TruffleObject {
        private final Class<? extends TruffleLanguage<?>> language;

        EmptyObject(Class<? extends TruffleLanguage<?>> language) {
            this.language = language;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return this.language;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return new EmptyKeys();
        }

        @ExportMessage
        final Object toDisplayString(boolean allowSideEffects) {
            return "empty";
        }
    }
}

