/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotManagement;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotSource;
import com.oracle.truffle.polyglot.PolyglotSourceSection;
import com.oracle.truffle.polyglot.PolyglotTargetMapping;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.proxy.Proxy;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object[] EMPTY_ARGS = new Object[0];
    static final String OPTION_GROUP_ENGINE = "engine";
    static final String PROP_ALLOW_EXPERIMENTAL_OPTIONS = "polyglot.engine.AllowExperimentalOptions";
    private static final HostException STACKOVERFLOW_ERROR = new HostException(new StackOverflowError(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    });
    private final PolyglotSource sourceImpl = new PolyglotSource(this);
    private final PolyglotSourceSection sourceSectionImpl = new PolyglotSourceSection(this);
    private final PolyglotManagement executionListenerImpl = new PolyglotManagement(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();
    private final Function<Source, org.graalvm.polyglot.Source> sourceConstructor = new Function<Source, org.graalvm.polyglot.Source>(){

        @Override
        public org.graalvm.polyglot.Source apply(Source t) {
            return PolyglotImpl.this.getAPIAccess().newSource(t);
        }
    };
    final Map<Class<?>, PolyglotValue> primitiveValues = new HashMap();
    Value hostNull;
    PolyglotValue disconnectedHostValue;
    static volatile PolyglotImpl polyglotImpl;

    public PolyglotImpl() {
        assert (polyglotImpl == null);
        polyglotImpl = this;
    }

    static PolyglotImpl getInstance() {
        if (polyglotImpl == null) {
            try {
                Method f = Engine.class.getDeclaredMethod("getImpl", new Class[0]);
                f.setAccessible(true);
                f.invoke(null, new Object[0]);
                assert (polyglotImpl != null);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return polyglotImpl;
    }

    @Override
    protected void initialize() {
        this.hostNull = this.getAPIAccess().newValue(HostObject.NULL, PolyglotValue.createHostNull(this));
        PolyglotValue.createDefaultValues(this, null, this.primitiveValues);
        this.disconnectedHostValue = new PolyglotValue.HostValue(this);
    }

    @Override
    public Context getLimitEventContext(Object impl) {
        return (Context)impl;
    }

    @Override
    public Object buildLimits(long statementLimit, Predicate<org.graalvm.polyglot.Source> statementLimitSourceFilter, Consumer<ResourceLimitEvent> onLimit) {
        try {
            return new PolyglotLimits(statementLimit, statementLimitSourceFilter, onLimit);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    @Override
    public AbstractPolyglotImpl.AbstractSourceImpl getSourceImpl() {
        return this.sourceImpl;
    }

    @Override
    public AbstractPolyglotImpl.AbstractSourceSectionImpl getSourceSectionImpl() {
        return this.sourceSectionImpl;
    }

    @Override
    public AbstractPolyglotImpl.AbstractManagementImpl getManagementImpl() {
        return this.executionListenerImpl;
    }

    @Override
    public Context getCurrentContext() {
        try {
            PolyglotContextImpl context = PolyglotContextImpl.currentNotEntered();
            if (context == null) {
                throw PolyglotEngineException.illegalState("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
            }
            return context.currentApi;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    @Override
    public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> originalOptions, boolean useSystemProperties, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandlerOrStream, HostAccess conf) {
        PolyglotEngineImpl impl = null;
        try {
            Engine engine;
            PolyglotLoggers.EngineLoggerProvider loggerProvider;
            PolyglotEngineImpl.LogConfig logConfig;
            OptionValuesImpl engineOptions;
            if (TruffleOptions.AOT) {
                EngineAccessor.ACCESSOR.initializeNativeImageTruffleLocator();
            }
            OutputStream resolvedOut = out == null ? System.out : out;
            OutputStream resolvedErr = err == null ? System.err : err;
            InputStream resolvedIn = in == null ? System.in : in;
            DispatchOutputStream dispatchOut = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
            DispatchOutputStream dispatchErr = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
            Handler logHandler = PolyglotLoggers.asHandler(logHandlerOrStream);
            ClassLoader contextClassLoader = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
            boolean useAllowExperimentalOptions = allowExperimentalOptions || Boolean.parseBoolean(EngineAccessor.RUNTIME.getSavedProperty(PROP_ALLOW_EXPERIMENTAL_OPTIONS));
            HashMap<String, String> options = new HashMap<String, String>(originalOptions);
            if (useSystemProperties) {
                PolyglotEngineImpl.readOptionsFromSystemProperties(options);
            }
            if ((impl = (PolyglotEngineImpl)EngineAccessor.RUNTIME.tryLoadCachedEngine(engineOptions = PolyglotImpl.createEngineOptions(options, logConfig = new PolyglotEngineImpl.LogConfig(), useAllowExperimentalOptions), loggerProvider = new PolyglotLoggers.EngineLoggerProvider(logHandler = logHandler != null ? logHandler : PolyglotEngineImpl.createLogHandler(logConfig, dispatchErr), logConfig.logLevels, logConfig.logFile))) == null && boundEngine && !EngineAccessor.RUNTIME.isStoreEnabled(engineOptions)) {
                impl = this.preInitializedEngineRef.getAndSet(null);
            }
            if (impl != null && !impl.patch(dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig, loggerProvider, options, useAllowExperimentalOptions, contextClassLoader, boundEngine, logHandler)) {
                impl.ensureClosed(false, false);
                impl = null;
            }
            if (impl == null) {
                impl = new PolyglotEngineImpl(this, dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig.logLevels, loggerProvider, options, useAllowExperimentalOptions, contextClassLoader, boundEngine, false, messageInterceptor, logHandler);
            }
            loggerProvider.setEngine(impl);
            impl.creatorApi = engine = this.getAPIAccess().newEngine(impl);
            impl.currentApi = this.getAPIAccess().newEngine(impl);
            return engine;
        }
        catch (Throwable t) {
            if (impl == null) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
            throw PolyglotImpl.guestToHostException(impl, t);
        }
    }

    static OptionValuesImpl createEngineOptions(Map<String, String> options, PolyglotEngineImpl.LogConfig logOptions, boolean allowExperimentalOptions) {
        OptionDescriptors engineOptionDescriptors = PolyglotEngineImpl.createEngineOptionDescriptors();
        HashMap<String, String> engineOptions = new HashMap<String, String>();
        PolyglotEngineImpl.parseEngineOptions(options, engineOptions, logOptions);
        OptionValuesImpl values = new OptionValuesImpl(null, engineOptionDescriptors, true);
        values.putAll(engineOptions, allowExperimentalOptions);
        return values;
    }

    @Override
    public void preInitializeEngine() {
        PolyglotEngineImpl engine = this.createDefaultEngine();
        try {
            engine.preInitialize();
        }
        finally {
            LanguageCache.resetNativeImageCacheLanguageHomes();
            engine.logLevels.clear();
            engine.logHandler = null;
        }
        this.preInitializedEngineRef.set(engine);
    }

    PolyglotEngineImpl createDefaultEngine() {
        HashMap<String, String> options = new HashMap<String, String>();
        PolyglotEngineImpl.readOptionsFromSystemProperties(options);
        PolyglotEngineImpl.LogConfig logConfig = new PolyglotEngineImpl.LogConfig();
        OptionValuesImpl engineOptions = PolyglotImpl.createEngineOptions(options, logConfig, true);
        DispatchOutputStream out = EngineAccessor.INSTRUMENT.createDispatchOutput(System.out);
        DispatchOutputStream err = EngineAccessor.INSTRUMENT.createDispatchOutput(System.err);
        Handler logHandler = PolyglotEngineImpl.createLogHandler(logConfig, err);
        PolyglotLoggers.EngineLoggerProvider loggerProvider = new PolyglotLoggers.EngineLoggerProvider(logHandler, logConfig.logLevels, logConfig.logFile);
        PolyglotEngineImpl engine = new PolyglotEngineImpl(this, out, err, System.in, engineOptions, logConfig.logLevels, loggerProvider, options, true, TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader(), true, true, null, logHandler);
        loggerProvider.setEngine(engine);
        return engine;
    }

    @Override
    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
        PolyglotEngineImpl.resetPreInitializedEngine();
    }

    @Override
    public Class<?> loadLanguageClass(String className) {
        for (Supplier supplier : EngineAccessor.locatorOrDefaultLoaders()) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            try {
                Class<?> c = loader.loadClass(className);
                if (!TruffleOptions.AOT) {
                    EngineAccessor.JDKSERVICES.exportTo(loader, null);
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public Collection<Engine> findActiveEngines() {
        return PolyglotEngineImpl.findActiveEngines();
    }

    @Override
    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
        try {
            return new PolyglotTargetMapping(sourceType, targetType, acceptsValue, convertValue, precedence);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    Value asValue(PolyglotContextImpl currentContext, Object hostValue) {
        if (currentContext != null) {
            return currentContext.asValue(hostValue);
        }
        assert (!(hostValue instanceof Value));
        Object guestValue = null;
        if (hostValue == null) {
            return this.hostNull;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return this.getAPIAccess().newValue(hostValue, this.primitiveValues.get(hostValue.getClass()));
        }
        if (HostWrapper.isInstance(hostValue)) {
            HostWrapper hostWrapper = HostWrapper.asInstance(hostValue);
            PolyglotLanguageContext languageContext = hostWrapper.getLanguageContext();
            assert (languageContext != null) : "HostWrappers must be guaranteed to have non-null language context.";
            guestValue = hostWrapper.getGuestObject();
            return languageContext.asValue(guestValue);
        }
        guestValue = hostValue instanceof TruffleObject ? hostValue : (hostValue instanceof Proxy ? PolyglotProxy.toProxyGuestObject((Proxy)hostValue) : (hostValue instanceof Class ? HostObject.forClass((Class)hostValue, null) : HostObject.forObject(hostValue, null)));
        return this.getAPIAccess().newValue(guestValue, this.disconnectedHostValue);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Value asValue(Object hostValue) {
        try {
            PolyglotContextImpl currentContext = PolyglotContextImpl.currentNotEntered();
            return this.asValue(currentContext, hostValue);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    @Override
    public FileSystem newDefaultFileSystem() {
        return FileSystems.newDefaultFileSystem();
    }

    org.graalvm.polyglot.Source getOrCreatePolyglotSource(Source source) {
        return EngineAccessor.SOURCE.getOrCreatePolyglotSource(source, this.sourceConstructor);
    }

    org.graalvm.polyglot.SourceSection getPolyglotSourceSection(SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        org.graalvm.polyglot.Source polyglotSource = this.getOrCreatePolyglotSource(sourceSection.getSource());
        return this.getAPIAccess().newSourceSection(polyglotSource, sourceSection);
    }

    static <T extends Throwable> RuntimeException hostToGuestException(PolyglotLanguageContext context, T e) {
        return PolyglotImpl.hostToGuestException(context.context, e);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException hostToGuestException(PolyglotContextImpl context, T e) {
        assert (!(e instanceof PolyglotEngineException)) : "engine exceptions not expected here";
        assert (!(e instanceof HostException)) : "host exceptions not expected here";
        if (e instanceof ThreadDeath) {
            throw (ThreadDeath)e;
        }
        if (e instanceof PolyglotException) {
            PolyglotException polyglot = (PolyglotException)e;
            if (context != null) {
                PolyglotExceptionImpl exceptionImpl = (PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl(polyglot);
                if (exceptionImpl.context == context || exceptionImpl.context == null || exceptionImpl.isHostException()) {
                    Throwable original = ((PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl((PolyglotException)polyglot)).exception;
                    if (original instanceof RuntimeException) {
                        throw (RuntimeException)original;
                    }
                    if (original instanceof Error) {
                        throw (Error)original;
                    }
                }
            }
        }
        try {
            return new HostException(e);
        }
        catch (StackOverflowError stack) {
            return STACKOVERFLOW_ERROR;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToLanguageException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest language";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToInstrumentException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest instrument";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotLanguageContext languageContext, T e, boolean entered) {
        PolyglotExceptionImpl exceptionImpl;
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e;
        PolyglotEngineException.rethrow(e);
        if (languageContext == null) {
            throw new RuntimeException(e);
        }
        PolyglotContextImpl context = languageContext.context;
        if (context.closed || context.invalid) {
            exceptionImpl = new PolyglotExceptionImpl(context.engine, e);
        } else {
            try {
                exceptionImpl = new PolyglotExceptionImpl(languageContext.getImpl(), languageContext.context.engine, languageContext, e, true, entered);
            }
            catch (Throwable t) {
                e.addSuppressed(t);
                exceptionImpl = new PolyglotExceptionImpl(context.engine, e);
            }
        }
        AbstractPolyglotImpl.APIAccess access = PolyglotImpl.getInstance().getAPIAccess();
        return access.newLanguageException(exceptionImpl.getMessage(), exceptionImpl);
    }

    static <T extends Throwable> PolyglotException guestToHostException(PolyglotEngineImpl engine, T e) {
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e;
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = engine.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, e);
        return access.newLanguageException(exceptionImpl.getMessage(), exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException guestToHostException(PolyglotImpl polyglot, T e) {
        assert (!(e instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the host: " + e;
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = polyglot.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(polyglot, e);
        return access.newLanguageException(exceptionImpl.getMessage(), exceptionImpl);
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String;
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        default public PolyglotImpl getImpl() {
            return this.getEngine().impl;
        }

        default public AbstractPolyglotImpl.APIAccess getAPIAccess() {
            return this.getEngine().impl.getAPIAccess();
        }
    }
}

