/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotValueFactory;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class PolyglotValue
extends AbstractPolyglotImpl.AbstractValueImpl {
    private static final String TRUNCATION_SUFFIX = "...";
    private static final String UNKNOWN = "Unknown";
    protected final PolyglotLanguageContext languageContext;
    static final InteropLibrary UNCACHED_INTEROP = InteropLibrary.getFactory().getUncached();
    private static final int CHARACTER_LIMIT = 140;
    private static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();

    PolyglotValue(PolyglotLanguageContext languageContext) {
        super(languageContext.getEngine().impl);
        this.languageContext = languageContext;
    }

    PolyglotValue(PolyglotImpl polyglot, PolyglotLanguageContext languageContext) {
        super(polyglot);
        this.languageContext = languageContext;
    }

    @Override
    public final Context getContext() {
        if (this.languageContext == null) {
            return null;
        }
        return this.languageContext.context.currentApi;
    }

    @Override
    public Value getArrayElement(Object receiver, long index) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.getArrayElementUnsupported(this.languageContext, receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final Value getArrayElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getArrayElement(long)", "hasArrayElements()");
    }

    @Override
    public void setArrayElement(Object receiver, long index, Object value) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.setArrayElementUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void setArrayElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "setArrayElement(long, Object)", "hasArrayElements()");
    }

    @Override
    public boolean removeArrayElement(Object receiver, long index) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.removeArrayElementUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException removeArrayElementUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "removeArrayElement(long, Object)", null);
    }

    @Override
    public long getArraySize(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            long l = PolyglotValue.getArraySizeUnsupported(this.languageContext, receiver);
            return l;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static long getArraySizeUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "getArraySize()", "hasArrayElements()");
    }

    @Override
    public Value getMember(Object receiver, String key) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.getMemberUnsupported(this.languageContext, receiver, key);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value getMemberUnsupported(PolyglotLanguageContext context, Object receiver, String key) {
        throw PolyglotValue.unsupported(context, receiver, "getMember(String)", "hasMembers()");
    }

    @Override
    public void putMember(Object receiver, String key, Object member) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.putMemberUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException putMemberUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "putMember(String, Object)", "hasMembers()");
    }

    @Override
    public boolean removeMember(Object receiver, String key) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.removeMemberUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException removeMemberUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "removeMember(String, Object)", null);
    }

    @Override
    public Value execute(Object receiver, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.executeUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @Override
    public Value execute(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.executeUnsupported(this.languageContext, receiver);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException executeUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "execute(Object...)", "canExecute()");
    }

    @Override
    public Value newInstance(Object receiver, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = PolyglotValue.newInstanceUnsupported(this.languageContext, receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value newInstanceUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "newInstance(Object...)", "canInstantiate()");
    }

    @Override
    public void executeVoid(Object receiver, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.executeVoidUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public void executeVoid(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            PolyglotValue.executeVoidUnsupported(this.languageContext, receiver);
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void executeVoidUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.unsupported(context, receiver, "executeVoid(Object...)", "canExecute()");
    }

    @Override
    public Value invoke(Object receiver, String identifier, Object[] arguments) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.invokeUnsupported(this.languageContext, receiver, identifier);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @Override
    public Value invoke(Object receiver, String identifier) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.invokeUnsupported(this.languageContext, receiver, identifier);
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invokeUnsupported(PolyglotLanguageContext context, Object receiver, String identifier) {
        throw PolyglotValue.unsupported(context, receiver, "invoke(" + identifier + ", Object...)", "canInvoke(String)");
    }

    @Override
    public String asString(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            String string = this.asStringUnsupported(receiver);
            return string;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final String asStringUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, String.class, "asString()", "isString()", "Invalid coercion.");
    }

    @Override
    public boolean asBoolean(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            boolean bl = this.asBooleanUnsupported(receiver);
            return bl;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    private static boolean isNullUncached(Object receiver) {
        return InteropLibrary.getFactory().getUncached().isNull(receiver);
    }

    protected final boolean asBooleanUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Boolean.TYPE, "asBoolean()", "isBoolean()", "Invalid or lossy primitive coercion.");
    }

    private <T> T invalidCastPrimitive(Object receiver, Class<T> clazz, String asMethodName, String isMethodName, String detail) {
        assert (this.languageContext == null || !this.languageContext.context.engine.needsEnter(this.languageContext.context));
        if (PolyglotValue.isNullUncached(receiver)) {
            throw PolyglotValue.nullCoercion(this.languageContext, receiver, clazz, asMethodName, isMethodName);
        }
        throw PolyglotValue.cannotConvert(this.languageContext, receiver, clazz, asMethodName, isMethodName, detail);
    }

    @Override
    public int asInt(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            int n = this.asIntUnsupported(receiver);
            return n;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final int asIntUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Integer.TYPE, "asInt()", "fitsInInt()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public long asLong(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            long l = this.asLongUnsupported(receiver);
            return l;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final long asLongUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Long.TYPE, "asLong()", "fitsInLong()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public double asDouble(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            double d = this.asDoubleUnsupported(receiver);
            return d;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final double asDoubleUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Double.TYPE, "asDouble()", "fitsInDouble()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public float asFloat(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            float f = this.asFloatUnsupported(receiver);
            return f;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final float asFloatUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Float.TYPE, "asFloat()", "fitsInFloat()", "Invalid or lossy primitive coercion.").floatValue();
    }

    @Override
    public byte asByte(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            byte by = this.asByteUnsupported(receiver);
            return by;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final byte asByteUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Byte.TYPE, "asByte()", "fitsInByte()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public short asShort(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            short s2 = this.asShortUnsupported(receiver);
            return s2;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final short asShortUnsupported(Object receiver) {
        return this.invalidCastPrimitive(receiver, Short.TYPE, "asShort()", "fitsInShort()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public long asNativePointer(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            long l = PolyglotValue.asNativePointerUnsupported(this.languageContext, receiver);
            return l;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    static long asNativePointerUnsupported(PolyglotLanguageContext context, Object receiver) {
        throw PolyglotValue.cannotConvert(context, receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
    }

    @Override
    public Object asHostObject(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Object object = this.asHostObjectUnsupported(receiver);
            return object;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final Object asHostObjectUnsupported(Object receiver) {
        throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asHostObject()", "isHostObject()", "Value is not a host object.");
    }

    @Override
    public Object asProxyObject(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Object object = this.asProxyObjectUnsupported(receiver);
            return object;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected final Object asProxyObjectUnsupported(Object receiver) {
        throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asProxyObject()", "isProxyObject()", "Value is not a proxy object.");
    }

    @Override
    public LocalDate asDate(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                LocalDate localDate = null;
                return localDate;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asDate()", "isDate()", "Value does not contain date information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public LocalTime asTime(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                LocalTime localTime = null;
                return localTime;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asTime()", "isTime()", "Value does not contain time information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public ZoneId asTimeZone(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                ZoneId zoneId = null;
                return zoneId;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asTimeZone()", "isTimeZone()", "Value does not contain time zone information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public Instant asInstant(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                Instant instant = null;
                return instant;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asInstant()", "isInstant()", "Value does not contain instant information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public Duration asDuration(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            if (PolyglotValue.isNullUncached(receiver)) {
                Duration duration = null;
                return duration;
            }
            try {
                throw PolyglotValue.cannotConvert(this.languageContext, receiver, null, "asDuration()", "isDuration()", "Value does not contain duration information.");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public RuntimeException throwException(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "throwException()", "isException()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @Override
    public final Value getMetaObject(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            Value value = this.getMetaObjectImpl(receiver);
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected Value getMetaObjectImpl(Object receiver) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        if (lib.hasMetaObject(receiver)) {
            try {
                return this.asValue(lib.getMetaObject(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere("Unexpected unsupported message.", e);
            }
        }
        return null;
    }

    private Value asValue(Object value) {
        if (this.languageContext == null) {
            return PolyglotImpl.getInstance().asValue(PolyglotContextImpl.currentNotEntered(), value);
        }
        return this.languageContext.asValue(value);
    }

    static Object hostEnter(PolyglotLanguageContext languageContext) {
        if (languageContext == null) {
            return null;
        }
        try {
            return languageContext.context.engine.enterIfNeeded(languageContext.context);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, false);
        }
    }

    static void hostLeave(PolyglotLanguageContext languageContext, Object prev) {
        if (languageContext == null) {
            return;
        }
        try {
            languageContext.context.engine.leaveIfNeeded(prev, languageContext.context);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t, false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException unsupported(PolyglotLanguageContext languageContext, Object receiver, String message, String useToCheck) {
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        String polyglotMessage = useToCheck != null ? String.format("Unsupported operation %s.%s for %s. You can ensure that the operation is supported using %s.%s.", Value.class.getSimpleName(), message, PolyglotValue.getValueInfo(languageContext, receiver), Value.class.getSimpleName(), useToCheck) : String.format("Unsupported operation %s.%s for %s.", Value.class.getSimpleName(), message, PolyglotValue.getValueInfo(languageContext, receiver));
        throw PolyglotEngineException.unsupported(polyglotMessage);
    }

    @CompilerDirectives.TruffleBoundary
    static String getValueInfo(PolyglotLanguageContext languageContext, Object receiver) {
        String valueToString;
        Object view;
        if (languageContext == null) {
            return receiver.toString();
        }
        if (receiver == null) {
            assert (false) : "receiver should never be null";
            return "null";
        }
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        PolyglotContextImpl context = languageContext.context;
        PolyglotLanguage displayLanguage = EngineAccessor.EngineImpl.findObjectLanguage(context.engine, receiver);
        if (displayLanguage == null) {
            displayLanguage = context.engine.hostLanguage;
            view = context.getHostContext().getLanguageView(receiver);
        } else {
            view = receiver;
        }
        String metaObjectToString = UNKNOWN;
        try {
            InteropLibrary uncached = InteropLibrary.getFactory().getUncached(view);
            if (uncached.hasMetaObject(view)) {
                Object qualifiedName = INTEROP.getMetaQualifiedName(uncached.getMetaObject(view));
                metaObjectToString = PolyglotValue.truncateString(INTEROP.asString(qualifiedName), 140);
            }
            valueToString = PolyglotValue.truncateString(INTEROP.asString(uncached.toDisplayString(view)), 140);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        String languageName = null;
        boolean hideType = false;
        if (displayLanguage.isHost()) {
            languageName = "Java";
            if (UNKNOWN.equals(metaObjectToString) && INTEROP.isNull(receiver)) {
                hideType = true;
            }
        } else {
            languageName = displayLanguage.getName();
        }
        if (hideType) {
            return String.format("'%s'(language: %s)", valueToString, languageName);
        }
        return String.format("'%s'(language: %s, type: %s)", valueToString, languageName, metaObjectToString);
    }

    private static String truncateString(String s2, int i) {
        if (s2.length() > i) {
            return s2.substring(0, i - TRUNCATION_SUFFIX.length()) + TRUNCATION_SUFFIX;
        }
        return s2;
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nullCoercion(PolyglotLanguageContext languageContext, Object receiver, Class<?> targetType, String message, String useToCheck) {
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        String valueInfo = PolyglotValue.getValueInfo(languageContext, receiver);
        throw PolyglotEngineException.nullPointer(String.format("Cannot convert null value %s to Java type '%s' using %s.%s. You can ensure that the operation is supported using %s.%s.", valueInfo, targetType, Value.class.getSimpleName(), message, Value.class.getSimpleName(), useToCheck));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException cannotConvert(PolyglotLanguageContext languageContext, Object receiver, Class<?> targetType, String message, String useToCheck, String reason) {
        assert (languageContext == null || !languageContext.context.engine.needsEnter(languageContext.context));
        String valueInfo = PolyglotValue.getValueInfo(languageContext, receiver);
        String targetTypeString = "";
        if (targetType != null) {
            targetTypeString = String.format("to Java type '%s'", targetType.getTypeName());
        }
        throw PolyglotEngineException.classCast(String.format("Cannot convert %s %s using %s.%s: %s You can ensure that the value can be converted using %s.%s.", valueInfo, targetTypeString, Value.class.getSimpleName(), message, reason, Value.class.getSimpleName(), useToCheck));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidArrayIndex(PolyglotLanguageContext context, Object receiver, long index) {
        String message = String.format("Invalid array index %s for array %s.", index, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.arrayIndexOutOfBounds(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidArrayValue(PolyglotLanguageContext context, Object receiver, long identifier, Object value) {
        throw PolyglotEngineException.classCast(String.format("Invalid array value %s for array %s and index %s.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), identifier));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidMemberKey(PolyglotLanguageContext context, Object receiver, String identifier) {
        String message = String.format("Invalid member key '%s' for object %s.", identifier, PolyglotValue.getValueInfo(context, receiver));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidMemberValue(PolyglotLanguageContext context, Object receiver, String identifier, Object value) {
        String message = String.format("Invalid member value %s for object %s and member key '%s'.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), identifier);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidExecuteArgumentType(PolyglotLanguageContext context, Object receiver, UnsupportedTypeException e) {
        String originalMessage = e.getMessage() == null ? "" : e.getMessage() + " ";
        String[] formattedArgs = PolyglotValue.formatArgs(context, e.getSuppliedValues());
        throw PolyglotEngineException.illegalArgument(String.format("Invalid argument when executing %s. %sProvided arguments: %s.", PolyglotValue.getValueInfo(context, receiver), originalMessage, Arrays.asList(formattedArgs)));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInvokeArgumentType(PolyglotLanguageContext context, Object receiver, String member, UnsupportedTypeException e) {
        String originalMessage = e.getMessage() == null ? "" : e.getMessage();
        String[] formattedArgs = PolyglotValue.formatArgs(context, e.getSuppliedValues());
        String message = String.format("Invalid argument when invoking '%s' on %s. %sProvided arguments: %s.", member, PolyglotValue.getValueInfo(context, receiver), originalMessage, Arrays.asList(formattedArgs));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInstantiateArgumentType(PolyglotLanguageContext context, Object receiver, Object[] arguments) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument when instantiating %s with arguments %s.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInstantiateArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when instantiating %s with arguments %s. Expected %d argument(s) but got %d.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidExecuteArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when executing %s with arguments %s. Expected %d argument(s) but got %d.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInvokeArity(PolyglotLanguageContext context, Object receiver, String member, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when invoking '%s' on %s with arguments %s. Expected %d argument(s) but got %d.", member, PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw PolyglotEngineException.illegalArgument(message);
    }

    private static String[] formatArgs(PolyglotLanguageContext context, Object[] arguments) {
        String[] formattedArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            formattedArgs[i] = PolyglotValue.getValueInfo(context, arguments[i]);
        }
        return formattedArgs;
    }

    @Override
    public final String toString(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            String string = this.toStringImpl(receiver);
            return string;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    protected String toStringImpl(Object receiver) throws AssertionError {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        Object result = lib.toDisplayString(receiver);
        InteropLibrary resultLib = InteropLibrary.getFactory().getUncached(result);
        try {
            return resultLib.asString(result);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere("toDisplayString must be coercible to java.lang.String, but is not.", e);
        }
    }

    @Override
    public org.graalvm.polyglot.SourceSection getSourceLocation(Object receiver) {
        if (this.languageContext == null) {
            return null;
        }
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
            SourceSection result = null;
            if (lib.hasSourceLocation(receiver)) {
                try {
                    result = lib.getSourceLocation(receiver);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            if (result == null) {
                org.graalvm.polyglot.SourceSection sourceSection = null;
                return sourceSection;
            }
            org.graalvm.polyglot.SourceSection sourceSection = this.languageContext.getImpl().getPolyglotSourceSection(result);
            return sourceSection;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
        }
        finally {
            PolyglotValue.hostLeave(this.languageContext, prev);
        }
    }

    @Override
    public boolean isMetaObject(Object receiver) {
        return false;
    }

    @Override
    public boolean equalsImpl(Object receiver, Object obj) {
        if (receiver == obj) {
            return true;
        }
        return HostWrapper.equals(this.languageContext, receiver, obj);
    }

    @Override
    public int hashCodeImpl(Object receiver) {
        return HostWrapper.hashCode(this.languageContext, receiver);
    }

    @Override
    public boolean isMetaInstance(Object receiver, Object instance) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "isMetaInstance(Object)", "isMetaObject()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @Override
    public String getMetaQualifiedName(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "getMetaQualifiedName()", "isMetaObject()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    @Override
    public String getMetaSimpleName(Object receiver) {
        Object prev = PolyglotValue.hostEnter(this.languageContext);
        try {
            try {
                throw PolyglotValue.unsupported(this.languageContext, receiver, "getMetaSimpleName()", "isMetaObject()");
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValue.hostLeave(this.languageContext, prev);
            throw throwable;
        }
    }

    static CallTarget createTarget(InteropNode root) {
        RootCallTarget target = Truffle.getRuntime().createCallTarget(root);
        Class<?>[] types = root.getArgumentTypes();
        if (types != null) {
            EngineAccessor.RUNTIME.initializeProfile(target, types);
        }
        return target;
    }

    static PolyglotValue createInteropValue(PolyglotLanguageContext languageContext, TruffleObject receiver, Class<?> receiverType) {
        PolyglotLanguageInstance languageInstance = languageContext.getLanguageInstance();
        InteropCodeCache cache = languageInstance.valueCodeCache.get(receiverType);
        if (cache == null) {
            cache = new InteropCodeCache(languageInstance, receiver, receiverType);
            languageInstance.valueCodeCache.put(receiverType, cache);
        }
        return new InteropValue(languageContext, cache);
    }

    static PolyglotValue createHostNull(PolyglotImpl polyglot) {
        return new HostNull(polyglot);
    }

    static void createDefaultValues(PolyglotImpl polyglot, PolyglotLanguageContext context, Map<Class<?>, PolyglotValue> valueCache) {
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, false);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, "");
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, Character.valueOf('a'));
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, (byte)0);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, (short)0);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, 0);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, 0L);
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, Float.valueOf(0.0f));
        PolyglotValue.addDefaultValue(polyglot, context, valueCache, 0.0);
    }

    static void addDefaultValue(PolyglotImpl polyglot, PolyglotLanguageContext context, Map<Class<?>, PolyglotValue> valueCache, Object primitive) {
        valueCache.put(primitive.getClass(), new PrimitiveValue(polyglot, context, primitive));
    }

    private static final class InteropValue
    extends PolyglotValue {
        private final InteropCodeCache cache;

        InteropValue(PolyglotLanguageContext context, InteropCodeCache codeCache) {
            super(context);
            this.cache = codeCache;
        }

        @Override
        public <T> T as(Object receiver, Class<T> targetType) {
            return (T)EngineAccessor.RUNTIME.callProfiled(this.cache.asClassLiteral, this.languageContext, receiver, targetType);
        }

        @Override
        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return (T)EngineAccessor.RUNTIME.callProfiled(this.cache.asTypeLiteral, this.languageContext, receiver, targetType);
        }

        @Override
        public boolean isNativePointer(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isNativePointer, this.languageContext, receiver);
        }

        @Override
        public boolean hasArrayElements(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasArrayElements, this.languageContext, receiver);
        }

        @Override
        public Value getArrayElement(Object receiver, long index) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getArrayElement, this.languageContext, receiver, index);
        }

        @Override
        public void setArrayElement(Object receiver, long index, Object value) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.setArrayElement, this.languageContext, receiver, index, value);
        }

        @Override
        public boolean removeArrayElement(Object receiver, long index) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.removeArrayElement, this.languageContext, receiver, index);
        }

        @Override
        public long getArraySize(Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.getArraySize, this.languageContext, receiver);
        }

        @Override
        public boolean hasMembers(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasMembers, this.languageContext, receiver);
        }

        @Override
        public Value getMember(Object receiver, String key) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getMember, this.languageContext, receiver, key);
        }

        @Override
        public boolean hasMember(Object receiver, String key) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.hasMember, this.languageContext, receiver, key);
        }

        @Override
        public void putMember(Object receiver, String key, Object member) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.putMember, this.languageContext, receiver, key, member);
        }

        @Override
        public boolean removeMember(Object receiver, String key) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.removeMember, this.languageContext, receiver, key);
        }

        @Override
        public Set<String> getMemberKeys(Object receiver) {
            Value keys = (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.getMemberKeys, this.languageContext, receiver);
            if (keys == null) {
                return Collections.emptySet();
            }
            return new MemberSet(receiver, keys);
        }

        @Override
        public long asNativePointer(Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.cache.asNativePointer, this.languageContext, receiver);
        }

        @Override
        public boolean isDate(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isDate, this.languageContext, receiver);
        }

        @Override
        public LocalDate asDate(Object receiver) {
            return (LocalDate)EngineAccessor.RUNTIME.callProfiled(this.cache.asDate, this.languageContext, receiver);
        }

        @Override
        public boolean isTime(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isTime, this.languageContext, receiver);
        }

        @Override
        public LocalTime asTime(Object receiver) {
            return (LocalTime)EngineAccessor.RUNTIME.callProfiled(this.cache.asTime, this.languageContext, receiver);
        }

        @Override
        public boolean isTimeZone(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isTimeZone, this.languageContext, receiver);
        }

        @Override
        public ZoneId asTimeZone(Object receiver) {
            return (ZoneId)EngineAccessor.RUNTIME.callProfiled(this.cache.asTimeZone, this.languageContext, receiver);
        }

        @Override
        public Instant asInstant(Object receiver) {
            return (Instant)EngineAccessor.RUNTIME.callProfiled(this.cache.asInstant, this.languageContext, receiver);
        }

        @Override
        public boolean isDuration(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isDuration, this.languageContext, receiver);
        }

        @Override
        public Duration asDuration(Object receiver) {
            return (Duration)EngineAccessor.RUNTIME.callProfiled(this.cache.asDuration, this.languageContext, receiver);
        }

        @Override
        public boolean isHostObject(Object receiver) {
            return this.cache.isHost;
        }

        @Override
        public boolean isProxyObject(Object receiver) {
            return this.cache.isProxy;
        }

        @Override
        public Object asProxyObject(Object receiver) {
            if (this.cache.isProxy) {
                return PolyglotProxy.toProxyHostObject((TruffleObject)receiver);
            }
            return super.asProxyObject(receiver);
        }

        @Override
        public Object asHostObject(Object receiver) {
            if (this.cache.isHost) {
                return HostObject.valueOf(receiver);
            }
            return super.asHostObject(receiver);
        }

        @Override
        public boolean isNull(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isNull, this.languageContext, receiver);
        }

        @Override
        public boolean canExecute(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.canExecute, this.languageContext, receiver);
        }

        @Override
        public void executeVoid(Object receiver, Object[] arguments) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.executeVoid, this.languageContext, receiver, arguments);
        }

        @Override
        public void executeVoid(Object receiver) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.executeVoidNoArgs, this.languageContext, receiver);
        }

        @Override
        public Value execute(Object receiver, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.execute, this.languageContext, receiver, arguments);
        }

        @Override
        public Value execute(Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.executeNoArgs, this.languageContext, receiver);
        }

        @Override
        public boolean canInstantiate(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.canInstantiate, this.languageContext, receiver);
        }

        @Override
        public Value newInstance(Object receiver, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.newInstance, this.languageContext, receiver, arguments);
        }

        @Override
        public boolean canInvoke(String identifier, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.canInvoke, this.languageContext, receiver, identifier);
        }

        @Override
        public Value invoke(Object receiver, String identifier, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.invoke, this.languageContext, receiver, identifier, arguments);
        }

        @Override
        public Value invoke(Object receiver, String identifier) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.cache.invokeNoArgs, this.languageContext, receiver, identifier);
        }

        @Override
        public boolean isException(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isException, this.languageContext, receiver);
        }

        @Override
        public RuntimeException throwException(Object receiver) {
            EngineAccessor.RUNTIME.callProfiled(this.cache.throwException, this.languageContext, receiver);
            throw super.throwException(receiver);
        }

        @Override
        public boolean isNumber(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.isNumber(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean fitsInByte(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInByte(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public byte asByte(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                byte by = UNCACHED_INTEROP.asByte(receiver);
                return by;
            }
            catch (UnsupportedMessageException e) {
                byte by = this.asByteUnsupported(receiver);
                return by;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean isString(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.isString(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public String asString(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                if (PolyglotValue.isNullUncached(receiver)) {
                    String string = null;
                    return string;
                }
                String string = UNCACHED_INTEROP.asString(receiver);
                return string;
            }
            catch (UnsupportedMessageException e) {
                String string = this.asStringUnsupported(receiver);
                return string;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean fitsInInt(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInInt(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public int asInt(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                int n = UNCACHED_INTEROP.asInt(receiver);
                return n;
            }
            catch (UnsupportedMessageException e) {
                int n = this.asIntUnsupported(receiver);
                return n;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean isBoolean(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().isBoolean(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean asBoolean(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().asBoolean(receiver);
                return bl;
            }
            catch (UnsupportedMessageException e) {
                boolean bl = this.asBooleanUnsupported(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean fitsInFloat(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().fitsInFloat(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public float asFloat(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                float f = UNCACHED_INTEROP.asFloat(receiver);
                return f;
            }
            catch (UnsupportedMessageException e) {
                float f = this.asFloatUnsupported(receiver);
                return f;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean fitsInDouble(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInDouble(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public double asDouble(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                double d = UNCACHED_INTEROP.asDouble(receiver);
                return d;
            }
            catch (UnsupportedMessageException e) {
                double d = this.asDoubleUnsupported(receiver);
                return d;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean fitsInLong(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInLong(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public long asLong(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                long l = UNCACHED_INTEROP.asLong(receiver);
                return l;
            }
            catch (UnsupportedMessageException e) {
                long l = this.asLongUnsupported(receiver);
                return l;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean fitsInShort(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInShort(receiver);
                return bl;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public short asShort(Object receiver) {
            Object c = InteropValue.hostEnter(this.languageContext);
            try {
                short s2 = UNCACHED_INTEROP.asShort(receiver);
                return s2;
            }
            catch (UnsupportedMessageException e) {
                short s3 = this.asShortUnsupported(receiver);
                return s3;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                InteropValue.hostLeave(this.languageContext, c);
            }
        }

        @Override
        public boolean isMetaObject(Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isMetaObject, this.languageContext, receiver);
        }

        @Override
        public boolean isMetaInstance(Object receiver, Object instance) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.cache.isMetaInstance, this.languageContext, receiver, instance);
        }

        @Override
        public String getMetaQualifiedName(Object receiver) {
            return (String)EngineAccessor.RUNTIME.callProfiled(this.cache.getMetaQualifiedName, this.languageContext, receiver);
        }

        @Override
        public String getMetaSimpleName(Object receiver) {
            return (String)EngineAccessor.RUNTIME.callProfiled(this.cache.getMetaSimpleName, this.languageContext, receiver);
        }

        private final class MemberSet
        extends AbstractSet<String> {
            private final Object receiver;
            private final Value keys;
            private int cachedSize = -1;

            MemberSet(Object receiver, Value keys) {
                this.receiver = receiver;
                this.keys = keys;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof String)) {
                    return false;
                }
                return InteropValue.this.hasMember(this.receiver, (String)o);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MemberSet.this.size();
                    }

                    @Override
                    public String next() {
                        if (this.index >= MemberSet.this.size()) {
                            throw new NoSuchElementException();
                        }
                        Value arrayElement = MemberSet.this.keys.getArrayElement(this.index++);
                        if (arrayElement.isString()) {
                            return arrayElement.asString();
                        }
                        return null;
                    }
                };
            }

            @Override
            public int size() {
                int size = this.cachedSize;
                if (size != -1) {
                    return size;
                }
                this.cachedSize = size = (int)this.keys.getArraySize();
                return size;
            }
        }
    }

    static final class HostValue
    extends PolyglotValue {
        HostValue(PolyglotImpl polyglot) {
            super(polyglot, null);
        }

        @Override
        public boolean isHostObject(Object receiver) {
            return HostObject.isInstance(receiver);
        }

        @Override
        public Object asHostObject(Object receiver) {
            return HostObject.valueOf(receiver);
        }

        @Override
        public boolean isProxyObject(Object receiver) {
            return PolyglotProxy.isProxyGuestObject(receiver);
        }

        @Override
        public Object asProxyObject(Object receiver) {
            return PolyglotProxy.toProxyHostObject((TruffleObject)receiver);
        }

        @Override
        public <T> T as(Object receiver, Class<T> targetType) {
            return this.asImpl(receiver, targetType);
        }

        @Override
        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return this.asImpl(receiver, targetType.getRawType());
        }

        <T> T asImpl(Object receiver, Class<T> targetType) {
            Object hostValue;
            if (this.isProxyObject(receiver)) {
                hostValue = this.asProxyObject(receiver);
            } else if (this.isHostObject(receiver)) {
                hostValue = this.asHostObject(receiver);
            } else {
                throw new ClassCastException();
            }
            return targetType.cast(hostValue);
        }
    }

    static abstract class InteropNode
    extends HostToGuestRootNode {
        protected static final int CACHE_LIMIT = 5;
        protected final InteropCodeCache polyglot;

        protected abstract String getOperationName();

        protected InteropNode(InteropCodeCache polyglot) {
            this.polyglot = polyglot;
        }

        protected abstract Class<?>[] getArgumentTypes();

        protected Class<? extends Object> getReceiverType() {
            return this.polyglot.receiverType;
        }

        protected final PolyglotLanguageContext.ToHostValueNode createToHost() {
            return PolyglotLanguageContext.ToHostValueNode.create(this.getImpl());
        }

        @Override
        public final String getName() {
            return "org.graalvm.polyglot.Value<" + this.polyglot.receiverType.getSimpleName() + ">." + this.getOperationName();
        }

        protected final PolyglotImpl getImpl() {
            return this.polyglot.languageInstance.language.getImpl();
        }

        @Override
        public final String toString() {
            return this.getName();
        }
    }

    private static final class HostNull
    extends PolyglotValue {
        private final PolyglotImpl polyglot;

        HostNull(PolyglotImpl polyglot) {
            super(polyglot, null);
            this.polyglot = polyglot;
        }

        @Override
        public boolean isNull(Object receiver) {
            return true;
        }

        @Override
        public <T> T as(Object receiver, Class<T> targetType) {
            if (targetType == Value.class) {
                return (T)this.polyglot.hostNull;
            }
            return null;
        }

        @Override
        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return this.as(receiver, targetType.getRawType());
        }
    }

    static final class PrimitiveValue
    extends PolyglotValue {
        private final InteropLibrary interop;

        PrimitiveValue(PolyglotImpl polyglot, PolyglotLanguageContext context, Object primitiveValue) {
            super(polyglot, context);
            this.interop = InteropLibrary.getFactory().getUncached(primitiveValue);
        }

        @Override
        public boolean isString(Object receiver) {
            return this.interop.isString(receiver);
        }

        @Override
        public boolean isBoolean(Object receiver) {
            return this.interop.isBoolean(receiver);
        }

        @Override
        public boolean asBoolean(Object receiver) {
            try {
                return this.interop.asBoolean(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asBoolean(receiver);
            }
        }

        @Override
        public String asString(Object receiver) {
            try {
                return this.interop.asString(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asString(receiver);
            }
        }

        @Override
        public boolean isNumber(Object receiver) {
            return this.interop.isNumber(receiver);
        }

        @Override
        public boolean fitsInByte(Object receiver) {
            return this.interop.fitsInByte(receiver);
        }

        @Override
        public boolean fitsInShort(Object receiver) {
            return this.interop.fitsInShort(receiver);
        }

        @Override
        public boolean fitsInInt(Object receiver) {
            return this.interop.fitsInInt(receiver);
        }

        @Override
        public boolean fitsInLong(Object receiver) {
            return this.interop.fitsInLong(receiver);
        }

        @Override
        public boolean fitsInFloat(Object receiver) {
            return this.interop.fitsInFloat(receiver);
        }

        @Override
        public boolean fitsInDouble(Object receiver) {
            return this.interop.fitsInDouble(receiver);
        }

        @Override
        public byte asByte(Object receiver) {
            try {
                return this.interop.asByte(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asByte(receiver);
            }
        }

        @Override
        public short asShort(Object receiver) {
            try {
                return this.interop.asShort(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asShort(receiver);
            }
        }

        @Override
        public int asInt(Object receiver) {
            try {
                return this.interop.asInt(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asInt(receiver);
            }
        }

        @Override
        public long asLong(Object receiver) {
            try {
                return this.interop.asLong(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asLong(receiver);
            }
        }

        @Override
        public float asFloat(Object receiver) {
            try {
                return this.interop.asFloat(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asFloat(receiver);
            }
        }

        @Override
        public double asDouble(Object receiver) {
            try {
                return this.interop.asDouble(receiver);
            }
            catch (UnsupportedMessageException e) {
                return super.asDouble(receiver);
            }
        }

        @Override
        public <T> T as(Object receiver, Class<T> targetType) {
            Object prev = PrimitiveValue.hostEnter(this.languageContext);
            try {
                Object object = ToHostNodeGen.getUncached().execute(receiver, targetType, targetType, this.languageContext, true);
                return (T)object;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(this.languageContext, e, true);
            }
            finally {
                PrimitiveValue.hostLeave(this.languageContext, prev);
            }
        }

        @Override
        public <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return this.as(receiver, targetType.getRawType());
        }

        @Override
        public Value getMetaObjectImpl(Object receiver) {
            return super.getMetaObjectImpl(this.getLanguageView(receiver));
        }

        @Override
        protected String toStringImpl(Object receiver) throws AssertionError {
            return super.toStringImpl(this.getLanguageView(receiver));
        }

        private Object getLanguageView(Object receiver) {
            if (this.languageContext == null) {
                return receiver;
            }
            return this.languageContext.getLanguageViewNoCheck(receiver);
        }
    }

    static class InteropCodeCache {
        final CallTarget isNativePointer;
        final CallTarget asNativePointer;
        final CallTarget hasArrayElements;
        final CallTarget getArrayElement;
        final CallTarget setArrayElement;
        final CallTarget removeArrayElement;
        final CallTarget getArraySize;
        final CallTarget hasMembers;
        final CallTarget hasMember;
        final CallTarget getMember;
        final CallTarget putMember;
        final CallTarget removeMember;
        final CallTarget isNull;
        final CallTarget canExecute;
        final CallTarget execute;
        final CallTarget canInstantiate;
        final CallTarget newInstance;
        final CallTarget executeNoArgs;
        final CallTarget executeVoid;
        final CallTarget executeVoidNoArgs;
        final CallTarget canInvoke;
        final CallTarget invoke;
        final CallTarget invokeNoArgs;
        final CallTarget getMemberKeys;
        final CallTarget isDate;
        final CallTarget asDate;
        final CallTarget isTime;
        final CallTarget asTime;
        final CallTarget isTimeZone;
        final CallTarget asTimeZone;
        final CallTarget asInstant;
        final CallTarget isDuration;
        final CallTarget asDuration;
        final CallTarget isException;
        final CallTarget throwException;
        final CallTarget isMetaObject;
        final CallTarget isMetaInstance;
        final CallTarget getMetaQualifiedName;
        final CallTarget getMetaSimpleName;
        final boolean isProxy;
        final boolean isHost;
        final CallTarget asClassLiteral;
        final CallTarget asTypeLiteral;
        final Class<?> receiverType;
        final PolyglotLanguageInstance languageInstance;

        InteropCodeCache(PolyglotLanguageInstance languageInstance, TruffleObject receiverObject, Class<?> receiverType) {
            Objects.requireNonNull(receiverType);
            this.languageInstance = languageInstance;
            this.receiverType = receiverType;
            this.asClassLiteral = PolyglotValue.createTarget(new AsClassLiteralNode(this));
            this.asTypeLiteral = PolyglotValue.createTarget(new AsTypeLiteralNode(this));
            this.isNativePointer = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsNativePointerNodeGen.create(this));
            this.asNativePointer = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsNativePointerNodeGen.create(this));
            this.hasArrayElements = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasArrayElementsNodeGen.create(this));
            this.getArrayElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetArrayElementNodeGen.create(this));
            this.setArrayElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.SetArrayElementNodeGen.create(this));
            this.removeArrayElement = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.RemoveArrayElementNodeGen.create(this));
            this.getArraySize = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetArraySizeNodeGen.create(this));
            this.hasMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasMemberNodeGen.create(this));
            this.getMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMemberNodeGen.create(this));
            this.putMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.PutMemberNodeGen.create(this));
            this.removeMember = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.RemoveMemberNodeGen.create(this));
            this.isNull = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsNullNodeGen.create(this));
            this.execute = PolyglotValue.createTarget(new ExecuteNode(this));
            this.executeNoArgs = PolyglotValue.createTarget(new ExecuteNoArgsNode(this));
            this.executeVoid = PolyglotValue.createTarget(new ExecuteVoidNode(this));
            this.executeVoidNoArgs = PolyglotValue.createTarget(new ExecuteVoidNoArgsNode(this));
            this.newInstance = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.NewInstanceNodeGen.create(this));
            this.canInstantiate = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.CanInstantiateNodeGen.create(this));
            this.canExecute = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.CanExecuteNodeGen.create(this));
            this.canInvoke = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.CanInvokeNodeGen.create(this));
            this.invoke = PolyglotValue.createTarget(new InvokeNode(this));
            this.invokeNoArgs = PolyglotValue.createTarget(new InvokeNoArgsNode(this));
            this.hasMembers = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.HasMembersNodeGen.create(this));
            this.isProxy = PolyglotProxy.isProxyGuestObject(receiverObject);
            this.isHost = HostObject.isInstance(receiverObject);
            this.getMemberKeys = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMemberKeysNodeGen.create(this));
            this.isDate = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsDateNodeGen.create(this));
            this.asDate = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsDateNodeGen.create(this));
            this.isTime = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsTimeNodeGen.create(this));
            this.asTime = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsTimeNodeGen.create(this));
            this.isTimeZone = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsTimeZoneNodeGen.create(this));
            this.asTimeZone = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsTimeZoneNodeGen.create(this));
            this.asInstant = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsInstantNodeGen.create(this));
            this.isDuration = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsDurationNodeGen.create(this));
            this.asDuration = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.AsDurationNodeGen.create(this));
            this.isException = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsExceptionNodeGen.create(this));
            this.throwException = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.ThrowExceptionNodeGen.create(this));
            this.isMetaObject = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsMetaObjectNodeGen.create(this));
            this.isMetaInstance = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.IsMetaInstanceNodeGen.create(this));
            this.getMetaQualifiedName = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMetaQualifiedNameNodeGen.create(this));
            this.getMetaSimpleName = PolyglotValue.createTarget(PolyglotValueFactory.InteropCodeCacheFactory.GetMetaSimpleNameNodeGen.create(this));
        }

        static abstract class IsMetaInstanceNode
        extends InteropNode {
            protected IsMetaInstanceNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, null};
            }

            @Override
            protected String getOperationName() {
                return "isMetaInstance";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached PolyglotLanguageContext.ToGuestValueNode toGuest, @Cached BranchProfile unsupported) {
                try {
                    return objects.isMetaInstance(receiver, toGuest.execute(context, args[2]));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class GetMetaSimpleNameNode
        extends InteropNode {
            protected GetMetaSimpleNameNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaSimpleName";
            }

            @Specialization(limit="CACHE_LIMIT")
            static String doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @CachedLibrary(limit="1") InteropLibrary toString, @Cached BranchProfile unsupported) {
                try {
                    return toString.asString(objects.getMetaSimpleName(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class GetMetaQualifiedNameNode
        extends InteropNode {
            protected GetMetaQualifiedNameNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaQualifiedName";
            }

            @Specialization(limit="CACHE_LIMIT")
            static String doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @CachedLibrary(limit="1") InteropLibrary toString, @Cached BranchProfile unsupported) {
                try {
                    return toString.asString(objects.getMetaQualifiedName(receiver));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class IsMetaObjectNode
        extends InteropNode {
            protected IsMetaObjectNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isMetaObject";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isMetaObject(receiver);
            }
        }

        static abstract class ThrowExceptionNode
        extends InteropNode {
            protected ThrowExceptionNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "throwException";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    throw objects.throwException(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.unsupported(context, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class IsExceptionNode
        extends InteropNode {
            protected IsExceptionNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isException";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isException(receiver);
            }
        }

        private static class InvokeNoArgsNode
        extends AbstractInvokeNode {
            protected InvokeNoArgsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "invoke";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                String key = (String)args[2];
                return this.executeShared(context, receiver, key, ExecuteVoidNoArgsNode.NO_ARGS);
            }
        }

        private static class InvokeNode
        extends AbstractInvokeNode {
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();

            protected InvokeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class, Object[].class};
            }

            @Override
            protected String getOperationName() {
                return "invoke";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                String key = (String)args[2];
                Object[] guestArguments = this.toGuestValues.apply(context, (Object[])args[3]);
                return this.executeShared(context, receiver, key, guestArguments);
            }
        }

        private static abstract class AbstractInvokeNode
        extends InteropNode {
            @Node.Child
            private InteropLibrary objects = InteropLibrary.getFactory().createDispatched(5);
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;
            private final BranchProfile invalidArgument = BranchProfile.create();
            private final BranchProfile arity = BranchProfile.create();
            private final BranchProfile unsupported = BranchProfile.create();
            private final BranchProfile unknownIdentifier = BranchProfile.create();

            protected AbstractInvokeNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            protected final Object executeShared(PolyglotLanguageContext context, Object receiver, String key, Object[] guestArguments) {
                try {
                    return this.toHostValue.execute(context, this.objects.invokeMember(receiver, key, guestArguments));
                }
                catch (UnsupportedMessageException e) {
                    this.unsupported.enter();
                    throw PolyglotValue.invokeUnsupported(context, receiver, key);
                }
                catch (UnknownIdentifierException e) {
                    this.unknownIdentifier.enter();
                    throw PolyglotValue.invalidMemberKey(context, receiver, key);
                }
                catch (UnsupportedTypeException e) {
                    this.invalidArgument.enter();
                    throw PolyglotValue.invalidInvokeArgumentType(context, receiver, key, e);
                }
                catch (ArityException e) {
                    this.arity.enter();
                    throw PolyglotValue.invalidInvokeArity(context, receiver, key, guestArguments, e.getExpectedArity(), e.getActualArity());
                }
            }
        }

        static abstract class NewInstanceNode
        extends InteropNode {
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected NewInstanceNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary instantiables, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuestValues, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached BranchProfile arity, @Cached BranchProfile invalidArgument, @Cached BranchProfile unsupported) {
                Object[] instantiateArguments = toGuestValues.apply(context, (Object[])args[2]);
                try {
                    return toHostValue.execute(context, instantiables.instantiate(receiver, instantiateArguments));
                }
                catch (UnsupportedTypeException e) {
                    invalidArgument.enter();
                    throw PolyglotValue.invalidInstantiateArgumentType(context, receiver, instantiateArguments);
                }
                catch (ArityException e) {
                    arity.enter();
                    throw PolyglotValue.invalidInstantiateArity(context, receiver, instantiateArguments, e.getExpectedArity(), e.getActualArity());
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.newInstanceUnsupported(context, receiver);
                }
            }

            @Override
            protected String getOperationName() {
                return "newInstance";
            }
        }

        private static class ExecuteNoArgsNode
        extends AbstractExecuteNode {
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected ExecuteNoArgsNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                return this.toHostValue.execute(context, this.executeShared(context, receiver, ExecuteVoidNoArgsNode.NO_ARGS));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        private static class ExecuteNode
        extends AbstractExecuteNode {
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected ExecuteNode(InteropCodeCache interop) {
                super(interop);
                this.toHostValue = PolyglotLanguageContext.ToHostValueNode.create(interop.languageInstance.language.getImpl());
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                return this.toHostValue.execute(context, this.executeShared(context, receiver, (Object[])args[2]));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        private static class ExecuteVoidNoArgsNode
        extends AbstractExecuteNode {
            private static final Object[] NO_ARGS = new Object[0];

            protected ExecuteVoidNoArgsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                this.executeShared(context, receiver, NO_ARGS);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        private static class ExecuteVoidNode
        extends AbstractExecuteNode {
            protected ExecuteVoidNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                this.executeShared(context, receiver, (Object[])args[2]);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        private static abstract class AbstractExecuteNode
        extends InteropNode {
            @Node.Child
            private InteropLibrary executables = InteropLibrary.getFactory().createDispatched(5);
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();
            private final BranchProfile invalidArgument = BranchProfile.create();
            private final BranchProfile arity = BranchProfile.create();
            private final BranchProfile unsupported = BranchProfile.create();

            protected AbstractExecuteNode(InteropCodeCache interop) {
                super(interop);
            }

            protected final Object executeShared(PolyglotLanguageContext context, Object receiver, Object[] args) {
                Object[] guestArguments = this.toGuestValues.apply(context, args);
                try {
                    return this.executables.execute(receiver, guestArguments);
                }
                catch (UnsupportedTypeException e) {
                    this.invalidArgument.enter();
                    throw PolyglotValue.invalidExecuteArgumentType(context, receiver, e);
                }
                catch (ArityException e) {
                    this.arity.enter();
                    throw PolyglotValue.invalidExecuteArity(context, receiver, guestArguments, e.getExpectedArity(), e.getActualArity());
                }
                catch (UnsupportedMessageException e) {
                    this.unsupported.enter();
                    throw PolyglotValue.executeUnsupported(context, receiver);
                }
            }
        }

        static abstract class CanInstantiateNode
        extends InteropNode {
            protected CanInstantiateNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "canInstantiate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary instantiables) {
                return instantiables.isInstantiable(receiver);
            }
        }

        static abstract class CanExecuteNode
        extends InteropNode {
            protected CanExecuteNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canExecute";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary executables) {
                return executables.isExecutable(receiver);
            }
        }

        static abstract class CanInvokeNode
        extends AbstractMemberInfoNode {
            protected CanInvokeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canInvoke";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                String key = (String)args[2];
                return objects.isMemberInvocable(receiver, key);
            }
        }

        static abstract class HasMemberNode
        extends AbstractMemberInfoNode {
            protected HasMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "hasMember";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                String key = (String)args[2];
                return objects.isMemberExisting(receiver, key);
            }
        }

        private static abstract class AbstractMemberInfoNode
        extends InteropNode {
            protected AbstractMemberInfoNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected final Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }
        }

        static abstract class HasMembersNode
        extends InteropNode {
            protected HasMembersNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasMembers";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.hasMembers(receiver);
            }
        }

        static abstract class IsNullNode
        extends InteropNode {
            protected IsNullNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNull";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary values) {
                return values.isNull(receiver);
            }
        }

        static abstract class RemoveMemberNode
        extends InteropNode {
            protected RemoveMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "removeMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                Boolean value;
                String key = (String)args[2];
                try {
                    assert (key != null) : "should be handled already";
                    objects.removeMember(receiver, key);
                    value = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (!objects.hasMembers(receiver) || objects.isMemberExisting(receiver, key)) {
                        throw PolyglotValue.removeMemberUnsupported(context, receiver);
                    }
                    value = Boolean.FALSE;
                }
                catch (UnknownIdentifierException e) {
                    unknown.enter();
                    value = Boolean.FALSE;
                }
                return value;
            }
        }

        static abstract class PutMemberNode
        extends InteropNode {
            protected PutMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "putMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class, null};
            }

            @Specialization
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(limit="CACHE_LIMIT") InteropLibrary objects, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached BranchProfile unsupported, @Cached BranchProfile invalidValue, @Cached BranchProfile unknown) {
                String key = (String)args[2];
                Object originalValue = args[3];
                Object value = toGuestValue.execute(context, originalValue);
                assert (key != null);
                try {
                    objects.writeMember(receiver, key, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.putMemberUnsupported(context, receiver);
                }
                catch (UnknownIdentifierException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidMemberKey(context, receiver, key);
                }
                catch (UnsupportedTypeException e) {
                    invalidValue.enter();
                    throw PolyglotValue.invalidMemberValue(context, receiver, key, value);
                }
                return null;
            }
        }

        static abstract class GetMemberNode
        extends InteropNode {
            protected GetMemberNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "getMember";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                Value value;
                String key = (String)args[2];
                try {
                    assert (key != null) : "should be handled already";
                    value = toHost.execute(context, objects.readMember(receiver, key));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.hasMembers(receiver)) {
                        value = null;
                    }
                    return PolyglotValue.getMemberUnsupported(context, receiver, key);
                }
                catch (UnknownIdentifierException e) {
                    unknown.enter();
                    value = null;
                }
                return value;
            }
        }

        static abstract class GetArraySizeNode
        extends InteropNode {
            protected GetArraySizeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getArraySize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached BranchProfile unsupported) {
                try {
                    return arrays.getArraySize(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.getArraySizeUnsupported(context, receiver);
                }
            }
        }

        static abstract class RemoveArrayElementNode
        extends InteropNode {
            protected RemoveArrayElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "removeArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex) {
                Boolean value;
                long index = (Long)args[2];
                try {
                    arrays.removeArrayElement(receiver, index);
                    value = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.removeArrayElementUnsupported(context, receiver);
                }
                catch (InvalidArrayIndexException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidArrayIndex(context, receiver, index);
                }
                return value;
            }
        }

        static abstract class SetArrayElementNode
        extends InteropNode {
            protected SetArrayElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class, null};
            }

            @Override
            protected String getOperationName() {
                return "setArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached BranchProfile unsupported, @Cached BranchProfile invalidIndex, @Cached BranchProfile invalidValue) {
                long index = (Long)args[2];
                Object value = toGuestValue.execute(context, args[3]);
                try {
                    arrays.writeArrayElement(receiver, index, value);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    PolyglotValue.setArrayElementUnsupported(context, receiver);
                }
                catch (UnsupportedTypeException e) {
                    invalidValue.enter();
                    throw PolyglotValue.invalidArrayValue(context, receiver, index, value);
                }
                catch (InvalidArrayIndexException e) {
                    invalidIndex.enter();
                    throw PolyglotValue.invalidArrayIndex(context, receiver, index);
                }
                return null;
            }
        }

        static abstract class GetArrayElementNode
        extends InteropNode {
            protected GetArrayElementNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "getArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported, @Cached BranchProfile unknown) {
                long index = (Long)args[2];
                try {
                    return toHost.execute(context, arrays.readArrayElement(receiver, index));
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    return PolyglotValue.getArrayElementUnsupported(context, receiver);
                }
                catch (InvalidArrayIndexException e) {
                    unknown.enter();
                    throw PolyglotValue.invalidArrayIndex(context, receiver, index);
                }
            }
        }

        static abstract class GetMemberKeysNode
        extends InteropNode {
            protected GetMemberKeysNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMemberKeys";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached(value="createToHost()") PolyglotLanguageContext.ToHostValueNode toHost, @Cached BranchProfile unsupported) {
                try {
                    return toHost.execute(context, objects.getMembers(receiver));
                }
                catch (UnsupportedMessageException e) {
                    return null;
                }
            }
        }

        static abstract class HasArrayElementsNode
        extends InteropNode {
            protected HasArrayElementsNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasArrayElements";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary arrays) {
                return arrays.hasArrayElements(receiver);
            }
        }

        static abstract class AsNativePointerNode
        extends InteropNode {
            protected AsNativePointerNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asNativePointer";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary natives, @Cached BranchProfile unsupported) {
                try {
                    return natives.asPointer(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    throw PolyglotValue.cannotConvert(context, receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
                }
            }
        }

        static abstract class IsNativePointerNode
        extends InteropNode {
            protected IsNativePointerNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNativePointer";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary natives) {
                return natives.isPointer(receiver);
            }
        }

        private static class AsTypeLiteralNode
        extends InteropNode {
            @Node.Child
            ToHostNode toHost = ToHostNodeGen.create();

            protected AsTypeLiteralNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, TypeLiteral.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                TypeLiteral typeLiteral = (TypeLiteral)args[2];
                return this.toHost.execute(receiver, typeLiteral.getRawType(), typeLiteral.getType(), context, true);
            }
        }

        private static class AsClassLiteralNode
        extends InteropNode {
            @Node.Child
            ToHostNode toHost = ToHostNodeGen.create();

            protected AsClassLiteralNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Class.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext context, Object receiver, Object[] args) {
                return this.toHost.execute(receiver, (Class)args[2], null, context, true);
            }
        }

        static abstract class AsInstantNode
        extends InteropNode {
            protected AsInstantNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getInstant";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asInstant(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asInstant()", "hasInstant()", "Value does not contain instant information.");
                }
            }
        }

        static abstract class AsDurationNode
        extends InteropNode {
            protected AsDurationNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asDuration";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asDuration(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asDuration()", "isDuration()", "Value does not contain duration information.");
                }
            }
        }

        static abstract class IsDurationNode
        extends InteropNode {
            protected IsDurationNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isDuration";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isDuration(receiver);
            }
        }

        static abstract class AsTimeZoneNode
        extends InteropNode {
            protected AsTimeZoneNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asTimeZone";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asTimeZone(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asTimeZone()", "isTimeZone()", "Value does not contain time-zone information.");
                }
            }
        }

        static abstract class IsTimeZoneNode
        extends InteropNode {
            protected IsTimeZoneNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isTimeZone";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isTimeZone(receiver);
            }
        }

        static abstract class AsTimeNode
        extends InteropNode {
            protected AsTimeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asTime";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asTime(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asTime()", "isTime()", "Value does not contain time information.");
                }
            }
        }

        static abstract class IsTimeNode
        extends InteropNode {
            protected IsTimeNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isTime";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isTime(receiver);
            }
        }

        static abstract class AsDateNode
        extends InteropNode {
            protected AsDateNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asDate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached BranchProfile unsupported) {
                try {
                    return objects.asDate(receiver);
                }
                catch (UnsupportedMessageException e) {
                    unsupported.enter();
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValue.cannotConvert(context, receiver, null, "asDate()", "isDate()", "Value does not contain date information.");
                }
            }
        }

        static abstract class IsDateNode
        extends InteropNode {
            protected IsDateNode(InteropCodeCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isDate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isDate(receiver);
            }
        }
    }
}

