/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.CompiledRegexObject;
import com.oracle.truffle.regex.RegexCompiler;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.runtime.nodes.ExpectByteArrayHostObjectNode;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNode;
import com.oracle.truffle.regex.runtime.nodes.ToLongNode;
import com.oracle.truffle.regex.tregex.util.Exceptions;
import com.oracle.truffle.regex.util.TruffleNull;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexObject
extends AbstractConstantKeysObject {
    static final String PROP_EXEC = "exec";
    static final String PROP_EXEC_BYTES = "execBytes";
    private static final String PROP_PATTERN = "pattern";
    private static final String PROP_FLAGS = "flags";
    private static final String PROP_GROUP_COUNT = "groupCount";
    private static final String PROP_GROUPS = "groups";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("exec", "pattern", "flags", "groupCount", "groups");
    private final RegexCompiler compiler;
    private final RegexSource source;
    private final TruffleObject flags;
    private final int numberOfCaptureGroups;
    private final TruffleObject namedCaptureGroups;
    private Object compiledRegexObject;
    private static final String N_METHODS = "2";

    public RegexObject(RegexCompiler compiler, RegexSource source, TruffleObject flags, int numberOfCaptureGroups, Map<String, Integer> namedCaptureGroups) {
        this.compiler = compiler;
        this.source = source;
        this.flags = flags;
        this.numberOfCaptureGroups = numberOfCaptureGroups;
        this.namedCaptureGroups = namedCaptureGroups != null ? new TruffleReadOnlyMap(namedCaptureGroups) : TruffleNull.INSTANCE;
    }

    public RegexSource getSource() {
        return this.source;
    }

    public TruffleObject getFlags() {
        return this.flags;
    }

    public int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    public TruffleObject getNamedCaptureGroups() {
        return this.namedCaptureGroups;
    }

    public Object getCompiledRegexObject() {
        if (this.compiledRegexObject == null) {
            this.compiledRegexObject = this.compileRegex(this.source);
        }
        return this.compiledRegexObject;
    }

    @CompilerDirectives.TruffleBoundary
    private Object compileRegex(RegexSource src) {
        return this.compiler.compile(src);
    }

    public void setCompiledRegexObject(TruffleObject compiledRegexObject) {
        this.compiledRegexObject = compiledRegexObject;
    }

    public RegexObjectExecMethod getExecMethod() {
        return new RegexObjectExecMethod(this);
    }

    public RegexObjectExecUTF8Method getExecUTF8Method() {
        return new RegexObjectExecUTF8Method(this);
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "exec": {
                return this.getExecMethod();
            }
            case "execBytes": {
                return this.getExecUTF8Method();
            }
            case "pattern": {
                return this.getSource().getPattern();
            }
            case "flags": {
                return this.getFlags();
            }
            case "groupCount": {
                return this.getNumberOfCaptureGroups();
            }
            case "groups": {
                return this.getNamedCaptureGroups();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create(symbol);
    }

    @ExportMessage
    boolean isMemberInvocable(String member, @Cached IsInvocableCacheNode cache) {
        return cache.execute(member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToLongNode toLongNode, @Cached GetCompiledRegexNode getCompiledRegexNode, @Cached InvokeCacheNode invokeCache) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (args.length != 2) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create(2, args.length);
        }
        Object input = args[0];
        long fromIndex = toLongNode.execute(args[1]);
        if (fromIndex > Integer.MAX_VALUE) {
            return NoMatchResult.getInstance();
        }
        return invokeCache.execute(member, getCompiledRegexNode.execute(this), input, (int)fromIndex);
    }

    @ImportStatic(value={RegexObject.class})
    @GenerateUncached
    static abstract class ExecCompiledRegexNode
    extends Node {
        ExecCompiledRegexNode() {
        }

        abstract Object execute(Object var1, Object var2, int var3) throws UnsupportedMessageException, ArityException, UnsupportedTypeException;

        @Specialization(guards={"receiver == cachedReceiver"}, limit="4")
        static Object executeTRegexFixed(CompiledRegexObject receiver, Object input, int fromIndex, @Cached(value="receiver") CompiledRegexObject cachedReceiver, @Cached(value="create(cachedReceiver.getCallTarget())") DirectCallNode directCallNode) {
            return directCallNode.call(input, fromIndex);
        }

        @Specialization(replaces={"executeTRegexFixed"})
        @ReportPolymorphism.Megamorphic
        static Object executeTRegexVarying(CompiledRegexObject receiver, Object input, int fromIndex, @Cached IndirectCallNode indirectCallNode) {
            return indirectCallNode.call(receiver.getCallTarget(), input, fromIndex);
        }

        @Specialization(guards={"receivers.isMemberInvocable(receiver, PROP_EXEC)"}, limit="4")
        static Object executeForeign(TruffleObject receiver, Object input, int fromIndex, @CachedLibrary(value="receiver") InteropLibrary receivers) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            try {
                return receivers.invokeMember(receiver, RegexObject.PROP_EXEC, input, fromIndex);
            }
            catch (UnknownIdentifierException e) {
                throw Exceptions.shouldNotReachHere("fallback compiled regex does not have an invocable \"exec\" method");
            }
        }
    }

    @GenerateUncached
    static abstract class GetCompiledRegexNode
    extends Node {
        GetCompiledRegexNode() {
        }

        abstract Object execute(RegexObject var1);

        @Specialization(guards={"receiver == cachedReceiver"}, limit="4")
        static Object executeFixed(RegexObject receiver, @Cached(value="receiver") RegexObject cachedReceiver, @Cached(value="receiver.getCompiledRegexObject()") Object cachedCompiledRegex) {
            return cachedCompiledRegex;
        }

        @Specialization(replaces={"executeFixed"})
        @ReportPolymorphism.Megamorphic
        static Object executeVarying(RegexObject receiver) {
            return receiver.getCompiledRegexObject();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RegexObjectExecUTF8Method
    extends AbstractRegexObject {
        private final RegexObject regex;

        public RegexObjectExecUTF8Method(RegexObject regex) {
            this.regex = regex;
        }

        public RegexObject getRegexObject() {
            return this.regex;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Cached GetCompiledRegexNode getCompiledRegexNode, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ToLongNode toLongNode, @Cached ExecCompiledRegexNode execNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            RegexObject regexObj = this.getRegexObject();
            if (args.length != 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(2, args.length);
            }
            byte[] input = expectByteArrayHostObjectNode.execute(args[0]);
            long fromIndex = toLongNode.execute(args[1]);
            if (fromIndex > Integer.MAX_VALUE) {
                return NoMatchResult.getInstance();
            }
            return execNode.execute(getCompiledRegexNode.execute(regexObj), input, (int)fromIndex);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class RegexObjectExecMethod
    extends AbstractRegexObject {
        private final RegexObject regex;

        public RegexObjectExecMethod(RegexObject regex) {
            this.regex = regex;
        }

        public RegexObject getRegexObject() {
            return this.regex;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Cached GetCompiledRegexNode getCompiledRegexNode, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ToLongNode toLongNode, @Cached ExecCompiledRegexNode execNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != 2) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(2, args.length);
            }
            Object input = expectStringOrTruffleObjectNode.execute(args[0]);
            long fromIndex = toLongNode.execute(args[1]);
            if (fromIndex > Integer.MAX_VALUE) {
                return NoMatchResult.getInstance();
            }
            return execNode.execute(getCompiledRegexNode.execute(this.getRegexObject()), input, (int)fromIndex);
        }
    }

    @ImportStatic(value={RegexObject.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(String var1, Object var2, Object var3, int var4) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_EXEC)"}, limit="2")
        Object getStartIdentity(String symbol, Object receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectStringOrTruffleObjectNode.execute(input), fromIndex);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_EXEC)"}, limit="2", replaces={"getStartIdentity"})
        Object getStartEquals(String symbol, Object receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectStringOrTruffleObjectNode.execute(input), fromIndex);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_EXEC_BYTES)"}, limit="2")
        Object getEndIdentity(String symbol, Object receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectByteArrayHostObjectNode.execute(input), fromIndex);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_EXEC_BYTES)"}, limit="2", replaces={"getEndIdentity"})
        Object getEndEquals(String symbol, Object receiver, Object input, int fromIndex, @Cached(value="symbol") String cachedSymbol, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            return execNode.execute(receiver, expectByteArrayHostObjectNode.execute(input), fromIndex);
        }

        @Specialization(replaces={"getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object invokeGeneric(String symbol, Object receiver, Object input, int fromIndex, @Cached ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode, @Cached ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode, @Cached ExecCompiledRegexNode execNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            switch (symbol) {
                case "exec": {
                    return execNode.execute(receiver, expectStringOrTruffleObjectNode.execute(input), fromIndex);
                }
                case "execBytes": {
                    return execNode.execute(receiver, expectByteArrayHostObjectNode.execute(input), fromIndex);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }
    }

    @GenerateUncached
    static abstract class IsInvocableCacheNode
    extends Node {
        IsInvocableCacheNode() {
        }

        abstract boolean execute(String var1);

        @Specialization(guards={"symbol == cachedSymbol"}, limit="2")
        static boolean cacheIdentity(String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(String symbol) {
            return RegexObject.PROP_EXEC.equals(symbol) || RegexObject.PROP_EXEC_BYTES.equals(symbol);
        }
    }
}

