/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.TwoCharMatcherNodeGen;
import com.oracle.truffle.regex.tregex.util.DebugUtil;

public abstract class TwoCharMatcher
extends InvertibleCharMatcher {
    private final int c1;
    private final int c2;

    TwoCharMatcher(boolean invert, int c1, int c2) {
        super(invert);
        assert (c1 != c2);
        this.c1 = c1;
        this.c2 = c2;
    }

    public static TwoCharMatcher create(boolean invert, int c1, int c2) {
        return TwoCharMatcherNodeGen.create(invert, c1, c2);
    }

    @Specialization
    public boolean match(int m3) {
        return this.result(m3 == this.c1 || m3 == this.c2);
    }

    @Override
    public int estimatedCost() {
        return 2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.modifiersToString() + DebugUtil.charToString(this.c1) + "||" + DebugUtil.charToString(this.c2);
    }
}

