/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class PureNFA
implements StateIndex<PureNFAState> {
    private final int subTreeId;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PureNFAState[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PureNFATransition[] transitions;

    public PureNFA(RegexASTSubtreeRootNode astSubRoot, PureNFAState[] states, Counter.ThresholdCounter stateIDCounter, Counter.ThresholdCounter transitionIDCounter) {
        this.subTreeId = astSubRoot.getSubTreeId();
        this.states = new PureNFAState[stateIDCounter.getCount()];
        this.transitions = new PureNFATransition[transitionIDCounter.getCount()];
        for (PureNFAState s2 : states) {
            if (s2 == null) continue;
            assert (this.states[s2.getId()] == null);
            this.states[s2.getId()] = s2;
            for (PureNFATransition t : (PureNFATransition[])s2.getSuccessors()) {
                if (s2.getId() != 0) {
                    t.getTarget().addPredecessor(t);
                }
                assert (this.transitions[t.getId()] == null || s2.getId() == 0 && this.transitions[t.getId()] == t);
                this.transitions[t.getId()] = t;
            }
        }
    }

    public int getSubTreeId() {
        return this.subTreeId;
    }

    public PureNFAState getDummyInitialState() {
        assert (((PureNFATransition[])this.states[0].getSuccessors()).length == 2 && ((PureNFATransition[])this.states[0].getPredecessors()).length == 2);
        return this.states[0];
    }

    public int getNumberOfEntryPoints() {
        return ((PureNFATransition[])this.getDummyInitialState().getSuccessors()).length / 2;
    }

    public PureNFATransition getAnchoredEntry() {
        return ((PureNFATransition[])this.getDummyInitialState().getSuccessors())[0];
    }

    public PureNFATransition getUnAnchoredEntry() {
        return ((PureNFATransition[])this.getDummyInitialState().getSuccessors())[1];
    }

    public PureNFAState getUnAnchoredInitialState() {
        return this.getUnAnchoredEntry().getTarget();
    }

    public PureNFAState getAnchoredInitialState() {
        return this.getAnchoredEntry().getTarget();
    }

    public PureNFATransition getReverseAnchoredEntry() {
        return ((PureNFATransition[])this.getDummyInitialState().getPredecessors())[0];
    }

    public PureNFATransition getReverseUnAnchoredEntry() {
        return ((PureNFATransition[])this.getDummyInitialState().getPredecessors())[1];
    }

    public PureNFAState getUnAnchoredFinalState() {
        return this.getReverseUnAnchoredEntry().getSource();
    }

    public PureNFAState getAnchoredFinalState() {
        return this.getReverseAnchoredEntry().getSource();
    }

    public PureNFAState getUnAnchoredInitialState(boolean forward) {
        return forward ? this.getUnAnchoredInitialState() : this.getUnAnchoredFinalState();
    }

    public PureNFAState getAnchoredInitialState(boolean forward) {
        return forward ? this.getAnchoredInitialState() : this.getAnchoredFinalState();
    }

    public PureNFAState[] getStates() {
        return this.states;
    }

    public PureNFATransition[] getTransitions() {
        return this.transitions;
    }

    @Override
    public int getNumberOfStates() {
        return this.states.length;
    }

    @Override
    public int getId(PureNFAState state) {
        assert (this.states[state.getId()] == state);
        return state.getId();
    }

    @Override
    public PureNFAState getState(int id) {
        return this.states[id];
    }

    public void materializeGroupBoundaries() {
        for (PureNFATransition t : this.transitions) {
            if (t == null) continue;
            t.getGroupBoundaries().materializeArrays();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson(RegexAST ast) {
        return Json.obj(Json.prop("states", Arrays.stream(this.states).map(x -> x == null || x == this.getDummyInitialState() || x.isAnchoredFinalState() && !x.hasPredecessors() ? Json.nullValue() : x.toJson(ast))), Json.prop("transitions", Arrays.stream(this.transitions).map(x -> x == null || x.getSource() == this.getDummyInitialState() ? Json.nullValue() : x.toJson(ast))), Json.prop("anchoredEntry", Json.array(Json.val(this.getAnchoredInitialState().getId()))), Json.prop("unAnchoredEntry", Json.array(Json.val(this.getUnAnchoredInitialState().getId()))));
    }
}

