/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.RegexParserGlobals;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CalcASTPropsVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.CopyVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.InitIDVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.MarkLookBehindEntriesVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.NodeCountVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.SetSourceSectionVisitor;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyFlavor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.ArrayList;
import java.util.Arrays;

public final class RegexParser {
    private final RegexParserGlobals globals;
    private final RegexAST ast;
    private final RegexSource source;
    private final RegexFlags flags;
    private final RegexOptions options;
    private final RegexLexer lexer;
    private final RegexProperties properties;
    private final Counter.ThresholdCounter groupCount;
    private final CopyVisitor copyVisitor;
    private final NodeCountVisitor countVisitor;
    private final SetSourceSectionVisitor setSourceSectionVisitor;
    private Sequence curSequence;
    private Group curGroup;
    private Term curTerm;
    private final CompilationBuffer compilationBuffer;

    @CompilerDirectives.TruffleBoundary
    public RegexParser(RegexLanguage language, RegexSource source, RegexFlags flags, RegexOptions options, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this.globals = language.parserGlobals;
        this.source = source;
        this.flags = flags;
        this.options = options;
        this.lexer = new RegexLexer(source, flags, options);
        this.ast = new RegexAST(language, source, flags, options);
        this.properties = this.ast.getProperties();
        this.groupCount = this.ast.getGroupCount();
        this.copyVisitor = new CopyVisitor(this.ast);
        this.countVisitor = new NodeCountVisitor();
        this.setSourceSectionVisitor = options.isDumpAutomata() ? new SetSourceSectionVisitor(this.ast) : null;
        this.compilationBuffer = compilationBuffer;
    }

    public static Group parseRootLess(RegexLanguage language, String pattern) throws RegexSyntaxException {
        return new RegexParser(language, new RegexSource(pattern, "", Encodings.UTF_16_RAW), RegexFlags.DEFAULT, RegexOptions.DEFAULT, new CompilationBuffer(Encodings.UTF_16_RAW)).parse(false);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexAST parse() throws RegexSyntaxException {
        this.ast.setRoot(this.parse(true));
        return this.ast;
    }

    public void prepareForDFA() {
        if (this.properties.hasQuantifiers()) {
            UnrollQuantifiersVisitor.unrollQuantifiers(this, this.ast.getRoot());
        }
        CalcASTPropsVisitor.run(this.ast);
        for (LookAroundAssertion lb : this.ast.getLookArounds()) {
            if (!lb.isLookBehindAssertion() || lb.isLiteral()) continue;
            this.properties.setNonLiteralLookBehindAssertions();
            break;
        }
        this.ast.createPrefix();
        InitIDVisitor.init(this.ast);
        if (!(this.properties.hasNonLiteralLookBehindAssertions() || this.properties.hasBackReferences() || this.properties.hasLargeCountedRepetitions())) {
            new MarkLookBehindEntriesVisitor(this.ast).run();
        }
        this.checkInnerLiteral();
    }

    private void checkInnerLiteral() {
        if (this.ast.isLiteralString() || this.ast.getRoot().startsWithCaret() || this.ast.getRoot().endsWithDollar() || this.ast.getRoot().size() != 1 || this.flags.isSticky()) {
            return;
        }
        ArrayList<Term> terms = this.ast.getRoot().getFirstAlternative().getTerms();
        int literalStart = -1;
        int literalEnd = -1;
        int maxPath = 0;
        for (int i = 0; i < terms.size(); ++i) {
            Term t = terms.get(i);
            if (t.isCharacterClass() && (t.asCharacterClass().getCharSet().matchesSingleChar() || t.asCharacterClass().getCharSet().matches2CharsWith1BitDifference()) && this.ast.getEncoding().isFixedCodePointWidth(t.asCharacterClass().getCharSet()) && (this.ast.getEncoding() == Encodings.UTF_16_RAW || !t.asCharacterClass().getCharSet().intersects(Constants.SURROGATES))) {
                if (literalStart < 0) {
                    literalStart = i;
                }
                literalEnd = i + 1;
                continue;
            }
            if (literalStart >= 0 || t.hasLoops() || t.hasBackReferences()) break;
            maxPath = t.getMaxPath();
            if (maxPath <= 4) continue;
            return;
        }
        if (literalStart >= 0 && (literalStart > 0 || literalEnd - literalStart > 1)) {
            this.properties.setInnerLiteral(literalStart, literalEnd);
        }
    }

    public RegexFlags getFlags() {
        return this.flags;
    }

    private void setComplexLookAround() {
        if (this.curGroup.isInLookAheadAssertion()) {
            this.properties.setComplexLookAheadAssertions();
        }
        if (this.curGroup.isInLookBehindAssertion()) {
            this.properties.setComplexLookBehindAssertions();
        }
    }

    private void createGroup(Token token) {
        this.createGroup(token, true, false, true, null);
    }

    private void createCaptureGroup(Token token) {
        this.createGroup(token, true, true, true, null);
    }

    private Group createGroup(Token token, boolean addToSeq, boolean capture, RegexASTSubtreeRootNode parent) {
        return this.createGroup(token, addToSeq, capture, true, parent);
    }

    private Group createGroup(Token token, boolean addToSeq, boolean capture, boolean setEnclosed, RegexASTSubtreeRootNode parent) {
        Group group;
        Group group2 = group = capture ? this.ast.createCaptureGroup(this.groupCount.inc()) : this.ast.createGroup();
        if (parent != null) {
            parent.setGroup(group);
        }
        if (addToSeq) {
            this.setComplexLookAround();
            this.addTerm(group);
        }
        this.ast.addSourceSection(group, token);
        this.curGroup = group;
        if (setEnclosed) {
            this.curGroup.setEnclosedCaptureGroupsLow(this.groupCount.getCount());
        }
        this.addSequence();
        return group;
    }

    private void addSequence() {
        if (!this.curGroup.isEmpty()) {
            this.setComplexLookAround();
        }
        this.curSequence = this.curGroup.addSequence(this.ast);
        this.curTerm = null;
    }

    private void popGroup(Token token) throws RegexSyntaxException {
        this.popGroup(token, true);
    }

    private void popGroup(Token token, boolean setEnclosed) throws RegexSyntaxException {
        if (setEnclosed) {
            this.curGroup.setEnclosedCaptureGroupsHigh(this.groupCount.getCount());
        }
        this.ast.addSourceSection(this.curGroup, token);
        if (this.curGroup.getParent().isLookAroundAssertion()) {
            this.ast.addSourceSection(this.curGroup.getParent(), token);
        }
        this.curTerm = this.curGroup;
        RegexASTNode parent = this.curGroup.getParent();
        if (parent instanceof RegexASTRootNode) {
            throw this.syntaxError("Unmatched ')'");
        }
        if (parent.isLookAroundAssertion()) {
            this.curSequence = parent.getParent().asSequence();
            this.curTerm = (Term)parent;
            this.optimizeLookAround();
        } else {
            this.curSequence = (Sequence)parent;
        }
        this.curGroup = this.curSequence.getParent();
    }

    private void optimizeLookAround() {
        Sequence wrapSeq;
        LookAroundAssertion lookaround = (LookAroundAssertion)this.curTerm;
        Group group = lookaround.getGroup();
        if (!group.isCapturing()) {
            if (group.isEmpty() || group.size() == 1 && group.getFirstAlternative().isEmpty()) {
                if (lookaround.isNegated()) {
                    this.replaceCurTermWithDeadNode();
                } else {
                    this.removeCurTerm();
                }
            } else if (!lookaround.isNegated()) {
                if (group.size() == 1 && group.getFirstAlternative().size() == 1 && group.getFirstAlternative().getFirstTerm().isPositionAssertion()) {
                    this.removeCurTerm();
                    this.addTerm(group.getFirstAlternative().getFirstTerm());
                } else {
                    int innerPositionAssertion = -1;
                    for (int i = 0; i < group.size(); ++i) {
                        Sequence s2 = group.getAlternatives().get(i);
                        if (s2.size() != 1 || !s2.getFirstTerm().isPositionAssertion()) continue;
                        innerPositionAssertion = i;
                        break;
                    }
                    if (innerPositionAssertion >= 0) {
                        this.curSequence.removeLastTerm();
                        Sequence removed = group.getAlternatives().remove(innerPositionAssertion);
                        Group wrapGroup = this.ast.createGroup();
                        wrapGroup.setEnclosedCaptureGroupsLow(group.getEnclosedCaptureGroupsLow());
                        wrapGroup.setEnclosedCaptureGroupsHigh(group.getEnclosedCaptureGroupsHigh());
                        wrapGroup.add(removed);
                        wrapSeq = wrapGroup.addSequence(this.ast);
                        wrapSeq.add(lookaround);
                        this.addTerm(wrapGroup);
                    }
                }
            }
        }
        if (lookaround.isNegated() && group.size() == 1 && group.getFirstAlternative().isSingleCharClass()) {
            this.ast.invertNegativeLookAround(lookaround);
            CharacterClass cc = group.getFirstAlternative().getFirstTerm().asCharacterClass();
            assert (!this.flags.isUnicode() || !this.options.isUTF16ExplodeAstralSymbols() || cc.getCharSet().matchesNothing() || cc.getCharSet().getMax() <= 65535);
            assert (!group.hasEnclosedCaptureGroups());
            cc.setCharSet(cc.getCharSet().createInverse(this.ast.getEncoding()));
            this.ast.updatePropsCC(cc);
            this.curSequence.removeLastTerm();
            Group wrapGroup = this.ast.createGroup();
            Sequence positionAssertionSeq = wrapGroup.addSequence(this.ast);
            positionAssertionSeq.add(this.ast.createPositionAssertion(lookaround.isLookAheadAssertion() ? PositionAssertion.Type.DOLLAR : PositionAssertion.Type.CARET));
            wrapSeq = wrapGroup.addSequence(this.ast);
            wrapSeq.add(lookaround);
            this.addTerm(wrapGroup);
        }
    }

    private void addTerm(Term term) {
        this.curSequence.add(term);
        this.curTerm = term;
    }

    private void addLookBehindAssertion(Token token, boolean negate) {
        LookBehindAssertion lookBehind = this.ast.createLookBehindAssertion(negate);
        this.ast.addSourceSection(lookBehind, token);
        this.addTerm(lookBehind);
        this.createGroup(token, false, false, lookBehind);
    }

    private void addLookAheadAssertion(Token token, boolean negate) {
        LookAheadAssertion lookAhead = this.ast.createLookAheadAssertion(negate);
        this.ast.addSourceSection(lookAhead, token);
        this.addTerm(lookAhead);
        this.createGroup(token, false, false, lookAhead);
    }

    private Term translateUnicodeCharClass(Token.CharacterClass token) {
        CodePointSet codePointSet = token.getCodePointSet();
        if (!this.options.isUTF16ExplodeAstralSymbols() || Constants.BMP_WITHOUT_SURROGATES.contains(token.getCodePointSet())) {
            return this.createCharClass(codePointSet, token, token.wasSingleChar());
        }
        Group group = this.ast.createGroup();
        group.setEnclosedCaptureGroupsLow(this.groupCount.getCount());
        group.setEnclosedCaptureGroupsHigh(this.groupCount.getCount());
        IntRangesBuffer tmp = this.compilationBuffer.getIntRangesBuffer1();
        CodePointSet bmpRanges = codePointSet.createIntersection(Constants.BMP_WITHOUT_SURROGATES, tmp);
        CodePointSet astralRanges = codePointSet.createIntersection(Constants.ASTRAL_SYMBOLS, tmp);
        CodePointSet loneLeadSurrogateRanges = codePointSet.createIntersection(Constants.LEAD_SURROGATES, tmp);
        CodePointSet loneTrailSurrogateRanges = codePointSet.createIntersection(Constants.TRAIL_SURROGATES, tmp);
        assert (astralRanges.matchesSomething() || loneLeadSurrogateRanges.matchesSomething() || loneTrailSurrogateRanges.matchesSomething());
        if (bmpRanges.matchesSomething()) {
            Sequence bmpAlternative = group.addSequence(this.ast);
            bmpAlternative.add(this.createCharClass(bmpRanges, token));
        }
        if (loneLeadSurrogateRanges.matchesSomething()) {
            Sequence loneLeadSurrogateAlternative = group.addSequence(this.ast);
            loneLeadSurrogateAlternative.add(this.createCharClass(loneLeadSurrogateRanges, token));
            loneLeadSurrogateAlternative.add(this.globals.noTrailSurrogateAhead.copyRecursive(this.ast, this.compilationBuffer));
        }
        if (loneTrailSurrogateRanges.matchesSomething()) {
            Sequence loneTrailSurrogateAlternative = group.addSequence(this.ast);
            loneTrailSurrogateAlternative.add(this.globals.noLeadSurrogateBehind.copyRecursive(this.ast, this.compilationBuffer));
            loneTrailSurrogateAlternative.add(this.createCharClass(loneTrailSurrogateRanges, token));
        }
        if (astralRanges.matchesSomething()) {
            CodePointSetAccumulator completeRanges = this.compilationBuffer.getCodePointSetAccumulator1();
            completeRanges.clear();
            char curLead = Character.highSurrogate(astralRanges.getLo(0));
            CodePointSetAccumulator curTrails = this.compilationBuffer.getCodePointSetAccumulator2();
            curTrails.clear();
            for (int i = 0; i < astralRanges.size(); ++i) {
                Sequence finishedAlternative;
                char startLead = Character.highSurrogate(astralRanges.getLo(i));
                char startTrail = Character.lowSurrogate(astralRanges.getLo(i));
                char endLead = Character.highSurrogate(astralRanges.getHi(i));
                char endTrail = Character.lowSurrogate(astralRanges.getHi(i));
                if (startLead > curLead) {
                    if (!curTrails.isEmpty()) {
                        finishedAlternative = group.addSequence(this.ast);
                        finishedAlternative.add(this.createCharClass(CodePointSet.create((int)curLead), token));
                        finishedAlternative.add(this.createCharClass(curTrails.toCodePointSet(), token));
                    }
                    curLead = startLead;
                    curTrails.clear();
                }
                if (startLead == endLead) {
                    curTrails.addRange(startTrail, endTrail);
                    continue;
                }
                if (startTrail != Constants.TRAIL_SURROGATES.getLo(0)) {
                    curTrails.addRange(startTrail, Constants.TRAIL_SURROGATES.getHi(0));
                    assert (startLead < '\uffff');
                    startLead = (char)(startLead + '\u0001');
                }
                if (!curTrails.isEmpty()) {
                    finishedAlternative = group.addSequence(this.ast);
                    finishedAlternative.add(this.createCharClass(CodePointSet.create((int)curLead), token));
                    finishedAlternative.add(this.createCharClass(curTrails.toCodePointSet(), token));
                }
                curLead = endLead;
                curTrails.clear();
                if (endTrail != Constants.TRAIL_SURROGATES.getHi(0)) {
                    curTrails.addRange(Constants.TRAIL_SURROGATES.getLo(0), endTrail);
                    assert (endLead > '\u0000');
                    endLead = (char)(endLead - '\u0001');
                }
                if (startLead > endLead) continue;
                completeRanges.addRange(startLead, endLead);
            }
            if (!curTrails.isEmpty()) {
                Sequence lastAlternative = group.addSequence(this.ast);
                lastAlternative.add(this.createCharClass(CodePointSet.create((int)curLead), token));
                lastAlternative.add(this.createCharClass(curTrails.toCodePointSet(), token));
            }
            if (!completeRanges.isEmpty()) {
                Sequence completeRangesAlt = this.ast.createSequence();
                group.insertFirst(completeRangesAlt);
                completeRangesAlt.add(this.createCharClass(completeRanges.toCodePointSet(), token));
                completeRangesAlt.add(this.createCharClass(Constants.TRAIL_SURROGATES, token));
            }
        }
        if (group.size() > 1) {
            this.properties.setAlternations();
        }
        assert (group.size() != 1 || group.getFirstAlternative().getTerms().size() != 1);
        return group;
    }

    private void addCharClass(Token.CharacterClass token) {
        CodePointSet codePointSet = token.getCodePointSet();
        if (this.flags.isUnicode()) {
            if (codePointSet.matchesNothing()) {
                this.addTerm(this.createCharClass(CodePointSet.getEmpty(), token));
            } else {
                this.addTerm(this.translateUnicodeCharClass(token));
            }
        } else {
            this.addTerm(this.createCharClass(codePointSet, token, token.wasSingleChar()));
        }
    }

    private CharacterClass createCharClass(CodePointSet charSet, Token token) {
        return this.createCharClass(charSet, token, false);
    }

    private CharacterClass createCharClass(CodePointSet charSet, Token token, boolean wasSingleChar) {
        CharacterClass characterClass = this.ast.createCharacterClass(charSet);
        this.ast.addSourceSection(characterClass, token);
        if (wasSingleChar) {
            characterClass.setWasSingleChar();
        }
        return characterClass;
    }

    private void createOptionalBranch(QuantifiableTerm term, Token.Quantifier quantifier, boolean copy, boolean unroll, int recurse) throws RegexSyntaxException {
        this.addTerm(copy ? this.copyVisitor.copy(term) : term);
        this.curTerm.setExpandedQuantifier(false);
        ((QuantifiableTerm)this.curTerm).setQuantifier(null);
        this.curTerm.setEmptyGuard(true);
        this.createOptional(term, quantifier, true, unroll, recurse - 1);
    }

    private void createOptional(QuantifiableTerm term, Token.Quantifier quantifier, boolean copy, boolean unroll, int recurse) throws RegexSyntaxException {
        if (recurse < 0) {
            return;
        }
        this.properties.setAlternations();
        if (copy) {
            this.createGroup(null, true, false, false, null);
        }
        this.curGroup.setExpandedQuantifier(unroll);
        this.curGroup.setQuantifier(quantifier);
        if (term.isGroup()) {
            this.curGroup.setEnclosedCaptureGroupsLow(term.asGroup().getEnclosedCaptureGroupsLow());
            this.curGroup.setEnclosedCaptureGroupsHigh(term.asGroup().getEnclosedCaptureGroupsHigh());
        }
        if (quantifier.isGreedy()) {
            this.createOptionalBranch(term, quantifier, copy, unroll, recurse);
            this.addSequence();
            this.curSequence.setExpandedQuantifier(true);
        } else {
            this.curSequence.setExpandedQuantifier(true);
            this.addSequence();
            this.createOptionalBranch(term, quantifier, copy, unroll, recurse);
        }
        this.popGroup(null, false);
    }

    private void expandQuantifier(QuantifiableTerm toExpand, boolean unroll) {
        assert (toExpand.hasNotUnrolledQuantifier());
        Token.Quantifier quantifier = toExpand.getQuantifier();
        assert (!unroll || toExpand.isUnrollingCandidate());
        this.curTerm = toExpand;
        this.curSequence = (Sequence)this.curTerm.getParent();
        this.curGroup = this.curSequence.getParent();
        ObjectArrayBuffer<Term> buf = this.compilationBuffer.getObjectBuffer1();
        if (unroll && quantifier.getMin() > 0) {
            int i;
            int size = this.curSequence.size();
            for (i = this.curTerm.getSeqIndex() + 1; i < size; ++i) {
                buf.add(this.curSequence.getLastTerm());
                this.curSequence.removeLastTerm();
            }
            this.curTerm.setExpandedQuantifier(true);
            for (i = 0; i < quantifier.getMin() - 1; ++i) {
                this.addTerm(this.copyVisitor.copy(this.curTerm));
                this.curTerm.setExpandedQuantifier(true);
            }
        } else {
            assert (!unroll || quantifier.getMin() == 0);
            toExpand.getParent().asSequence().replace(toExpand.getSeqIndex(), this.createGroup(null, false, false, false, null));
        }
        this.createOptional(toExpand, quantifier, unroll && quantifier.getMin() > 0, unroll, !unroll || quantifier.isInfiniteLoop() ? 0 : quantifier.getMax() - quantifier.getMin() - 1);
        if (!unroll || quantifier.isInfiniteLoop()) {
            ((Group)this.curTerm).setLoop(true);
        }
        if (unroll && quantifier.getMin() > 0) {
            for (int i = buf.length() - 1; i >= 0; --i) {
                this.curSequence.add((Term)buf.get(i));
            }
        }
    }

    private void substitute(Token token, Group substitution) {
        Group copy = substitution.copyRecursive(this.ast, this.compilationBuffer);
        if (this.options.isDumpAutomata()) {
            this.setSourceSectionVisitor.run(copy, token);
        }
        this.addTerm(copy);
    }

    private Group parse(boolean rootCapture) throws RegexSyntaxException {
        RegexASTRootNode rootParent = this.ast.createRootNode();
        Group root = this.createGroup(null, false, rootCapture, rootParent);
        if (this.options.isDumpAutomata()) {
            this.ast.addSourceSections(root, Arrays.asList(this.ast.getSource().getSource().createSection(0, 1), this.ast.getSource().getSource().createSection(this.ast.getSource().getPattern().length() + 1, 1)));
        }
        Token token = null;
        while (this.lexer.hasNext()) {
            Token.Kind prevKind = token == null ? null : token.kind;
            token = this.lexer.next();
            if (this.options.getFlavor() != RubyFlavor.INSTANCE && token.kind != Token.Kind.quantifier && this.curTerm != null && this.curTerm.isBackReference() && this.curTerm.asBackReference().isNestedOrForwardReference() && !RegexParser.isNestedInLookBehindAssertion(this.curTerm)) {
                this.removeCurTerm();
            }
            switch (token.kind) {
                case caret: {
                    if (prevKind == Token.Kind.caret) break;
                    if (this.flags.isMultiline()) {
                        this.substitute(token, this.globals.multiLineCaretSubstitution);
                        this.properties.setAlternations();
                        break;
                    }
                    PositionAssertion caret = this.ast.createPositionAssertion(PositionAssertion.Type.CARET);
                    this.ast.addSourceSection(caret, token);
                    this.addTerm(caret);
                    break;
                }
                case dollar: {
                    if (prevKind == Token.Kind.dollar) break;
                    if (this.flags.isMultiline()) {
                        this.substitute(token, this.globals.multiLineDollarSubsitution);
                        this.properties.setAlternations();
                        break;
                    }
                    PositionAssertion dollar = this.ast.createPositionAssertion(PositionAssertion.Type.DOLLAR);
                    this.ast.addSourceSection(dollar, token);
                    this.addTerm(dollar);
                    break;
                }
                case wordBoundary: {
                    if (prevKind == Token.Kind.wordBoundary) break;
                    if (prevKind == Token.Kind.nonWordBoundary) {
                        this.replaceCurTermWithDeadNode();
                        break;
                    }
                    if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                        this.substitute(token, this.globals.unicodeIgnoreCaseWordBoundarySubstitution);
                    } else {
                        this.substitute(token, this.globals.wordBoundarySubstituion);
                    }
                    this.properties.setAlternations();
                    break;
                }
                case nonWordBoundary: {
                    if (prevKind == Token.Kind.nonWordBoundary) break;
                    if (prevKind == Token.Kind.wordBoundary) {
                        this.replaceCurTermWithDeadNode();
                        break;
                    }
                    if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                        this.substitute(token, this.globals.unicodeIgnoreCaseNonWordBoundarySubsitution);
                    } else {
                        this.substitute(token, this.globals.nonWordBoundarySubstitution);
                    }
                    this.properties.setAlternations();
                    break;
                }
                case backReference: {
                    BackReference backReference = this.ast.createBackReference(((Token.BackReference)token).getGroupNr());
                    this.ast.addSourceSection(backReference, token);
                    this.addTerm(backReference);
                    if (backReference.getGroupNr() >= this.groupCount.getCount()) {
                        backReference.setForwardReference();
                        break;
                    }
                    if (!RegexParser.isNestedBackReference(backReference)) break;
                    backReference.setNestedBackReference();
                    break;
                }
                case quantifier: {
                    this.parseQuantifier((Token.Quantifier)token);
                    break;
                }
                case alternation: {
                    if (this.tryMergeSingleCharClassAlternations()) break;
                    this.addSequence();
                    this.properties.setAlternations();
                    break;
                }
                case captureGroupBegin: {
                    this.properties.setCaptureGroups();
                    this.createCaptureGroup(token);
                    break;
                }
                case nonCaptureGroupBegin: {
                    this.createGroup(token);
                    break;
                }
                case lookAheadAssertionBegin: {
                    this.addLookAheadAssertion(token, ((Token.LookAheadAssertionBegin)token).isNegated());
                    break;
                }
                case lookBehindAssertionBegin: {
                    this.addLookBehindAssertion(token, ((Token.LookBehindAssertionBegin)token).isNegated());
                    break;
                }
                case groupEnd: {
                    if (this.tryMergeSingleCharClassAlternations()) {
                        this.curGroup.removeLastSequence();
                        this.ast.getNodeCount().dec();
                    }
                    this.optimizeGroup();
                    this.popGroup(token);
                    break;
                }
                case charClass: {
                    this.addCharClass((Token.CharacterClass)token);
                }
            }
        }
        if (this.curGroup != root) {
            throw this.syntaxError("Unterminated group");
        }
        this.optimizeGroup();
        root.setEnclosedCaptureGroupsHigh(this.groupCount.getCount());
        return root;
    }

    private static boolean isNestedBackReference(BackReference backReference) {
        RegexASTNode parent = backReference.getParent().getParent();
        while (parent.asGroup().getGroupNumber() != backReference.getGroupNr()) {
            if ((parent = parent.getParent()).isRoot()) {
                return false;
            }
            if (parent.isLookAroundAssertion()) {
                parent = parent.getParent();
            }
            parent = parent.getParent();
        }
        return true;
    }

    private static boolean isNestedInLookBehindAssertion(Term t) {
        RegexASTSubtreeRootNode parent = t.getSubTreeParent();
        while (parent.isLookAroundAssertion()) {
            if (parent.isLookBehindAssertion()) {
                return true;
            }
            parent = parent.getParent().getSubTreeParent();
        }
        return false;
    }

    private void optimizeGroup() {
        RegexParser.sortAlternatives(this.curGroup);
        this.mergeCommonPrefixes(this.curGroup);
    }

    private void parseQuantifier(Token.Quantifier quantifier) throws RegexSyntaxException {
        QuantifiableTerm prev;
        Term prevTerm;
        boolean curTermIsZeroWidthGroup;
        if (this.curTerm == null) {
            throw this.syntaxError("Quantifier without target");
        }
        if (this.flags.isUnicode() && this.curTerm.isLookAheadAssertion()) {
            throw this.syntaxError("Quantifier on lookahead assertion");
        }
        if (this.curTerm.isLookBehindAssertion()) {
            throw this.syntaxError("Quantifier on lookbehind assertion");
        }
        assert (this.curTerm == this.curSequence.getLastTerm());
        if (quantifier.getMin() == -1) {
            this.replaceCurTermWithDeadNode();
            return;
        }
        boolean bl = curTermIsZeroWidthGroup = this.curTerm.isGroup() && this.curTerm.asGroup().isAlwaysZeroWidth();
        if (quantifier.getMax() == 0 || quantifier.getMin() == 0 && (this.curTerm.isLookAroundAssertion() || curTermIsZeroWidthGroup || this.curTerm.isCharacterClass() && this.curTerm.asCharacterClass().getCharSet().matchesNothing())) {
            this.removeCurTerm();
            return;
        }
        this.ast.addSourceSection(this.curTerm, quantifier);
        if (this.curTerm.isLookAroundAssertion() || curTermIsZeroWidthGroup) {
            return;
        }
        if (quantifier.getMin() == 1 && quantifier.getMax() == 1) {
            return;
        }
        this.setQuantifier((QuantifiableTerm)this.curTerm, quantifier);
        if (this.curSequence.size() > 1 && (prevTerm = this.curSequence.getTerms().get(this.curSequence.size() - 2)).isQuantifiableTerm() && (prev = prevTerm.asQuantifiableTerm()).hasQuantifier() && ((QuantifiableTerm)this.curTerm).equalsSemantic(prev, true)) {
            long max;
            this.removeCurTerm();
            long min2 = (long)prev.getQuantifier().getMin() + (long)quantifier.getMin();
            long l = max = prev.getQuantifier().isInfiniteLoop() || quantifier.isInfiniteLoop() ? -1L : (long)prev.getQuantifier().getMax() + (long)quantifier.getMax();
            if (min2 > Integer.MAX_VALUE) {
                this.replaceCurTermWithDeadNode();
                return;
            }
            if (max > Integer.MAX_VALUE) {
                max = -1L;
            }
            this.setQuantifier(prev, Token.createQuantifier((int)min2, (int)max, prev.getQuantifier().isGreedy() || quantifier.isGreedy()));
        }
    }

    private void removeCurTerm() {
        this.ast.getNodeCount().dec(this.countVisitor.count(this.curSequence.getLastTerm()));
        this.curSequence.removeLastTerm();
        if (!this.curSequence.isEmpty()) {
            this.curTerm = this.curSequence.getLastTerm();
        }
    }

    private void replaceCurTermWithDeadNode() {
        this.removeCurTerm();
        this.addTerm(this.createCharClass(CodePointSet.getEmpty(), null));
    }

    private void setQuantifier(QuantifiableTerm term, Token.Quantifier quantifier) {
        term.setQuantifier(quantifier);
        if (!term.isUnrollingCandidate()) {
            this.properties.setLargeCountedRepetitions();
        }
        this.properties.setQuantifiers();
        if (quantifier.getMin() != quantifier.getMax()) {
            this.properties.setAlternations();
        }
    }

    private boolean tryMergeSingleCharClassAlternations() {
        if (this.curGroup.size() > 1 && this.curSequence.isSingleCharClass()) {
            assert (this.curSequence == this.curGroup.getAlternatives().get(this.curGroup.size() - 1));
            Sequence prevSequence = this.curGroup.getAlternatives().get(this.curGroup.size() - 2);
            if (prevSequence.isSingleCharClass()) {
                this.mergeCharClasses((CharacterClass)prevSequence.getFirstTerm(), (CharacterClass)this.curSequence.getFirstTerm());
                this.curSequence.removeLastTerm();
                this.ast.getNodeCount().dec();
                return true;
            }
        }
        return false;
    }

    private void mergeCharClasses(CharacterClass dst, CharacterClass src) {
        dst.setCharSet(dst.getCharSet().union(src.getCharSet()));
        dst.setWasSingleChar(false);
        this.ast.updatePropsCC(dst);
        this.ast.addSourceSections(dst, this.ast.getSourceSections(src));
    }

    private static void sortAlternatives(Group group) {
        if (group.size() < 2) {
            return;
        }
        int begin = 0;
        while (begin + 1 < group.size()) {
            int end = RegexParser.findSingleCharAlternatives(group, begin);
            if (end > begin + 1) {
                group.getAlternatives().subList(begin, end).sort((a, b) -> a.getFirstTerm().asCharacterClass().getCharSet().getMin() - b.getFirstTerm().asCharacterClass().getCharSet().getMin());
                begin = end;
                continue;
            }
            ++begin;
        }
    }

    private void mergeCommonPrefixes(Group group) {
        if (group.size() < 2) {
            return;
        }
        ArrayList<Sequence> newAlternatives = null;
        int lastEnd = 0;
        int begin = 0;
        while (begin + 1 < group.size()) {
            int end = RegexParser.findMatchingAlternatives(group, begin);
            if (end < 0) {
                ++begin;
                continue;
            }
            if (newAlternatives == null) {
                newAlternatives = new ArrayList<Sequence>();
            }
            for (int i = lastEnd; i < begin; ++i) {
                newAlternatives.add(group.getAlternatives().get(i));
            }
            lastEnd = end;
            int prefixSize = 1;
            while (RegexParser.alternativesAreEqualAt(group, begin, end, prefixSize)) {
                ++prefixSize;
            }
            Sequence prefixSeq = this.ast.createSequence();
            Group innerGroup = this.ast.createGroup();
            int enclosedCGLo = Integer.MAX_VALUE;
            int enclosedCGHi = Integer.MIN_VALUE;
            boolean emptyAlt = false;
            for (int i = begin; i < end; ++i) {
                Sequence s2 = group.getAlternatives().get(i);
                assert (s2.size() >= prefixSize);
                for (int j = 0; j < prefixSize; ++j) {
                    Term t = s2.getTerms().get(j);
                    if (i == begin) {
                        prefixSeq.add(t);
                        continue;
                    }
                    this.ast.addSourceSections(prefixSeq.getTerms().get(j), this.ast.getSourceSections(t));
                    this.ast.getNodeCount().dec(this.countVisitor.count(t));
                }
                if (i > begin && s2.size() - prefixSize == 1 && s2.getLastTerm().isCharacterClass() && !s2.getLastTerm().asCharacterClass().hasQuantifier() && innerGroup.getLastAlternative().isSingleCharClass()) {
                    this.mergeCharClasses(innerGroup.getLastAlternative().getFirstTerm().asCharacterClass(), s2.getLastTerm().asCharacterClass());
                    continue;
                }
                if (prefixSize == s2.size()) {
                    if (!emptyAlt) {
                        innerGroup.addSequence(this.ast);
                    }
                    emptyAlt = true;
                    continue;
                }
                Sequence copy = innerGroup.addSequence(this.ast);
                for (int j = prefixSize; j < s2.size(); ++j) {
                    Term t = s2.getTerms().get(j);
                    copy.add(t);
                    if (!t.isGroup()) continue;
                    Group g2 = t.asGroup();
                    if (g2.getEnclosedCaptureGroupsLow() != g2.getEnclosedCaptureGroupsHigh()) {
                        enclosedCGLo = Math.min(enclosedCGLo, g2.getEnclosedCaptureGroupsLow());
                        enclosedCGHi = Math.max(enclosedCGHi, g2.getEnclosedCaptureGroupsHigh());
                    }
                    if (!g2.isCapturing()) continue;
                    enclosedCGLo = Math.min(enclosedCGLo, g2.getGroupNumber());
                    enclosedCGHi = Math.max(enclosedCGHi, g2.getGroupNumber() + 1);
                }
            }
            if (enclosedCGLo != Integer.MAX_VALUE) {
                innerGroup.setEnclosedCaptureGroupsLow(enclosedCGLo);
                innerGroup.setEnclosedCaptureGroupsHigh(enclosedCGHi);
            }
            if (!(innerGroup.isEmpty() || innerGroup.size() == 1 && innerGroup.getFirstAlternative().isEmpty())) {
                this.mergeCommonPrefixes(innerGroup);
                prefixSeq.add(innerGroup);
            }
            newAlternatives.add(prefixSeq);
            begin = end;
        }
        if (newAlternatives != null) {
            for (int i = lastEnd; i < group.size(); ++i) {
                newAlternatives.add(group.getAlternatives().get(i));
            }
            group.setAlternatives(newAlternatives);
        }
    }

    private static boolean alternativesAreEqualAt(Group group, int altBegin, int altEnd, int iTerm) {
        if (group.getAlternatives().get(altBegin).size() <= iTerm) {
            return false;
        }
        Term cmp = group.getAlternatives().get(altBegin).getTerms().get(iTerm);
        for (int i = altBegin + 1; i < altEnd; ++i) {
            Sequence s2 = group.getAlternatives().get(i);
            if (s2.size() <= iTerm) {
                return false;
            }
            if (s2.getTerms().get(iTerm).equalsSemantic(cmp)) continue;
            return false;
        }
        return true;
    }

    private static int findMatchingAlternatives(Group group, int begin) {
        if (group.getAlternatives().get(begin).isEmpty()) {
            return -1;
        }
        Term cmp = group.getAlternatives().get(begin).getFirstTerm();
        int ret = -1;
        for (int i = begin + 1; i < group.size(); ++i) {
            Sequence s2 = group.getAlternatives().get(i);
            if (s2.isEmpty() || !cmp.equalsSemantic(s2.getFirstTerm())) {
                return ret;
            }
            ret = i + 1;
        }
        return ret;
    }

    private static int findSingleCharAlternatives(Group group, int begin) {
        int ret = -1;
        for (int i = begin; i < group.size(); ++i) {
            Sequence s2 = group.getAlternatives().get(i);
            if (s2.isEmpty() || !s2.getFirstTerm().isCharacterClass() || !s2.getFirstTerm().asCharacterClass().wasSingleChar()) {
                return ret;
            }
            ret = i + 1;
        }
        return ret;
    }

    private RegexSyntaxException syntaxError(String msg) {
        return new RegexSyntaxException(this.source, msg);
    }

    private static final class UnrollQuantifiersVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private final RegexParser parser;
        private final ShouldUnrollQuantifierVisitor shouldUnrollVisitor = new ShouldUnrollQuantifierVisitor();

        private UnrollQuantifiersVisitor(RegexParser parser) {
            this.parser = parser;
        }

        public static void unrollQuantifiers(RegexParser parser, RegexASTNode runRoot) {
            new UnrollQuantifiersVisitor(parser).run(runRoot);
        }

        @Override
        protected void visit(BackReference backReference) {
            if (backReference.hasNotUnrolledQuantifier()) {
                this.parser.expandQuantifier(backReference, this.shouldUnroll(backReference));
            }
        }

        @Override
        protected void visit(CharacterClass characterClass) {
            if (characterClass.hasNotUnrolledQuantifier()) {
                this.parser.expandQuantifier(characterClass, this.shouldUnroll(characterClass));
            }
        }

        @Override
        protected void leave(Group group) {
            if (group.hasNotUnrolledQuantifier() && !group.getFirstAlternative().isExpandedQuantifier() && !group.getLastAlternative().isExpandedQuantifier()) {
                this.parser.expandQuantifier(group, this.shouldUnroll(group) && this.shouldUnrollVisitor.shouldUnroll(group));
            }
        }

        private boolean shouldUnroll(QuantifiableTerm term) {
            return term.getQuantifier().isUnrollTrivial() || this.parser.ast.getNumberOfNodes() <= 4000 && term.isUnrollingCandidate();
        }

        private static final class ShouldUnrollQuantifierVisitor
        extends DepthFirstTraversalRegexASTVisitor {
            private Group root;
            private boolean result;

            private ShouldUnrollQuantifierVisitor() {
            }

            boolean shouldUnroll(Group group) {
                assert (group.hasQuantifier());
                this.result = true;
                this.root = group;
                this.run(group);
                return this.result;
            }

            @Override
            protected void visit(BackReference backReference) {
                this.result = false;
            }

            @Override
            protected void visit(Group group) {
                if (group != this.root && group.hasNotUnrolledQuantifier()) {
                    this.result = false;
                }
            }
        }
    }
}

