/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.util;

import com.oracle.truffle.regex.tregex.util.Exceptions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotExport {
    private static final Pattern specialChars = Pattern.compile("[\"\\\\]");

    public static void printConnection(BufferedWriter writer, String from, String to, String label) throws IOException {
        writer.write(String.format("    \"%s\" -> \"%s\" [ label = \"%s\" ];", DotExport.escape(from), DotExport.escape(to), DotExport.escape(label)));
        writer.newLine();
    }

    public static String escape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m3 = specialChars.matcher(str);
        while (m3.find()) {
            String replacement;
            switch (str.charAt(m3.start())) {
                case '\"': {
                    replacement = "\\\\\"";
                    break;
                }
                case '\\': {
                    replacement = "\\\\\\\\";
                    break;
                }
                default: {
                    throw Exceptions.shouldNotReachHere();
                }
            }
            m3.appendReplacement(escapedString, replacement);
        }
        m3.appendTail(escapedString);
        return escapedString.toString();
    }
}

