/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.util;

import com.oracle.truffle.regex.tregex.util.Exceptions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LaTexExport {
    private static final Pattern specialChars = Pattern.compile("[&%$#_{}~^\\\\]");

    public static String escape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m3 = specialChars.matcher(str);
        while (m3.find()) {
            String replacement;
            switch (str.charAt(m3.start())) {
                case '&': {
                    replacement = "\\\\&";
                    break;
                }
                case '%': {
                    replacement = "\\\\%";
                    break;
                }
                case '$': {
                    replacement = "\\\\\\$";
                    break;
                }
                case '#': {
                    replacement = "\\\\#";
                    break;
                }
                case '_': {
                    replacement = "\\\\_";
                    break;
                }
                case '{': {
                    replacement = "\\\\{";
                    break;
                }
                case '}': {
                    replacement = "\\\\}";
                    break;
                }
                case '~': {
                    replacement = "\\\\textasciitilde ";
                    break;
                }
                case '^': {
                    replacement = "\\\\textasciicircum ";
                    break;
                }
                case '\\': {
                    replacement = "\\\\textbackslash ";
                    break;
                }
                default: {
                    throw Exceptions.shouldNotReachHere();
                }
            }
            m3.appendReplacement(escapedString, replacement);
        }
        m3.appendTail(escapedString);
        return escapedString.toString();
    }
}

