/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.util.Boundaries;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public class TruffleReadOnlyMap
extends AbstractRegexObject {
    private final Map<String, ?> map;

    public TruffleReadOnlyMap(Map<String, ?> map) {
        this.map = map;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new TruffleReadOnlyKeysArray(Boundaries.setToArray(Boundaries.mapKeySet(this.map), new String[this.map.size()]));
    }

    @ExportMessage
    boolean isMemberReadable(String member, @Cached IsReadableCacheNode cache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) {
        return cache.execute(receiverProfile.profile(this), member);
    }

    @ExportMessage
    Object readMember(String member, @Cached ReadCacheNode readCache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) throws UnknownIdentifierException {
        return readCache.execute(receiverProfile.profile(this), member);
    }

    @GenerateUncached
    static abstract class ReadCacheNode
    extends Node {
        ReadCacheNode() {
        }

        abstract Object execute(TruffleReadOnlyMap var1, String var2) throws UnknownIdentifierException;

        @Specialization(guards={"receiver == cachedReceiver", "symbol == cachedSymbol", "result != null"}, limit="6")
        static Object readIdentity(TruffleReadOnlyMap receiver, String symbol, @Cached(value="receiver") TruffleReadOnlyMap cachedReceiver, @Cached(value="symbol") String cachedSymbol, @Cached(value="readDirect(cachedReceiver, cachedSymbol)") Object result) {
            return result;
        }

        @Specialization(guards={"receiver == cachedReceiver", "symbol.equals(cachedSymbol)", "result != null"}, limit="6", replaces={"readIdentity"})
        static Object readEquals(TruffleReadOnlyMap receiver, String symbol, @Cached(value="receiver") TruffleReadOnlyMap cachedReceiver, @Cached(value="symbol") String cachedSymbol, @Cached(value="readDirect(cachedReceiver, cachedSymbol)") Object result) {
            return result;
        }

        @Specialization(replaces={"readEquals"})
        static Object read(TruffleReadOnlyMap receiver, String symbol) throws UnknownIdentifierException {
            Object value = ReadCacheNode.readDirect(receiver, symbol);
            if (value != null) {
                return value;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }

        static Object readDirect(TruffleReadOnlyMap receiver, String symbol) {
            return Boundaries.mapGet(receiver.map, symbol);
        }
    }

    @GenerateUncached
    static abstract class IsReadableCacheNode
    extends Node {
        IsReadableCacheNode() {
        }

        abstract boolean execute(TruffleReadOnlyMap var1, String var2);

        @Specialization(guards={"receiver == cachedReceiver", "symbol == cachedSymbol", "result"}, limit="6")
        static boolean cacheIdentity(TruffleReadOnlyMap receiver, String symbol, @Cached(value="receiver") TruffleReadOnlyMap cachedReceiver, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(cachedReceiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"receiver == cachedReceiver", "symbol.equals(cachedSymbol)", "result"}, limit="6", replaces={"cacheIdentity"})
        static boolean cacheEquals(TruffleReadOnlyMap receiver, String symbol, @Cached(value="receiver") TruffleReadOnlyMap cachedReceiver, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(cachedReceiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isReadable(TruffleReadOnlyMap receiver, String symbol) {
            return Boundaries.mapContainsKey(receiver.map, symbol);
        }
    }
}

