/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Chunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.UTF8Decoder;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.utils.Charsets;

public class BufferChunk
implements Chunk {
    private static final UTF8Decoder UTF8_DECODER = new UTF8Decoder();
    private Buffer buffer;
    private boolean disposeOnRecycle;
    private int start;
    private int end;
    private int limit;
    String cachedString;
    Charset cachedStringCharset;

    public void setBufferChunk(Buffer buffer, int start, int end, boolean disposeOnRecycle) {
        this.setBufferChunk(buffer, start, end, end, disposeOnRecycle);
    }

    public void setBufferChunk(Buffer buffer, int start, int end) {
        this.setBufferChunk(buffer, start, end, end, false);
    }

    public void setBufferChunk(Buffer buffer, int start, int end, int limit) {
        this.setBufferChunk(buffer, start, end, limit, false);
    }

    public void setBufferChunk(Buffer buffer, int start, int end, int limit, boolean disposeOnRecycle) {
        this.disposeOnRecycle = disposeOnRecycle;
        this.buffer = buffer;
        this.start = start;
        this.end = end;
        this.limit = limit;
        this.resetStringCache();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.resetStringCache();
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.resetStringCache();
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
        this.resetStringCache();
    }

    @Override
    public final int getLength() {
        return this.end - this.start;
    }

    public final boolean isNull() {
        return this.buffer == null;
    }

    public void allocate(int size) {
        if (this.isNull() || this.limit - this.start < size) {
            this.setBufferChunk(Buffers.wrap(null, new byte[size]), 0, 0, size);
        }
        this.end = this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int start, int end) {
        int absDeleteStart = this.start + start;
        int absDeleteEnd = this.start + end;
        int diff = this.end - absDeleteEnd;
        if (diff == 0) {
            this.end = absDeleteStart;
        } else {
            int oldPos = this.buffer.position();
            int oldLim = this.buffer.limit();
            try {
                Buffers.setPositionLimit(this.buffer, absDeleteStart, absDeleteStart + diff);
                this.buffer.put(this.buffer, absDeleteEnd, diff);
                this.end = absDeleteStart + diff;
            }
            finally {
                Buffers.setPositionLimit(this.buffer, oldPos, oldLim);
            }
        }
        this.resetStringCache();
    }

    public void append(BufferChunk bc) {
        int oldPos = this.buffer.position();
        int oldLim = this.buffer.limit();
        int srcLen = bc.getLength();
        Buffers.setPositionLimit(this.buffer, this.end, this.end + srcLen);
        this.buffer.put(bc.getBuffer(), bc.getStart(), srcLen);
        Buffers.setPositionLimit(this.buffer, oldPos, oldLim);
        this.end += srcLen;
    }

    @Override
    public final int indexOf(char c, int fromIndex) {
        int idx = BufferChunk.indexOf(this.buffer, this.start + fromIndex, this.end, c);
        return idx >= this.start ? idx - this.start : -1;
    }

    @Override
    public final int indexOf(String s2, int fromIndex) {
        int idx = BufferChunk.indexOf(this.buffer, this.start + fromIndex, this.end, s2);
        return idx >= this.start ? idx - this.start : -1;
    }

    boolean startsWith(String s2, int pos) {
        int len = s2.length();
        if (len > this.getLength() - pos) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (this.buffer.get(off++) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s2, int pos) {
        int len = s2.length();
        if (len > this.getLength() - pos) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(this.buffer.get(off++)) == Ascii.toLower(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int findBytesAscii(byte[] b) {
        byte first = b[0];
        int from = this.getStart();
        int to = this.getEnd();
        int srcEnd = b.length;
        for (int i = from; i <= to - srcEnd; ++i) {
            if (Ascii.toLower(this.buffer.get(i)) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(this.buffer.get(myPos++)) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - from;
            }
        }
        return -1;
    }

    public int hash() {
        int code = 0;
        for (int i = this.start; i < this.end; ++i) {
            code = code * 31 + this.buffer.get(i);
        }
        return code;
    }

    public boolean equals(CharSequence s2) {
        if (this.getLength() != s2.length()) {
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (this.buffer.get(i) == s2.charAt(i - this.start)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(CharSequence s2) {
        if (this.getLength() != s2.length()) {
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (Ascii.toLower(this.buffer.get(i)) == Ascii.toLower(s2.charAt(i - this.start))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] b) {
        if (this.getLength() != b.length) {
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (Ascii.toLower(this.buffer.get(i)) == Ascii.toLower(b[i - this.start])) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCaseLowerCase(byte[] b) {
        return BufferChunk.equalsIgnoreCaseLowerCase(this.buffer, this.start, this.end, b);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Charset charset) {
        if (charset == null) {
            charset = Charsets.UTF8_CHARSET;
        }
        if (this.cachedString != null && charset.equals(this.cachedStringCharset)) {
            return this.cachedString;
        }
        this.cachedString = this.buffer.toStringContent(charset, this.start, this.end);
        this.cachedStringCharset = charset;
        return this.cachedString;
    }

    @Override
    public String toString(int start, int end) {
        return this.buffer.toStringContent(Charsets.UTF8_CHARSET, this.start + start, this.start + end);
    }

    protected final void resetStringCache() {
        this.cachedString = null;
        this.cachedStringCharset = null;
    }

    protected final void reset() {
        if (this.disposeOnRecycle) {
            this.disposeOnRecycle = false;
            this.buffer.tryDispose();
        }
        this.buffer = null;
        this.start = -1;
        this.end = -1;
        this.limit = -1;
        this.resetStringCache();
    }

    public final void recycle() {
        this.reset();
    }

    @Override
    public void notifyDirectUpdate() {
    }

    public static int indexOf(Buffer buffer, int off, int end, char qq) {
        while (off < end) {
            byte b = buffer.get(off);
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int indexOf(Buffer buffer, int off, int end, CharSequence s2) {
        int strLen = s2.length();
        if (strLen == 0) {
            return off;
        }
        if (strLen > end - off) {
            return -1;
        }
        int strOffs = 0;
        int lastOffs = end - strLen;
        while (off <= lastOffs + strOffs) {
            byte b = buffer.get(off);
            if (b == s2.charAt(strOffs)) {
                if (++strOffs == strLen) {
                    return off - strLen + 1;
                }
            } else {
                strOffs = 0;
            }
            ++off;
        }
        return -1;
    }

    public int compareIgnoreCase(int start, int end, String compareTo) {
        int result = 0;
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (Ascii.toLower(this.buffer.get(i + start)) > Ascii.toLower(compareTo.charAt(i))) {
                result = 1;
                continue;
            }
            if (Ascii.toLower(this.buffer.get(i + start)) >= Ascii.toLower(compareTo.charAt(i))) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    public int compare(int start, int end, String compareTo) {
        int result = 0;
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (this.buffer.get(i + start) > compareTo.charAt(i)) {
                result = 1;
                continue;
            }
            if (this.buffer.get(i + start) >= compareTo.charAt(i)) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    public CharChunk toChars(CharChunk cc, Charset encoding) throws CharConversionException {
        int length = this.getLength();
        cc.allocate(length, -1);
        if (Charsets.UTF8_CHARSET.equals(encoding)) {
            try {
                char[] ccBuf = cc.getChars();
                int ccStart = cc.getStart();
                int ccEnd = UTF8_DECODER.convert(this, ccBuf, ccStart);
                cc.setEnd(ccEnd);
            }
            catch (IOException e) {
                if (!(e instanceof CharConversionException)) {
                    throw new CharConversionException();
                }
                throw (CharConversionException)e;
            }
            return cc;
        }
        if (!Constants.DEFAULT_HTTP_CHARSET.equals(encoding)) {
            ByteBuffer bb = this.buffer.toByteBuffer(this.start, this.end);
            char[] ccBuf = cc.getChars();
            int ccStart = cc.getStart();
            CharBuffer cb = CharBuffer.wrap(ccBuf, ccStart, ccBuf.length - ccStart);
            CharsetDecoder decoder = Charsets.getCharsetDecoder(encoding);
            CoderResult cr = decoder.decode(bb, cb, true);
            if (cr != CoderResult.UNDERFLOW) {
                throw new CharConversionException("Decoding error");
            }
            cc.setEnd(cb.position());
            return cc;
        }
        char[] cbuf = cc.getChars();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(this.buffer.get(i + this.start) & 0xFF);
        }
        cc.setEnd(length);
        return cc;
    }

    public static boolean equalsIgnoreCaseLowerCase(Buffer buffer, int start, int end, byte[] cmpTo) {
        int len = end - start;
        if (len != cmpTo.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(buffer.get(i + start)) == cmpTo[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(Buffer buffer, int start, int end, byte[] cmpTo) {
        int len = end - start;
        if (len < cmpTo.length) {
            return false;
        }
        for (int i = 0; i < cmpTo.length; ++i) {
            if (buffer.get(start + i) == cmpTo[i]) continue;
            return false;
        }
        return true;
    }
}

