/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.StringCache;

public final class ByteChunk
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1L;
    public static Charset DEFAULT_CHARSET = Constants.DEFAULT_HTTP_CHARSET;
    private byte[] buff;
    private int start = 0;
    private int end;
    private Charset charset;
    private boolean isSet = false;
    private int limit = -1;
    private transient ByteInputChannel in = null;
    private transient ByteOutputChannel out = null;
    private boolean optimizedWrite = true;

    public ByteChunk() {
    }

    public ByteChunk(int initial) {
        this.allocate(initial, -1);
    }

    public ByteChunk getClone() {
        try {
            return (ByteChunk)this.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isNull() {
        return !this.isSet;
    }

    public void recycle() {
        this.charset = null;
        this.start = 0;
        this.end = 0;
        this.isSet = false;
    }

    public void reset() {
        this.buff = null;
    }

    public void allocate(int initial, int limit) {
        boolean output = true;
        if (this.buff == null || this.buff.length < initial) {
            this.buff = new byte[initial];
        }
        this.limit = limit;
        this.start = 0;
        this.end = 0;
        this.isSet = true;
    }

    public void setBytes(byte[] b, int off, int len) {
        this.buff = b;
        this.start = off;
        this.end = this.start + len;
        this.isSet = true;
    }

    public void setOptimizedWrite(boolean optimizedWrite) {
        this.optimizedWrite = optimizedWrite;
    }

    public Charset getCharset() {
        return this.charset != null ? this.charset : DEFAULT_CHARSET;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public byte[] getBytes() {
        return this.getBuffer();
    }

    public byte[] getBuffer() {
        return this.buff;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.start;
    }

    public void setOffset(int off) {
        if (this.end < off) {
            this.end = off;
        }
        this.start = off;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setByteInputChannel(ByteInputChannel in) {
        this.in = in;
    }

    public void setByteOutputChannel(ByteOutputChannel out) {
        this.out = out;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int i) {
        this.end = i;
    }

    public void append(char c) throws IOException {
        this.append((byte)c);
    }

    public void append(byte b) throws IOException {
        this.makeSpace(1);
        if (this.limit > 0 && this.end >= this.limit) {
            this.flushBuffer();
        }
        this.buff[this.end++] = b;
    }

    public void append(ByteChunk src) throws IOException {
        this.append(src.getBytes(), src.getStart(), src.getLength());
    }

    public void append(byte[] src, int off, int len) throws IOException {
        int remain;
        this.makeSpace(len);
        if (this.limit < 0) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (this.optimizedWrite && len == this.limit && this.end == this.start) {
            this.out.realWriteBytes(src, off, len);
            return;
        }
        if (len <= this.limit - this.end) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        int avail = this.limit - this.end;
        System.arraycopy(src, off, this.buff, this.end, avail);
        this.end += avail;
        this.flushBuffer();
        for (remain = len - avail; remain > this.limit - this.end; remain -= this.limit - this.end) {
            this.out.realWriteBytes(src, off + len - remain, this.limit - this.end);
        }
        System.arraycopy(src, off + len - remain, this.buff, this.end, remain);
        this.end += remain;
    }

    public int substract() throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        return this.buff[this.start++] & 0xFF;
    }

    public int substract(ByteChunk src) throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        int len = this.getLength();
        src.append(this.buff, this.start, len);
        this.start = this.end;
        return len;
    }

    public int substract(byte[] src, int off, int len) throws IOException {
        int n;
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        n = len;
        if (len > this.getLength()) {
            n = this.getLength();
        }
        System.arraycopy(this.buff, this.start, src, off, n);
        this.start += n;
        return n;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.limit + ' ' + this.buff.length);
        }
        this.out.realWriteBytes(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    boolean canGrow() {
        if (this.buff.length == this.limit) {
            return false;
        }
        int desiredSize = this.buff.length * 2;
        if (this.limit > 0 && desiredSize > this.limit && this.limit > this.end - this.start) {
            desiredSize = this.limit;
        }
        byte[] tmp = new byte[desiredSize];
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = 0;
        return true;
    }

    private void makeSpace(int count) {
        byte[] tmp;
        int desiredSize = this.end + count;
        if (this.limit > 0 && desiredSize > this.limit) {
            desiredSize = this.limit;
        }
        if (this.buff == null) {
            if (desiredSize < 256) {
                desiredSize = 256;
            }
            this.buff = new byte[desiredSize];
        }
        if (desiredSize <= this.buff.length) {
            return;
        }
        if (desiredSize < 2 * this.buff.length) {
            int newSize = this.buff.length * 2;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        } else {
            int newSize = this.buff.length * 2 + count;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        }
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = 0;
    }

    public String toString() {
        if (null == this.buff || this.end - this.start == 0) {
            return "";
        }
        return StringCache.toString(this);
    }

    public String toStringInternal() {
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        CharBuffer cb = this.charset.decode(ByteBuffer.wrap(this.buff, this.start, this.end - this.start));
        return cb.toString();
    }

    public int getInt() {
        return Ascii.parseInt(this.buff, this.start, this.end - this.start);
    }

    public long getLong() {
        return Ascii.parseLong(this.buff, this.start, this.end - this.start);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.buff);
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.charset.hashCode();
        result = 31 * result + (this.isSet ? 1 : 0);
        result = 31 * result + this.limit;
        result = 31 * result + this.in.hashCode();
        result = 31 * result + this.out.hashCode();
        result = 31 * result + (this.optimizedWrite ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteChunk byteChunk = (ByteChunk)o;
        if (this.end != byteChunk.end) {
            return false;
        }
        if (this.isSet != byteChunk.isSet) {
            return false;
        }
        if (this.limit != byteChunk.limit) {
            return false;
        }
        if (this.optimizedWrite != byteChunk.optimizedWrite) {
            return false;
        }
        if (this.start != byteChunk.start) {
            return false;
        }
        if (!Arrays.equals(this.buff, byteChunk.buff)) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(byteChunk.charset) : byteChunk.charset != null) {
            return false;
        }
        if (this.in != null ? !this.in.equals(byteChunk.in) : byteChunk.in != null) {
            return false;
        }
        return !(this.out != null ? !this.out.equals(byteChunk.out) : byteChunk.out != null);
    }

    public boolean equals(String s2) {
        byte[] b = this.buff;
        int blen = this.end - this.start;
        if (b == null || blen != s2.length()) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s2) {
        byte[] b = this.buff;
        int blen = this.end - this.start;
        if (b == null || blen != s2.length()) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (Ascii.toLower(b[boff++]) == Ascii.toLower(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(ByteChunk bb) {
        return this.equals(bb.getBytes(), bb.getStart(), bb.getLength());
    }

    public boolean equals(byte[] b2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (len2 != len || b1 == null || b2 == null) {
            return false;
        }
        int off1 = this.start;
        while (len-- > 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk cc) {
        return this.equals(cc.getChars(), cc.getStart(), cc.getLength());
    }

    public boolean equals(char[] c2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (c2 == null && b1 == null) {
            return true;
        }
        if (b1 == null || c2 == null || this.end - this.start != len2) {
            return false;
        }
        int off1 = this.start;
        int len = this.end - this.start;
        while (len-- > 0) {
            if ((char)b1[off1++] == c2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s2) {
        byte[] b = this.buff;
        int blen = s2.length();
        if (b == null || blen > this.end - this.start) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(byte[] b2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (b1 == null || b2 == null || b2.length > len) {
            return false;
        }
        int i = this.start;
        int j = 0;
        while (i < this.end && j < b2.length) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s2, int pos) {
        byte[] b = this.buff;
        int len = s2.length();
        if (b == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(b[off++]) == Ascii.toLower(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String src, int srcOff, int srcLen, int myOff) {
        char first = src.charAt(srcOff);
        int srcEnd = srcOff + srcLen;
        for (int i = myOff + this.start; i <= this.end - srcLen; ++i) {
            if (this.buff[i] != first) continue;
            int myPos = i + 1;
            int srcPos = srcOff + 1;
            while (srcPos < srcEnd && this.buff[myPos++] == src.charAt(srcPos++)) {
                if (srcPos != srcEnd) continue;
                return i - this.start;
            }
        }
        return -1;
    }

    public int hash() {
        return ByteChunk.hashBytes(this.buff, this.start, this.end - this.start);
    }

    public int hashIgnoreCase() {
        return ByteChunk.hashBytesIC(this.buff, this.start, this.end - this.start);
    }

    private static int hashBytes(byte[] buff, int start, int bytesLen) {
        int max = start + bytesLen;
        int code = 0;
        for (int i = start; i < max; ++i) {
            code = code * 37 + buff[i];
        }
        return code;
    }

    private static int hashBytesIC(byte[] bytes, int start, int bytesLen) {
        int max = start + bytesLen;
        int code = 0;
        for (int i = start; i < max; ++i) {
            code = code * 37 + Ascii.toLower(bytes[i]);
        }
        return code;
    }

    public int indexOf(char c, int starting) {
        int ret = ByteChunk.indexOf(this.buff, this.start + starting, this.end, c);
        return ret >= this.start ? ret - this.start : -1;
    }

    public static int indexOf(byte[] bytes, int off, int end, char qq) {
        while (off < end) {
            byte b = bytes[off];
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int findChar(byte[] buf, int start, int end, char c) {
        byte b = (byte)c;
        for (int offset = start; offset < end; ++offset) {
            if (buf[offset] != b) continue;
            return offset;
        }
        return -1;
    }

    public static int findChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        for (int offset = start; offset < end; ++offset) {
            for (int i = 0; i < clen; ++i) {
                if (buf[offset] != c[i]) continue;
                return offset;
            }
        }
        return -1;
    }

    public static int findNotChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        for (int offset = start; offset < end; ++offset) {
            boolean found = true;
            for (int i = 0; i < clen; ++i) {
                if (buf[offset] != c[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return offset;
        }
        return -1;
    }

    public static byte[] convertToBytes(String value) {
        byte[] result = new byte[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            result[i] = (byte)value.charAt(i);
        }
        return result;
    }

    public static interface ByteOutputChannel {
        public void realWriteBytes(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ByteInputChannel {
        public int realReadBytes(byte[] var1, int var2, int var3) throws IOException;
    }
}

