/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.grizzly.http.server.HttpServer;
import org.graphwalker.cli.Options;
import org.graphwalker.cli.commands.Check;
import org.graphwalker.cli.commands.Convert;
import org.graphwalker.cli.commands.Methods;
import org.graphwalker.cli.commands.Offline;
import org.graphwalker.cli.commands.Online;
import org.graphwalker.cli.commands.Requirements;
import org.graphwalker.cli.commands.Source;
import org.graphwalker.cli.util.LoggerUtil;
import org.graphwalker.cli.util.UnsupportedFileFormat;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.event.EventType;
import org.graphwalker.core.generator.SingletonRandomGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.SimpleMachine;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.dsl.antlr.DslException;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.common.ResourceUtils;
import org.graphwalker.io.common.Util;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.dot.DotContextFactory;
import org.graphwalker.io.factory.java.JavaContextFactory;
import org.graphwalker.io.factory.json.JsonContextFactory;
import org.graphwalker.io.factory.yed.YEdContextFactory;
import org.graphwalker.java.test.TestExecutor;
import org.graphwalker.modelchecker.ContextsChecker;
import org.graphwalker.restful.Restful;
import org.graphwalker.websocket.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLI {
    private static final Logger logger = LoggerFactory.getLogger(CLI.class);
    private Offline offline;
    private Online online;
    private Methods methods;
    private Requirements requirements;
    private Convert convert;
    private Source source;
    private Check check;
    private Command command = Command.NONE;

    public static void main(String[] args) {
        CLI cli = new CLI();
        try {
            cli.run(args);
        }
        catch (Exception e) {
            System.err.println(e + System.lineSeparator());
            logger.error("An error occurred when running command: " + StringUtils.join((Object[])args, " "), e);
        }
    }

    private void run(String[] args) {
        Options options = new Options();
        JCommander jc = new JCommander(options);
        jc.setProgramName("graphwalker");
        this.offline = new Offline();
        jc.addCommand("offline", this.offline);
        this.online = new Online();
        jc.addCommand("online", this.online);
        this.methods = new Methods();
        jc.addCommand("methods", this.methods);
        this.requirements = new Requirements();
        jc.addCommand("requirements", this.requirements);
        this.convert = new Convert();
        jc.addCommand("convert", this.convert);
        this.source = new Source();
        jc.addCommand("source", this.source);
        this.check = new Check();
        jc.addCommand("check", this.check);
        try {
            jc.parse(args);
            this.setLogLevel(options);
            if (options.help) {
                jc.usage();
                return;
            }
            if (options.version) {
                System.out.println(Util.printVersionInformation());
                return;
            }
            if (jc.getParsedCommand() == null) {
                throw new MissingCommandException("Missing a command. Add '--help'");
            }
            if (jc.getParsedCommand().equalsIgnoreCase("offline")) {
                this.command = Command.OFFLINE;
                this.runCommandOffline();
            } else if (jc.getParsedCommand().equalsIgnoreCase("online")) {
                this.command = Command.ONLINE;
                this.runCommandOnline();
            } else if (jc.getParsedCommand().equalsIgnoreCase("methods")) {
                this.command = Command.METHODS;
                this.runCommandMethods();
            } else if (jc.getParsedCommand().equalsIgnoreCase("requirements")) {
                this.command = Command.REQUIREMENTS;
                this.runCommandRequirements();
            } else if (jc.getParsedCommand().equalsIgnoreCase("convert")) {
                this.command = Command.CONVERT;
                this.runCommandConvert();
            } else if (jc.getParsedCommand().equalsIgnoreCase("source")) {
                this.command = Command.SOURCE;
                this.runCommandSource();
            } else if (jc.getParsedCommand().equalsIgnoreCase("check")) {
                this.command = Command.CHECK;
                this.runCommandCheck();
            }
        }
        catch (MissingCommandException | UnsupportedFileFormat e) {
            System.err.println(e.getMessage() + System.lineSeparator());
        }
        catch (ParameterException e) {
            System.err.println("An error occurred when running command: " + StringUtils.join((Object[])args, " "));
            System.err.println(e.getMessage() + System.lineSeparator());
            jc.usage();
        }
        catch (Exception e) {
            System.err.println("An error occurred when running command: " + StringUtils.join((Object[])args, " "));
            System.err.println(e.getMessage() + System.lineSeparator());
            logger.error("An error occurred when running command: " + StringUtils.join((Object[])args, " "), e);
        }
    }

    private void setLogLevel(Options options) {
        if (options.debug.equalsIgnoreCase("OFF")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.OFF);
        } else if (options.debug.equalsIgnoreCase("ERROR")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.ERROR);
        } else if (options.debug.equalsIgnoreCase("WARN")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.WARN);
        } else if (options.debug.equalsIgnoreCase("INFO")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.INFO);
        } else if (options.debug.equalsIgnoreCase("DEBUG")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.DEBUG);
        } else if (options.debug.equalsIgnoreCase("TRACE")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.TRACE);
        } else if (options.debug.equalsIgnoreCase("ALL")) {
            LoggerUtil.setLogLevel(LoggerUtil.Level.ALL);
        } else {
            throw new ParameterException("Incorrect argument to --debug");
        }
    }

    private void runCommandCheck() throws Exception, UnsupportedFileFormat {
        List<String> issues;
        List<Context> contexts = this.getContextsWithPathGenerators(this.check.model.iterator());
        if (this.check.blocked) {
            Util.filterBlockedElements(contexts);
        }
        if (!(issues = ContextsChecker.hasIssues(contexts)).isEmpty()) {
            for (String issue : issues) {
                System.out.println(issue);
            }
        } else {
            System.out.println("No issues found with the model(s).");
        }
    }

    private void runCommandRequirements() throws Exception, UnsupportedFileFormat {
        TreeSet<String> reqs = new TreeSet<String>();
        List<Context> contexts = this.getContexts(this.requirements.model.iterator());
        if (this.requirements.blocked) {
            Util.filterBlockedElements(contexts);
        }
        for (Context context : contexts) {
            for (Requirement req : context.getRequirements()) {
                reqs.add(req.getKey());
            }
        }
        for (String req : reqs) {
            System.out.println(req);
        }
    }

    private void runCommandMethods() throws Exception, UnsupportedFileFormat {
        TreeSet<String> names = new TreeSet<String>();
        List<Context> contexts = this.getContexts(this.methods.model.iterator());
        if (this.methods.blocked) {
            Util.filterBlockedElements(contexts);
        }
        for (Context context : contexts) {
            for (Vertex.RuntimeVertex vertex : context.getModel().getVertices()) {
                if (null == vertex.getName()) continue;
                names.add(vertex.getName());
            }
            for (Edge.RuntimeEdge edge : context.getModel().getEdges()) {
                if (edge.getName() == null) continue;
                names.add(edge.getName());
            }
        }
        for (String name : names) {
            System.out.println(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommandOnline() throws Exception, UnsupportedFileFormat {
        if (this.online.service.equalsIgnoreCase("WEBSOCKET")) {
            WebSocketServer GraphWalkerWebSocketServer = new WebSocketServer(this.online.port);
            try {
                GraphWalkerWebSocketServer.startService();
            }
            catch (Exception e) {
                logger.error("Something went wrong.", e);
            }
        } else if (this.online.service.equalsIgnoreCase("RESTFUL")) {
            DefaultResourceConfig rc = new DefaultResourceConfig();
            try {
                List<Context> contexts = this.getContextsWithPathGenerators(this.online.model.iterator());
                ((Application)rc).getSingletons().add(new Restful(contexts, this.online.verbose, this.online.unvisited, this.online.blocked));
            }
            catch (MachineException e) {
                System.err.println("Was the argument --model correctly?");
                throw e;
            }
            String url = "http://0.0.0.0:" + this.online.port;
            HttpServer server = GrizzlyServerFactory.createHttpServer(url, (ResourceConfig)rc);
            System.out.println("Try http://localhost:" + this.online.port + "/graphwalker/hasNext or http://localhost:" + this.online.port + "/graphwalker/getNext");
            System.out.println("Press Control+C to end...");
            try {
                server.start();
                Thread.currentThread().join();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                logger.error("An error occurred when running command online: ", e);
            }
            finally {
                server.stop();
            }
        } else {
            throw new ParameterException("--service expected either WEBSOCKET or RESTFUL");
        }
    }

    private void runCommandConvert() throws Exception, UnsupportedFileFormat {
        List<Context> contexts;
        String inputFileName = this.convert.input;
        ContextFactory inputFactory = this.getContextFactory(inputFileName);
        try {
            contexts = inputFactory.create(Paths.get(inputFileName, new String[0]));
        }
        catch (DslException e) {
            System.err.println("When parsing model: '" + inputFileName + "' " + e.getMessage() + System.lineSeparator());
            throw new Exception("Model syntax error");
        }
        if (this.convert.blocked) {
            Util.filterBlockedElements(contexts);
        }
        ContextFactory outputFactory = this.getContextFactory("foo." + this.convert.format);
        System.out.println(outputFactory.getAsString(contexts));
    }

    private void runCommandSource() throws Exception, UnsupportedFileFormat {
        List<Context> contexts;
        String modelFileName = this.source.input.get(0);
        String templateFileName = this.source.input.get(1);
        ContextFactory inputFactory = this.getContextFactory(modelFileName);
        try {
            contexts = inputFactory.create(Paths.get(modelFileName, new String[0]));
            if (Objects.isNullOrEmpty(contexts)) {
                logger.error("No valid models found in: " + modelFileName);
                throw new RuntimeException("No valid models found in: " + modelFileName);
            }
        }
        catch (DslException e) {
            System.err.println("When parsing model: '" + modelFileName + "' " + e.getMessage() + System.lineSeparator());
            throw new Exception("Model syntax error");
        }
        if (this.source.blocked) {
            Util.filterBlockedElements(contexts);
        }
        for (Context context : contexts) {
            TreeSet<String> names = new TreeSet<String>();
            for (Vertex.RuntimeVertex vertex : context.getModel().getVertices()) {
                if (!vertex.hasName()) continue;
                names.add(vertex.getName());
            }
            for (Edge.RuntimeEdge edge : context.getModel().getEdges()) {
                if (!edge.hasName()) continue;
                names.add(edge.getName());
            }
            StringBuilder templateStrBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceAsStream(templateFileName)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    templateStrBuilder.append(line).append("\n");
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                throw new RuntimeException("Could not read the file: " + templateFileName);
            }
            String templateStr = templateStrBuilder.toString();
            String header = "";
            String body = "";
            String footer = "";
            Pattern p = Pattern.compile("HEADER<\\{\\{([.\\s\\S]+)\\}\\}>HEADER([.\\s\\S]+)FOOTER<\\{\\{([.\\s\\S]+)\\}\\}>FOOTER");
            Matcher m3 = p.matcher(templateStr);
            if (m3.find()) {
                header = m3.group(1);
                body = m3.group(2);
                footer = m3.group(3);
            }
            System.out.println(header);
            for (String name : names) {
                System.out.println(body.replaceAll("\\{LABEL\\}", name));
            }
            System.out.println(footer);
        }
    }

    private void runCommandOffline() throws Exception, UnsupportedFileFormat {
        if (this.offline.model.size() > 0) {
            List<Context> contexts = this.getContextsWithPathGenerators(this.offline.model.iterator());
            if (this.offline.blocked) {
                Util.filterBlockedElements(contexts);
            }
            TestExecutor executor = new TestExecutor(contexts);
            executor.getMachine().addObserver((machine, element, type) -> {
                if (EventType.BEFORE_ELEMENT.equals((Object)type)) {
                    System.out.println(org.graphwalker.restful.Util.getStepAsJSON(machine, this.offline.verbose, this.offline.unvisited).toString());
                }
            });
            if (this.offline.seed != 0L) {
                SingletonRandomGenerator.setSeed(this.offline.seed);
            }
            executor.execute();
        } else if (!this.offline.gw3.isEmpty()) {
            List<Context> contexts = new JsonContextFactory().create(Paths.get(this.offline.gw3, new String[0]));
            if (this.offline.seed != 0L) {
                SingletonRandomGenerator.setSeed(this.offline.seed);
            }
            if (this.offline.blocked) {
                Util.filterBlockedElements(contexts);
            }
            SimpleMachine machine2 = new SimpleMachine(contexts);
            while (machine2.hasNextStep()) {
                machine2.getNextStep();
                System.out.println(org.graphwalker.restful.Util.getStepAsJSON(machine2, this.offline.verbose, this.offline.unvisited).toString());
            }
        }
    }

    public List<Context> getContextsWithPathGenerators(Iterator itr) throws Exception, UnsupportedFileFormat {
        ArrayList<Context> executionContexts = new ArrayList<Context>();
        boolean triggerOnce = true;
        while (itr.hasNext()) {
            List<Context> contexts;
            String modelFileName = (String)itr.next();
            ContextFactory factory = this.getContextFactory(modelFileName);
            try {
                contexts = factory.create(Paths.get(modelFileName, new String[0]));
            }
            catch (DslException e) {
                System.err.println("When parsing model: '" + modelFileName + "' " + e.getMessage() + System.lineSeparator());
                throw new Exception("Model syntax error");
            }
            contexts.get(0).setPathGenerator(GeneratorFactory.parse((String)itr.next()));
            if (!(!triggerOnce || this.offline.startElement.isEmpty() && this.online.startElement.isEmpty())) {
                triggerOnce = false;
                List<Element> elements = null;
                if (this.command == Command.OFFLINE) {
                    elements = contexts.get(0).getModel().findElements(this.offline.startElement);
                } else if (this.command == Command.ONLINE) {
                    elements = contexts.get(0).getModel().findElements(this.online.startElement);
                }
                if (elements == null) {
                    throw new ParameterException("--start-element Did not find matching element in the model: " + modelFileName);
                }
                if (elements.size() > 1) {
                    throw new ParameterException("--start-element There are more than one matching element in the model: " + modelFileName);
                }
                contexts.get(0).setNextElement(elements.get(0));
            }
            executionContexts.addAll(contexts);
        }
        return executionContexts;
    }

    private ContextFactory getContextFactory(String modelFileName) throws UnsupportedFileFormat {
        ContextFactory factory;
        if (new YEdContextFactory().accept(Paths.get(modelFileName, new String[0]))) {
            factory = new YEdContextFactory();
        } else if (new JsonContextFactory().accept(Paths.get(modelFileName, new String[0]))) {
            factory = new JsonContextFactory();
        } else if (new DotContextFactory().accept(Paths.get(modelFileName, new String[0]))) {
            factory = new DotContextFactory();
        } else if (new JavaContextFactory().accept(Paths.get(modelFileName, new String[0]))) {
            factory = new JavaContextFactory();
        } else {
            throw new UnsupportedFileFormat(modelFileName);
        }
        return factory;
    }

    private List<Context> getContexts(Iterator itr) throws Exception, UnsupportedFileFormat {
        ArrayList<Context> executionContexts = new ArrayList<Context>();
        while (itr.hasNext()) {
            List<Context> contexts;
            String modelFileName = (String)itr.next();
            ContextFactory factory = this.getContextFactory(modelFileName);
            try {
                contexts = factory.create(Paths.get(modelFileName, new String[0]));
            }
            catch (DslException e) {
                System.err.println("When parsing model: '" + modelFileName + "' " + e.getMessage() + System.lineSeparator());
                throw new Exception("Model syntax error");
            }
            executionContexts.addAll(contexts);
        }
        return executionContexts;
    }

    static enum Command {
        NONE,
        OFFLINE,
        ONLINE,
        METHODS,
        REQUIREMENTS,
        CONVERT,
        SOURCE,
        CHECK;

    }
}

