/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.model.Classification;
import org.graphwalker.core.model.ClassificationTree;

public class AllClassificationCombinations
implements Algorithm {
    private final ClassificationTree.RuntimeClassificationTree tree;
    private static List<List<Classification.RuntimeClassification>> combinations;

    public AllClassificationCombinations(ClassificationTree.RuntimeClassificationTree tree) {
        this.tree = tree;
    }

    public List<Classification.RuntimeClassification> getClassifications() {
        ArrayList<Classification.RuntimeClassification> result = new ArrayList<Classification.RuntimeClassification>();
        this.getClassifications(result, this.tree.getRoot());
        return result;
    }

    private void getClassifications(List<Classification.RuntimeClassification> result, Classification.RuntimeClassification node) {
        List<Classification.RuntimeClassification> children = node.getClassifications();
        for (Classification.RuntimeClassification child : children) {
            if (child.getClassifications().size() > 0) {
                this.getClassifications(result, child);
                continue;
            }
            if (result.contains(node)) continue;
            result.add(node);
        }
    }

    public List<List<Classification.RuntimeClassification>> generate() {
        List<Classification.RuntimeClassification> classes = this.getClassifications();
        ArrayList<List<Classification.RuntimeClassification>> treeData = new ArrayList<List<Classification.RuntimeClassification>>();
        for (Classification.RuntimeClassification cls : classes) {
            treeData.add(cls.getClassifications());
        }
        combinations = new ArrayList<List<Classification.RuntimeClassification>>();
        AllClassificationCombinations.getCombinations(treeData, 0, new ArrayList<Classification.RuntimeClassification>());
        return combinations;
    }

    private static void getCombinations(List<List<Classification.RuntimeClassification>> treeData, int n, ArrayList<Classification.RuntimeClassification> testCase) {
        if (n >= treeData.size()) {
            combinations.add(testCase);
            return;
        }
        for (Classification.RuntimeClassification c : treeData.get(n)) {
            ArrayList<Classification.RuntimeClassification> foo = new ArrayList<Classification.RuntimeClassification>(testCase);
            foo.add(c);
            AllClassificationCombinations.getCombinations(treeData, n + 1, foo);
        }
    }
}

