/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.algorithm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.algorithm.AlgorithmException;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.ElementVisitor;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Path;
import org.graphwalker.core.model.Vertex;

public class Fleury
implements Algorithm {
    private final Context context;

    public Fleury(Context context) {
        this.context = context;
    }

    public Path<Element> getTrail(Element element) {
        if (element instanceof Edge.RuntimeEdge) {
            Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
            HashSet<Edge.RuntimeEdge> visitedEdges = new HashSet<Edge.RuntimeEdge>();
            visitedEdges.add(edge);
            Path<Element> path = this.getTrail(edge.getTargetVertex(), visitedEdges);
            path.addFirst(edge.getTargetVertex());
            return path;
        }
        return this.getTrail((Vertex.RuntimeVertex)element, new HashSet<Edge.RuntimeEdge>());
    }

    private Path<Element> getTrail(Vertex.RuntimeVertex vertex, Set<Edge.RuntimeEdge> visitedEdges) {
        Path<Element> trail = new Path<Element>();
        Vertex.RuntimeVertex currentVertex = vertex;
        ArrayList<Edge.RuntimeEdge> availableEdges = new ArrayList<Edge.RuntimeEdge>(this.context.getModel().getEdges());
        availableEdges.removeAll(visitedEdges);
        while (!availableEdges.isEmpty()) {
            Edge.RuntimeEdge edge = this.getNextEdge(this.context.getModel(), visitedEdges, currentVertex);
            trail.add(edge);
            visitedEdges.add(edge);
            currentVertex = edge.getTargetVertex();
            trail.add(currentVertex);
            availableEdges.remove(edge);
        }
        return trail;
    }

    private Edge.RuntimeEdge getNextEdge(Model.RuntimeModel model, Set<Edge.RuntimeEdge> visitedEdges, Vertex.RuntimeVertex vertex) {
        ArrayList<Edge.RuntimeEdge> bridges = new ArrayList<Edge.RuntimeEdge>();
        for (Edge.RuntimeEdge edge : model.getOutEdges(vertex)) {
            if (visitedEdges.contains(edge)) continue;
            if (!this.isBridge(model, visitedEdges, edge)) {
                return edge;
            }
            bridges.add(edge);
        }
        if (!bridges.isEmpty()) {
            return (Edge.RuntimeEdge)bridges.get(0);
        }
        throw new AlgorithmException();
    }

    private boolean isBridge(Model.RuntimeModel model, Set<Edge.RuntimeEdge> visitedElements, Edge.RuntimeEdge edge) {
        VertexCounter counter1 = new VertexCounter(model, visitedElements, edge);
        VertexCounter counter2 = new VertexCounter(model);
        edge.getSourceVertex().accept(counter1);
        edge.getSourceVertex().accept(counter2);
        return counter1.getCount() < counter2.getCount();
    }

    private static class VertexCounter
    implements ElementVisitor {
        private final Model.RuntimeModel model;
        private final Set<Element> visitedElements = new HashSet<Element>();
        private int count = 0;

        public VertexCounter(Model.RuntimeModel model) {
            this.model = model;
        }

        public VertexCounter(Model.RuntimeModel model, Set<Edge.RuntimeEdge> visitedElements, Edge.RuntimeEdge edge) {
            this.model = model;
            this.visitedElements.addAll(visitedElements);
            this.visitedElements.add(edge);
        }

        public int getCount() {
            return this.count;
        }

        private boolean isNotVisited(Element element) {
            return !this.visitedElements.contains(element);
        }

        @Override
        public void visit(Element element) {
            Edge.RuntimeEdge edge;
            this.visitedElements.add(element);
            if (element instanceof Vertex.RuntimeVertex) {
                Vertex.RuntimeVertex vertex = (Vertex.RuntimeVertex)element;
                ++this.count;
                for (Edge.RuntimeEdge edge2 : this.model.getOutEdges(vertex)) {
                    if (!this.isNotVisited(edge2)) continue;
                    edge2.accept(this);
                }
            } else if (element instanceof Edge.RuntimeEdge && this.isNotVisited((edge = (Edge.RuntimeEdge)element).getTargetVertex())) {
                edge.getTargetVertex().accept(this);
            }
        }
    }
}

