/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.condition.StopConditionBase;
import org.graphwalker.core.machine.Context;

public class AlternativeCondition
extends StopConditionBase {
    private final List<StopCondition> conditions = new ArrayList<StopCondition>();

    public AlternativeCondition() {
        super("");
    }

    public AlternativeCondition addStopCondition(StopCondition condition) {
        this.conditions.add(condition);
        condition.setContext(this.getContext());
        return this;
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.conditions.forEach(stopCondition -> stopCondition.setContext(context));
    }

    public List<StopCondition> getStopConditions() {
        return this.conditions;
    }

    @Override
    public boolean isFulfilled() {
        for (StopCondition condition : this.conditions) {
            if (!condition.isFulfilled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getFulfilment() {
        double fulfilment = 0.0;
        for (StopCondition condition : this.conditions) {
            double newFulfilment = condition.getFulfilment();
            if (!(newFulfilment > fulfilment)) continue;
            fulfilment = newFulfilment;
        }
        return fulfilment;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        return builder.append(this.conditions.stream().map(Object::toString).collect(Collectors.joining(" OR ")));
    }
}

