/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import java.util.List;
import org.graphwalker.core.condition.DependencyCoverageStopConditionBase;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;

public class DependencyEdgeCoverage
extends DependencyCoverageStopConditionBase {
    public DependencyEdgeCoverage(int dependency) {
        super(dependency);
    }

    @Override
    public boolean isFulfilled() {
        return this.getFulfilment() >= 0.999999 && super.isFulfilled();
    }

    @Override
    public double getFulfilment() {
        Context context = this.getContext();
        List<Edge.RuntimeEdge> edges = this.getContext().getModel().getEdges();
        long totalDependencyEdgesCount = edges.stream().filter(edge -> edge.getDependencyAsDouble() >= super.getDependencyAsDouble()).count();
        if (totalDependencyEdgesCount != 0L) {
            long visitedDependencyEdgesCount = edges.stream().filter(edge -> edge.getDependencyAsDouble() >= super.getDependencyAsDouble()).filter(edge -> context.getProfiler().isVisited(context, (Element)edge)).count();
            return (double)visitedDependencyEdgesCount / (double)totalDependencyEdgesCount;
        }
        return 0.0;
    }
}

