/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import org.graalvm.polyglot.Value;
import org.graphwalker.core.condition.StopConditionBase;
import org.graphwalker.core.condition.StopConditionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalState
extends StopConditionBase {
    private static final Logger LOG = LoggerFactory.getLogger(InternalState.class);
    private final String script;

    public InternalState(String script) {
        super(String.valueOf(script));
        this.script = script;
    }

    @Override
    public boolean isFulfilled() {
        Value value = this.getContext().getExecutionEnvironment().eval("js", this.script);
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        throw new StopConditionException("Wrong type of expression");
    }

    @Override
    public double getFulfilment() {
        return this.isFulfilled() ? 1.0 : 0.0;
    }
}

