/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.condition;

import java.util.concurrent.TimeUnit;
import org.graphwalker.core.condition.StopConditionBase;
import org.graphwalker.core.condition.StopConditionException;

public class TimeDuration
extends StopConditionBase {
    private final long duration;
    private final long timestamp;

    public TimeDuration(long duration, TimeUnit unit) {
        super(String.valueOf(duration));
        if (0L > duration) {
            throw new StopConditionException("A duration cannot be negative");
        }
        this.timestamp = System.nanoTime();
        this.duration = TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    public long getDuration() {
        return TimeUnit.SECONDS.convert(this.duration, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isFulfilled() {
        return this.getFulfilment() >= 0.999999 && super.isFulfilled();
    }

    @Override
    public double getFulfilment() {
        return (double)(System.nanoTime() - this.timestamp) / (double)this.duration;
    }
}

