/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.generator;

import java.util.List;
import org.graphwalker.core.algorithm.AStar;
import org.graphwalker.core.algorithm.FloydWarshall;
import org.graphwalker.core.condition.ReachedStopCondition;
import org.graphwalker.core.generator.NoPathFoundException;
import org.graphwalker.core.generator.PathGeneratorBase;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;

public class AStarPath
extends PathGeneratorBase<ReachedStopCondition> {
    public AStarPath(ReachedStopCondition stopCondition) {
        this.setStopCondition(stopCondition);
    }

    @Override
    public Context getNextStep() {
        Context context = super.getNextStep();
        List<Element> elements = context.filter(context.getModel().getElements(context.getCurrentElement()));
        if (elements.isEmpty()) {
            throw new NoPathFoundException(context.getCurrentElement());
        }
        Element target = null;
        int distance = Integer.MAX_VALUE;
        FloydWarshall floydWarshall = context.getAlgorithm(FloydWarshall.class);
        for (Element element : context.filter(((ReachedStopCondition)this.getStopCondition()).getTargetElements())) {
            int edgeDistance = floydWarshall.getShortestDistance(context.getCurrentElement(), element);
            if (edgeDistance >= distance) continue;
            distance = edgeDistance;
            target = element;
        }
        AStar astar = context.getAlgorithm(AStar.class);
        return context.setCurrentElement(astar.getNextElement(context.getCurrentElement(), target));
    }

    @Override
    public boolean hasNextStep() {
        return !((ReachedStopCondition)this.getStopCondition()).isFulfilled();
    }
}

