/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.generator.NoPathFoundException;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.generator.PathGeneratorBase;
import org.graphwalker.core.machine.Context;

public class CombinedPath
extends PathGeneratorBase<StopCondition> {
    private final List<PathGenerator> generators = new ArrayList<PathGenerator>();
    private int index = 0;

    public void addPathGenerator(PathGenerator generator) {
        this.generators.add(generator);
        generator.setContext(this.getContext());
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.generators.forEach(pathGenerator -> pathGenerator.setContext(context));
    }

    public List<PathGenerator> getPathGenerators() {
        return this.generators;
    }

    private PathGenerator getActivePathGenerator() {
        return this.generators.get(this.index);
    }

    @Override
    public StopCondition getStopCondition() {
        return this.getActivePathGenerator().getStopCondition();
    }

    @Override
    public Context getNextStep() {
        if (this.index > this.generators.size() - 1) {
            throw new NoPathFoundException(this.getContext().getCurrentElement());
        }
        return this.getActivePathGenerator().getNextStep();
    }

    @Override
    public boolean hasNextStep() {
        while (this.index < this.generators.size()) {
            if (this.getActivePathGenerator().hasNextStep()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        return builder.append(this.generators.stream().map(Object::toString).collect(Collectors.joining(" ")));
    }
}

