/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.generator;

import java.util.List;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.generator.NoPathFoundException;
import org.graphwalker.core.generator.PathGeneratorBase;
import org.graphwalker.core.generator.SingletonRandomGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomPath
extends PathGeneratorBase<StopCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(RandomPath.class);

    public RandomPath(StopCondition stopCondition) {
        this.setStopCondition(stopCondition);
    }

    @Override
    public Context getNextStep() {
        Context context = super.getNextStep();
        Element currentElement = context.getCurrentElement();
        List<Element> elements = context.filter(context.getModel().getElements(currentElement));
        if (elements.isEmpty()) {
            LOG.error("currentElement: " + currentElement);
            LOG.error("context.getModel().getElements(): " + context.getModel().getElements());
            throw new NoPathFoundException(context.getCurrentElement());
        }
        context.setCurrentElement(elements.get(SingletonRandomGenerator.nextInt(elements.size())));
        return context;
    }

    @Override
    public boolean hasNextStep() {
        return !this.getStopCondition().isFulfilled();
    }
}

