/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.generator;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonRandomGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonRandomGenerator.class);
    private static Random random = null;
    private static Boolean isSeeded = null;
    private static SingletonRandomGenerator singletonRandomGenerator = new SingletonRandomGenerator();

    private SingletonRandomGenerator() {
        random = new Random();
        isSeeded = new Boolean(false);
    }

    public static Random random() {
        if (isSeeded.booleanValue()) {
            return random;
        }
        long seed = System.nanoTime();
        LOG.info("Seed: " + seed);
        random.setSeed(seed);
        isSeeded = true;
        return random;
    }

    public static int nextInt() {
        if (isSeeded.booleanValue()) {
            return random.nextInt();
        }
        long seed = System.nanoTime();
        LOG.info("Seed: " + seed);
        random.setSeed(seed);
        isSeeded = true;
        return random.nextInt();
    }

    public static int nextInt(int bound) {
        if (isSeeded.booleanValue()) {
            return random.nextInt(bound);
        }
        long seed = System.nanoTime();
        LOG.info("Seed: " + seed);
        random.setSeed(seed);
        isSeeded = true;
        return random.nextInt(bound);
    }

    public static void setSeed(long seed) {
        LOG.info("Seeded: " + seed);
        isSeeded = true;
        random.setSeed(seed);
    }
}

