/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.machine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.polyglot.Value;
import org.graphwalker.core.algorithm.Algorithm;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.ExecutionStatus;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.RequirementStatus;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Builder;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.statistics.Profiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionContext
implements Context {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionContext.class);
    private org.graalvm.polyglot.Context executionEnvironment;
    private org.graalvm.polyglot.Context globalExecutionEnvironment;
    private Model.RuntimeModel model;
    private PathGenerator pathGenerator;
    private Profiler profiler;
    private ExecutionStatus executionStatus = ExecutionStatus.NOT_EXECUTED;
    private Element currentElement;
    private Element nextElement;
    private Element lastElement;
    private Integer predefinedPathCurrentEdgeIndex;
    private String REGEXP_GLOBAL = "global\\.";
    private final Map<Class<? extends Algorithm>, Object> algorithms = new HashMap<Class<? extends Algorithm>, Object>();
    private final Map<Requirement, RequirementStatus> requirements = new HashMap<Requirement, RequirementStatus>();

    public ExecutionContext() {
        this.executionEnvironment = org.graalvm.polyglot.Context.newBuilder(new String[0]).allowAllAccess(true).build();
        this.executionEnvironment.getBindings("js").putMember(this.getClass().getSimpleName(), this);
        this.predefinedPathCurrentEdgeIndex = 0;
    }

    public ExecutionContext(Model model, PathGenerator pathGenerator) {
        this(model.build(), pathGenerator);
    }

    public ExecutionContext(Model.RuntimeModel model, PathGenerator pathGenerator) {
        this();
        this.setModel(model);
        this.setPathGenerator(pathGenerator);
    }

    @Override
    public org.graalvm.polyglot.Context getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    @Override
    public Model.RuntimeModel getModel() {
        return this.model;
    }

    @Override
    public Context setModel(Model.RuntimeModel model) {
        this.model = model;
        this.addRequirements(model);
        return this;
    }

    private void addRequirements(Model.RuntimeModel model) {
        this.requirements.clear();
        for (Requirement requirement : model.getRequirements()) {
            this.requirements.put(requirement, RequirementStatus.NOT_COVERED);
        }
        for (Element element : model.getElements()) {
            for (Requirement requirement : element.getRequirements()) {
                this.requirements.put(requirement, RequirementStatus.NOT_COVERED);
            }
        }
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public Context setProfiler(Profiler profiler) {
        this.profiler = profiler;
        this.profiler.addContext(this);
        return this;
    }

    @Override
    public PathGenerator getPathGenerator() {
        return this.pathGenerator;
    }

    @Override
    public Context setPathGenerator(PathGenerator pathGenerator) {
        this.pathGenerator = pathGenerator;
        if (Objects.isNotNull(pathGenerator)) {
            this.pathGenerator.setContext(this);
        }
        return this;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    @Override
    public Context setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
        return this;
    }

    @Override
    public Element getLastElement() {
        return this.lastElement;
    }

    @Override
    public Element getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public Context setCurrentElement(Element element) {
        this.lastElement = this.currentElement;
        this.currentElement = element;
        this.nextElement = null;
        return this;
    }

    @Override
    public Element getNextElement() {
        return this.nextElement;
    }

    @Override
    public Context setNextElement(Builder<? extends Element> nextElement) {
        this.setNextElement(nextElement.build());
        return this;
    }

    @Override
    public Context setNextElement(Element nextElement) {
        this.nextElement = nextElement;
        this.currentElement = null;
        return this;
    }

    @Override
    public Integer getPredefinedPathCurrentEdgeIndex() {
        return this.predefinedPathCurrentEdgeIndex;
    }

    @Override
    public Context setPredefinedPathCurrentElementIndex(Integer predefinedPathCurrentElementIndex) {
        this.predefinedPathCurrentEdgeIndex = predefinedPathCurrentElementIndex;
        return this;
    }

    @Override
    public Context setRequirementStatus(Requirement requirement, RequirementStatus requirementStatus) {
        this.requirements.put(requirement, requirementStatus);
        return this;
    }

    @Override
    public List<Requirement> getRequirements() {
        return new ArrayList<Requirement>(this.requirements.keySet());
    }

    @Override
    public List<Requirement> getRequirements(RequirementStatus status) {
        ArrayList<Requirement> filteredRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : this.requirements.keySet()) {
            if (!status.equals((Object)this.requirements.get(requirement))) continue;
            filteredRequirements.add(requirement);
        }
        return filteredRequirements;
    }

    @Override
    public <A extends Algorithm> A getAlgorithm(Class<A> clazz) {
        if (!this.algorithms.containsKey(clazz)) {
            try {
                Constructor<A> constructor = clazz.getConstructor(Context.class);
                this.algorithms.put(clazz, constructor.newInstance(this));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error(e.getMessage());
                throw new MachineException(this, (Throwable)e);
            }
        }
        return (A)((Algorithm)this.algorithms.get(clazz));
    }

    @Override
    public <E> List<E> filter(Collection<E> elements) {
        ArrayList<E> filteredElements = new ArrayList<E>();
        if (Objects.isNotNull(elements)) {
            for (E element : elements) {
                if (element instanceof Edge.RuntimeEdge) {
                    Edge.RuntimeEdge edge = (Edge.RuntimeEdge)element;
                    if (!this.isAvailable(edge)) continue;
                    filteredElements.add(element);
                    continue;
                }
                filteredElements.add(element);
            }
        }
        return filteredElements;
    }

    @Override
    public boolean isAvailable(Edge.RuntimeEdge edge) {
        if (edge.hasGuard()) {
            LOG.debug("Execute guard: '{}' in edge {}, in model: '{}'", edge.getGuard().getScript(), edge.getName(), this.getModel().getName());
            Pattern pattern = Pattern.compile(this.REGEXP_GLOBAL);
            Matcher matcher = pattern.matcher(edge.getGuard().getScript());
            if (matcher.find()) {
                return this.globalExecutionEnvironment.eval("js", edge.getGuard().getScript().replaceAll(this.REGEXP_GLOBAL, "")).asBoolean();
            }
            return this.executionEnvironment.eval("js", edge.getGuard().getScript()).asBoolean();
        }
        return true;
    }

    @Override
    public void execute(Action action) {
        LOG.debug("Execute action: '{}' in model: '{}'", (Object)action.getScript(), (Object)this.getModel().getName());
        Pattern pattern = Pattern.compile(this.REGEXP_GLOBAL);
        Matcher matcher = pattern.matcher(action.getScript());
        if (matcher.find()) {
            this.globalExecutionEnvironment.eval("js", action.getScript().replaceAll(this.REGEXP_GLOBAL, ""));
        } else {
            this.executionEnvironment.eval("js", action.getScript());
        }
        LOG.debug("Data: '{}'", (Object)this.data());
    }

    @Override
    public void execute(Element element) {
        if (!element.hasName()) {
            return;
        }
        LOG.debug("Execute method: '{}' in model: '{}'", (Object)element.getName(), (Object)this.getModel().getName());
        try {
            Method method = this.getClass().getMethod(element.getName(), new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException method) {
        }
        catch (Throwable t) {
            this.executionStatus = ExecutionStatus.FAILED;
            LOG.error(t.getMessage());
            throw new MachineException(this, t);
        }
    }

    @Override
    public Value getAttribute(String name) {
        Pattern pattern = Pattern.compile(this.REGEXP_GLOBAL);
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            return this.globalExecutionEnvironment.getBindings("js").getMember(name.replaceAll(this.REGEXP_GLOBAL, ""));
        }
        return this.executionEnvironment.getBindings("js").getMember(name);
    }

    @Override
    public void setAttribute(String name, Value value) {
        this.executionEnvironment.getBindings("js").putMember(name, value);
    }

    public String data() {
        StringBuilder data = new StringBuilder();
        for (String member : this.executionEnvironment.getBindings("js").getMemberKeys()) {
            if (this.executionEnvironment.getBindings("js").getMember(member).toString().contains("org.graphwalker.core.machine.TestExecutionContext")) continue;
            data.append(member).append(": ").append(this.executionEnvironment.getBindings("js").getMember(member)).append(", ");
        }
        if (Objects.isNotNull(this.globalExecutionEnvironment)) {
            for (String member : this.globalExecutionEnvironment.getBindings("js").getMemberKeys()) {
                data.append("global." + member).append(": ").append(this.globalExecutionEnvironment.getBindings("js").getMember(member)).append(", ");
            }
        }
        return data.toString();
    }

    @Override
    public void setGlobalExecutionEnvironment(org.graalvm.polyglot.Context globalExecutionEnvironment) {
        this.globalExecutionEnvironment = globalExecutionEnvironment;
    }
}

