/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.Builder;
import org.graphwalker.core.model.Requirement;

public abstract class BuilderBase<B, T>
implements Builder<T> {
    private String id;
    private String name;
    private Set<Requirement> requirements = new HashSet<Requirement>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public B setId(String id) {
        this.id = id;
        return (B)this;
    }

    public String getName() {
        return this.name;
    }

    public B setName(String name) {
        this.name = name;
        return (B)this;
    }

    public Set<Requirement> getRequirements() {
        return Objects.unmodifiableSet(this.requirements);
    }

    public B addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
        return (B)this;
    }

    public B setRequirements(Set<Requirement> requirements) {
        this.requirements = new HashSet<Requirement>(requirements);
        return (B)this;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public Map<String, Object> getProperties() {
        return Objects.unmodifiableMap(this.properties);
    }

    public B setProperties(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>(properties);
        return (B)this;
    }

    public B setProperty(String key, Object value) {
        this.properties.put(key, value);
        return (B)this;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

