/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Builder;
import org.graphwalker.core.model.CachedBuilder;
import org.graphwalker.core.model.ElementVisitor;
import org.graphwalker.core.model.Guard;
import org.graphwalker.core.model.RuntimeBase;
import org.graphwalker.core.model.Vertex;

public class Edge
extends CachedBuilder<Edge, RuntimeEdge> {
    private Vertex sourceVertex;
    private Vertex targetVertex;
    private Guard guard;
    private List<Action> actions = new ArrayList<Action>();
    private Double weight = 0.0;
    private Integer dependency = 0;

    public Edge setSourceVertex(Vertex vertex) {
        this.sourceVertex = vertex;
        this.invalidateCache();
        return this;
    }

    public Vertex getSourceVertex() {
        return this.sourceVertex;
    }

    public Edge setTargetVertex(Vertex vertex) {
        this.targetVertex = vertex;
        this.invalidateCache();
        return this;
    }

    public Vertex getTargetVertex() {
        return this.targetVertex;
    }

    public Edge setGuard(Guard guard) {
        this.guard = guard;
        this.invalidateCache();
        return this;
    }

    public Guard getGuard() {
        return this.guard;
    }

    public Edge addAction(Action action) {
        this.actions.add(action);
        this.invalidateCache();
        return this;
    }

    public Edge addActions(Action ... actions) {
        return this.addActions(Arrays.asList(actions));
    }

    public Edge addActions(List<Action> actions) {
        this.actions.addAll(actions);
        return this;
    }

    public Edge setActions(List<Action> actions) {
        this.actions = new ArrayList<Action>(actions);
        this.invalidateCache();
        return this;
    }

    public List<Action> getActions() {
        return Objects.unmodifiableList(this.actions);
    }

    public Double getWeight() {
        return this.weight;
    }

    public Edge setWeight(Double weight) {
        this.weight = weight;
        this.invalidateCache();
        return this;
    }

    @Override
    protected RuntimeEdge createCache() {
        return new RuntimeEdge(this);
    }

    public Integer getDependency() {
        return this.dependency;
    }

    public Edge setDependency(Integer dependency) {
        this.dependency = dependency;
        this.invalidateCache();
        return this;
    }

    public static class RuntimeEdge
    extends RuntimeBase {
        private final Vertex.RuntimeVertex sourceVertex;
        private final Vertex.RuntimeVertex targetVertex;
        private final Guard guard;
        private final Double weight;
        private final Integer dependency;

        private RuntimeEdge(Edge edge) {
            super(edge.getId(), edge.getName(), edge.getActions(), edge.getRequirements(), edge.getProperties());
            this.sourceVertex = this.build(edge.getSourceVertex());
            this.targetVertex = this.build(edge.getTargetVertex());
            this.guard = edge.getGuard();
            this.weight = edge.getWeight();
            this.dependency = edge.getDependency();
        }

        private <T> T build(Builder<T> builder) {
            return Objects.isNotNull(builder) ? (T)builder.build() : null;
        }

        public Vertex.RuntimeVertex getSourceVertex() {
            return this.sourceVertex;
        }

        public Vertex.RuntimeVertex getTargetVertex() {
            return this.targetVertex;
        }

        public Guard getGuard() {
            return this.guard;
        }

        public boolean hasGuard() {
            return Objects.isNotNull(this.guard) && Objects.isNotNullOrEmpty(this.guard.getScript());
        }

        public Double getWeight() {
            return this.weight;
        }

        @Override
        public void accept(ElementVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.guard == null ? 0 : this.guard.hashCode());
            result = 31 * result + (this.sourceVertex == null ? 0 : this.sourceVertex.hashCode());
            result = 31 * result + (this.targetVertex == null ? 0 : this.targetVertex.hashCode());
            result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
            result = 31 * result + (this.dependency == null ? 0 : this.dependency.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RuntimeEdge that = (RuntimeEdge)o;
            return Objects.equals(this.sourceVertex, that.sourceVertex) && Objects.equals(this.targetVertex, that.targetVertex) && Objects.equals(this.guard, that.guard) && Objects.equals(this.weight, that.weight) && Objects.equals(this.dependency, that.dependency);
        }

        public Integer getDependency() {
            return this.dependency;
        }

        public double getDependencyAsDouble() {
            return (double)this.getDependency().intValue() / 100.0;
        }
    }
}

