/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Requirement;

public abstract class RuntimeBase
implements Element {
    private final String id;
    private final String name;
    private final List<Action> actions;
    private final Set<Requirement> requirements;
    private final Map<String, Object> properties;

    protected RuntimeBase(String id, String name) {
        this(id, name, new ArrayList<Action>(), new HashSet<Requirement>());
    }

    protected RuntimeBase(String id, String name, List<Action> actions, Set<Requirement> requirements) {
        this(id, name, actions, requirements, new HashMap<String, Object>());
    }

    protected RuntimeBase(String id, String name, List<Action> actions, Set<Requirement> requirements, Map<String, Object> properties) {
        this.id = this.getIdOrDefault(id);
        this.name = name;
        this.actions = Objects.unmodifiableList(actions);
        this.requirements = Objects.unmodifiableSet(requirements);
        this.properties = Objects.unmodifiableMap(properties);
    }

    private String getIdOrDefault(String id) {
        return Objects.isNotNullOrEmpty(id) ? id : this.createDefault();
    }

    private String createDefault() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return Objects.isNotNullOrEmpty(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasName() {
        return Objects.isNotNullOrEmpty(this.name);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public boolean hasActions() {
        return Objects.isNotNullOrEmpty(this.actions);
    }

    @Override
    public Set<Requirement> getRequirements() {
        return this.requirements;
    }

    @Override
    public boolean hasRequirements() {
        return Objects.isNotNullOrEmpty(this.requirements);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean hasProperties() {
        return Objects.isNotNullOrEmpty(this.properties);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.requirements == null ? 0 : this.requirements.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeBase that = (RuntimeBase)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.actions, that.actions) && Objects.equals(this.requirements, that.requirements) && Objects.equals(this.properties, that.properties);
    }
}

