/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.statistics;

import java.util.concurrent.TimeUnit;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;

public class Execution {
    private final Context context;
    private final Element element;
    private final long time;
    private final long duration;

    public Execution(Context context, Element element, long time, long duration) {
        this(context, element, time, duration, TimeUnit.NANOSECONDS);
    }

    public Execution(Context context, Element element, long time, long duration, TimeUnit unit) {
        this.context = context;
        this.element = element;
        this.time = unit.convert(time, TimeUnit.NANOSECONDS);
        this.duration = unit.convert(duration, TimeUnit.NANOSECONDS);
    }

    public Context getContext() {
        return this.context;
    }

    public Element getElement() {
        return this.element;
    }

    public long getTime(TimeUnit unit) {
        return unit.convert(this.time, TimeUnit.NANOSECONDS);
    }

    public long getTime() {
        return this.time;
    }

    public long getDuration(TimeUnit unit) {
        return unit.convert(this.duration, TimeUnit.NANOSECONDS);
    }

    public long getDuration() {
        return this.duration;
    }
}

