/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.core.statistics;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.statistics.Execution;
import org.graphwalker.core.statistics.MissingExecutionException;

public class Profile {
    private final Context context;
    private final Element element;
    private final List<Execution> executions;

    public Profile(Context context, Element element, List<Execution> executions) {
        this.context = context;
        this.element = element;
        this.executions = executions;
    }

    public Context getContext() {
        return this.context;
    }

    public Element getElement() {
        return this.element;
    }

    public long getExecutionCount() {
        return this.executions.size();
    }

    public long getMinExecutionTime() {
        return this.getMinExecutionTime(TimeUnit.NANOSECONDS);
    }

    public long getMinExecutionTime(TimeUnit unit) {
        return unit.convert(this.executions.stream().mapToLong(Execution::getDuration).min().orElseThrow(MissingExecutionException::new), TimeUnit.NANOSECONDS);
    }

    public long getMaxExecutionTime() {
        return this.getMaxExecutionTime(TimeUnit.NANOSECONDS);
    }

    public long getMaxExecutionTime(TimeUnit unit) {
        return unit.convert(this.executions.stream().mapToLong(Execution::getDuration).max().orElseThrow(MissingExecutionException::new), TimeUnit.NANOSECONDS);
    }

    public long getTotalExecutionTime() {
        return this.getTotalExecutionTime(TimeUnit.NANOSECONDS);
    }

    public long getTotalExecutionTime(TimeUnit unit) {
        return unit.convert(this.executions.stream().mapToLong(Execution::getDuration).sum(), TimeUnit.NANOSECONDS);
    }

    public long getAverageExecutionTime() {
        return this.getAverageExecutionTime(TimeUnit.NANOSECONDS);
    }

    public long getAverageExecutionTime(TimeUnit unit) {
        return unit.convert(Math.round(this.executions.stream().mapToLong(Execution::getDuration).average().orElseThrow(MissingExecutionException::new)), TimeUnit.NANOSECONDS);
    }

    public long getFirstExecutionTime() {
        return this.getFirstExecutionTime(TimeUnit.NANOSECONDS);
    }

    public long getFirstExecutionTime(TimeUnit unit) {
        return ((Execution)this.executions.stream().findFirst().orElseThrow(MissingExecutionException::new)).getDuration(unit);
    }

    public long getLastExecutionTime() {
        return this.getLastExecutionTime(TimeUnit.NANOSECONDS);
    }

    public long getLastExecutionTime(TimeUnit unit) {
        return ((Execution)this.executions.stream().reduce((first, second) -> second).orElseThrow(MissingExecutionException::new)).getDuration(unit);
    }
}

