/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.dsl.antlr.generator;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.FilenameUtils;
import org.graphwalker.core.generator.PathGeneratorBase;
import org.graphwalker.dsl.antlr.generator.GeneratorFactoryException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorFactoryScanner {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorFactoryScanner.class);

    private GeneratorFactoryScanner() {
    }

    private static boolean valid(URL url) {
        String extension = FilenameUtils.getExtension(url.getPath());
        return "".equals(extension) || "jar".equals(extension);
    }

    private static Collection<URL> getUrls() {
        HashSet<URL> filteredUrls = new HashSet<URL>();
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(ClasspathHelper.forClassLoader());
        urls.addAll(ClasspathHelper.forJavaClassPath());
        for (URL url : urls) {
            if (!GeneratorFactoryScanner.valid(url)) continue;
            logger.debug(url.toString());
            filteredUrls.add(url);
        }
        return filteredUrls;
    }

    public static Class get(String generator) {
        return GeneratorFactoryScanner.get(new Reflections(new ConfigurationBuilder().addUrls(GeneratorFactoryScanner.getUrls()).setScanners(Scanners.SubTypes)), generator);
    }

    public static Class get(Reflections reflections, String generatorString) {
        for (Class<PathGeneratorBase> generatorClass : reflections.getSubTypesOf(PathGeneratorBase.class)) {
            if (!generatorClass.getSimpleName().equalsIgnoreCase(generatorString)) continue;
            return generatorClass;
        }
        throw new GeneratorFactoryException("No suitable generator found with name: " + generatorString);
    }
}

