/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.graphwalker.io.common.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static File getResourceAsFile(String filename) {
        File file = new File(filename);
        if (file != null && file.exists()) {
            return file;
        }
        URL resource = ResourceUtils.class.getResource(filename);
        if (null == resource) {
            resource = Thread.currentThread().getContextClassLoader().getResource(filename);
        }
        if (null != resource) {
            try {
                return Paths.get(resource.toURI()).toFile();
            }
            catch (URISyntaxException e) {
                throw new ResourceNotFoundException("Could not read resource: " + filename + ", " + e.getMessage());
            }
        }
        throw new ResourceNotFoundException("Could not read resource: " + filename);
    }

    public static InputStream getResourceAsStream(String filename) {
        File file = new File(filename);
        if (file != null && file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage());
                throw new ResourceNotFoundException("Could not read file: " + filename);
            }
        }
        InputStream resource = ResourceUtils.class.getResourceAsStream(filename);
        if (null == resource) {
            resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        }
        if (null != resource) {
            return resource;
        }
        throw new ResourceNotFoundException("Could not read resource: " + filename);
    }

    public static boolean isDirectory(Path path) {
        File file = path.toFile();
        return file != null && file.isDirectory();
    }
}

