/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static void filterBlockedElements(List<Context> executionContexts) {
        for (Context context : executionContexts) {
            Model model = new Model(context.getModel());
            List<Edge> edges = model.getEdges();
            List<Vertex> vertices = model.getVertices();
            ListIterator<Edge> e_it = edges.listIterator();
            while (e_it.hasNext()) {
                Edge edge = e_it.next();
                if (!edge.hasProperty("blocked") || !((Boolean)edge.getProperty("blocked")).booleanValue()) continue;
                e_it.remove();
            }
            ListIterator<Vertex> v_it = vertices.listIterator();
            while (v_it.hasNext()) {
                Vertex vertex = v_it.next();
                if (!vertex.hasProperty("blocked") || !((Boolean)vertex.getProperty("blocked")).booleanValue()) continue;
                e_it = edges.listIterator();
                while (e_it.hasNext()) {
                    Edge e = e_it.next();
                    if (e.getSourceVertex() == vertex) {
                        e_it.remove();
                        continue;
                    }
                    if (e.getTargetVertex() != vertex) continue;
                    e_it.remove();
                }
                v_it.remove();
            }
            context.setModel(model.build());
        }
    }

    public static String printVersionInformation() {
        String version = "org.graphwalker version: " + Util.getVersionString() + System.lineSeparator();
        version = version + System.lineSeparator();
        version = version + "org.graphwalker is open source software licensed under MIT license" + System.lineSeparator();
        version = version + "The software (and it's source) can be downloaded from http://graphwalker.org" + System.lineSeparator();
        version = version + "For a complete list of this package software dependencies, see http://graphwalker.org/archive/site/graphwalker-cli/dependencies.html" + System.lineSeparator();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionString() {
        Properties properties;
        String versionStr = "";
        InputStream inputStream = Util.class.getResourceAsStream("/version.properties");
        if (null != inputStream) {
            try {
                properties = new Properties();
                properties.load(inputStream);
                versionStr = properties.getProperty("graphwalker.version");
            }
            catch (IOException e) {
                logger.error("An error occurred when trying to get the version string", e);
                String string = "unknown";
                return string;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
        if (null != (inputStream = Util.class.getResourceAsStream("/git.properties"))) {
            try {
                properties = new Properties();
                properties.load(inputStream);
                versionStr = versionStr + "-" + properties.getProperty("git.commit.id.abbrev");
            }
            catch (IOException e) {
                logger.error("An error occurred when trying to get the version string", e);
                String string = "unknown";
                return string;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
        return versionStr;
    }
}

