/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FilenameUtils;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextFactoryScanner {
    public static final String JAVA = "JAVA";
    public static final String GRAPHML = "GRAPHML";
    public static final String DOT = "DOT";
    public static final String JSON = "JSON";
    private static final Logger logger = LoggerFactory.getLogger(ContextFactoryScanner.class);
    private static Map<Class<? extends ContextFactory>, ContextFactory> factories = new HashMap<Class<? extends ContextFactory>, ContextFactory>();

    private ContextFactoryScanner() {
    }

    private static boolean valid(URL url) {
        String extension = FilenameUtils.getExtension(url.getPath());
        return "".equals(extension) || "jar".equals(extension);
    }

    private static Collection<URL> getUrls() {
        HashSet<URL> filteredUrls = new HashSet<URL>();
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(ClasspathHelper.forClassLoader());
        urls.addAll(ClasspathHelper.forJavaClassPath());
        for (URL url : urls) {
            if (!ContextFactoryScanner.valid(url)) continue;
            filteredUrls.add(url);
        }
        return filteredUrls;
    }

    private static Reflections getReflections(Collection<URL> urls) {
        return new Reflections(new ConfigurationBuilder().addUrls(urls).setScanners(Scanners.SubTypes));
    }

    public static ContextFactory get(Path path) {
        Supplier<Collection> memoizedUrls = Suppliers.memoize(ContextFactoryScanner::getUrls);
        return ContextFactoryScanner.get(ContextFactoryScanner.getReflections(memoizedUrls.get()), path);
    }

    public static ContextFactory get(Reflections reflections, Path path) {
        LoadingCache memo = CacheBuilder.newBuilder().build(CacheLoader.from(ContextFactoryScanner::create));
        for (Class<ContextFactory> factoryClass : reflections.getSubTypesOf(ContextFactory.class)) {
            ContextFactory factory = null;
            try {
                factory = (ContextFactory)memo.get(factoryClass);
            }
            catch (ExecutionException e) {
                factory = ContextFactoryScanner.create(factoryClass);
            }
            if (null == factory || !factory.accept(path)) continue;
            return factory;
        }
        throw new ContextFactoryException("No suitable context factory found for file: " + path.toString());
    }

    private static ContextFactory create(Class<? extends ContextFactory> factoryClass) {
        if (!factories.containsKey(factoryClass)) {
            try {
                factories.put(factoryClass, factoryClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage());
                return null;
            }
        }
        return factories.get(factoryClass);
    }
}

