/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.json;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.generator.SingletonRandomGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.common.ResourceUtils;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.json.JsonContext;
import org.graphwalker.io.factory.json.JsonModel;
import org.graphwalker.io.factory.json.JsonMultimodel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonContextFactory
implements ContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonContextFactory.class);
    private static final String FILE_TYPE = "json";
    private static final Set<String> SUPPORTED_TYPE = new HashSet<String>(Arrays.asList("**/*.json"));

    @Override
    public void write(List<Context> contexts, Path path) throws IOException {
        File folder = path.toFile().getAbsoluteFile();
        Path jsonFile = Paths.get(folder.toString(), contexts.get(0).getModel().getName() + ".json");
        try (OutputStream outputStream = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            outputStream.write(String.valueOf(this.getAsString(contexts)).getBytes());
        }
    }

    public String getJsonFromModel(Model model) {
        return new Gson().toJson(model);
    }

    @Override
    public String getAsString(List<Context> contexts) {
        JsonMultimodel jsonMultimodel = new JsonMultimodel();
        for (Context context : contexts) {
            JsonModel jsonModel = new JsonModel();
            jsonModel.setModel(context.getModel());
            if (context.getPathGenerator() != null) {
                jsonModel.setGenerator(context.getPathGenerator().toString());
            }
            if (context.getNextElement() != null && context.getNextElement().hasId()) {
                jsonModel.setStartElementId(context.getNextElement().getId());
            }
            jsonMultimodel.add(jsonModel);
        }
        return new Gson().toJson(jsonMultimodel);
    }

    @Override
    public Set<String> getSupportedFileTypes() {
        return SUPPORTED_TYPE;
    }

    @Override
    public boolean accept(Path path) {
        return FilenameUtils.getExtension(path.toString()).equalsIgnoreCase(FILE_TYPE);
    }

    @Override
    public List<Context> create(Path path) throws IOException {
        ArrayList<Context> contexts = new ArrayList<Context>();
        if (ResourceUtils.isDirectory(path)) {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
            for (Path file : directoryStream) {
                contexts.addAll(this.read(file));
            }
        } else {
            contexts.addAll(this.read(path));
        }
        return contexts;
    }

    private List<Context> read(Path file) {
        StringBuilder jsonStr = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceAsStream(file.toString())));){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonStr.append(line);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new ContextFactoryException("Could not read the file.");
        }
        logger.debug(jsonStr.toString());
        return this.create(jsonStr.toString());
    }

    public List<Context> create(String jsonStr) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        JsonMultimodel jsonMultimodel = new Gson().fromJson(jsonStr, JsonMultimodel.class);
        if (Objects.isNull(jsonMultimodel) || Objects.isNull(jsonMultimodel.getModels())) {
            throw new ContextFactoryException("The json file is not a valid GraphWalker model(s) file");
        }
        if (jsonMultimodel.getSeed() != null) {
            SingletonRandomGenerator.setSeed(jsonMultimodel.getSeed());
        }
        for (JsonModel jsonModel : jsonMultimodel.getModels()) {
            JsonContext context = new JsonContext();
            Model model = jsonModel.getModel();
            context.setModel(model.build());
            if (jsonModel.getGenerator() != null) {
                context.setPathGenerator(GeneratorFactory.parse(jsonModel.getGenerator()));
            }
            for (Element element : context.getModel().getElements()) {
                if (!element.getId().equals(jsonModel.getStartElementId())) continue;
                context.setNextElement(element);
                break;
            }
            contexts.add(context);
        }
        return contexts;
    }
}

