/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Guard;
import org.graphwalker.core.model.Requirement;

public class JsonEdge {
    private String id;
    private String name;
    private String guard;
    private List<String> actions;
    private List<String> requirements;
    private Map<String, Object> properties;
    private Double weight;
    private Integer dependency;
    private String sourceVertexId;
    private String targetVertexId;

    public String getSourceVertexId() {
        return this.sourceVertexId;
    }

    public String getTargetVertexId() {
        return this.targetVertexId;
    }

    public Edge getEdge() {
        Edge edge = new Edge();
        edge.setId(this.id);
        edge.setName(this.name);
        if (this.weight != null) {
            edge.setWeight(this.weight);
        } else {
            edge.setWeight(0.0);
        }
        if (this.dependency != null) {
            edge.setDependency(this.dependency);
        } else {
            edge.setDependency(0);
        }
        edge.setGuard(new Guard(this.guard));
        if (this.actions != null) {
            for (String action : this.actions) {
                edge.addAction(new Action(action));
            }
        }
        if (this.requirements != null) {
            for (String requirement : this.requirements) {
                edge.addRequirement(new Requirement(requirement));
            }
        }
        if (this.properties != null) {
            edge.setProperties(this.properties);
        }
        return edge;
    }

    public void setEdge(Edge.RuntimeEdge edge) {
        this.id = edge.getId();
        this.name = edge.getName();
        this.weight = edge.getWeight();
        this.dependency = edge.getDependency();
        if (edge.hasGuard()) {
            this.guard = edge.getGuard().getScript();
        }
        if (edge.getSourceVertex() != null) {
            this.sourceVertexId = edge.getSourceVertex().getId();
        }
        if (edge.getTargetVertex() != null) {
            this.targetVertexId = edge.getTargetVertex().getId();
        }
        if (edge.hasActions()) {
            this.actions = new ArrayList<String>();
            for (Action action : edge.getActions()) {
                this.actions.add(action.getScript());
            }
        }
        if (edge.hasRequirements()) {
            this.requirements = new ArrayList<String>();
            for (Requirement requirement : edge.getRequirements()) {
                this.requirements.add(requirement.getKey());
            }
        }
        if (edge.hasProperties()) {
            this.properties = new HashMap<String, Object>();
            this.properties.putAll(edge.getProperties());
        }
    }

    public void setEdge(Edge edge) {
        this.setEdge((Edge.RuntimeEdge)edge.build());
    }

    public void copyValues(Edge edge) {
        if (this.id != null) {
            edge.setId(this.id);
        }
        if (this.name != null) {
            edge.setName(this.name);
        }
        edge.setWeight(this.weight);
        edge.setDependency(this.dependency);
        if (this.guard != null) {
            edge.setGuard(new Guard(this.guard));
        }
        if (this.actions != null) {
            for (String action : this.actions) {
                edge.addAction(new Action(action));
            }
        }
        if (this.requirements != null) {
            for (String requirement : this.requirements) {
                edge.addRequirement(new Requirement(requirement));
            }
        }
        if (this.properties != null) {
            edge.setProperties(this.properties);
        }
    }
}

