/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.model.Vertex;

public class JsonVertex {
    private String id;
    private String name;
    private String sharedState;
    private List<String> actions;
    private List<String> requirements;
    private Map<String, Object> properties;

    public Vertex getVertex() {
        Vertex vertex = new Vertex();
        vertex.setId(this.id);
        vertex.setName(this.name);
        vertex.setSharedState(this.sharedState);
        if (this.requirements != null) {
            for (String requirement : this.requirements) {
                vertex.addRequirement(new Requirement(requirement));
            }
        }
        if (this.actions != null) {
            for (String action : this.actions) {
                vertex.addAction(new Action(action));
            }
        }
        if (this.properties != null) {
            vertex.setProperties(this.properties);
        }
        return vertex;
    }

    public void setVertex(Vertex.RuntimeVertex vertex) {
        this.id = vertex.getId();
        this.name = vertex.getName();
        this.sharedState = vertex.getSharedState();
        if (vertex.hasRequirements()) {
            this.requirements = new ArrayList<String>();
            for (Requirement requirement : vertex.getRequirements()) {
                this.requirements.add(requirement.getKey());
            }
        }
        if (vertex.hasActions()) {
            this.actions = new ArrayList<String>();
            for (Action action : vertex.getActions()) {
                this.actions.add(action.getScript());
            }
        }
        if (vertex.hasProperties()) {
            this.properties = new HashMap<String, Object>();
            this.properties.putAll(vertex.getProperties());
        }
    }

    public void setVertex(Vertex vertex) {
        this.setVertex((Vertex.RuntimeVertex)vertex.build());
    }

    public void copyValues(Vertex vertex) {
        if (this.id != null) {
            vertex.setId(this.id);
        }
        if (this.name != null) {
            vertex.setName(this.name);
        }
        if (this.sharedState != null) {
            vertex.setSharedState(this.sharedState);
        }
        if (this.requirements != null) {
            for (String requirement : this.requirements) {
                vertex.addRequirement(new Requirement(requirement));
            }
        }
        if (this.actions != null) {
            for (String action : this.actions) {
                vertex.addAction(new Action(action));
            }
        }
        if (this.properties != null) {
            vertex.setProperties(this.properties);
        }
    }
}

