/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.java.report.Error;
import org.graphwalker.java.report.Failure;
import org.graphwalker.java.report.Properties;
import org.graphwalker.java.report.Property;
import org.graphwalker.java.report.Testcase;
import org.graphwalker.java.report.Testsuite;
import org.graphwalker.java.report.Testsuites;
import org.graphwalker.java.report.XMLReportException;
import org.graphwalker.java.test.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLReportGenerator {
    private static final Logger logger = LoggerFactory.getLogger(XMLReportGenerator.class);
    private static final String TESTSUITE_NAME = "GraphWalker";
    private static final String NEWLINE = "\n";
    private static final String INDENT = "    ";
    private final java.util.Properties systemProperties;
    private final Date startTime;

    public XMLReportGenerator(Date startTime, java.util.Properties systemProperties) {
        this.startTime = startTime;
        this.systemProperties = systemProperties;
    }

    public void writeReport(File reportDirectory, Executor executor) {
        Testsuites testsuites = new Testsuites();
        ArrayList<Report> reports = new ArrayList<Report>();
        Machine machine = executor.getMachine();
        Report report = new Report(machine, this.startTime);
        Testsuite testsuite = new Testsuite();
        ArrayList<String> keys = new ArrayList<String>(this.systemProperties.stringPropertyNames());
        Collections.sort(keys);
        Properties properties = new Properties();
        for (String name : keys) {
            Property property = new Property();
            property.setName(name);
            property.setValue(this.systemProperties.getProperty(name));
            properties.getProperty().add(property);
        }
        testsuite.setName(TESTSUITE_NAME);
        testsuite.setProperties(properties);
        testsuite.setTests(report.getTestsAsString());
        testsuite.setFailures(report.getFailuresAsString());
        testsuite.setErrors(report.getErrorsAsString());
        testsuite.setTime(report.getTimeAsString());
        testsuite.setTimestamp(report.getTimestamp());
        for (Context context : machine.getContexts()) {
            Testcase testcase = new Testcase();
            testcase.setName(context.getClass().getSimpleName());
            testcase.setClassname(context.getClass().getName());
            testcase.setTime(this.getSeconds(context.getProfiler().getTotalExecutionTime()));
            if (executor.isFailure(context)) {
                Throwable throwable = executor.getFailure(context).getCause();
                Error error = new Error();
                error.setType(throwable.getClass().getName());
                error.setMessage(throwable.getMessage());
                error.setContent(XMLReportGenerator.getStackTrace(throwable));
                testcase.getError().add(error);
            } else if (report.isFailure(context)) {
                Failure failure = new Failure();
                failure.setType("Not fulfilled");
                double fulfilment = context.getPathGenerator().getStopCondition().getFulfilment();
                failure.setMessage(String.valueOf(Math.round(100.0 * fulfilment)));
                testcase.getFailure().add(failure);
            }
            testsuite.getTestcase().add(testcase);
        }
        testsuites.getTestsuite().add(testsuite);
        reports.add(report);
        this.consolidate(testsuites, reports);
        this.writeReport(reportDirectory, testsuites);
    }

    private void writeReport(File reportDirectory, Testsuites testsuites) {
        try {
            JAXBContext context = JAXBContext.newInstance("org.graphwalker.java.report");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", "UTF-8");
            marshaller.setProperty("jaxb.formatted.output", true);
            marshaller.marshal((Object)testsuites, this.getOutputStream(reportDirectory, this.getName()));
        }
        catch (JAXBException e) {
            logger.error(e.getMessage());
            throw new XMLReportException(e);
        }
    }

    private void consolidate(Testsuites testsuites, List<Report> reports) {
        long tests = 0L;
        long failures = 0L;
        long errors = 0L;
        double time = Double.MAX_VALUE;
        for (Report report : reports) {
            tests += (long)report.getTests();
            failures += (long)report.getFailures();
            errors += (long)report.getErrors();
            if (!(time > report.getTime())) continue;
            time = report.getTime();
        }
        testsuites.setTime(String.valueOf(time));
        testsuites.setFailures(String.valueOf(failures));
        testsuites.setErrors(String.valueOf(errors));
        testsuites.setTests(String.valueOf(tests));
    }

    private String getName() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        return "TEST-GraphWalker-" + formatter.format(this.startTime) + ".xml";
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        StringBuilder buffer = new StringBuilder().append(NEWLINE);
        for (String line : stringWriter.getBuffer().toString().split(NEWLINE)) {
            buffer.append(INDENT).append(INDENT).append(INDENT).append(INDENT).append(line).append(NEWLINE);
        }
        return buffer.toString();
    }

    private String getSeconds(long milliseconds) {
        return String.valueOf((double)milliseconds / 1000.0);
    }

    private OutputStream getOutputStream(File directory, String reportName) {
        try {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return new FileOutputStream(new File(directory, reportName));
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            throw new XMLReportException(t);
        }
    }

    private class Report {
        private final List<Context> failedExecutions = new ArrayList<Context>();
        private int errors = 0;
        private int tests = 0;
        private int failures = 0;
        private int time = 0;
        private final String timestamp;

        Report(Machine machine, Date startTime) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.timestamp = formatter.format(startTime);
            for (Context context : machine.getContexts()) {
                ++this.tests;
                switch (context.getExecutionStatus()) {
                    case FAILED: {
                        ++this.errors;
                        break;
                    }
                    case NOT_EXECUTED: 
                    case EXECUTING: {
                        ++this.failures;
                        this.failedExecutions.add(context);
                    }
                }
                this.time = (int)((long)this.time + context.getProfiler().getTotalExecutionTime());
            }
        }

        public boolean isFailure(Context context) {
            return this.failedExecutions.contains(context);
        }

        public int getErrors() {
            return this.errors;
        }

        public String getErrorsAsString() {
            return String.valueOf(this.errors);
        }

        public int getTests() {
            return this.tests;
        }

        public String getTestsAsString() {
            return String.valueOf(this.tests);
        }

        public int getFailures() {
            return this.failures;
        }

        public String getFailuresAsString() {
            return String.valueOf(this.failures);
        }

        public double getTime() {
            return (double)this.time / 1000.0;
        }

        public String getTimeAsString() {
            return String.valueOf((double)this.time / 1000.0);
        }

        public String getTimestamp() {
            return this.timestamp;
        }
    }
}

