/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import org.graphwalker.core.common.Objects;
import org.graphwalker.java.annotation.GraphWalker;

public class ContextConfiguration {
    private Class<?> testClass;
    private String testClassName;
    private String pathGeneratorName;
    private String stopConditionName;
    private String stopConditionValue;

    public ContextConfiguration() {
    }

    public ContextConfiguration(Class<?> testClass) {
        this.setTestClass(testClass);
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
        this.setTestClassName(testClass.getSimpleName());
        GraphWalker configuration = testClass.getAnnotation(GraphWalker.class);
        if (Objects.isNotNull(configuration)) {
            this.setPathGeneratorName(configuration.pathGenerator().getSimpleName());
            this.setStopConditionName(configuration.stopCondition().getSimpleName());
            this.setStopConditionValue(configuration.stopConditionValue());
        }
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public void setTestClassName(String testClassName) {
        this.testClassName = testClassName;
    }

    public String getPathGeneratorName() {
        return this.pathGeneratorName;
    }

    public void setPathGeneratorName(String pathGeneratorName) {
        this.pathGeneratorName = pathGeneratorName;
    }

    public String getStopConditionName() {
        return this.stopConditionName;
    }

    public void setStopConditionName(String stopConditionName) {
        this.stopConditionName = stopConditionName;
    }

    public String getStopConditionValue() {
        return this.stopConditionValue;
    }

    public void setStopConditionValue(String stopConditionValue) {
        this.stopConditionValue = stopConditionValue;
    }
}

