/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.test.Result;
import org.graphwalker.java.test.TestExecutionException;
import org.graphwalker.java.test.TestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TestBuilder.class);
    private List<Context> contexts = new ArrayList<Context>();

    public TestBuilder addContext(Context context) {
        this.contexts.add(context);
        return this;
    }

    @Deprecated
    public TestBuilder addContext(Context context, Path path) throws IOException {
        List<Context> pathContexts = ContextFactoryScanner.get(path).create(path);
        if (Objects.isNullOrEmpty(pathContexts)) {
            throw new TestExecutionException("Could not read the model: " + path.toString());
        }
        if (pathContexts.size() > 1) {
            throw new TestExecutionException("The model path: " + path.toString() + ", has more models than 1. Can only handle 1 model.");
        }
        context.setModel(pathContexts.get(0).getModel());
        context.setNextElement(pathContexts.get(0).getNextElement());
        this.contexts.add(context);
        return this;
    }

    public TestBuilder addClass(Class<? extends Context> testClass) {
        this.contexts.add(this.createContext(testClass));
        return this;
    }

    public TestBuilder addClass(Class<? extends Context> testClass, String pathGenerator) {
        return this.addClass(testClass, GeneratorFactory.parse(pathGenerator));
    }

    public TestBuilder addClass(Class<? extends Context> testClass, PathGenerator pathGenerator) {
        Context context = this.createContext(testClass);
        context.setPathGenerator(pathGenerator);
        this.contexts.add(context);
        return this;
    }

    public TestBuilder addContext(Context context, Path model, String pathGenerator) {
        return this.addContext(context, model, GeneratorFactory.parse(pathGenerator));
    }

    public TestBuilder addContext(Context context, Path model, PathGenerator pathGenerator) {
        this.addModel(context, model);
        context.setPathGenerator(pathGenerator);
        this.contexts.add(context);
        return this;
    }

    private Context addModel(Context context, Path model) {
        try {
            List<Context> pathContexts = ContextFactoryScanner.get(model).create(model);
            if (Objects.isNullOrEmpty(pathContexts)) {
                throw new TestExecutionException("Could not read the model: " + model.toString());
            }
            if (pathContexts.size() > 1) {
                throw new TestExecutionException("The model path: " + model.toString() + ", has more models than 1. Can only handle 1 model.");
            }
            context.setModel(pathContexts.get(0).getModel());
            context.setNextElement(pathContexts.get(0).getNextElement());
            return context;
        }
        catch (IOException e) {
            throw new TestExecutionException(e);
        }
    }

    private Context createContext(Class<? extends Context> testClass) {
        try {
            return testClass.newInstance();
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            throw new ContextFactoryException("Failed to create context", t);
        }
    }

    public Result execute(boolean ignoreError) {
        return new TestExecutor(this.contexts).execute(ignoreError);
    }

    public Result execute() {
        return this.execute(false);
    }
}

