/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.modelchecker;

import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.condition.EdgeCoverage;
import org.graphwalker.core.generator.RandomPath;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.modelchecker.ModelChecker;

public class ContextChecker {
    private ContextChecker() {
    }

    public static List<String> hasIssues(Context context) {
        EdgeCoverage edgeCoverage;
        ArrayList<String> issues = new ArrayList<String>();
        if (context.getModel() == null) {
            issues.add("No model found in context");
            return issues;
        }
        issues.addAll(ModelChecker.hasIssues(context.getModel()));
        if (context.getNextElement() == null && !context.getModel().hasSharedStates()) {
            issues.add("The model has neither a start element or a defined shared state.");
            return issues;
        }
        if (context.getPathGenerator() instanceof RandomPath && context.getPathGenerator().getStopCondition() instanceof EdgeCoverage && (edgeCoverage = (EdgeCoverage)context.getPathGenerator().getStopCondition()).getPercent() == 100) {
            int countNumOfCulDeSac = 0;
            for (Vertex.RuntimeVertex vertex : context.getModel().getVertices()) {
                if (context.getModel().getOutEdges(vertex).size() != 0 || vertex.hasSharedState()) continue;
                ++countNumOfCulDeSac;
            }
            if (countNumOfCulDeSac > 1) {
                issues.add("The model has multiple cul-de-sacs, and is requested to run using a random path generator and 100% edge coverage. That will not work.");
            } else if (countNumOfCulDeSac == 1) {
                issues.add("The model has one cul-de-sacs, and is requested to run using a random path generator and 100% edge coverage. That might not work.");
            }
        }
        return issues;
    }
}

